/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.android.cdt.internal.build.ui;

import java.util.ArrayList;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.sequoyah.android.cdt.internal.build.ui.Messages;
import org.eclipse.sequoyah.android.cdt.internal.build.ui.NDKNativeProblem;

public class NDKNativeMethodDetectionVisitor
extends ASTVisitor {
    private boolean nativePresence = false;
    private int startPosition;
    private int endPosition;
    private int numberNatives = 0;
    private ArrayList<NDKNativeProblem> problems;

    public int getNumberNatives() {
        return this.numberNatives;
    }

    public void setNumberNatives(int n) {
        this.numberNatives = n;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(int n) {
        this.startPosition = n;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public void setEndPosition(int n) {
        this.endPosition = n;
    }

    public void setNativePresence(boolean bl) {
        this.nativePresence = bl;
    }

    public boolean isNativePresence() {
        return this.nativePresence;
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        Object[] objectArray;
        this.nativePresence = false;
        Object[] objectArray2 = objectArray = methodDeclaration.modifiers().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (object.toString().equals("native")) {
                this.nativePresence = true;
                this.startPosition = methodDeclaration.getStartPosition();
                this.endPosition = methodDeclaration.getLength() + this.startPosition;
                this.problems.add(new NDKNativeProblem(Messages.NDKNativeMethodDetectionVisitor_ProblemName0, 0, null, 0, this.startPosition, this.endPosition, 14, 1));
            }
            ++n2;
        }
        return true;
    }

    public NDKNativeProblem[] getProblems() {
        NDKNativeProblem[] nDKNativeProblemArray = new NDKNativeProblem[this.problems.size()];
        int n = 0;
        while (n < this.problems.size()) {
            nDKNativeProblemArray[n] = this.problems.get(n);
            ++n;
        }
        return nDKNativeProblemArray;
    }

    public void resetVisitor() {
        this.problems = new ArrayList();
    }
}

