/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sequoyah.device.common.utilities.PluginUtils;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.device.framework.DevicePlugin;
import org.eclipse.sequoyah.device.framework.factory.ServiceFactory;
import org.eclipse.sequoyah.device.framework.internal.model.MobileDeviceType;
import org.eclipse.sequoyah.device.framework.model.IDeviceType;
import org.eclipse.sequoyah.device.framework.model.IDeviceTypeRegistry;
import org.eclipse.sequoyah.device.framework.model.IService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceTypeRegistry
implements IDeviceTypeRegistry {
    private static final String XML_ELEMENT_DEVICE_TYPE = "deviceType";
    private static final String XML_ATTRIBUTE_ID = "id";
    private static final String XML_ATTRIBUTE_LABEL = "label";
    private static final String XML_ATTRIBUTE_IS_ABSTRACT = "isAbstract";
    private static final String XML_ATTRIBUTE_SUPERCLASS = "superClass";
    private static final String XML_ATTRIBUTE_PROPERTY = "property";
    private static final String XML_ATTRIBUTE_NAME = "name";
    private static final String XML_ATTRIBUTE_VALUE = "value";
    private static DeviceTypeRegistry _instance;
    private Map<String, IDeviceType> deviceTypes = new HashMap<String, IDeviceType>();

    private DeviceTypeRegistry() {
    }

    public static DeviceTypeRegistry getInstance() {
        if (_instance == null) {
            _instance = new DeviceTypeRegistry();
        }
        return _instance;
    }

    @Override
    public IDeviceType getDeviceTypeById(String string) {
        this.loadDeviceTypesExtensions();
        return this.deviceTypes.get(string);
    }

    @Override
    public Collection<IDeviceType> getDeviceTypes() {
        this.loadDeviceTypesExtensions();
        return this.deviceTypes.values();
    }

    public Set<String> getDeviceTypeIds() {
        this.loadDeviceTypesExtensions();
        return this.deviceTypes.keySet();
    }

    @Override
    public ImageDescriptor getImage() {
        return DevicePlugin.getDefault().getImageDescriptor("ICON_MOVING");
    }

    private synchronized Map<String, IDeviceType> loadDeviceTypesExtensions() {
        IExtension[] iExtensionArray;
        IExtensionPoint iExtensionPoint;
        if (this.deviceTypes.isEmpty() && (iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.sequoyah.device.framework.deviceTypes")) != null && (iExtensionArray = iExtensionPoint.getExtensions()) != null) {
            int n = 0;
            while (n < iExtensionArray.length) {
                IExtension object = iExtensionArray[n];
                IConfigurationElement[] iConfigurationElementArray = object.getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                    if (iConfigurationElement.getName().equals(XML_ELEMENT_DEVICE_TYPE)) {
                        IDeviceType iDeviceType = this.loadDeviceType(iConfigurationElement);
                        iDeviceType.setBundleName(iConfigurationElement.getContributor().getName());
                        this.deviceTypes.put(iDeviceType.getId(), iDeviceType);
                    }
                    ++n2;
                }
                ++n;
            }
            for (IDeviceType iDeviceType : this.deviceTypes.values()) {
                iDeviceType.setServices(this.loadServices(iDeviceType));
                iDeviceType.getProperties().putAll((Map<?, ?>)this.loadSuperClassProperties(iDeviceType));
            }
        }
        return this.deviceTypes;
    }

    private Properties loadSuperClassProperties(IDeviceType iDeviceType) {
        Properties properties = new Properties();
        String string = iDeviceType.getSuperClass();
        if (string != null && this.deviceTypes.containsKey(string)) {
            IDeviceType iDeviceType2 = this.deviceTypes.get(string);
            properties.putAll((Map<?, ?>)this.loadSuperClassProperties(iDeviceType2));
            Properties properties2 = iDeviceType2.getProperties();
            Properties properties3 = iDeviceType.getProperties();
            for (String string2 : properties2.keySet()) {
                if (properties3.containsKey(string2)) continue;
                properties.put(string2, properties2.get(string2));
            }
        }
        return properties;
    }

    private IDeviceType loadDeviceType(IConfigurationElement iConfigurationElement) {
        Object object;
        String string = iConfigurationElement.getAttribute(XML_ATTRIBUTE_ID);
        String string2 = iConfigurationElement.getAttribute(XML_ATTRIBUTE_LABEL);
        MobileDeviceType mobileDeviceType = new MobileDeviceType(string, string2);
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            object = iConfigurationElementArray[n];
            if (object.getName().equals(XML_ATTRIBUTE_PROPERTY)) {
                String string3 = object.getAttribute(XML_ATTRIBUTE_NAME);
                String string4 = object.getAttribute(XML_ATTRIBUTE_VALUE);
                mobileDeviceType.addProperty(string3, string4);
            }
            ++n;
        }
        String string5 = iConfigurationElement.getAttribute(XML_ATTRIBUTE_IS_ABSTRACT);
        if (string5 != null && Boolean.valueOf(string5).booleanValue()) {
            mobileDeviceType.setAbstract(true);
        }
        if ((object = iConfigurationElement.getAttribute(XML_ATTRIBUTE_SUPERCLASS)) != null) {
            mobileDeviceType.setSuperClass((String)object);
        }
        return mobileDeviceType;
    }

    private List<IService> loadServices(IDeviceType iDeviceType) {
        ArrayList<IService> arrayList = new ArrayList<IService>();
        arrayList.addAll(this.loadServices(iDeviceType.getId()));
        String string = iDeviceType.getSuperClass();
        if (string != null && this.deviceTypes.containsKey(string)) {
            List<IService> list = this.loadServices(this.deviceTypes.get(string));
            for (IService iService : list) {
                if (this.serviceExists(arrayList, iService.getId())) continue;
                arrayList.add(iService);
            }
        }
        return arrayList;
    }

    private boolean serviceExists(List<IService> list, String string) {
        if (list != null) {
            for (IService iService : list) {
                if (!iService.getId().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    private List<IService> loadServices(String string) {
        ArrayList<IService> arrayList = new ArrayList<IService>();
        Collection collection = PluginUtils.getInstalledExtensions((String)"org.eclipse.sequoyah.device.framework.serviceDefinition");
        for (IExtension iExtension : collection) {
            if (!iExtension.getUniqueIdentifier().equals(string)) continue;
            try {
                IService iService = ServiceFactory.createService(iExtension);
                if (iService == null) continue;
                arrayList.add(iService);
            }
            catch (SequoyahException sequoyahException) {
                sequoyahException.printStackTrace();
            }
        }
        return arrayList;
    }
}

