/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.editor.model.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.localization.editor.datatype.CellInfo;
import org.eclipse.sequoyah.localization.editor.datatype.ColumnInfo;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfo;
import org.eclipse.sequoyah.localization.editor.datatype.TranslationInfo;
import org.eclipse.sequoyah.localization.editor.model.input.IEditorChangeListener;
import org.eclipse.sequoyah.localization.editor.model.input.IInputChangeListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStringEditorInput
implements IEditorInput {
    private final List<IInputChangeListener> inputChangeListeners = new ArrayList<IInputChangeListener>();
    private final List<IEditorChangeListener> fileChangeListeners = new ArrayList<IEditorChangeListener>();

    public abstract void init(IProject var1) throws Exception;

    public abstract String getTitle();

    public abstract List<ColumnInfo> getColumns();

    public abstract boolean translateColumn(String var1, TranslationInfo var2, IProgressMonitor var3);

    public abstract boolean translateCells(String var1, TranslationInfo[] var2, IProgressMonitor var3);

    public abstract void addColumn(String var1);

    public abstract void removeColumn(String var1);

    public abstract void setValue(String var1, String var2, String var3) throws SequoyahException;

    public abstract void setValue(String var1, String var2, String var3, int var4) throws SequoyahException;

    public abstract CellInfo getValue(String var1, String var2);

    public abstract Map<String, CellInfo> getValues(String var1);

    public abstract List<CellInfo> getAvailableKeysForColumn(String var1);

    public abstract boolean canSave();

    public abstract boolean save();

    public abstract boolean isDirty();

    public abstract boolean revert();

    public abstract boolean revert(String var1) throws IOException;

    public abstract boolean canRevertByColumn();

    public abstract void removeRow(String var1);

    public abstract void removeChildRow(String var1, int var2);

    public abstract void removeCell(String var1, String var2);

    public abstract void removeCell(String var1, String var2, int var3);

    public abstract RowInfo addRow(RowInfo var1);

    public abstract void dispose();

    public abstract void setCellTooltip(String var1, String var2, String var3) throws SequoyahException;

    public abstract void setCellTooltip(String var1, String var2, String var3, Integer var4) throws SequoyahException;

    public abstract IStatus validate();

    public abstract boolean canHandle(IFile var1);

    public void addInputChangeListener(IInputChangeListener iInputChangeListener) {
        if (!this.inputChangeListeners.contains(iInputChangeListener)) {
            this.inputChangeListeners.add(iInputChangeListener);
        }
    }

    public void removeInputChangeListener(IInputChangeListener iInputChangeListener) {
        this.inputChangeListeners.remove(iInputChangeListener);
    }

    public void notifyInputChanged(String string) {
        for (IInputChangeListener iInputChangeListener : this.inputChangeListeners) {
            iInputChangeListener.columnChanged(string);
        }
    }

    public void addEditorChangeListener(IEditorChangeListener iEditorChangeListener) {
        if (!this.fileChangeListeners.contains(iEditorChangeListener)) {
            this.fileChangeListeners.add(iEditorChangeListener);
        }
    }

    public void removeEditorChangeListener(IEditorChangeListener iEditorChangeListener) {
        this.fileChangeListeners.remove(iEditorChangeListener);
    }

    public void notifyEditorChanged(IEditorInput iEditorInput, String string) {
        for (IEditorChangeListener iEditorChangeListener : this.fileChangeListeners) {
            iEditorChangeListener.editorContentChanged(iEditorInput, string);
        }
    }

    public abstract List<IFile> getFiles();

    public abstract String getSourcePageNameForFile(IFile var1);

    public abstract String getContentForFileAsText(IFileEditorInput var1);

    public abstract void renameKey(String var1, String var2) throws SequoyahException;

    public abstract boolean isRevertable(String var1);
}

