/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.tools.extensions.implementation.generic;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.sequoyah.localization.tools.extensions.classes.ILocalizationSchema;
import org.eclipse.sequoyah.localization.tools.extensions.implementation.generic.LanguagesUtil;
import org.eclipse.sequoyah.localization.tools.i18n.Messages;
import org.eclipse.sequoyah.localization.tools.managers.LocalizationManager;
import org.eclipse.sequoyah.localization.tools.managers.PreferencesManager;
import org.eclipse.sequoyah.localization.tools.managers.TranslatorManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslateColumnsInputDialog
extends Dialog {
    private IProject project = null;
    private String dialogTitle = null;
    private Combo translatorsCombo = null;
    private String translator;
    private Label translatorBrandingImage = null;
    private String selectedColumn = null;
    private String[] selectedCells = null;
    private Combo fromCombo = null;
    private String fromLanguage;
    private List<DestinationColumn> destinationColumns = null;
    private TreeColumn[] columns = null;
    private PreferenceDialog networkPreferencesDialog;
    private PreferenceManager prefMan;
    private static final String PROXY_PREFERENCE_PAGE_ID = "org.eclipse.ui.net.NetPreferences";

    public TranslateColumnsInputDialog(Shell shell, IProject iProject, String string, String[] stringArray, TreeColumn[] treeColumnArray, String string2) {
        super(shell);
        this.project = iProject;
        this.selectedColumn = string;
        this.selectedCells = stringArray;
        this.columns = treeColumnArray;
        this.dialogTitle = string2;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.dialogTitle);
    }

    public List<DestinationColumn> getDestinationColumns() {
        ArrayList<DestinationColumn> arrayList = new ArrayList<DestinationColumn>();
        for (DestinationColumn destinationColumn : this.destinationColumns) {
            if (!destinationColumn.isSelected()) continue;
            arrayList.add(destinationColumn);
        }
        return arrayList;
    }

    private static void centralizeShell(Shell shell) {
        int n = shell.getSize().x;
        int n2 = shell.getSize().y;
        int n3 = (shell.getDisplay().getClientArea().width - n) / 2;
        int n4 = (shell.getDisplay().getClientArea().height - n2) / 2;
        shell.setLocation(n3, n4);
    }

    private boolean openNetworkPreferencesPage() {
        this.networkPreferencesDialog = new WorkbenchPreferenceDialog(this.getShell(), this.prefMan);
        this.networkPreferencesDialog.create();
        TranslateColumnsInputDialog.centralizeShell(this.networkPreferencesDialog.getShell());
        this.networkPreferencesDialog.open();
        return this.networkPreferencesDialog.getReturnCode() == 0;
    }

    public String getFromLanguage() {
        return LanguagesUtil.getLanguageID(this.fromLanguage);
    }

    public String getTranslator() {
        return this.translator;
    }

    protected Control createDialogArea(Composite composite) {
        ILocalizationSchema iLocalizationSchema = LocalizationManager.getInstance().getLocalizationSchema(this.project);
        ComboListener comboListener = new ComboListener();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        composite2.setLayout((Layout)new GridLayout(1, true));
        this.createTranslatorArea(composite2, comboListener);
        this.createFromArea(composite2, comboListener, iLocalizationSchema);
        this.createToArea(composite2, iLocalizationSchema);
        this.createNetworkGroup(composite2);
        this.createTranslatorBrandingArea(composite2);
        this.setInitialValues();
        return composite;
    }

    private void createTranslatorArea(Composite composite, ComboListener comboListener) {
        Group group = new Group(composite, 64);
        group.setText(Messages.Translator_Text);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.Service_Text);
        this.translatorsCombo = LanguagesUtil.createTranslatorsCombo((Composite)group);
        this.translatorsCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.translatorsCombo.addSelectionListener((SelectionListener)comboListener);
    }

    private void createFromArea(Composite composite, ComboListener comboListener, ILocalizationSchema iLocalizationSchema) {
        Group group = new Group(composite, 64);
        group.setText(Messages.TranslationDialog_From);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.TranslationDialog_FromLanguage);
        String string = iLocalizationSchema.getISO639LangFromID(this.selectedColumn);
        string = LanguagesUtil.getLanguageName(string) != null ? string : null;
        String string2 = PreferencesManager.getInstance().getProjectPreferencesManager(this.project).getDefaultLanguageForColumn(this.selectedColumn);
        this.fromCombo = LanguagesUtil.createLanguagesCombo((Composite)group, string, string2, iLocalizationSchema);
        this.fromCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fromCombo.addSelectionListener((SelectionListener)comboListener);
        LanguagesUtil.createImageStatus((Composite)group, string);
    }

    private void createToArea(Composite composite, ILocalizationSchema iLocalizationSchema) {
        TreeColumn treeColumn;
        Group group = new Group(composite, 64);
        group.setText(Messages.TranslationDialog_To);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(4, false));
        if (this.columns.length <= 2) {
            Label label = new Label((Composite)group, 0);
            label.setText(Messages.TranslationDialog_NoColumns);
        }
        this.destinationColumns = new ArrayList<DestinationColumn>();
        int n = 0;
        TreeColumn[] treeColumnArray = this.columns;
        int n2 = this.columns.length;
        int n3 = 0;
        while (n3 < n2) {
            treeColumn = treeColumnArray[n3];
            if (n > 0 && !treeColumn.getText().equals(this.selectedColumn)) {
                Button button = new Button((Composite)group, 32);
                button.setSelection(true);
                Label label = new Label((Composite)group, 0);
                label.setText(treeColumn.getText());
                String string = iLocalizationSchema.getISO639LangFromID(treeColumn.getText());
                string = LanguagesUtil.getLanguageName(string) != null ? string : null;
                String string2 = PreferencesManager.getInstance().getProjectPreferencesManager(this.project).getDefaultLanguageForColumn(treeColumn.getText());
                DestinationColumn destinationColumn = new DestinationColumn(button, true, treeColumn.getText(), string);
                button.setData((Object)destinationColumn);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        ((DestinationColumn)((Button)selectionEvent.getSource()).getData()).setSelected(((Button)selectionEvent.getSource()).getSelection());
                        TranslateColumnsInputDialog.this.validateSelection();
                    }
                });
                Combo combo = LanguagesUtil.createLanguagesCombo((Composite)group, string, string2, iLocalizationSchema);
                destinationColumn.setLang(LanguagesUtil.getLanguageID(combo.getText()));
                combo.setLayoutData((Object)new GridData(4, 4, true, false));
                combo.setData((Object)destinationColumn);
                combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        String string = ((Combo)selectionEvent.getSource()).getText();
                        if (!string.equals(LanguagesUtil.getComboSeparator())) {
                            ((DestinationColumn)((Combo)selectionEvent.getSource()).getData()).setLang(LanguagesUtil.getLanguageID(string));
                            PreferencesManager.getInstance().getProjectPreferencesManager(TranslateColumnsInputDialog.this.project).setDefaultLanguageForColumn(((DestinationColumn)((Combo)selectionEvent.getSource()).getData()).getText(), LanguagesUtil.getLanguageID(string));
                        } else {
                            ((DestinationColumn)((Combo)selectionEvent.getSource()).getData()).setLang(null);
                        }
                        TranslateColumnsInputDialog.this.validateSelection();
                    }
                });
                LanguagesUtil.createImageStatus((Composite)group, string);
                this.destinationColumns.add(destinationColumn);
            }
            ++n;
            ++n3;
        }
        treeColumn = new Composite((Composite)group, 0);
        treeColumn.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        treeColumn.setLayout((Layout)new GridLayout(2, true));
        Button button = new Button((Composite)treeColumn, 8);
        button.setLayoutData((Object)new GridData(4, 4, true, false));
        button.setText(Messages.TranslationDialog_SelectAll);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                for (DestinationColumn destinationColumn : TranslateColumnsInputDialog.this.destinationColumns) {
                    destinationColumn.setSelected(true);
                }
                TranslateColumnsInputDialog.this.validateSelection();
            }
        });
        Button button2 = new Button((Composite)treeColumn, 8);
        button2.setText(Messages.TranslationDialog_DeselectAll);
        button2.setLayoutData((Object)new GridData(4, 4, true, false));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                for (DestinationColumn destinationColumn : TranslateColumnsInputDialog.this.destinationColumns) {
                    destinationColumn.setSelected(false);
                }
                TranslateColumnsInputDialog.this.validateSelection();
            }
        });
    }

    private void createTranslatorBrandingArea(Composite composite) {
        Composite composite2 = new Composite(composite, 131072);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.translatorBrandingImage = new Label(composite2, 0);
        this.translatorBrandingImage.setLayoutData((Object)new GridData(4, 128, true, true));
    }

    private void setInitialValues() {
        this.translator = this.translatorsCombo.getText();
        this.fromLanguage = this.fromCombo.getText();
        TranslatorManager.getInstance().setTranslatorBranding(this.translator, this.translatorBrandingImage);
    }

    protected void initializeBounds() {
        super.initializeBounds();
        this.validateSelection();
    }

    private void validateSelection() {
        boolean bl = true;
        if (this.fromLanguage == null) {
            bl = false;
        }
        if (this.getDestinationColumns().size() == 0) {
            bl = false;
        }
        for (DestinationColumn destinationColumn : this.getDestinationColumns()) {
            if (destinationColumn.getLang() != null) continue;
            bl = false;
            break;
        }
        if (this.translator == null || this.translator.length() == 0) {
            bl = false;
        }
        this.getButton(0).setEnabled(bl);
    }

    private void createNetworkGroup(Composite composite) {
        IPreferenceNode iPreferenceNode3;
        PreferenceManager preferenceManager = PlatformUI.getWorkbench().getPreferenceManager();
        IPreferenceNode iPreferenceNode2 = null;
        for (IPreferenceNode iPreferenceNode3 : preferenceManager.getElements(0)) {
            if (!iPreferenceNode3.getId().equals(PROXY_PREFERENCE_PAGE_ID)) continue;
            iPreferenceNode2 = iPreferenceNode3;
            break;
        }
        this.prefMan = new PreferenceManager();
        if (iPreferenceNode2 != null) {
            this.prefMan.addToRoot(iPreferenceNode2);
        }
        iPreferenceNode3 = new Link(composite, 64);
        iPreferenceNode3.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                TranslateColumnsInputDialog.this.openNetworkPreferencesPage();
            }
        });
        String string = Messages.bind((String)Messages.NetworkLinkText, (Object)Messages.NetworkLinkText, (Object)Messages.NetworkLinkLink);
        iPreferenceNode3.setText(string);
        iPreferenceNode3.update();
        GridData gridData = new GridData(4, 0x1000000, true, false, 1, 1);
        iPreferenceNode3.setLayoutData((Object)gridData);
    }

    class ComboListener
    implements SelectionListener {
        ComboListener() {
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            this.widgetSelected(selectionEvent);
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.getSource() == TranslateColumnsInputDialog.this.fromCombo) {
                if (!TranslateColumnsInputDialog.this.fromCombo.getText().equals(LanguagesUtil.getComboSeparator())) {
                    TranslateColumnsInputDialog.this.fromLanguage = TranslateColumnsInputDialog.this.fromCombo.getText();
                    if (!TranslateColumnsInputDialog.this.fromLanguage.equals(LanguagesUtil.getComboSeparator())) {
                        PreferencesManager.getInstance().getProjectPreferencesManager(TranslateColumnsInputDialog.this.project).setDefaultLanguageForColumn(TranslateColumnsInputDialog.this.selectedColumn, LanguagesUtil.getLanguageID(TranslateColumnsInputDialog.this.fromLanguage));
                    }
                } else {
                    TranslateColumnsInputDialog.this.fromLanguage = null;
                }
            } else if (selectionEvent.getSource() == TranslateColumnsInputDialog.this.translatorsCombo) {
                TranslateColumnsInputDialog.this.translator = TranslateColumnsInputDialog.this.translatorsCombo.getText();
                TranslatorManager.getInstance().setTranslatorBranding(TranslateColumnsInputDialog.this.translator, TranslateColumnsInputDialog.this.translatorBrandingImage);
            }
            TranslateColumnsInputDialog.this.validateSelection();
        }
    }

    public class DestinationColumn {
        private Button checkbox;
        private boolean isSelected = false;
        private String text;
        private String lang;

        public DestinationColumn(Button button, boolean bl, String string, String string2) {
            this.checkbox = button;
            this.text = string;
            this.isSelected = bl;
            this.lang = string2;
        }

        public Button getCheckbox() {
            return this.checkbox;
        }

        public void setCheckbox(Button button) {
            this.checkbox = button;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String string) {
            this.text = string;
        }

        public String getLang() {
            return this.lang;
        }

        public void setLang(String string) {
            this.lang = string;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean bl) {
            this.isSelected = bl;
            this.getCheckbox().setSelection(bl);
        }
    }
}

