/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.sequoyah.device.framework.factory.DeviceTypeRegistry;
import org.eclipse.sequoyah.device.framework.model.IDeviceType;
import org.eclipse.sequoyah.device.framework.ui.internal.model.DeviceTypeCustomWizardPage;
import org.eclipse.sequoyah.device.framework.ui.model.IDeviceTypeCustomWizardPage;
import org.eclipse.sequoyah.device.framework.ui.wizard.DefaultDeviceTypeMenuWizardPage;
import org.eclipse.sequoyah.device.framework.ui.wizard.DeviceWizardRunnable;
import org.eclipse.sequoyah.device.framework.ui.wizard.NewDeviceMenuWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceTypeCustomMenuWizardPageHandler {
    private NewDeviceMenuWizard wizard;
    private static final String WIZARD_PAGES_EXTENSION_POINT_ID = "org.eclipse.sequoyah.device.framework.ui.newDeviceWizardPages";
    private static final String XML_ELEMENT_WIZARD_PAGE = "wizardPage";
    private static final String XML_ATTRIBUTE_ID = "id";
    private static final String XML_ATTRIBUTE_OPERATION_CLASS = "operationClass";
    private static final String XML_ATTRIBUTE_PAGE_CLASS = "pageClass";
    private static final String XML_ELEMENT_DEVICE_TYPE = "deviceType";
    private static final String XML_ATTRIBUTE_DEVICE_TYPE_ID = "deviceTypeId";
    private static Map<String, ArrayList<IDeviceTypeCustomWizardPage>> customPages = new HashMap<String, ArrayList<IDeviceTypeCustomWizardPage>>();

    public DeviceTypeCustomMenuWizardPageHandler(NewDeviceMenuWizard newDeviceMenuWizard) {
        this.wizard = newDeviceMenuWizard;
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        DeviceTypeCustomMenuWizardPageHandler.loadExtensionsSynchronized();
        ArrayList<IDeviceTypeCustomWizardPage> arrayList = customPages.get(this.wizard.getCurrentDeviceTypeId());
        if (arrayList == null) {
            return null;
        }
        if (iWizardPage instanceof DefaultDeviceTypeMenuWizardPage) {
            return arrayList.get(0).getPageClass();
        }
        int n = 0;
        while (n < arrayList.size() - 1) {
            IDeviceTypeCustomWizardPage iDeviceTypeCustomWizardPage = arrayList.get(n);
            if (iDeviceTypeCustomWizardPage.getPageClass().equals(iWizardPage)) {
                return arrayList.get(n + 1).getPageClass();
            }
            ++n;
        }
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage iWizardPage) {
        DeviceTypeCustomMenuWizardPageHandler.loadExtensionsSynchronized();
        if (iWizardPage instanceof DefaultDeviceTypeMenuWizardPage) {
            return null;
        }
        ArrayList<IDeviceTypeCustomWizardPage> arrayList = customPages.get(this.wizard.getCurrentDeviceTypeId());
        if (arrayList != null) {
            if (iWizardPage instanceof DefaultDeviceTypeMenuWizardPage) {
                return null;
            }
            int n = arrayList.size() - 1;
            while (n >= 0) {
                IDeviceTypeCustomWizardPage iDeviceTypeCustomWizardPage = arrayList.get(n);
                if (iDeviceTypeCustomWizardPage.getPageClass().equals(iWizardPage)) {
                    if (n == 0) {
                        return this.wizard.getPage(NewDeviceMenuWizard.DEFAULT_PAGE_ID);
                    }
                    return arrayList.get(n - 1).getPageClass();
                }
                --n;
            }
        }
        return null;
    }

    private static synchronized void loadExtensionsSynchronized() {
        if (!customPages.isEmpty()) {
            return;
        }
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(WIZARD_PAGES_EXTENSION_POINT_ID);
        if (iExtensionPoint != null) {
            Object object;
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            if (iExtensionArray != null) {
                int n = 0;
                while (n < iExtensionArray.length) {
                    IExtension iExtension = iExtensionArray[n];
                    object = iExtension.getConfigurationElements();
                    int n2 = 0;
                    while (n2 < ((IConfigurationElement[])object).length) {
                        IConfigurationElement iConfigurationElement = object[n2];
                        if (iConfigurationElement.getName().equals(XML_ELEMENT_WIZARD_PAGE)) {
                            String string = iConfigurationElement.getAttribute(XML_ATTRIBUTE_ID);
                            DeviceWizardRunnable deviceWizardRunnable = null;
                            try {
                                IWizardPage iWizardPage = (IWizardPage)iConfigurationElement.createExecutableExtension(XML_ATTRIBUTE_PAGE_CLASS);
                                if (iConfigurationElement.getAttribute(XML_ATTRIBUTE_OPERATION_CLASS) != null) {
                                    deviceWizardRunnable = (DeviceWizardRunnable)iConfigurationElement.createExecutableExtension(XML_ATTRIBUTE_OPERATION_CLASS);
                                    deviceWizardRunnable.setPage(iWizardPage);
                                }
                                DeviceTypeCustomWizardPage deviceTypeCustomWizardPage = new DeviceTypeCustomWizardPage(string, iWizardPage, deviceWizardRunnable);
                                IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
                                int n3 = 0;
                                while (n3 < iConfigurationElementArray.length) {
                                    IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[n3];
                                    if (iConfigurationElement2.getName().equals(XML_ELEMENT_DEVICE_TYPE)) {
                                        ArrayList<Object> arrayList;
                                        String string2 = iConfigurationElement2.getAttribute(XML_ATTRIBUTE_DEVICE_TYPE_ID);
                                        if (customPages.containsKey(string2)) {
                                            arrayList = customPages.get(string2);
                                            arrayList.add(deviceTypeCustomWizardPage);
                                        } else {
                                            arrayList = new ArrayList();
                                            arrayList.add(deviceTypeCustomWizardPage);
                                            customPages.put(string2, arrayList);
                                        }
                                    }
                                    ++n3;
                                }
                            }
                            catch (CoreException coreException) {
                                coreException.printStackTrace();
                            }
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            for (String string : DeviceTypeRegistry.getInstance().getDeviceTypeIds()) {
                object = customPages.get(string);
                ArrayList<IDeviceTypeCustomWizardPage> arrayList = DeviceTypeCustomMenuWizardPageHandler.getSuperClassWizardPages(string);
                if (object != null) {
                    if (arrayList == null) continue;
                    ((ArrayList)object).addAll(0, arrayList);
                    continue;
                }
                if (arrayList == null) continue;
                object = new ArrayList();
                ((ArrayList)object).addAll(arrayList);
                customPages.put(string, (ArrayList<IDeviceTypeCustomWizardPage>)object);
            }
        }
    }

    private static ArrayList<IDeviceTypeCustomWizardPage> getSuperClassWizardPages(String string) {
        String string2;
        IDeviceType iDeviceType;
        ArrayList<IDeviceTypeCustomWizardPage> arrayList;
        ArrayList<IDeviceTypeCustomWizardPage> arrayList2 = new ArrayList<IDeviceTypeCustomWizardPage>();
        if (customPages != null && (arrayList = customPages.get(string)) != null && (iDeviceType = DeviceTypeRegistry.getInstance().getDeviceTypeById(string)) != null && (string2 = iDeviceType.getSuperClass()) != null) {
            arrayList2.addAll(0, DeviceTypeCustomMenuWizardPageHandler.getSuperClassWizardPages(string2));
            ArrayList<IDeviceTypeCustomWizardPage> arrayList3 = customPages.get(string2);
            int n = 0;
            if (arrayList3 != null) {
                for (IDeviceTypeCustomWizardPage iDeviceTypeCustomWizardPage : arrayList3) {
                    if (DeviceTypeCustomMenuWizardPageHandler.isPageExists(iDeviceTypeCustomWizardPage.getId(), arrayList)) continue;
                    arrayList2.add(n++, iDeviceTypeCustomWizardPage);
                }
            }
        }
        return arrayList2;
    }

    private static boolean isPageExists(String string, ArrayList<IDeviceTypeCustomWizardPage> arrayList) {
        if (arrayList != null) {
            for (IDeviceTypeCustomWizardPage iDeviceTypeCustomWizardPage : arrayList) {
                if (!iDeviceTypeCustomWizardPage.getId().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canFinish() {
        DeviceTypeCustomMenuWizardPageHandler.loadExtensionsSynchronized();
        ArrayList<IDeviceTypeCustomWizardPage> arrayList = customPages.get(this.wizard.getCurrentDeviceTypeId());
        if (arrayList != null) {
            for (IDeviceTypeCustomWizardPage iDeviceTypeCustomWizardPage : arrayList) {
                if (iDeviceTypeCustomWizardPage.getPageClass().isPageComplete()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean performFinish() {
        DeviceTypeCustomMenuWizardPageHandler.loadExtensionsSynchronized();
        ArrayList<IDeviceTypeCustomWizardPage> arrayList = customPages.get(this.wizard.getCurrentDeviceTypeId());
        if (arrayList == null) {
            return true;
        }
        ArrayList<IRunnableWithProgress> arrayList2 = new ArrayList<IRunnableWithProgress>();
        for (IDeviceTypeCustomWizardPage iDeviceTypeCustomWizardPage : arrayList) {
            IRunnableWithProgress interruptedException = iDeviceTypeCustomWizardPage.getOperationClass();
            if (interruptedException == null) continue;
            arrayList2.add(interruptedException);
        }
        for (IRunnableWithProgress iRunnableWithProgress : arrayList2) {
            try {
                this.wizard.getContainer().run(false, true, iRunnableWithProgress);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return true;
    }
}

