/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.editor.datatype;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellInfo {
    private String value;
    private String comment;
    private boolean dirty;
    private int position = -1;
    private final List<CellInfo> children;

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public CellInfo(String string, String string2, int n) {
        this(false);
        this.value = string;
        this.comment = string2;
        this.dirty = false;
        this.position = n;
    }

    public CellInfo(String string, String string2) {
        this(string, string2, -1);
    }

    public CellInfo(CellInfo cellInfo) {
        this(cellInfo.hasChildren());
        this.value = cellInfo.getValue();
        this.comment = cellInfo.getComment();
        this.dirty = false;
        if (cellInfo.hasChildren()) {
            for (CellInfo cellInfo2 : cellInfo.getChildren()) {
                this.addChild(cellInfo2);
            }
        }
    }

    public CellInfo(boolean bl) {
        this.children = bl ? new ArrayList<CellInfo>() : null;
    }

    public String toString() {
        return this.getValue() != null ? this.getValue() : "";
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean hasChildren() {
        return this.children != null;
    }

    public List<CellInfo> getChildren() {
        return new ArrayList<CellInfo>(this.children);
    }

    public void clearChildren() {
        if (this.children != null) {
            this.children.clear();
        }
    }

    public void addChild(CellInfo cellInfo) {
        this.ensurePosition(cellInfo);
        if (this.children != null) {
            this.children.add(cellInfo);
            cellInfo.setPosition(this.children.indexOf(cellInfo));
        }
    }

    public void addChild(CellInfo cellInfo, int n, boolean bl) {
        this.ensurePosition(bl ? n + 1 : n);
        if (this.children != null) {
            if (cellInfo != null) {
                cellInfo.setPosition(n);
            }
            if (!bl) {
                this.children.add(n, cellInfo);
                int n2 = n + 1;
                while (n2 < this.children.size()) {
                    this.children.get(n2).setPosition(this.children.get(n2).getPosition() + 1);
                    ++n2;
                }
            } else {
                this.children.set(n, cellInfo);
            }
        }
    }

    private void ensurePosition(CellInfo cellInfo) {
        this.ensurePosition(cellInfo.getPosition());
    }

    private void ensurePosition(int n) {
        int n2 = this.children.size();
        while (n2 < n) {
            this.addChild(new CellInfo(null, null, n2), n2, false);
            ++n2;
        }
    }

    public void removeChild(int n) {
        if (this.children != null && this.children.size() > n) {
            this.children.remove(n);
            int n2 = n;
            while (n2 < this.children.size()) {
                this.children.get(n2).setPosition(this.children.get(n2).getPosition() - 1);
                ++n2;
            }
        }
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public int getPosition() {
        return this.position;
    }
}

