/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.editor.model;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfoLeaf;
import org.eclipse.sequoyah.localization.editor.i18n.Messages;
import org.eclipse.sequoyah.localization.editor.model.StringEditorPart;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class StringEditorViewerEditableTooltipSupport
extends ColumnViewerToolTipSupport {
    private String tooltipText;
    private final ColumnViewer viewer;
    private Event currentTooltipEvent;
    private final StringEditorPart editor;

    protected StringEditorViewerEditableTooltipSupport(ColumnViewer columnViewer, int n, boolean bl, StringEditorPart stringEditorPart) {
        super(columnViewer, n, bl);
        this.setHideOnMouseDown(false);
        this.tooltipText = null;
        this.viewer = columnViewer;
        this.editor = stringEditorPart;
    }

    public static void enableFor(ColumnViewer columnViewer, int n, StringEditorPart stringEditorPart) {
        new StringEditorViewerEditableTooltipSupport(columnViewer, n, false, stringEditorPart);
    }

    protected Composite createViewerToolTipContentArea(Event event, ViewerCell viewerCell, Composite composite) {
        Composite composite2 = null;
        if (viewerCell.getColumnIndex() != 0) {
            final String string = this.getText(event);
            composite2 = new Composite(composite, 4);
            GridLayout gridLayout = new GridLayout();
            composite2.setLayout((Layout)gridLayout);
            final Text text = new Text(composite2, 66);
            GridData gridData = new GridData(1808);
            gridData.minimumWidth = 200;
            gridData.minimumHeight = 50;
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            text.setText(string.trim().length() > 0 ? string : Messages.StringEditorViewerEditableTooltipSupport_TypeYourComment);
            text.setLayoutData((Object)gridData);
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    StringEditorViewerEditableTooltipSupport.this.tooltipText = ((Text)modifyEvent.widget).getText();
                }
            });
            text.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent focusEvent) {
                }

                public void focusGained(FocusEvent focusEvent) {
                    if (string.trim().length() == 0) {
                        text.setText("");
                        StringEditorViewerEditableTooltipSupport.this.tooltipText = null;
                    }
                }
            });
        } else {
            composite2 = super.createViewerToolTipContentArea(event, viewerCell, composite);
        }
        this.currentTooltipEvent = event;
        return composite2;
    }

    protected void afterHideToolTip(Event event) {
        ViewerCell viewerCell;
        if (this.currentTooltipEvent != null && (viewerCell = this.viewer.getCell(new Point(this.currentTooltipEvent.x, this.currentTooltipEvent.y))).getColumnIndex() != 0) {
            if (viewerCell.getViewerRow().getElement() instanceof RowInfoLeaf) {
                RowInfoLeaf rowInfoLeaf = (RowInfoLeaf)viewerCell.getViewerRow().getElement();
                TreeColumn treeColumn = ((Tree)this.viewer.getControl()).getColumn(viewerCell.getColumnIndex());
                if (this.tooltipText != null && !this.tooltipText.trim().equals(rowInfoLeaf.getCells().get(treeColumn.getText()).getComment())) {
                    rowInfoLeaf.getCells().get(treeColumn.getText()).setComment(this.tooltipText.trim());
                    if (this.editor != null) {
                        try {
                            if (rowInfoLeaf.getParent() == null) {
                                this.editor.getEditorInput().setCellTooltip(treeColumn.getText(), rowInfoLeaf.getKey(), this.tooltipText);
                            } else {
                                this.editor.getEditorInput().setCellTooltip(treeColumn.getText(), rowInfoLeaf.getKey(), this.tooltipText, rowInfoLeaf.getPosition());
                            }
                            this.editor.fireDirtyPropertyChanged();
                        }
                        catch (SequoyahException sequoyahException) {
                            BasePlugin.logError((String)("Error setting cell tooltip: (" + treeColumn.getText() + ", " + rowInfoLeaf.getKey() + ") = " + this.tooltipText), (Throwable)sequoyahException);
                        }
                    }
                }
            }
            this.tooltipText = null;
            this.currentTooltipEvent = null;
        }
        super.afterHideToolTip(event);
    }
}

