/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.editor.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sequoyah.localization.editor.datatype.CellInfo;
import org.eclipse.sequoyah.localization.editor.datatype.ColumnInfo;
import org.eclipse.sequoyah.localization.editor.datatype.IModelChangedListener;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfo;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfoLeaf;
import org.eclipse.sequoyah.localization.editor.providers.ICellValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringEditorViewerModel {
    private static final String DEFAULT_COLUMN_NAME = "values";
    private static final int INDEX_NOT_REQUIRED = -1;
    private final List<ColumnInfo> columns;
    private final Map<String, ColumnInfo> columnsMap;
    private final Map<String, RowInfo> rowsMap;
    private final ICellValidator validator;
    private final List<IModelChangedListener> listeners;

    public StringEditorViewerModel(List<ColumnInfo> list, ICellValidator iCellValidator) {
        this.columns = list;
        this.columnsMap = new HashMap<String, ColumnInfo>();
        this.rowsMap = new TreeMap<String, RowInfo>();
        this.listeners = new ArrayList<IModelChangedListener>();
        this.validator = iCellValidator;
        this.initMaps();
        this.doInitialValidation();
    }

    private void doInitialValidation() {
        for (RowInfo rowInfo : this.rowsMap.values()) {
            this.validateRow(rowInfo.getKey());
        }
    }

    private void initMaps() {
        for (ColumnInfo columnInfo : this.columns) {
            this.columnsMap.put(columnInfo.getId(), columnInfo);
            for (String string : columnInfo.getCells().keySet()) {
                Object object;
                Object object2;
                CellInfo cellInfo = columnInfo.getCells().get(string);
                if (cellInfo.hasChildren()) {
                    Object object3;
                    Object object4;
                    Object object5;
                    if (this.rowsMap.get(string) == null) {
                        object2 = new RowInfo(string);
                        object = cellInfo.getChildren();
                        object5 = object.iterator();
                        while (object5.hasNext()) {
                            object4 = object5.next();
                            object3 = new HashMap();
                            object3.put(columnInfo.getId(), object4);
                            ((RowInfo)object2).addChild(new RowInfoLeaf(string, (RowInfo)object2, ((CellInfo)object4).getPosition(), (Map<String, CellInfo>)object3), ((CellInfo)object4).getPosition());
                        }
                        this.rowsMap.put(string, (RowInfo)object2);
                        continue;
                    }
                    object2 = this.rowsMap.get(string);
                    object = cellInfo.getChildren();
                    object4 = ((RowInfo)object2).getChildren();
                    object3 = object.iterator();
                    while (object3.hasNext()) {
                        Object object6;
                        object5 = object3.next();
                        if (((CellInfo)object5).getPosition() >= 0 && ((CellInfo)object5).getPosition() < object4.size() && object4.get(((CellInfo)object5).getPosition()) != null) {
                            object6 = (RowInfoLeaf)object4.get(((CellInfo)object5).getPosition());
                            ((RowInfoLeaf)object6).addCell(columnInfo.getId(), (CellInfo)object5);
                            continue;
                        }
                        object6 = new HashMap<String, Object>();
                        object6.put(columnInfo.getId(), object5);
                        ((RowInfo)object2).addChild(new RowInfoLeaf(string, (RowInfo)object2, ((CellInfo)object5).getPosition(), (Map<String, CellInfo>)object6), ((CellInfo)object5).getPosition());
                    }
                    continue;
                }
                if (this.rowsMap.get(string) == null) {
                    object2 = new HashMap();
                    object2.put(columnInfo.getId(), cellInfo);
                    object = new RowInfoLeaf(string, null, -1, (Map<String, CellInfo>)object2);
                    this.rowsMap.put(string, (RowInfo)object);
                    continue;
                }
                object2 = this.rowsMap.get(string);
                if (!(object2 instanceof RowInfoLeaf)) continue;
                ((RowInfoLeaf)object2).addCell(columnInfo.getId(), cellInfo);
            }
        }
        this.notifyListeners();
    }

    public RowInfo getRow(String string) {
        return this.rowsMap.get(string);
    }

    public ColumnInfo getColumn(String string) {
        return this.columnsMap.get(string);
    }

    public Map<String, RowInfo> getRows() {
        return this.rowsMap;
    }

    public List<ColumnInfo> getColumns() {
        return this.columns;
    }

    public void addColumn(ColumnInfo columnInfo) {
        this.columns.add(columnInfo);
        this.columnsMap.put(columnInfo.getId(), columnInfo);
        Map<String, CellInfo> map = columnInfo.getCells();
        HashMap<String, CellInfo> hashMap = new HashMap<String, CellInfo>(map);
        for (String string : hashMap.keySet()) {
            Object object;
            CellInfo cellInfo = map.get(string);
            RowInfo rowInfo = this.rowsMap.get(string);
            if (cellInfo != null && cellInfo.hasChildren() && cellInfo.getChildren().size() > 0) {
                Object object2;
                Object object3;
                Object object4;
                object = cellInfo.getChildren();
                if (rowInfo == null) {
                    rowInfo = new RowInfo(string);
                    this.rowsMap.put(string, rowInfo);
                    object4 = object.iterator();
                    while (object4.hasNext()) {
                        object3 = (CellInfo)object4.next();
                        object2 = new HashMap();
                        object2.put(columnInfo.getId(), object3);
                        rowInfo.addChild(new RowInfoLeaf(string, rowInfo, ((CellInfo)object3).getPosition(), (Map<String, CellInfo>)object2), ((CellInfo)object3).getPosition());
                    }
                } else {
                    object3 = rowInfo.getChildren();
                    object2 = object.iterator();
                    while (object2.hasNext()) {
                        Object object5;
                        object4 = (CellInfo)object2.next();
                        if (object4 == null) continue;
                        if (((CellInfo)object4).getPosition() >= 0 && ((CellInfo)object4).getPosition() < object3.size() && object3.get(((CellInfo)object4).getPosition()) != null) {
                            object5 = (RowInfoLeaf)object3.get(((CellInfo)object4).getPosition());
                            this.addCellIfItIsNotOnDefaultColumn(columnInfo, (RowInfoLeaf)object5);
                            ((RowInfoLeaf)object5).addCell(columnInfo.getId(), (CellInfo)object4);
                            continue;
                        }
                        object5 = new HashMap<String, Object>();
                        object5.put(columnInfo.getId(), object4);
                        this.addRow(new RowInfoLeaf(string, rowInfo, ((CellInfo)object4).getPosition(), (Map<String, CellInfo>)object5));
                    }
                }
            } else if (cellInfo != null && !cellInfo.hasChildren()) {
                if (rowInfo == null) {
                    object = new HashMap();
                    object.put(columnInfo.getId(), cellInfo);
                    rowInfo = new RowInfoLeaf(string, null, -1, (Map<String, CellInfo>)object);
                    this.rowsMap.put(string, rowInfo);
                } else if (rowInfo instanceof RowInfoLeaf) {
                    object = (RowInfoLeaf)rowInfo;
                    this.addCellIfItIsNotOnDefaultColumn(columnInfo, (RowInfoLeaf)object);
                    ((RowInfoLeaf)object).addCell(columnInfo.getId(), cellInfo);
                }
            }
            if (rowInfo == null) continue;
            this.validateRow(rowInfo);
        }
        this.notifyListeners();
    }

    private void addCellIfItIsNotOnDefaultColumn(ColumnInfo columnInfo, RowInfoLeaf rowInfoLeaf) {
        if (!columnInfo.getId().equals(DEFAULT_COLUMN_NAME) && rowInfoLeaf.getCells() != null && rowInfoLeaf.getCells().get(DEFAULT_COLUMN_NAME) == null) {
            rowInfoLeaf.addCell(DEFAULT_COLUMN_NAME, new CellInfo("", ""));
        }
    }

    public void addRow(RowInfo rowInfo) {
        Map<String, CellInfo> map = null;
        if (rowInfo instanceof RowInfoLeaf) {
            RowInfoLeaf rowInfoLeaf = (RowInfoLeaf)rowInfo;
            if (rowInfoLeaf.getParent() == null) {
                map = rowInfoLeaf.getCells();
                for (String linkedHashMap : this.columnsMap.keySet()) {
                    CellInfo columnInfo;
                    ColumnInfo columnInfo2 = this.columnsMap.get(linkedHashMap);
                    if (columnInfo2 == null) {
                        columnInfo2 = new ColumnInfo(linkedHashMap, linkedHashMap, null, true);
                        this.columnsMap.put(linkedHashMap, columnInfo2);
                        this.columns.add(columnInfo2);
                    }
                    if ((columnInfo = map.get(linkedHashMap)) == null) {
                        columnInfo = new CellInfo(false);
                    }
                    columnInfo2.addCell(rowInfo.getKey(), columnInfo);
                    this.rowsMap.put(rowInfo.getKey(), rowInfo);
                }
            } else {
                RowInfo rowInfo2 = rowInfoLeaf.getParent();
                if (this.rowsMap.get(rowInfo2.getKey()) == null) {
                    this.rowsMap.put(rowInfo2.getKey(), rowInfo2);
                }
                if (!rowInfo2.getChildren().contains(rowInfoLeaf)) {
                    rowInfo2.addChild(rowInfoLeaf, rowInfoLeaf.getPosition());
                }
                for (String string : this.columnsMap.keySet()) {
                    CellInfo cellInfo;
                    CellInfo cellInfo2;
                    ColumnInfo columnInfo = this.columnsMap.get(string);
                    if (columnInfo == null) {
                        columnInfo = new ColumnInfo(string, string, null, true);
                        this.columnsMap.put(string, columnInfo);
                        this.columns.add(columnInfo);
                    }
                    if ((cellInfo2 = columnInfo.getCells().get(rowInfo2.getKey())) == null) {
                        cellInfo2 = new CellInfo(true);
                        columnInfo.addCell(rowInfo2.getKey(), cellInfo2);
                    }
                    if ((cellInfo = rowInfoLeaf.getCells().get(string)) == null) {
                        cellInfo = new CellInfo(null, null, rowInfoLeaf.getPosition());
                    }
                    cellInfo2.addChild(cellInfo, rowInfoLeaf.getPosition(), false);
                }
            }
        } else {
            List<RowInfoLeaf> list = rowInfo.getChildren();
            LinkedHashMap<String, CellInfo> linkedHashMap = new LinkedHashMap<String, CellInfo>();
            for (RowInfoLeaf object : list) {
                map = object.getCells();
                for (ColumnInfo columnInfo : this.columns) {
                    CellInfo cellInfo;
                    String string = columnInfo.getId();
                    CellInfo cellInfo3 = (CellInfo)linkedHashMap.get(string);
                    if (cellInfo3 == null) {
                        cellInfo3 = new CellInfo(true);
                        linkedHashMap.put(string, cellInfo3);
                    }
                    if ((cellInfo = map.get(string)) == null) {
                        cellInfo = new CellInfo(false);
                    }
                    cellInfo3.addChild(cellInfo);
                }
            }
            for (String string : linkedHashMap.keySet()) {
                ColumnInfo columnInfo;
                columnInfo = this.columnsMap.get(string);
                if (columnInfo == null) {
                    columnInfo = new ColumnInfo(string, string, null, true);
                    this.columnsMap.put(string, columnInfo);
                    this.columns.add(columnInfo);
                }
                columnInfo.addCell(rowInfo.getKey(), (CellInfo)linkedHashMap.get(string));
            }
            this.rowsMap.put(rowInfo.getKey(), rowInfo);
        }
        this.validateRow(rowInfo);
        this.notifyListeners();
    }

    public void addCell(CellInfo cellInfo, String string, String string2) {
        this.addCell(cellInfo, string, string2, -1, false);
    }

    public void addCell(CellInfo cellInfo, String string, String string2, Integer n, boolean bl) {
        RowInfo rowInfo = this.rowsMap.get(string);
        if (rowInfo instanceof RowInfoLeaf) {
            RowInfoLeaf rowInfoLeaf = (RowInfoLeaf)rowInfo;
            if (rowInfoLeaf.getParent() == null) {
                this.columnsMap.get(string2).addCell(string, cellInfo);
            }
            rowInfoLeaf.addCell(string2, cellInfo);
        } else if (n >= 0) {
            List<RowInfoLeaf> list = rowInfo.getChildren();
            Map<String, CellInfo> map = list.get(n).getCells();
            map.put(string2, cellInfo);
            ColumnInfo columnInfo = this.columnsMap.get(string2);
            CellInfo cellInfo2 = columnInfo.getCells().get(string);
            if (cellInfo2 == null) {
                cellInfo2 = new CellInfo(true);
                columnInfo.addCell(string, cellInfo2);
            }
            cellInfo2.addChild(cellInfo, n, bl);
        }
        this.validateRow(string);
        this.notifyListeners();
    }

    public void removeColumn(String string) {
        this.columnsMap.remove(string);
        ArrayList<ColumnInfo> arrayList = new ArrayList<ColumnInfo>(this.columns);
        for (ColumnInfo object2 : arrayList) {
            if (!object2.getId().equals(string)) continue;
            this.columns.remove(object2);
        }
        HashMap<String, RowInfo> hashMap = new HashMap<String, RowInfo>(this.rowsMap);
        for (RowInfo rowInfo : hashMap.values()) {
            if (rowInfo instanceof RowInfoLeaf) {
                ((RowInfoLeaf)rowInfo).removeCell(string);
                if (!this.isEmptyRow(rowInfo)) continue;
                this.removeRow(rowInfo.getKey());
                continue;
            }
            for (RowInfoLeaf rowInfoLeaf : new ArrayList<RowInfoLeaf>(rowInfo.getChildren())) {
                rowInfoLeaf.removeCell(string);
                if (!this.isEmptyRow(rowInfoLeaf)) continue;
                this.removeRow(rowInfoLeaf.getKey(), rowInfoLeaf.getPosition());
            }
        }
        this.notifyListeners();
    }

    public void removeColumnForRevertion(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.columnsMap.remove(string);
        ArrayList<ColumnInfo> arrayList2 = new ArrayList<ColumnInfo>(this.columns);
        for (ColumnInfo object2 : arrayList2) {
            if (!object2.getId().equals(string)) continue;
            this.columns.remove(object2);
        }
        HashMap<String, RowInfo> hashMap = new HashMap<String, RowInfo>(this.rowsMap);
        for (RowInfo rowInfo : hashMap.values()) {
            Object object;
            if (rowInfo instanceof RowInfoLeaf) {
                object = (RowInfoLeaf)rowInfo;
                ((RowInfoLeaf)object).removeCell(string);
                if (!this.isEmptyRow(rowInfo)) continue;
                this.removeRow(rowInfo.getKey());
                continue;
            }
            object = rowInfo.getChildren();
            ArrayList arrayList3 = new ArrayList(object);
            arrayList.clear();
            Iterator iterator = arrayList3.iterator();
            int n = 0;
            int n2 = -2;
            while (iterator.hasNext()) {
                RowInfoLeaf rowInfoLeaf = (RowInfoLeaf)iterator.next();
                rowInfoLeaf.removeCell(string);
                if (rowInfoLeaf.getCells().isEmpty()) {
                    if (!arrayList.isEmpty() && n - n2 != 1) {
                        arrayList.clear();
                    }
                    arrayList.add(n);
                    n2 = n;
                }
                ++n;
            }
            if (n2 < n - 1) {
                arrayList.clear();
            }
            n = 0;
            for (RowInfoLeaf rowInfoLeaf : arrayList3) {
                if (arrayList.contains(n)) {
                    this.removeRow(rowInfo.getKey(), rowInfoLeaf.getPosition());
                    object.remove(rowInfoLeaf.getPosition());
                }
                ++n;
            }
            if (!object.isEmpty()) continue;
            this.removeRow(rowInfo.getKey());
        }
        this.notifyListeners();
    }

    private boolean isEmptyRow(RowInfo rowInfo) {
        if (rowInfo instanceof RowInfoLeaf) {
            return ((RowInfoLeaf)rowInfo).getCells().size() == 0;
        }
        return false;
    }

    public void removeRow(String string, int n) {
        RowInfo rowInfo = this.rowsMap.get(string);
        boolean bl = true;
        if (rowInfo != null) {
            rowInfo.removeChild(n);
            if (rowInfo.getChildren().size() == 0) {
                this.rowsMap.remove(string);
                bl = false;
            }
        }
        for (ColumnInfo columnInfo : this.columnsMap.values()) {
            CellInfo cellInfo = columnInfo.getCells().get(string);
            if (cellInfo == null) continue;
            cellInfo.removeChild(n);
            if (cellInfo.getChildren().size() != 0) continue;
            columnInfo.removeCell(string);
        }
        if (bl) {
            this.validateRow(rowInfo);
        }
        this.notifyListeners();
    }

    public void removeRow(String string) {
        this.rowsMap.remove(string);
        for (ColumnInfo columnInfo : this.columnsMap.values()) {
            columnInfo.removeCell(string);
        }
        this.notifyListeners();
    }

    public void renameKey(String string, String string2) {
        RowInfo rowInfo = this.rowsMap.get(string);
        if (rowInfo != null) {
            this.rowsMap.remove(string);
            rowInfo.setKey(string2);
            this.rowsMap.put(string2, rowInfo);
            for (ColumnInfo object : this.columns) {
                object.renameKey(string, string2);
            }
            this.validateRow(rowInfo);
            for (RowInfoLeaf rowInfoLeaf : rowInfo.getChildren()) {
                rowInfoLeaf.setKey(string2);
            }
        }
    }

    public void addListener(IModelChangedListener iModelChangedListener) {
        this.listeners.add(iModelChangedListener);
    }

    public void removeListener(IModelChangedListener iModelChangedListener) {
        this.listeners.remove(iModelChangedListener);
    }

    private void notifyListeners() {
        for (IModelChangedListener iModelChangedListener : this.listeners) {
            iModelChangedListener.modelChanged(this);
        }
    }

    public List<RowInfo> save() {
        ArrayList<RowInfo> arrayList = new ArrayList<RowInfo>();
        for (RowInfo rowInfo : this.rowsMap.values()) {
            List<RowInfoLeaf> list;
            if (rowInfo instanceof RowInfoLeaf) {
                list = new ArrayList<RowInfoLeaf>(1);
                list.add((RowInfoLeaf)rowInfo);
            } else {
                list = rowInfo.getChildren();
            }
            for (RowInfoLeaf rowInfoLeaf : list) {
                for (CellInfo cellInfo : rowInfoLeaf.getCells().values()) {
                    if (cellInfo == null || !cellInfo.isDirty()) continue;
                    cellInfo.setDirty(false);
                    arrayList.add(rowInfo);
                }
            }
        }
        return arrayList;
    }

    public List<ColumnInfo> getColumnsChanged() {
        HashSet<ColumnInfo> hashSet = new HashSet<ColumnInfo>();
        for (RowInfo rowInfo : this.rowsMap.values()) {
            List<RowInfoLeaf> list;
            if (rowInfo instanceof RowInfoLeaf) {
                list = new ArrayList<RowInfoLeaf>(1);
                list.add((RowInfoLeaf)rowInfo);
            } else {
                list = rowInfo.getChildren();
            }
            for (RowInfoLeaf rowInfoLeaf : list) {
                for (Map.Entry<String, CellInfo> entry : rowInfoLeaf.getCells().entrySet()) {
                    CellInfo cellInfo = entry.getValue();
                    if (cellInfo == null || !cellInfo.isDirty()) continue;
                    hashSet.add(this.columnsMap.get(entry.getKey()));
                }
            }
        }
        return new ArrayList<ColumnInfo>(hashSet);
    }

    public IStatus validateRowKey(String string) {
        RowInfo rowInfo = this.rowsMap.get(string);
        IStatus iStatus = this.validator.isKeyValid(rowInfo.getKey());
        if (!iStatus.isOK()) {
            rowInfo.addStatus(iStatus);
        }
        return iStatus;
    }

    public void validateRow(String string) {
        RowInfo rowInfo = this.rowsMap.get(string);
        this.validateRow(rowInfo);
    }

    public void validateRow(RowInfo rowInfo) {
        block5: {
            block4: {
                ColumnInfo columnInfo22;
                rowInfo.cleanStatus();
                if (!(rowInfo instanceof RowInfoLeaf)) break block4;
                RowInfoLeaf rowInfoLeaf = (RowInfoLeaf)rowInfo;
                if (rowInfoLeaf.getParent() == null) {
                    this.validateRowKey(rowInfo.getKey());
                }
                for (ColumnInfo columnInfo22 : this.columns) {
                    CellInfo cellInfo = rowInfoLeaf.getCells().get(columnInfo22.getId());
                    IStatus iStatus = this.validator.isCellValid(columnInfo22.getId(), rowInfo.getKey(), cellInfo != null ? cellInfo.getValue() : null);
                    if (iStatus.isOK()) continue;
                    rowInfo.addStatus(iStatus);
                }
                if (rowInfoLeaf.getParent() == null) break block5;
                columnInfo22 = rowInfoLeaf.getParent().getStatus();
                if (rowInfoLeaf.getStatus().getSeverity() <= columnInfo22.getSeverity()) break block5;
                columnInfo22 = rowInfoLeaf.getStatus();
                rowInfoLeaf.getParent().addStatus((IStatus)columnInfo22);
                break block5;
            }
            this.validateRowKey(rowInfo.getKey());
            IStatus iStatus = null;
            List<RowInfoLeaf> list = rowInfo.getChildren();
            for (RowInfoLeaf rowInfoLeaf : list) {
                rowInfoLeaf.cleanStatus();
                for (ColumnInfo columnInfo : this.columns) {
                    CellInfo cellInfo = rowInfoLeaf.getCells().get(columnInfo.getId());
                    iStatus = this.validator.isCellValid(columnInfo.getId(), rowInfo.getKey(), cellInfo != null ? cellInfo.getValue() : null);
                    if (iStatus.isOK()) continue;
                    rowInfoLeaf.addStatus(iStatus);
                }
                MultiStatus multiStatus = rowInfo.getStatus();
                if (rowInfoLeaf.getStatus().getSeverity() <= multiStatus.getSeverity()) continue;
                MultiStatus multiStatus2 = rowInfoLeaf.getStatus();
                rowInfo.addStatus((IStatus)multiStatus2);
            }
        }
    }

    public IStatus getStatus() {
        IStatus iStatus = null;
        for (RowInfo rowInfo : this.rowsMap.values()) {
            if (rowInfo.getStatus().isOK()) continue;
            if (iStatus == null) {
                iStatus = new MultiStatus("org.eclipse.sequoyah.localization.editor", 0, null, null);
            }
            iStatus.merge((IStatus)rowInfo.getStatus());
        }
        return iStatus != null ? iStatus : Status.OK_STATUS;
    }

    public CellInfo getCellInfo(String string, String string2, int n) {
        CellInfo cellInfo;
        CellInfo cellInfo2 = null;
        ColumnInfo columnInfo = this.columnsMap.get(string);
        if (columnInfo != null && (cellInfo = columnInfo.getCell(string2)) != null) {
            cellInfo2 = n >= 0 ? cellInfo.getChildren().get(n) : cellInfo;
        }
        return cellInfo2;
    }
}

