/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.editor.model.actions;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.sequoyah.localization.editor.StringEditorPlugin;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfo;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfoLeaf;
import org.eclipse.sequoyah.localization.editor.i18n.Messages;
import org.eclipse.sequoyah.localization.editor.model.StringEditorPart;
import org.eclipse.sequoyah.localization.editor.model.operations.AddKeyOperation;
import org.eclipse.sequoyah.localization.editor.model.operations.AddKeysOperation;
import org.eclipse.sequoyah.localization.editor.model.operations.EditorOperation;

public class AddArrayAction
extends Action {
    private final StringEditorPart stringEditorPart;
    int quantity = 1;
    public static final String ID = "Array";

    public AddArrayAction(StringEditorPart stringEditorPart) {
        super(Messages.StringEditorPart_AddArrayActionName);
        this.stringEditorPart = stringEditorPart;
        this.setImageDescriptor(StringEditorPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sequoyah.localization.editor", (String)"icons/string_array.png"));
        this.setId(ID);
        this.setDescription(String.valueOf(Messages.AddArrayAction_DescriptionPrefix) + ID);
    }

    public void setQuantity(int n) {
        this.quantity = n;
    }

    public void run() {
        RowInfo[] rowInfoArray = new RowInfo[this.quantity];
        rowInfoArray = this.stringEditorPart.getContentProvider().getOperationProvider().getNewArrayRow(this.quantity);
        if (rowInfoArray != null) {
            Object object;
            if (rowInfoArray.length > 1) {
                object = new AddKeysOperation(Messages.StringEditorPart_AddArrayOperationName, this.stringEditorPart, rowInfoArray);
                object.addContext(this.stringEditorPart.getUndoContext());
                this.stringEditorPart.executeOperation((EditorOperation)((Object)object));
            } else {
                object = rowInfoArray[0].getKey();
                if (rowInfoArray[0] instanceof RowInfo && this.stringEditorPart.getModel().getRow((String)object) == null) {
                    List<RowInfoLeaf> list = rowInfoArray[0].getChildren();
                    int n = 0;
                    while (n < list.size()) {
                        if (this.stringEditorPart.getModel().getRow(list.get(n).getCells().toString()) == null) {
                            AddKeyOperation addKeyOperation = new AddKeyOperation(Messages.StringEditorPart_AddArrayOperationName, this.stringEditorPart, rowInfoArray[0]);
                            addKeyOperation.addContext(this.stringEditorPart.getUndoContext());
                            this.stringEditorPart.executeOperation(addKeyOperation);
                        } else {
                            this.stringEditorPart.setMessage(Messages.bind((String)Messages.StringEditorPart_KeyAlreadyExistsErrorMessage, (Object)object), 3);
                        }
                        ++n;
                    }
                }
            }
        }
        int n = 0;
        this.stringEditorPart.getEditorViewer().editElement((Object)rowInfoArray[0], n);
        this.stringEditorPart.refreshButtonsEnabled();
        this.quantity = 1;
    }
}

