/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.editor.model.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sequoyah.localization.editor.datatype.TranslationInfo;
import org.eclipse.sequoyah.localization.editor.i18n.Messages;
import org.eclipse.sequoyah.localization.editor.model.StringEditorPart;
import org.eclipse.sequoyah.localization.editor.model.operations.AddColumnOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;

public class TranslateColumnAction
extends Action {
    private final StringEditorPart stringEditorPart;

    public TranslateColumnAction(StringEditorPart stringEditorPart) {
        super(Messages.StringEditorPart_TranslateActionName);
        this.stringEditorPart = stringEditorPart;
        this.setEnabled(this.stringEditorPart.getActiveColumn() != 0);
    }

    public void run() {
        TreeColumn treeColumn = this.stringEditorPart.getEditorViewer().getTree().getColumn(this.stringEditorPart.getActiveColumn());
        final TranslationInfo translationInfo = this.stringEditorPart.getContentProvider().getOperationProvider().getTranslatedColumnInfo(treeColumn.getText());
        if (translationInfo != null) {
            try {
                PlatformUI.getWorkbench().getProgressService().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                        iProgressMonitor.setTaskName(Messages.TranslationProgress_Connecting);
                        TreeColumn treeColumn = TranslateColumnAction.this.stringEditorPart.getEditorViewer().getTree().getColumn(TranslateColumnAction.this.stringEditorPart.getActiveColumn());
                        if (translationInfo != null && TranslateColumnAction.this.stringEditorPart.getColumnByID(translationInfo.getId()) == null) {
                            IStatus iStatus = TranslateColumnAction.this.stringEditorPart.getEditorInput().translateColumn(treeColumn.getText(), translationInfo, iProgressMonitor);
                            if (iStatus.isOK()) {
                                TranslateColumnAction.this.stringEditorPart.getEditorInput().getValues(translationInfo.getId());
                                AddColumnOperation addColumnOperation = new AddColumnOperation(Messages.StringEditorPart_TranslateActionName, TranslateColumnAction.this.stringEditorPart, translationInfo);
                                addColumnOperation.addContext(TranslateColumnAction.this.stringEditorPart.getUndoContext());
                                TranslateColumnAction.this.stringEditorPart.executeOperation(addColumnOperation);
                            } else {
                                iProgressMonitor.setCanceled(true);
                                ErrorDialog.openError((Shell)TranslateColumnAction.this.stringEditorPart.getEditorSite().getShell(), (String)Messages.StringEditorPart_TranslationError, (String)(String.valueOf(Messages.StringEditorPart_TranslationError) + "\n" + Messages.StringEditorPart_TranslationErrorCheckConnetion), (IStatus)iStatus);
                            }
                        } else {
                            iProgressMonitor.setCanceled(true);
                            MessageDialog.openError((Shell)TranslateColumnAction.this.stringEditorPart.getEditorSite().getShell(), (String)Messages.StringEditorPart_TranslationError, (String)Messages.StringEditorPart_TranslationErrorTargetExists);
                        }
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

