/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.editor.model.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfo;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfoLeaf;
import org.eclipse.sequoyah.localization.editor.model.StringEditorPart;
import org.eclipse.sequoyah.localization.editor.model.operations.EditorOperation;

public class AddArrayItemOperation
extends EditorOperation {
    private final RowInfo row;
    private int index = 0;
    private RowInfoLeaf item;
    private boolean wasExpanded = false;
    private boolean doRefresh = true;

    public AddArrayItemOperation(String string, StringEditorPart stringEditorPart, RowInfo rowInfo) {
        super(string, stringEditorPart);
        this.row = rowInfo;
    }

    public AddArrayItemOperation(String string, StringEditorPart stringEditorPart, RowInfo rowInfo, boolean bl) {
        this(string, stringEditorPart, rowInfo);
        this.doRefresh = bl;
    }

    public IStatus execute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        RowInfo rowInfo = this.getModel().getRow(this.row.getKey());
        this.index = rowInfo.getChildren().size();
        this.item = new RowInfoLeaf(rowInfo.getKey(), rowInfo, this.index, null);
        this.wasExpanded = this.getEditor().getEditorViewer().getExpandedState((Object)this.item.getParent());
        return this.redo(iProgressMonitor, iAdaptable);
    }

    public IStatus redo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        if (!this.wasExpanded) {
            this.getEditor().getEditorViewer().expandToLevel((Object)this.item, -1);
        }
        this.getEditor().addRow(this.item);
        if (this.doRefresh) {
            this.getEditor().refresh();
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        this.getEditor().removeRow(this.row.getKey(), this.index);
        if (!this.wasExpanded) {
            this.getEditor().getEditorViewer().collapseToLevel((Object)this.item.getParent(), -1);
        }
        if (this.doRefresh) {
            this.getEditor().refresh();
        }
        return Status.OK_STATUS;
    }
}

