/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.editor.model.operations;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfo;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfoLeaf;
import org.eclipse.sequoyah.localization.editor.model.StringEditorPart;
import org.eclipse.sequoyah.localization.editor.model.operations.EditorOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveKeyOperation
extends EditorOperation {
    private final List<RowInfo> rows = new ArrayList<RowInfo>();

    public RemoveKeyOperation(String string, StringEditorPart stringEditorPart, List<RowInfo> list) {
        super(string, stringEditorPart);
        for (RowInfo rowInfo : list) {
            if (rowInfo instanceof RowInfoLeaf) {
                if (this.rows.contains(rowInfo)) continue;
                this.rows.add(rowInfo);
                continue;
            }
            for (RowInfoLeaf rowInfoLeaf : rowInfo.getChildren()) {
                if (this.rows.contains(rowInfoLeaf)) continue;
                this.rows.add(rowInfoLeaf);
            }
        }
    }

    public IStatus execute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        return this.redo(iProgressMonitor, iAdaptable);
    }

    public IStatus redo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        HashMap<RowInfo, TreeSet<RowInfoLeaf>> hashMap = new HashMap<RowInfo, TreeSet<RowInfoLeaf>>();
        for (RowInfo object : this.rows) {
            if (object instanceof RowInfoLeaf) {
                RowInfoLeaf rowInfoLeaf = (RowInfoLeaf)object;
                if (rowInfoLeaf.getParent() == null) {
                    this.getEditor().removeRow(object.getKey());
                    continue;
                }
                TreeSet treeSet = (TreeSet)hashMap.get(rowInfoLeaf.getParent());
                if (treeSet == null) {
                    treeSet = new TreeSet(new LeavesInvertedPositionComparator());
                    hashMap.put(rowInfoLeaf.getParent(), treeSet);
                }
                treeSet.add(rowInfoLeaf);
                continue;
            }
            this.getEditor().removeRow(object.getKey());
        }
        if (!hashMap.isEmpty()) {
            for (TreeSet treeSet : hashMap.values()) {
                for (RowInfoLeaf rowInfoLeaf : treeSet) {
                    this.getEditor().removeRow(rowInfoLeaf.getKey(), rowInfoLeaf.getPosition());
                }
            }
        }
        this.getEditor().refresh();
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        for (RowInfo rowInfo : this.rows) {
            this.getEditor().addRow(rowInfo);
        }
        this.getEditor().refresh();
        return Status.OK_STATUS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LeavesInvertedPositionComparator
    implements Comparator<RowInfoLeaf> {
        private LeavesInvertedPositionComparator() {
        }

        @Override
        public int compare(RowInfoLeaf rowInfoLeaf, RowInfoLeaf rowInfoLeaf2) {
            int n = 0;
            if (rowInfoLeaf.getPosition() != null && rowInfoLeaf2.getPosition() != null) {
                n = rowInfoLeaf.getPosition().compareTo(rowInfoLeaf2.getPosition()) * -1;
            }
            return n;
        }
    }
}

