/**
 * Copyright (c) 2023 DB Netz AG and others.
 *  
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>ENUMW Kr Art</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.Weichen_und_GleissperrenPackage#getENUMWKrArt()
 * @model extendedMetaData="name='ENUMW_Kr_Art'"
 * @generated
 */
public enum ENUMWKrArt implements Enumerator {
	/**
	 * The '<em><b>ENUMW Kr Art ABW</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_KR_ART_ABW_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMW_KR_ART_ABW(0, "ENUMW_Kr_Art_ABW", "ABW"),

	/**
	 * The '<em><b>ENUMW Kr Art DKW</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_KR_ART_DKW_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMW_KR_ART_DKW(1, "ENUMW_Kr_Art_DKW", "DKW"),

	/**
	 * The '<em><b>ENUMW Kr Art DW</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_KR_ART_DW_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMW_KR_ART_DW(2, "ENUMW_Kr_Art_DW", "DW"),

	/**
	 * The '<em><b>ENUMW Kr Art EKW</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_KR_ART_EKW_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMW_KR_ART_EKW(3, "ENUMW_Kr_Art_EKW", "EKW"),

	/**
	 * The '<em><b>ENUMW Kr Art EW</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_KR_ART_EW_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMW_KR_ART_EW(4, "ENUMW_Kr_Art_EW", "EW"),

	/**
	 * The '<em><b>ENUMW Kr Art Flachkreuzung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_KR_ART_FLACHKREUZUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMW_KR_ART_FLACHKREUZUNG(5, "ENUMW_Kr_Art_Flachkreuzung", "Flachkreuzung"),

	/**
	 * The '<em><b>ENUMW Kr Art IBW</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_KR_ART_IBW_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMW_KR_ART_IBW(6, "ENUMW_Kr_Art_IBW", "IBW"),

	/**
	 * The '<em><b>ENUMW Kr Art Klothoidenweiche</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_KR_ART_KLOTHOIDENWEICHE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMW_KR_ART_KLOTHOIDENWEICHE(7, "ENUMW_Kr_Art_Klothoidenweiche", "Klothoidenweiche"),

	/**
	 * The '<em><b>ENUMW Kr Art Korbbogenweiche</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_KR_ART_KORBBOGENWEICHE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMW_KR_ART_KORBBOGENWEICHE(8, "ENUMW_Kr_Art_Korbbogenweiche", "Korbbogenweiche"),

	/**
	 * The '<em><b>ENUMW Kr Art Kr</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_KR_ART_KR_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMW_KR_ART_KR(9, "ENUMW_Kr_Art_Kr", "Kr"),

	/**
	 * The '<em><b>ENUMW Kr Art sonstige</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_KR_ART_SONSTIGE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMW_KR_ART_SONSTIGE(10, "ENUMW_Kr_Art_sonstige", "sonstige");

	/**
	 * The '<em><b>ENUMW Kr Art ABW</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_KR_ART_ABW
	 * @model name="ENUMW_Kr_Art_ABW" literal="ABW"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMW_KR_ART_ABW_VALUE = 0;

	/**
	 * The '<em><b>ENUMW Kr Art DKW</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_KR_ART_DKW
	 * @model name="ENUMW_Kr_Art_DKW" literal="DKW"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMW_KR_ART_DKW_VALUE = 1;

	/**
	 * The '<em><b>ENUMW Kr Art DW</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_KR_ART_DW
	 * @model name="ENUMW_Kr_Art_DW" literal="DW"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMW_KR_ART_DW_VALUE = 2;

	/**
	 * The '<em><b>ENUMW Kr Art EKW</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_KR_ART_EKW
	 * @model name="ENUMW_Kr_Art_EKW" literal="EKW"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMW_KR_ART_EKW_VALUE = 3;

	/**
	 * The '<em><b>ENUMW Kr Art EW</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_KR_ART_EW
	 * @model name="ENUMW_Kr_Art_EW" literal="EW"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMW_KR_ART_EW_VALUE = 4;

	/**
	 * The '<em><b>ENUMW Kr Art Flachkreuzung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_KR_ART_FLACHKREUZUNG
	 * @model name="ENUMW_Kr_Art_Flachkreuzung" literal="Flachkreuzung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMW_KR_ART_FLACHKREUZUNG_VALUE = 5;

	/**
	 * The '<em><b>ENUMW Kr Art IBW</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_KR_ART_IBW
	 * @model name="ENUMW_Kr_Art_IBW" literal="IBW"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMW_KR_ART_IBW_VALUE = 6;

	/**
	 * The '<em><b>ENUMW Kr Art Klothoidenweiche</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_KR_ART_KLOTHOIDENWEICHE
	 * @model name="ENUMW_Kr_Art_Klothoidenweiche" literal="Klothoidenweiche"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMW_KR_ART_KLOTHOIDENWEICHE_VALUE = 7;

	/**
	 * The '<em><b>ENUMW Kr Art Korbbogenweiche</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_KR_ART_KORBBOGENWEICHE
	 * @model name="ENUMW_Kr_Art_Korbbogenweiche" literal="Korbbogenweiche"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMW_KR_ART_KORBBOGENWEICHE_VALUE = 8;

	/**
	 * The '<em><b>ENUMW Kr Art Kr</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_KR_ART_KR
	 * @model name="ENUMW_Kr_Art_Kr" literal="Kr"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMW_KR_ART_KR_VALUE = 9;

	/**
	 * The '<em><b>ENUMW Kr Art sonstige</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMW_KR_ART_SONSTIGE
	 * @model name="ENUMW_Kr_Art_sonstige" literal="sonstige"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMW_KR_ART_SONSTIGE_VALUE = 10;

	/**
	 * An array of all the '<em><b>ENUMW Kr Art</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ENUMWKrArt[] VALUES_ARRAY =
		new ENUMWKrArt[] {
			ENUMW_KR_ART_ABW,
			ENUMW_KR_ART_DKW,
			ENUMW_KR_ART_DW,
			ENUMW_KR_ART_EKW,
			ENUMW_KR_ART_EW,
			ENUMW_KR_ART_FLACHKREUZUNG,
			ENUMW_KR_ART_IBW,
			ENUMW_KR_ART_KLOTHOIDENWEICHE,
			ENUMW_KR_ART_KORBBOGENWEICHE,
			ENUMW_KR_ART_KR,
			ENUMW_KR_ART_SONSTIGE,
		};

	/**
	 * A public read-only list of all the '<em><b>ENUMW Kr Art</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ENUMWKrArt> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>ENUMW Kr Art</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMWKrArt get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMWKrArt result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUMW Kr Art</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMWKrArt getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMWKrArt result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUMW Kr Art</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMWKrArt get(int value) {
		switch (value) {
			case ENUMW_KR_ART_ABW_VALUE: return ENUMW_KR_ART_ABW;
			case ENUMW_KR_ART_DKW_VALUE: return ENUMW_KR_ART_DKW;
			case ENUMW_KR_ART_DW_VALUE: return ENUMW_KR_ART_DW;
			case ENUMW_KR_ART_EKW_VALUE: return ENUMW_KR_ART_EKW;
			case ENUMW_KR_ART_EW_VALUE: return ENUMW_KR_ART_EW;
			case ENUMW_KR_ART_FLACHKREUZUNG_VALUE: return ENUMW_KR_ART_FLACHKREUZUNG;
			case ENUMW_KR_ART_IBW_VALUE: return ENUMW_KR_ART_IBW;
			case ENUMW_KR_ART_KLOTHOIDENWEICHE_VALUE: return ENUMW_KR_ART_KLOTHOIDENWEICHE;
			case ENUMW_KR_ART_KORBBOGENWEICHE_VALUE: return ENUMW_KR_ART_KORBBOGENWEICHE;
			case ENUMW_KR_ART_KR_VALUE: return ENUMW_KR_ART_KR;
			case ENUMW_KR_ART_SONSTIGE_VALUE: return ENUMW_KR_ART_SONSTIGE;
			default: return null;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ENUMWKrArt(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //ENUMWKrArt
