/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.internal;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.MissingSupplier;
import org.eclipse.set.basis.cache.Cache;
import org.eclipse.set.basis.constants.TableType;
import org.eclipse.set.basis.graph.AbstractDirectedEdgePath;
import org.eclipse.set.basis.graph.Digraphs;
import org.eclipse.set.basis.part.PartDescription;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.cache.CacheService;
import org.eclipse.set.feature.table.PlanPro2TableTransformationService;
import org.eclipse.set.feature.table.TableService;
import org.eclipse.set.feature.table.internal.EdgeToPointsCacheProxy;
import org.eclipse.set.feature.table.internal.TableServiceContextFunction;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableCell;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.extensions.TableCellExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableRowExtensions;
import org.eclipse.set.ppmodel.extensions.ContainerExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.ppmodel.extensions.utils.TableNameInfo;
import org.eclipse.set.services.table.TableDiffService;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.set.utils.table.TableError;

public final class TableServiceImpl
implements TableService {
    @Inject
    private TableDiffService diffService;
    @Inject
    private IEventBroker broker;
    @Inject
    CacheService cacheService;
    private final Map<String, PlanPro2TableTransformationService> modelServiceMap = new ConcurrentHashMap<String, PlanPro2TableTransformationService>();

    private CacheService getCache() {
        return ToolboxConfiguration.isDebugMode() ? Services.getNoCacheService() : this.cacheService;
    }

    void addModelService(PlanPro2TableTransformationService service, Map<String, Object> properties) throws IllegalAccessException {
        String elementId = TableServiceContextFunction.getElementId(properties);
        this.modelServiceMap.put(elementId, service);
    }

    void addModelServiceById(String elementId, PlanPro2TableTransformationService service) {
        this.modelServiceMap.put(elementId, service);
    }

    private Table createDiffTable(String elementId, IModelSession modelSession) {
        Table startTable = this.transformToTable(elementId, TableType.INITIAL, modelSession);
        Table zielTable = this.transformToTable(elementId, TableType.FINAL, modelSession);
        if (zielTable == null || startTable == null) {
            return null;
        }
        return this.diffService.createDiffTable(startTable, zielTable);
    }

    @Override
    public String extractShortcut(PartDescription element) {
        return element.getToolboxViewName().substring(0, 4);
    }

    @Override
    public String extractShortcut(String elementId) {
        String[] parts = elementId.split("\\.");
        return parts[parts.length - 1];
    }

    private String getContainerCacheId(IModelSession modelSession, TableType tableType) {
        if (tableType == TableType.DIFF) {
            return this.getContainerCacheId(modelSession, TableType.INITIAL) + "#" + this.getContainerCacheId(modelSession, TableType.FINAL);
        }
        return tableType.toString() + "$" + ContainerExtensions.getCacheId((MultiContainer_AttributeGroup)modelSession.getContainer(tableType.getContainerForTable()));
    }

    private PlanPro2TableTransformationService getModelService(String elementId) {
        PlanPro2TableTransformationService modelService = this.modelServiceMap.get(elementId.toLowerCase());
        if (modelService == null) {
            throw new IllegalArgumentException("no model service for " + elementId + " found!");
        }
        return modelService;
    }

    @Override
    public TableNameInfo getTableNameInfo(String shortcut) {
        return this.getModelService(shortcut).getTableNameInfo();
    }

    @Override
    public Collection<String> getAvailableTables() {
        return new ArrayList<String>(this.modelServiceMap.keySet());
    }

    @Override
    public Set<Integer> getFixedColumns(String elementID) {
        return this.getModelService(this.extractShortcut(elementID)).getFixedColumnsPos();
    }

    @Override
    public Map<String, Collection<TableError>> getTableErrors() {
        HashMap<String, Collection<TableError>> map = new HashMap<String, Collection<TableError>>();
        Cache cache = this.getCache().getCache("toolbox.cache.table-errors");
        Collection tableShortcuts = cache.getKeys();
        tableShortcuts.forEach(shortCut -> {
            Collection collection = map.put((String)shortCut, (Collection)cache.getIfPresent(shortCut));
        });
        return map;
    }

    private boolean combineTableErrors(String shortCut) {
        Collection initialErrors = (Collection)this.getCache().getCache("toolbox.cache.table-errors-initial").getIfPresent(shortCut);
        Collection finalErrors = (Collection)this.getCache().getCache("toolbox.cache.table-errors-final").getIfPresent(shortCut);
        if (initialErrors == null || finalErrors == null) {
            return false;
        }
        ArrayList combined = new ArrayList();
        combined.addAll(initialErrors);
        combined.addAll(finalErrors);
        this.getCache().getCache("toolbox.cache.table-errors").set(shortCut, combined);
        this.broker.post("modelsession/change/tableerror", null);
        return true;
    }

    private void saveTableError(String shortCut, TableType tableType, Collection<TableError> errors) {
        String shortName = this.getTableNameInfo(shortCut).getShortName();
        errors.forEach(error -> error.setSource(shortName));
        switch (tableType) {
            case INITIAL: {
                this.getCache().getCache("toolbox.cache.table-errors-initial").set(shortCut, errors);
                break;
            }
            case FINAL: {
                this.getCache().getCache("toolbox.cache.table-errors-final").set(shortCut, errors);
                break;
            }
            default: {
                return;
            }
        }
        this.combineTableErrors(shortCut);
    }

    private Object loadTransform(String elementId, TableType tableType, IModelSession modelSession, String shortCut) {
        Table transformedTable;
        PlanPro2TableTransformationService modelService = this.getModelService(shortCut);
        if (tableType == TableType.DIFF) {
            transformedTable = this.createDiffTable(elementId, modelSession);
            modelService.format(transformedTable);
        } else {
            transformedTable = modelService.transform(modelSession.getContainer(tableType.getContainerForTable()));
            this.saveTableError(shortCut, tableType, modelService.getTableErrors());
        }
        if (Thread.currentThread().isInterrupted() || transformedTable == null) {
            return MissingSupplier.MISSING_VALUE;
        }
        ECollections.sort((EList)transformedTable.getTablecontent().getRowgroups(), (Comparator)modelService.getRowGroupComparator());
        return transformedTable;
    }

    public void removeModelService(PlanPro2TableTransformationService service, Map<String, Object> properties) throws IllegalAccessException {
        String elementId = TableServiceContextFunction.getElementId(properties);
        this.modelServiceMap.remove(elementId);
    }

    @Override
    public String transformToCsv(String elementId, TableType tableType, IModelSession modelSession) {
        Table table = this.transformToTable(elementId, tableType, modelSession);
        return this.transformToCsv(table);
    }

    private String transformToCsv(Table table) {
        List rows = TableExtensions.getTableRows((Table)table);
        List<ColumnDescriptor> colNames = table.getColumndescriptors().stream().filter(descriptor -> !Strings.isNullOrEmpty((String)descriptor.getLabel())).toList();
        String delimeter = ";";
        Object result = "";
        for (ColumnDescriptor colName : colNames) {
            result = (String)result + colName.getLabel() + ";";
        }
        result = (String)result + "\n";
        for (TableRow row : rows) {
            for (ColumnDescriptor colName : colNames) {
                try {
                    result = (String)result + TableCellExtensions.getPlainStringValue((TableCell)TableRowExtensions.getCell((TableRow)row, (ColumnDescriptor)colName)) + ";";
                }
                catch (Exception e) {
                    result = (String)result + e.toString();
                }
            }
            result = (String)result + "\n";
        }
        return result;
    }

    @Override
    public Table transformToTable(String elementId, TableType tableType, IModelSession modelSession) {
        String shortCut = this.extractShortcut(elementId);
        String containerId = this.getContainerCacheId(modelSession, tableType);
        Cache cache = this.getCache().getCache("toolbox.cache.shortcut-to-table", containerId);
        return (Table)cache.get(shortCut, () -> this.loadTransform(shortCut, tableType, modelSession, shortCut));
    }

    public void activate() {
        this.wireCacheSupplier();
    }

    private void wireCacheSupplier() {
        AbstractDirectedEdgePath.setEdgeToPointsCacheSupplier(() -> new EdgeToPointsCacheProxy(this.getCache()));
        Digraphs.setEdgeToSubPathCacheSupplier(() -> this.getCache().getCache("toolbox.cache.directed-edge-to-subpath"));
    }
}

