/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.check;

import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.feature.plazmodel.check.AbstractPlazContainerCheck;
import org.eclipse.set.feature.plazmodel.check.PlazCheck;
import org.eclipse.set.model.plazmodel.PlazError;
import org.eclipse.set.model.plazmodel.PlazFactory;
import org.eclipse.set.model.validationreport.ValidationSeverity;
import org.eclipse.set.ppmodel.extensions.BereichObjektExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.toolboxmodel.Basisobjekte.Begrenzung_A_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Begrenzung_B_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Bereich_Objekt_Teilbereich_AttributeGroup;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante_Allg_AttributeGroup;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Laenge_TypeClass;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.osgi.service.component.annotations.Component;

@Component
public class TeilbereichTOPKante
extends AbstractPlazContainerCheck
implements PlazCheck {
    @Override
    public List<PlazError> run(MultiContainer_AttributeGroup container) {
        Functions.Function1<Bereich_Objekt_Teilbereich_AttributeGroup, PlazError> _function = new Functions.Function1<Bereich_Objekt_Teilbereich_AttributeGroup, PlazError>(){

            public PlazError apply(Bereich_Objekt_Teilbereich_AttributeGroup it) {
                Begrenzung_A_TypeClass _begrenzungA = null;
                if (it != null) {
                    _begrenzungA = it.getBegrenzungA();
                }
                BigDecimal _wert = null;
                if (_begrenzungA != null) {
                    _wert = _begrenzungA.getWert();
                }
                BigDecimal limitA = _wert;
                Begrenzung_B_TypeClass _begrenzungB = null;
                if (it != null) {
                    _begrenzungB = it.getBegrenzungB();
                }
                BigDecimal _wert_1 = null;
                if (_begrenzungB != null) {
                    _wert_1 = _begrenzungB.getWert();
                }
                BigDecimal limitB = _wert_1;
                TOP_Kante _topKante = BereichObjektExtensions.getTopKante((Bereich_Objekt_Teilbereich_AttributeGroup)it);
                TOP_Kante_Allg_AttributeGroup _tOPKanteAllg = null;
                if (_topKante != null) {
                    _tOPKanteAllg = _topKante.getTOPKanteAllg();
                }
                TOP_Laenge_TypeClass _tOPLaenge = null;
                if (_tOPKanteAllg != null) {
                    _tOPLaenge = _tOPKanteAllg.getTOPLaenge();
                }
                BigDecimal _wert_2 = null;
                if (_tOPLaenge != null) {
                    _wert_2 = _tOPLaenge.getWert();
                }
                BigDecimal topLength = _wert_2;
                if (limitA == null || limitB == null || topLength == null) {
                    return null;
                }
                String errmsg = TeilbereichTOPKante.this.getErrorMessage(limitA.doubleValue(), limitB.doubleValue(), topLength.doubleValue());
                if (errmsg != null) {
                    PlazError err = PlazFactory.eINSTANCE.createPlazError();
                    err.setMessage(errmsg);
                    err.setType(TeilbereichTOPKante.this.checkType());
                    err.setObject((EObject)it);
                    err.setSeverity(TeilbereichTOPKante.this.getErrorSeverity(limitA.doubleValue(), limitB.doubleValue()));
                    return err;
                }
                return null;
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)container.getAllContents(), Bereich_Objekt_Teilbereich_AttributeGroup.class), (Functions.Function1)_function)));
    }

    private String getErrorMessage(double limitA, double limitB, double topLength) {
        if (limitA < 0.0) {
            StringConcatenation _builder = new StringConcatenation();
            String _generalErrMsg = this.getGeneralErrMsg();
            _builder.append(_generalErrMsg);
            _builder.append(" BegrenzungA: ");
            _builder.append((Object)limitA);
            _builder.append(".");
            return _builder.toString();
        }
        if (limitB < 0.0) {
            StringConcatenation _builder_1 = new StringConcatenation();
            String _generalErrMsg_1 = this.getGeneralErrMsg();
            _builder_1.append(_generalErrMsg_1);
            _builder_1.append(" BegrenzungB: ");
            _builder_1.append((Object)limitB);
            _builder_1.append(".");
            return _builder_1.toString();
        }
        if (limitA > topLength) {
            StringConcatenation _builder_2 = new StringConcatenation();
            String _generalErrMsg_2 = this.getGeneralErrMsg();
            _builder_2.append(_generalErrMsg_2);
            _builder_2.append(" BegrenzungA: ");
            _builder_2.append((Object)limitA);
            _builder_2.append(". L\u00e4nge TOP-Kante: ");
            _builder_2.append((Object)topLength);
            return _builder_2.toString();
        }
        if (limitB > topLength) {
            StringConcatenation _builder_3 = new StringConcatenation();
            String _generalErrMsg_3 = this.getGeneralErrMsg();
            _builder_3.append(_generalErrMsg_3);
            _builder_3.append(" BegrenzungB: ");
            _builder_3.append((Object)limitB);
            _builder_3.append(". L\u00e4nge TOP-Kante: ");
            _builder_3.append((Object)topLength);
            return _builder_3.toString();
        }
        if (limitB < limitA) {
            StringConcatenation _builder_4 = new StringConcatenation();
            String _generalErrMsg_4 = this.getGeneralErrMsg();
            _builder_4.append(_generalErrMsg_4);
            _builder_4.append(" BegrenzungA: ");
            _builder_4.append((Object)limitA);
            _builder_4.append(". BegrenzungB: ");
            _builder_4.append((Object)limitB);
            _builder_4.append(".");
            return _builder_4.toString();
        }
        return null;
    }

    private ValidationSeverity getErrorSeverity(double limitA, double limitB) {
        return ValidationSeverity.ERROR;
    }

    @Override
    public String checkType() {
        return "Teilbereichsgrenze";
    }

    @Override
    public String getDescription() {
        return "Teilbereichsgrenzen der LST-Objekte sind g\u00fcltig.";
    }

    @Override
    public String getGeneralErrMsg() {
        return "Ung\u00fcltige Teilbereichsgrenzen f\u00fcr LST-Objekt.";
    }
}

