/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table.transform;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFPrintSetup;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.set.utils.excel.ExcelWorkbookExtension;
import org.eclipse.set.utils.table.transform.AbstractTransformTableHeader;
import org.eclipse.set.utils.table.transform.MultiPageTableHeader;
import org.eclipse.set.utils.table.transform.SinglePageTableHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TransformTable {
    private static final String EXCEL_TEMPLATE_PATH = "data/export/excel";
    private static final String WATER_MARK_TEMPLATE_NAME = "water-mark-content";
    private static final float A3_PAPER_WIDTH = 42.0f;
    String shortcut;
    String tableTyle;
    private static final Logger logger = LoggerFactory.getLogger(TransformTable.class);

    public TransformTable(String tableShortcut, String tableType) {
        this.shortcut = tableShortcut;
        this.tableTyle = tableType;
    }

    public Document transform() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        File excelFile = this.getTemplatePath();
        XSSFSheet tableSheet = TransformTable.getTableSheet(excelFile);
        if (tableSheet == null) {
            return null;
        }
        float contentWidth = TransformTable.getContentWidth(tableSheet);
        AbstractTransformTableHeader transformHeader = TransformTable.needToBreakPage(tableSheet, contentWidth) ? new MultiPageTableHeader(tableSheet, contentWidth) : new SinglePageTableHeader(tableSheet, contentWidth);
        Document xslDoc = transformHeader.transform();
        if (this.tableTyle != null) {
            this.setWaterMarkContent(xslDoc);
        }
        return xslDoc;
    }

    private void setWaterMarkContent(Document xslDoc) {
        Optional<Element> waterMarkVariable = AbstractTransformTableHeader.findNodebyTagName(xslDoc, "xsl:variable", "name", WATER_MARK_TEMPLATE_NAME);
        if (waterMarkVariable.isPresent()) {
            waterMarkVariable.get().setTextContent(this.tableTyle);
        }
    }

    private static float getContentWidth(XSSFSheet sheet) {
        XSSFPrintSetup printSetup = sheet.getPrintSetup();
        double leftMargin = printSetup.getLeftMargin() * 2.54;
        double rightMargin = printSetup.getRightMargin() * 2.54;
        return (float)Math.round((42.0f - (float)(leftMargin + rightMargin)) * 100.0f) / 100.0f;
    }

    /*
     * Loose catch block
     */
    private static XSSFSheet getTableSheet(File templateFile) throws IOException {
        if (templateFile.canRead()) {
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                XSSFSheet xSSFSheet;
                XSSFWorkbook workbook;
                FileInputStream inputStream;
                block17: {
                    block16: {
                        inputStream = new FileInputStream(templateFile);
                        workbook = new XSSFWorkbook((InputStream)inputStream);
                        xSSFSheet = workbook.getSheetAt(0);
                        if (workbook == null) break block16;
                        workbook.close();
                    }
                    if (inputStream == null) break block17;
                    ((InputStream)inputStream).close();
                }
                return xSSFSheet;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (workbook != null) {
                                workbook.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (inputStream != null) {
                                ((InputStream)inputStream).close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        logger.error("Missing pdf export template: " + templateFile.toString());
        return null;
    }

    private File getTemplatePath() {
        return Paths.get(String.format("%s/%s_vorlage.xlsx", EXCEL_TEMPLATE_PATH, this.shortcut), new String[0]).toAbsolutePath().toFile();
    }

    public static StreamSource toStreamSource(Document doc) throws TransformerException {
        DOMSource domSource = new DOMSource(doc);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(baos);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(domSource, result);
        return new StreamSource(new ByteArrayInputStream(baos.toByteArray()), domSource.getSystemId());
    }

    private static boolean needToBreakPage(XSSFSheet sheet, float maxContentWidth) {
        int[] columnBreaks = sheet.getColumnBreaks();
        if (columnBreaks.length > 0) {
            return true;
        }
        float sumWidth = 0.0f;
        int i = 0;
        while (i <= ExcelWorkbookExtension.getHeaderLastColumnIndex((Sheet)sheet)) {
            float columnWidthInCm = ExcelWorkbookExtension.getColumnWidthInCm((Sheet)sheet, (int)i);
            sumWidth += columnWidthInCm;
            ++i;
        }
        return sumWidth > maxContentWidth;
    }
}

