/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.transform;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.EList;
import org.eclipse.set.feature.siteplan.positionservice.PositionService;
import org.eclipse.set.feature.siteplan.trackservice.GEOKanteCoordinate;
import org.eclipse.set.feature.siteplan.trackservice.TrackService;
import org.eclipse.set.feature.siteplan.transform.BaseTransformator;
import org.eclipse.set.feature.siteplan.transform.TransformUtils;
import org.eclipse.set.feature.siteplan.transform.Transformator;
import org.eclipse.set.model.siteplan.Label;
import org.eclipse.set.model.siteplan.LockKey;
import org.eclipse.set.model.siteplan.LockKeyType;
import org.eclipse.set.model.siteplan.RouteObject;
import org.eclipse.set.model.siteplan.SiteplanFactory;
import org.eclipse.set.model.siteplan.SiteplanPackage;
import org.eclipse.set.toolboxmodel.Ansteuerung_Element.Unterbringung;
import org.eclipse.set.toolboxmodel.BasisTypen.Bezeichnung_Element_AttributeGroup;
import org.eclipse.set.toolboxmodel.BasisTypen.Bezeichnung_Lageplan_Kurz_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt_Strecke_AttributeGroup;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.toolboxmodel.Schluesselabhaengigkeiten.Bedienung_Art_TypeClass;
import org.eclipse.set.toolboxmodel.Schluesselabhaengigkeiten.ENUMBedienungArt;
import org.eclipse.set.toolboxmodel.Schluesselabhaengigkeiten.Schloss;
import org.eclipse.set.toolboxmodel.Schluesselabhaengigkeiten.Schloss_Ssp_AttributeGroup;
import org.eclipse.set.toolboxmodel.Schluesselabhaengigkeiten.Schluessel_In_Grdst_Eingeschl_TypeClass;
import org.eclipse.set.toolboxmodel.Schluesselabhaengigkeiten.Schluesselsperre;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Transformator.class})
public class LockKeyTransformator
extends BaseTransformator<Schluesselsperre> {
    @Reference
    private TrackService trackService;
    @Reference
    private PositionService positionService;
    private static final String ERROR_NO_UNTERBRINGUNG = "Keine Unterbringung f\u00fcr Schl\u00fcsselsperre '%s' gefunden";

    @Override
    public void transform(Schluesselsperre lockkey) {
        GEOKanteCoordinate coor;
        LockKey result = SiteplanFactory.eINSTANCE.createLockKey();
        Identitaet_TypeClass _identitaet = lockkey.getIdentitaet();
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        result.setGuid(_wert);
        result.setLabel(SiteplanFactory.eINSTANCE.createLabel());
        Label _label = result.getLabel();
        Bezeichnung_Element_AttributeGroup _bezeichnung = lockkey.getBezeichnung();
        Bezeichnung_Lageplan_Kurz_TypeClass _bezeichnungLageplanKurz = null;
        if (_bezeichnung != null) {
            _bezeichnungLageplanKurz = _bezeichnung.getBezeichnungLageplanKurz();
        }
        String _wert_1 = null;
        if (_bezeichnungLageplanKurz != null) {
            _wert_1 = _bezeichnungLageplanKurz.getWert();
        }
        _label.setText(_wert_1);
        result.setLocked(this.transformLockStatus(lockkey).booleanValue());
        result.setType(this.transformLockKeyType(lockkey));
        Unterbringung _iDUnterbringung = lockkey.getIDUnterbringung();
        Punkt_Objekt_TOP_Kante_AttributeGroup _punktObjektTOPKante = null;
        if (_iDUnterbringung != null) {
            _punktObjektTOPKante = _iDUnterbringung.getPunktObjektTOPKante();
        }
        if ((coor = this.trackService.getCoordinateAt(_punktObjektTOPKante, 0.0)) == null) {
            this.recordError(result.getGuid(), String.format(ERROR_NO_UNTERBRINGUNG, result.getGuid()));
            return;
        }
        result.setPosition(this.positionService.transformPosition(coor));
        Unterbringung _iDUnterbringung_1 = lockkey.getIDUnterbringung();
        EList _punktObjektStrecke = null;
        if (_iDUnterbringung_1 != null) {
            _punktObjektStrecke = _iDUnterbringung_1.getPunktObjektStrecke();
        }
        if (_punktObjektStrecke != null) {
            TransformUtils.transformPunktObjektStrecke((EList<Punkt_Objekt_Strecke_AttributeGroup>)_punktObjektStrecke, (RouteObject)result);
        }
        this.addSiteplanElement(result, SiteplanPackage.eINSTANCE.getSiteplanState_Lockkeys());
    }

    public LockKeyType transformLockKeyType(Schluesselsperre schluesselsperre) {
        Bedienung_Art_TypeClass _bedienungArt = schluesselsperre.getBedienungArt();
        ENUMBedienungArt _wert = null;
        if (_bedienungArt != null) {
            _wert = _bedienungArt.getWert();
        }
        if (_wert != null) {
            switch (_wert) {
                case ENUM_BEDIENUNG_ART_AUSSEN: 
                case ENUM_BEDIENUNG_ART_AUSSEN_AWANST: {
                    return LockKeyType.OUTSIDE;
                }
                case ENUM_BEDIENUNG_ART_INNEN: {
                    return LockKeyType.INSIDE;
                }
            }
            return null;
        }
        return null;
    }

    public Boolean transformLockStatus(final Schluesselsperre schluesselsperre) {
        Boolean _elvis = null;
        Functions.Function1<Schloss, Boolean> _function = new Functions.Function1<Schloss, Boolean>(){

            public Boolean apply(Schloss it) {
                Schloss_Ssp_AttributeGroup _schlossSsp = it.getSchlossSsp();
                return _schlossSsp != null;
            }
        };
        Functions.Function1<Schloss, Boolean> _function_1 = new Functions.Function1<Schloss, Boolean>(){

            public Boolean apply(Schloss it) {
                Schluesselsperre _iDSchluesselsperre = it.getSchlossSsp().getIDSchluesselsperre();
                return Objects.equal((Object)_iDSchluesselsperre, (Object)schluesselsperre);
            }
        };
        Schloss _findFirst = (Schloss)IterableExtensions.findFirst((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)this.container.getAllContents(), Schloss.class), (Functions.Function1)_function), (Functions.Function1)_function_1);
        Schluessel_In_Grdst_Eingeschl_TypeClass _schluesselInGrdstEingeschl = null;
        if (_findFirst != null) {
            _schluesselInGrdstEingeschl = _findFirst.getSchluesselInGrdstEingeschl();
        }
        Boolean _wert = null;
        if (_schluesselInGrdstEingeschl != null) {
            _wert = _schluesselInGrdstEingeschl.getWert();
        }
        _elvis = _wert != null ? _wert : Boolean.valueOf(false);
        return _elvis;
    }
}

