/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.fileservice;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.set.basis.extensions.PathExtensions;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.basis.files.ToolboxFileExtension;
import org.eclipse.set.basis.files.ToolboxFileRole;
import org.eclipse.set.core.fileservice.SupportMapExtensions;
import org.eclipse.set.core.fileservice.ZippedPlanProToolboxFile;
import org.eclipse.set.core.services.files.ToolboxFileFormatService;
import org.eclipse.set.core.services.session.SessionService;
import org.eclipse.set.toolboxmodel.PlanPro.util.PlanProResourceFactoryImpl;
import org.eclipse.set.toolboxmodel.PlanPro.util.ToolboxModelService;
import org.eclipse.set.toolboxmodel.transform.ToolboxModelServiceImpl;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class ZippedPlanProFileFormatService
implements ToolboxFileFormatService {
    @Reference
    protected SessionService sessionService;

    public ToolboxFile create(ToolboxFile.Format format, ToolboxFileRole role) {
        Assert.isTrue((boolean)format.isZippedPlanPro());
        return new ZippedPlanProToolboxFile(format, this.createEditingDomain(), role);
    }

    public ToolboxFile create(ToolboxFile toolboxFile) {
        return new ZippedPlanProToolboxFile((ZippedPlanProToolboxFile)toolboxFile);
    }

    public Collection<ToolboxFileExtension> extensionsForCategory(String category) {
        return this.sessionService.getZippedSupportMap().getOrDefault(category, Collections.emptySet());
    }

    public boolean isSupported(ToolboxFile.Format format) {
        return format.isZippedPlanPro();
    }

    public boolean isSupported(Path path) {
        return SupportMapExtensions.getSupportedExtensions(this.sessionService.getZippedSupportMap()).contains(PathExtensions.getExtension((Path)path));
    }

    public boolean isSupported(ToolboxFile toolboxFile) {
        return toolboxFile instanceof ZippedPlanProToolboxFile;
    }

    public ToolboxFile load(Path path, ToolboxFileRole role) {
        ToolboxFile.Format format = this.sessionService.getFormat(path);
        Assert.isTrue((boolean)format.isZippedPlanPro());
        return new ZippedPlanProToolboxFile(path, format, this.createEditingDomain(), true, role);
    }

    private EditingDomain createEditingDomain() {
        EditingDomain ed = this.sessionService.createEditingDomain();
        Resource.Factory.Registry registry = ed.getResourceSet().getResourceFactoryRegistry();
        for (ToolboxFileExtension toolboxExtension : this.extensionsForCategory("ppfile")) {
            String extension = toolboxExtension.getExtension();
            if (extension.length() <= 0) continue;
            PlanProResourceFactoryImpl resourceFactory = new PlanProResourceFactoryImpl();
            registry.getContentTypeToFactoryMap().put(extension, resourceFactory);
            ToolboxModelServiceImpl toolboxmodelService = new ToolboxModelServiceImpl();
            resourceFactory.setToolboxModelServiceProvider(() -> ZippedPlanProFileFormatService.lambda$0((ToolboxModelService)toolboxmodelService));
        }
        return ed;
    }

    private static /* synthetic */ ToolboxModelService lambda$0(ToolboxModelService toolboxModelService) {
        return toolboxModelService;
    }
}

