/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.modelservice;

import java.util.Optional;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.set.core.services.planningaccess.PlanningAccessService;
import org.eclipse.set.ppmodel.extensions.PlanungEinzelExtensions;
import org.eclipse.set.toolboxmodel.PlanPro.ENUMUntergewerkArt;
import org.eclipse.set.toolboxmodel.PlanPro.PlanProFactory;
import org.eclipse.set.toolboxmodel.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.toolboxmodel.PlanPro.Planung_Einzel;
import org.eclipse.set.toolboxmodel.PlanPro.Planung_Gruppe;
import org.eclipse.set.toolboxmodel.PlanPro.Planung_Projekt;
import org.eclipse.set.toolboxmodel.PlanPro.Untergewerk_Art_TypeClass;
import org.osgi.service.component.annotations.Component;

@Component
public class PlanningAccessServiceImpl
implements PlanningAccessService {
    private static void createPrerequisiteElements(PlanPro_Schnittstelle planProIterface) {
        if (planProIterface.getLSTPlanung() == null) {
            planProIterface.setLSTPlanung(PlanProFactory.eINSTANCE.createLST_Planung_AttributeGroup());
        }
        if (planProIterface.getLSTPlanung().getObjektmanagement() == null) {
            planProIterface.getLSTPlanung().setObjektmanagement(PlanProFactory.eINSTANCE.createObjektmanagement_AttributeGroup());
        }
    }

    private static ENUMUntergewerkArt getUntergewerkArt(Planung_Gruppe group) {
        Untergewerk_Art_TypeClass untergewerkArt = PlanungEinzelExtensions.getAusgabeFachdaten((Planung_Einzel)group.getLSTPlanungEinzel()).getUntergewerkArt();
        if (untergewerkArt == null) {
            return null;
        }
        return untergewerkArt.getWert();
    }

    private static boolean isEstw(Planung_Projekt project) {
        return project.getLSTPlanungGruppe().stream().anyMatch(x -> PlanningAccessServiceImpl.getUntergewerkArt(x) == ENUMUntergewerkArt.ENUM_UNTERGEWERK_ART_ESTW);
    }

    private static boolean isGeo(Planung_Projekt project) {
        return project.getLSTPlanungGruppe().stream().anyMatch(x -> PlanningAccessServiceImpl.getUntergewerkArt(x) == ENUMUntergewerkArt.ENUM_UNTERGEWERK_ART_GEO);
    }

    public Planung_Projekt getLSTPlanungProjekt(PlanPro_Schnittstelle planProIterface) {
        if (planProIterface.getLSTPlanung() != null) {
            EList projects = planProIterface.getLSTPlanung().getObjektmanagement().getLSTPlanungProjekt();
            Optional<Planung_Projekt> firstESTWProject = projects.stream().filter(PlanningAccessServiceImpl::isEstw).findFirst();
            Optional<Planung_Projekt> firstGeoProject = projects.stream().filter(PlanningAccessServiceImpl::isGeo).findFirst();
            if (firstESTWProject.isPresent()) {
                return firstESTWProject.orElseThrow();
            }
            if (firstGeoProject.isPresent()) {
                return firstGeoProject.orElseThrow();
            }
            if (!projects.isEmpty()) {
                return (Planung_Projekt)projects.get(0);
            }
        }
        return null;
    }

    public Planung_Gruppe getPlanungGruppe(Planung_Projekt project) {
        EList groups = project.getLSTPlanungGruppe();
        Optional<Planung_Gruppe> firstESTWGroup = groups.stream().filter(x -> PlanningAccessServiceImpl.getUntergewerkArt(x) == ENUMUntergewerkArt.ENUM_UNTERGEWERK_ART_ESTW).findFirst();
        Optional<Planung_Gruppe> firstGeoGroup = groups.stream().filter(x -> PlanningAccessServiceImpl.getUntergewerkArt(x) == ENUMUntergewerkArt.ENUM_UNTERGEWERK_ART_GEO).findFirst();
        if (firstESTWGroup.isPresent()) {
            return firstESTWGroup.orElseThrow();
        }
        if (firstGeoGroup.isPresent()) {
            return firstGeoGroup.orElseThrow();
        }
        if (!groups.isEmpty()) {
            return (Planung_Gruppe)groups.get(0);
        }
        return null;
    }

    public void setLSTPlanungProjekt(PlanPro_Schnittstelle planProIterface, Planung_Projekt project) {
        Planung_Projekt projectToBeReplaced = this.getLSTPlanungProjekt(planProIterface);
        if (projectToBeReplaced == null) {
            PlanningAccessServiceImpl.createPrerequisiteElements(planProIterface);
            planProIterface.getLSTPlanung().getObjektmanagement().getLSTPlanungProjekt().add((Object)project);
        } else {
            EList projects = planProIterface.getLSTPlanung().getObjektmanagement().getLSTPlanungProjekt();
            int index = projects.indexOf(projectToBeReplaced);
            Assert.isTrue((index >= 0 ? 1 : 0) != 0);
            if (projects.get(index) != project) {
                projects.add(index, project);
                projects.remove(projectToBeReplaced);
            }
        }
    }

    public void setPlanungGruppe(Planung_Projekt project, Planung_Gruppe group) {
        Planung_Gruppe groupToBeReplaced = this.getPlanungGruppe(project);
        EList groups = project.getLSTPlanungGruppe();
        int index = groups.indexOf(groupToBeReplaced);
        if (index < 0) {
            groups.add(group);
        } else if (groups.get(index) != group) {
            groups.add(index, group);
            groups.remove(groupToBeReplaced);
        }
    }
}

