/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.partservice;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.emf.common.util.URI;
import org.eclipse.set.basis.ActionProvider;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.Wrapper;
import org.eclipse.set.basis.constants.PlanProFileNature;
import org.eclipse.set.basis.constants.ValidationResult;
import org.eclipse.set.basis.extensions.MApplicationElementExtensions;
import org.eclipse.set.basis.part.PartDescription;
import org.eclipse.set.basis.part.ToolboxPart;
import org.eclipse.set.basis.part.ViewVisibility;
import org.eclipse.set.basis.viewgroups.ToolboxViewGroup;
import org.eclipse.set.core.services.part.PartDescriptionService;
import org.eclipse.set.core.services.part.ToolboxPartService;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.events.NewActiveViewEvent;
import org.eclipse.set.utils.events.ToolboxEvent;
import org.eclipse.set.utils.events.ToolboxEvents;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolboxMultiPartServiceImpl
implements ToolboxPartService {
    private static final String ACTION_PART_ID = "org.eclipse.set.application.part.actions";
    private static final String APPLICATION_PARTSASHCONTAINER_ID = "org.eclipse.set.application.document.partsashcontainer";
    private static final String DEFAULT_ICON_URI = "platform:/plugin/org.eclipse.set.utils/icons/baseline_view_module_black_24dp.png";
    private static final Logger LOGGER = LoggerFactory.getLogger(ToolboxMultiPartServiceImpl.class);
    private static final String PRIMARY_PART_STACK_ID = "org.eclipse.set.core.stack.primary";
    private MPart actionPart;
    private MPartStack primaryPartStack;
    MPart activePart;
    @Inject
    MApplication application;
    @Inject
    IEventBroker broker;
    @Inject
    EModelService modelService;
    @Inject
    EPartService partService;
    Map<ToolboxViewGroup, List<PartDescription>> registeredDescriptions = Maps.newHashMap();
    @Inject
    UISynchronize sync;

    private static void checkPartContribution(PartDescription description) {
        try {
            URI uri = URI.createURI((String)description.getContributionUri());
            Bundle bundle = Activator.getDefault().getBundleForName(uri.authority());
            String typeName = uri.segment(0);
            if (bundle == null) {
                throw new IllegalArgumentException(uri.toString());
            }
            Class type = bundle.loadClass(typeName);
            if (!ToolboxPart.class.isAssignableFrom(type)) {
                LOGGER.warn("Contribution " + type.getSimpleName() + " for view " + description.getToolboxViewName() + " is no subclass of " + BasePart.class.getSimpleName() + " and possibly has no agreed title.");
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static MPart createPart(PartDescription description) {
        MPart part = MBasicFactory.INSTANCE.createPart();
        part.setContributionURI(description.getContributionUri());
        part.setContainerData("77");
        part.setLabel(description.getToolboxViewName());
        part.setElementId(description.getId());
        part.setVisible(false);
        part.setToBeRendered(false);
        part.setCloseable(true);
        MApplicationElementExtensions.setDescription((MApplicationElement)part, (PartDescription)description);
        MApplicationElementExtensions.setVisibility((MApplicationElement)part, (ViewVisibility)ViewVisibility.EXPOSED);
        return part;
    }

    private static String getPdfPartId(Path path) {
        return "org.eclipse.set.application.parts.ViewPdfPart:" + String.valueOf(path);
    }

    public void clean() {
        this.closeOpenParts();
    }

    public MPart getActivePart() {
        return this.activePart;
    }

    public List<MPart> getOpenParts() {
        List stacks = this.modelService.findElements((MUIElement)this.application, null, MPartStack.class, null);
        return stacks.stream().flatMap(stack -> stack.getChildren().stream()).filter(e -> MApplicationElementExtensions.isOpenPart((MApplicationElement)e) && e != this.actionPart).map(e -> (MPart)e).collect(Collectors.toList());
    }

    public PartDescription getRegisteredDescription(String partId) {
        for (List<PartDescription> descriptions : this.registeredDescriptions.values()) {
            for (PartDescription description : descriptions) {
                if (!description.getId().equals(partId)) continue;
                return description;
            }
        }
        return null;
    }

    public Map<ToolboxViewGroup, List<PartDescription>> getRegisteredDescriptions() {
        return this.registeredDescriptions;
    }

    public List<PartDescription> getRegisteredDescriptions(ToolboxViewGroup type) {
        List<PartDescription> descriptions = this.registeredDescriptions.get(type);
        if (descriptions != null) {
            return descriptions;
        }
        return Collections.emptyList();
    }

    public boolean isActionAreaVisible() {
        return this.actionPart.isVisible() && this.actionPart.isToBeRendered();
    }

    public boolean isOpen(PartDescription description) {
        return this.getOpenParts().stream().anyMatch(p -> Objects.equals(p.getElementId(), description.getId()));
    }

    public void showActionArea() {
        this.partService.activate(this.actionPart);
        ActionProvider actionProvider = (ActionProvider)this.actionPart.getObject();
        actionProvider.update();
    }

    public boolean showDefaultPart(IModelSession session) {
        return this.showPart(this.getDefaultPartID(session));
    }

    public boolean showPart(PartDescription description) {
        return this.showPart(description.getId());
    }

    public boolean showPart(String id) {
        return this.forceFocusAndShowPart(id);
    }

    public void showPdfPart(Path path) {
        String pdfPartId = ToolboxMultiPartServiceImpl.getPdfPartId(path);
        MPart pdfPart = this.partService.findPart(pdfPartId);
        if (pdfPart == null) {
            this.createAndPlacePdfPart(pdfPartId, path);
        }
        this.showPart(pdfPartId);
    }

    private void closeOpenParts() {
        this.getOpenParts().forEach(part -> part.setToBeRendered(false));
        this.activePart = null;
    }

    private void createAndPlacePart(PartDescription description) {
        ToolboxMultiPartServiceImpl.checkPartContribution(description);
        MPart part = ToolboxMultiPartServiceImpl.createPart(description);
        MPartStack partStack = this.getPrimaryPartStack();
        if (partStack == null) {
            return;
        }
        partStack.getChildren().add(part);
    }

    private void createAndPlacePdfPart(String pdfPartId, Path path) {
        PartDescription description = this.getRegisteredDescription("org.eclipse.set.application.parts.ViewPdfPart");
        MPart part = ToolboxMultiPartServiceImpl.createPart(description);
        Path fileName = path.getFileName();
        if (fileName != null) {
            part.setLabel(fileName.toString());
        }
        part.setElementId(pdfPartId);
        part.getTransientData().put("org.eclipse.set.application.commandparameter.file", path.toString());
        this.getPrimaryPartStack().getChildren().add(part);
    }

    private PartDescription createDescription(PartDescriptionService descriptionService) {
        PartDescription description = descriptionService.getDescription(this.application.getContext());
        this.getOrCreate(descriptionService.getToolboxViewGroup()).add(description);
        return description;
    }

    private MPartStack createPrimaryPartStack() {
        List elements = this.modelService.findElements((MUIElement)this.application, APPLICATION_PARTSASHCONTAINER_ID, MPartSashContainer.class, null);
        if (elements.isEmpty()) {
            return null;
        }
        MPartSashContainer sashContainer = (MPartSashContainer)elements.get(0);
        List children = sashContainer.getChildren();
        while (children.size() > 1) {
            MPartSashContainerElement element = (MPartSashContainerElement)children.get(1);
            element.setVisible(false);
            element.setToBeRendered(false);
            children.remove(1);
        }
        MPartSashContainerElement actionPartContainer = (MPartSashContainerElement)children.get(0);
        MPartStack stack = MBasicFactory.INSTANCE.createPartStack();
        stack.setElementId(PRIMARY_PART_STACK_ID);
        children.add(stack);
        stack.getTags().add("NoAutoCollapse");
        String oppositWidthText = actionPartContainer.getContainerData();
        int oppositeWidth = Integer.parseInt(oppositWidthText);
        stack.setContainerData(Integer.toString(100 - oppositeWidth));
        this.primaryPartStack = stack;
        return stack;
    }

    private boolean forceFocusAndShowPart(String id) {
        Wrapper result = new Wrapper();
        List windows = this.application.getChildren();
        MWindow mWindow = (MWindow)windows.get(0);
        Display.getDefault().syncExec(() -> {
            ((Shell)mWindow.getWidget()).forceFocus();
            this.showPartImpl(id);
            result.setValue((Object)true);
            this.broker.post("org/eclipse/e4/ui/renderer/requestEnablementUpdate", (Object)"ALL");
        });
        return (Boolean)result.getValue();
    }

    private MPart getActionPart() {
        List parts = this.modelService.findElements((MUIElement)this.application, ACTION_PART_ID, MPart.class, null);
        if (parts.isEmpty()) {
            return null;
        }
        Assert.isTrue((parts.size() == 1 ? 1 : 0) != 0);
        return (MPart)parts.get(0);
    }

    private String getDefaultPartID(IModelSession session) {
        if (session == null) {
            return null;
        }
        if (session.getNature() == PlanProFileNature.INVALID) {
            return "org.eclipse.set.feature.validation.parts.ValidationPart";
        }
        ValidationResult.Outcome outcome = session.getValidationsOutcome(ValidationResult::getOutcome);
        if (outcome == ValidationResult.Outcome.INVALID) {
            return "org.eclipse.set.feature.validation.parts.ValidationPart";
        }
        Iterable descriptions = Iterables.concat(this.registeredDescriptions.values());
        for (PartDescription description : descriptions) {
            PlanProFileNature defaultForNature = description.getDefaultForNature();
            if (session.getNature() != defaultForNature) continue;
            return description.getId();
        }
        return null;
    }

    private List<PartDescription> getOrCreate(ToolboxViewGroup toolboxViewGroup) {
        if (this.registeredDescriptions.containsKey(toolboxViewGroup)) {
            return this.registeredDescriptions.get(toolboxViewGroup);
        }
        this.registeredDescriptions.put(toolboxViewGroup, Lists.newLinkedList());
        return this.registeredDescriptions.get(toolboxViewGroup);
    }

    private boolean isPrimaryPartStack(MElementContainer<MUIElement> container) {
        MElementContainer<MUIElement> containerObject = container;
        return containerObject == this.getPrimaryPartStack();
    }

    @PostConstruct
    private void postConstruct() {
        this.actionPart = this.getActionPart();
        this.application.getContext().runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                ToolboxMultiPartServiceImpl.this.sessionChanged((IModelSession)context.get(IModelSession.class));
                return true;
            }
        });
    }

    private void setActivePart(MPart part) {
        if (part == this.actionPart) {
            return;
        }
        this.activePart = part;
        if (part == null) {
            ToolboxEvents.send((IEventBroker)this.broker, (ToolboxEvent)new NewActiveViewEvent(part));
            return;
        }
        if (!MApplicationElementExtensions.isToolboxView((MApplicationElement)part)) {
            throw new IllegalArgumentException(part.toString());
        }
        MElementContainer stack = part.getParent();
        stack.getChildren().forEach(this::setVisibility);
        stack.setSelectedElement((MUIElement)this.activePart);
        ToolboxEvents.send((IEventBroker)this.broker, (ToolboxEvent)new NewActiveViewEvent(this.activePart));
    }

    private void setVisibility(MApplicationElement element) {
        if (element == this.activePart) {
            MApplicationElementExtensions.setVisibility((MApplicationElement)element, (ViewVisibility)ViewVisibility.EXPOSED);
        } else {
            MApplicationElementExtensions.setVisibility((MApplicationElement)element, (ViewVisibility)ViewVisibility.CONCEALED);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    @Optional
    private void subscribeTopicActivate(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/activate") Event event) {
        Object element;
        Object object;
        if (event != null && (object = (element = event.getProperty("ChangedElement"))) instanceof MPart) {
            void part;
            MPart mPart = (MPart)object;
            MPart cfr_ignored_0 = (MPart)object;
            if (MApplicationElementExtensions.isToolboxView((MApplicationElement)part)) {
                this.setActivePart((MPart)part);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    @Optional
    private void subscribeTopicBringToTop(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/bringToTop") Event event) {
        Object element;
        Object object;
        if (event != null && (object = (element = event.getProperty("ChangedElement"))) instanceof MPart) {
            void part;
            MPart mPart = (MPart)object;
            MPart cfr_ignored_0 = (MPart)object;
            MElementContainer parent = part.getParent();
            if (!this.isPrimaryPartStack((MElementContainer<MUIElement>)parent) && MApplicationElementExtensions.isToolboxView((MApplicationElement)part)) {
                this.setActivePart((MPart)part);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    @Optional
    private void subscribeTopicSelectedElement(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*") Event event) {
        Object object;
        MPartSashContainer selectedStackElement;
        Object element = event.getProperty("ChangedElement");
        Object object2 = element;
        if (object2 instanceof MPartStack) {
            void stack;
            MPartStack mPartStack = (MPartStack)object2;
            MPartStack cfr_ignored_0 = (MPartStack)object2;
            selectedStackElement = (MStackElement)stack.getSelectedElement();
            if (selectedStackElement != this.activePart) {
                this.setActivePart((MPart)selectedStackElement);
            }
        }
        if ((object = element) instanceof MPartSashContainer) {
            void container;
            MPartSashContainerElement selectedContainerElement;
            selectedStackElement = (MPartSashContainer)object;
            MPartSashContainer cfr_ignored_1 = (MPartSashContainer)object;
            MPartSashContainerElement mPartSashContainerElement = selectedContainerElement = (MPartSashContainerElement)container.getSelectedElement();
            if (mPartSashContainerElement instanceof MPartStack) {
                void stack;
                MPartStack mPartStack = (MPartStack)mPartSashContainerElement;
                MPartStack cfr_ignored_2 = (MPartStack)mPartSashContainerElement;
                MStackElement selectedStackElement2 = (MStackElement)stack.getSelectedElement();
                if (selectedStackElement2 != this.activePart) {
                    this.setActivePart((MPart)selectedStackElement2);
                }
            }
        }
    }

    protected void sessionChanged(IModelSession session) {
        if (session == null) {
            this.closeOpenParts();
        }
    }

    MPartStack getPrimaryPartStack() {
        if (this.primaryPartStack != null) {
            return this.primaryPartStack;
        }
        List stacks = this.modelService.findElements((MUIElement)this.application, PRIMARY_PART_STACK_ID, MPartStack.class, null);
        if (stacks.isEmpty()) {
            return this.createPrimaryPartStack();
        }
        return (MPartStack)stacks.get(0);
    }

    void put(PartDescriptionService descriptionService) {
        PartDescription description = this.createDescription(descriptionService);
        this.createAndPlacePart(description);
    }

    void showPartImpl(String id) {
        LOGGER.trace("showPart: {}...", (Object)id);
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            if (id == null || "org.eclipse.set.application.part.nosessionpart".equals(id)) {
                return;
            }
            MPart part = this.partService.findPart(id);
            if (part == this.activePart) {
                return;
            }
            if (part != null && part.isVisible() && part.isToBeRendered()) {
                this.setActivePart(part);
                return;
            }
            MPart created = this.partService.showPart(id, EPartService.PartState.CREATE);
            if (created == null) {
                throw new IllegalArgumentException(id);
            }
            created.setIconURI(DEFAULT_ICON_URI);
            if (MApplicationElementExtensions.isSuccessful((MApplicationElement)created)) {
                MApplicationElementExtensions.markAsToolboxView((MApplicationElement)created);
                created.setVisible(true);
                created.setToBeRendered(true);
                MPartStack stack = this.getPrimaryPartStack();
                stack.getChildren().remove(created);
                stack.getChildren().add(created);
                this.setActivePart(created);
            } else {
                this.partService.hidePart(created);
                MApplicationElementExtensions.resetViewState((MApplicationElement)created);
            }
        }
        finally {
            LOGGER.info("showPart: {} done: {}", (Object)id, (Object)stopwatch);
        }
    }

    public Collection<ToolboxViewGroup> getViewGroups() {
        return this.getRegisteredDescriptions().keySet();
    }
}

