/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.pt1.sslz;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.math.BigInteger;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.MixedStringComparator;
import org.eclipse.set.basis.Wrapper;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.feature.table.pt1.AbstractPlanPro2TableModelTransformator;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.RowGroup;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.extensions.Utils;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.BedienAnzeigeElementExtensions;
import org.eclipse.set.ppmodel.extensions.FahrwegExtensions;
import org.eclipse.set.ppmodel.extensions.FstrAbhaengigkeitExtensions;
import org.eclipse.set.ppmodel.extensions.FstrNichthaltfallExtensions;
import org.eclipse.set.ppmodel.extensions.FstrSignalisierungExtensions;
import org.eclipse.set.ppmodel.extensions.FstrZugRangierExtensions;
import org.eclipse.set.ppmodel.extensions.SchaltmittelZuordnungExtensions;
import org.eclipse.set.ppmodel.extensions.SignalExtensions;
import org.eclipse.set.ppmodel.extensions.SignalRahmenExtensions;
import org.eclipse.set.ppmodel.extensions.SignalbegriffExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.ppmodel.extensions.utils.Case;
import org.eclipse.set.ppmodel.extensions.utils.Debug;
import org.eclipse.set.ppmodel.extensions.utils.GestellteWeiche;
import org.eclipse.set.toolboxmodel.Bahnuebergang.BUE_Anlage;
import org.eclipse.set.toolboxmodel.Bahnuebergang.BUE_Anlage_Allg_AttributeGroup;
import org.eclipse.set.toolboxmodel.Bahnuebergang.BUE_Sicherungsart_TypeClass;
import org.eclipse.set.toolboxmodel.Bahnuebergang.ENUMBUESicherungsart;
import org.eclipse.set.toolboxmodel.BasisTypen.Bezeichnung_Element_AttributeGroup;
import org.eclipse.set.toolboxmodel.BasisTypen.Bezeichnung_Tabelle_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Basis_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Ur_Objekt;
import org.eclipse.set.toolboxmodel.Bedienung.Bedien_Anzeige_Element;
import org.eclipse.set.toolboxmodel.Bedienung.Bedien_Anzeige_Element_Allg_AttributeGroup;
import org.eclipse.set.toolboxmodel.Bedienung.Schalter_TypeClass;
import org.eclipse.set.toolboxmodel.Bedienung.Taste_TypeClass;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Automatische_Einstellung_TypeClass;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Bezeichnung_Fstr_DWeg_TypeClass;
import org.eclipse.set.toolboxmodel.Fahrstrasse.DWeg_V_TypeClass;
import org.eclipse.set.toolboxmodel.Fahrstrasse.DWeg_Vorzug_TypeClass;
import org.eclipse.set.toolboxmodel.Fahrstrasse.ENUMAutomatischeEinstellung;
import org.eclipse.set.toolboxmodel.Fahrstrasse.ENUMFstrZugArt;
import org.eclipse.set.toolboxmodel.Fahrstrasse.F_Bedienung_TypeClass;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Abhaengigkeit;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_DWeg;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_DWeg_Bezeichnung_AttributeGroup;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_DWeg_Spezifisch_AttributeGroup;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Fahrweg;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Mittel_AttributeGroup;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Mittel_V_Aufwertung_TypeClass;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Nichthaltfall;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Reihenfolge_TypeClass;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Signalisierung;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_V_Hg_TypeClass;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_V_TypeClass;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Zug_Art_TypeClass;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Zug_AttributeGroup;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Zug_DWeg_AttributeGroup;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Zug_Rangier;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Zug_Rangier_Allg_AttributeGroup;
import org.eclipse.set.toolboxmodel.Gleis.ENUMGleisart;
import org.eclipse.set.toolboxmodel.Gleis.Gleis_Abschnitt;
import org.eclipse.set.toolboxmodel.Gleis.Gleis_Bezeichnung;
import org.eclipse.set.toolboxmodel.Ortung.FMA_Anlage;
import org.eclipse.set.toolboxmodel.Ortung.Schaltmittel_Zuordnung;
import org.eclipse.set.toolboxmodel.Ortung.Zugeinwirkung;
import org.eclipse.set.toolboxmodel.Schluesselabhaengigkeiten.Schluesselsperre;
import org.eclipse.set.toolboxmodel.Signalbegriffe_Ril_301.Hp0;
import org.eclipse.set.toolboxmodel.Signalbegriffe_Ril_301.Kl;
import org.eclipse.set.toolboxmodel.Signalbegriffe_Ril_301.ZlO;
import org.eclipse.set.toolboxmodel.Signalbegriffe_Ril_301.Zs13;
import org.eclipse.set.toolboxmodel.Signalbegriffe_Ril_301.Zs2;
import org.eclipse.set.toolboxmodel.Signalbegriffe_Ril_301.Zs2v;
import org.eclipse.set.toolboxmodel.Signalbegriffe_Ril_301.Zs3;
import org.eclipse.set.toolboxmodel.Signalbegriffe_Ril_301.Zs3v;
import org.eclipse.set.toolboxmodel.Signalbegriffe_Ril_301.Zs6;
import org.eclipse.set.toolboxmodel.Signalbegriffe_Struktur.Signalbegriff_ID_TypeClass;
import org.eclipse.set.toolboxmodel.Signale.Signal;
import org.eclipse.set.toolboxmodel.Signale.Signal_Rahmen;
import org.eclipse.set.toolboxmodel.Signale.Signal_Signalbegriff;
import org.eclipse.set.utils.table.AbstractTableModelTransformator;
import org.eclipse.set.utils.table.TMFactory;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslzTransformator
extends AbstractPlanPro2TableModelTransformator {
    private static final Logger logger = LoggerFactory.getLogger(SslzTransformator.class);
    private static final MixedStringComparator SIGNALBEGRIFF_COMPARATOR = new MixedStringComparator("(?<letters1>[A-Za-z]*)(?<number>[0-9]*)(?<letters2>[A-Za-z]*)");
    private static final List<ENUMGleisart> NOT_USABLE = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ENUMGleisart[]{ENUMGleisart.ENUM_GLEISART_ANSCHLUSSGLEIS, ENUMGleisart.ENUM_GLEISART_NEBENGLEIS, ENUMGleisart.ENUM_GLEISART_SONSTIGE}));
    private static final String EMPTY_FILLING = "";

    public SslzTransformator(Set<ColumnDescriptor> cols, EnumTranslationService enumTranslationService) {
        super(cols, enumTranslationService);
    }

    public Table transformTableContent(MultiContainer_AttributeGroup container, TMFactory factory) {
        Iterable fstrZugRangierList;
        Iterable fstrZugRangierListSorted = fstrZugRangierList = container.getFstrZugRangier();
        int current = 0;
        for (final Fstr_Zug_Rangier fstrZugRangier : fstrZugRangierListSorted) {
            Set _emptySet;
            boolean isZ;
            ++current;
            boolean _isInterrupted = Thread.currentThread().isInterrupted();
            if (_isInterrupted) {
                return null;
            }
            Fstr_Zug_AttributeGroup _fstrZug = fstrZugRangier.getFstrZug();
            Fstr_Zug_Art_TypeClass _fstrZugArt = null;
            if (_fstrZug != null) {
                _fstrZugArt = _fstrZug.getFstrZugArt();
            }
            if (!(isZ = FstrZugRangierExtensions.isZ(_fstrZugArt))) continue;
            final TableRow instance = factory.newTableRow((Ur_Objekt)fstrZugRangier);
            Functions.Function1<Fstr_Zug_Rangier, String> _function = new Functions.Function1<Fstr_Zug_Rangier, String>(){

                public String apply(Fstr_Zug_Rangier it) {
                    Functions.Function1<Fstr_Zug_Art_TypeClass, Boolean> _function = new Functions.Function1<Fstr_Zug_Art_TypeClass, Boolean>(){

                        public Boolean apply(Fstr_Zug_Art_TypeClass it_1) {
                            return FstrZugRangierExtensions.isZ((Fstr_Zug_Art_TypeClass)it_1);
                        }
                    };
                    return FstrZugRangierExtensions.getZugFstrBezeichnung((Fstr_Zug_Rangier)it, (Functions.Function1)_function);
                }
            };
            this.fill(instance, this.getColumn(this.cols, "A"), fstrZugRangier, (Functions.Function1)_function);
            Functions.Function1<Fstr_Zug_Rangier, String> _function_1 = new Functions.Function1<Fstr_Zug_Rangier, String>(){

                public String apply(Fstr_Zug_Rangier it) {
                    return SslzTransformator.this.fahrwegStart(it);
                }
            };
            this.fill(instance, this.getColumn(this.cols, "B"), fstrZugRangier, (Functions.Function1)_function_1);
            Functions.Function1<Fstr_Zug_Rangier, Boolean> _function_2 = new Functions.Function1<Fstr_Zug_Rangier, Boolean>(){

                public Boolean apply(Fstr_Zug_Rangier it) {
                    final Basis_Objekt zielSignal = it.getIDFstrFahrweg().getIDZiel();
                    Functions.Function1<Fstr_Zug_Rangier, Boolean> _function = new Functions.Function1<Fstr_Zug_Rangier, Boolean>(){

                        public Boolean apply(Fstr_Zug_Rangier it_1) {
                            boolean _tripleEquals;
                            boolean _and = false;
                            Fstr_Zug_AttributeGroup _fstrZug = it_1.getFstrZug();
                            Fstr_Zug_Art_TypeClass _fstrZugArt = null;
                            if (_fstrZug != null) {
                                _fstrZugArt = _fstrZug.getFstrZugArt();
                            }
                            ENUMFstrZugArt _wert = null;
                            if (_fstrZugArt != null) {
                                _wert = _fstrZugArt.getWert();
                            }
                            boolean bl = _tripleEquals = _wert == ENUMFstrZugArt.ENUM_FSTR_ZUG_ART_B;
                            if (!_tripleEquals) {
                                _and = false;
                            } else {
                                boolean _equals;
                                Fstr_Fahrweg _iDFstrFahrweg = it_1.getIDFstrFahrweg();
                                Signal _iDStart = null;
                                if (_iDFstrFahrweg != null) {
                                    _iDStart = _iDFstrFahrweg.getIDStart();
                                }
                                _and = _equals = Objects.equal((Object)_iDStart, (Object)zielSignal);
                            }
                            return _and;
                        }
                    };
                    Fstr_Zug_Rangier _findFirst = (Fstr_Zug_Rangier)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)BasisAttributExtensions.getContainer((EObject)zielSignal).getContents(), Fstr_Zug_Rangier.class), (Functions.Function1)_function);
                    return _findFirst == null;
                }
            };
            Functions.Function1<Fstr_Zug_Rangier, String> _function_3 = new Functions.Function1<Fstr_Zug_Rangier, String>(){

                public String apply(Fstr_Zug_Rangier it) {
                    return SslzTransformator.this.fahrwegZiel(it);
                }
            };
            Functions.Function1<Fstr_Zug_Rangier, String> _function_4 = new Functions.Function1<Fstr_Zug_Rangier, String>(){

                public String apply(Fstr_Zug_Rangier it) {
                    return SslzTransformator.this.fahrwegZielBlock(it);
                }
            };
            this.fillConditional(instance, this.getColumn(this.cols, "C"), fstrZugRangier, (Functions.Function1)_function_2, (Functions.Function1)_function_3, (Functions.Function1)_function_4);
            Functions.Function1<Fstr_Zug_Rangier, String> _function_5 = new Functions.Function1<Fstr_Zug_Rangier, String>(){

                public String apply(Fstr_Zug_Rangier it) {
                    return SslzTransformator.this.fahrwegNummer(it);
                }
            };
            this.fill(instance, this.getColumn(this.cols, "D"), fstrZugRangier, (Functions.Function1)_function_5);
            Functions.Function1<Fstr_Zug_Rangier, Iterable<String>> _function_6 = new Functions.Function1<Fstr_Zug_Rangier, Iterable<String>>(){

                public Iterable<String> apply(Fstr_Zug_Rangier it) {
                    Functions.Function1<GestellteWeiche, String> _function = new Functions.Function1<GestellteWeiche, String>(){

                        public String apply(GestellteWeiche it_1) {
                            return it_1.getBezeichnung();
                        }
                    };
                    return ListExtensions.map((List)FstrZugRangierExtensions.getEntscheidungsweichen((Fstr_Zug_Rangier)it, NOT_USABLE), (Functions.Function1)_function);
                }
            };
            Functions.Function1<String, String> _function_7 = new Functions.Function1<String, String>(){

                public String apply(String it) {
                    return it;
                }
            };
            this.fillIterable(instance, this.getColumn(this.cols, "E"), fstrZugRangier, (Functions.Function1)_function_6, AbstractPlanPro2TableModelTransformator.MIXED_STRING_COMPARATOR, (Functions.Function1)_function_7);
            Functions.Function1<Fstr_Zug_Rangier, String> _function_8 = new Functions.Function1<Fstr_Zug_Rangier, String>(){

                public String apply(Fstr_Zug_Rangier it) {
                    Object _xblockexpression = null;
                    Fstr_DWeg _fstrDWeg = null;
                    if (fstrZugRangier != null) {
                        _fstrDWeg = FstrZugRangierExtensions.getFstrDWeg((Fstr_Zug_Rangier)fstrZugRangier);
                    }
                    Fstr_DWeg_Bezeichnung_AttributeGroup _bezeichnung = null;
                    if (_fstrDWeg != null) {
                        _bezeichnung = _fstrDWeg.getBezeichnung();
                    }
                    Bezeichnung_Fstr_DWeg_TypeClass _bezeichnungFstrDWeg = null;
                    if (_bezeichnung != null) {
                        _bezeichnungFstrDWeg = _bezeichnung.getBezeichnungFstrDWeg();
                    }
                    String _wert = null;
                    if (_bezeichnungFstrDWeg != null) {
                        _wert = _bezeichnungFstrDWeg.getWert();
                    }
                    String bezeichnung = _wert;
                    Object _xifexpression = null;
                    boolean _or = false;
                    if (bezeichnung == null) {
                        _or = true;
                    } else {
                        boolean _not;
                        Fstr_Zug_AttributeGroup _fstrZug = null;
                        if (fstrZugRangier != null) {
                            _fstrZug = fstrZugRangier.getFstrZug();
                        }
                        Fstr_Zug_DWeg_AttributeGroup _fstrZugDWeg = null;
                        if (_fstrZug != null) {
                            _fstrZugDWeg = _fstrZug.getFstrZugDWeg();
                        }
                        DWeg_Vorzug_TypeClass _dWegVorzug = null;
                        if (_fstrZugDWeg != null) {
                            _dWegVorzug = _fstrZugDWeg.getDWegVorzug();
                        }
                        Boolean _wert_1 = null;
                        if (_dWegVorzug != null) {
                            _wert_1 = _dWegVorzug.getWert();
                        }
                        _or = _not = _wert_1 == false;
                    }
                    _xifexpression = _or ? bezeichnung : bezeichnung + "*";
                    _xblockexpression = _xifexpression;
                    return _xblockexpression;
                }
            };
            this.fill(instance, this.getColumn(this.cols, "F"), fstrZugRangier, (Functions.Function1)_function_8);
            ColumnDescriptor _column = this.getColumn(this.cols, "G");
            Functions.Function1<Fstr_Zug_Rangier, Boolean> _function_9 = new Functions.Function1<Fstr_Zug_Rangier, Boolean>(){

                public Boolean apply(Fstr_Zug_Rangier it) {
                    Fstr_Zug_Rangier _zielFstrZugRangier = SslzTransformator.this.getZielFstrZugRangier(it);
                    return _zielFstrZugRangier != null;
                }
            };
            Functions.Function1<Fstr_Zug_Rangier, String> _function_10 = new Functions.Function1<Fstr_Zug_Rangier, String>(){

                public String apply(Fstr_Zug_Rangier it) {
                    StringConcatenation _builder = new StringConcatenation();
                    Fstr_Zug_AttributeGroup _fstrZug = it.getFstrZug();
                    Fstr_Zug_Art_TypeClass _fstrZugArt = null;
                    if (_fstrZug != null) {
                        _fstrZugArt = _fstrZug.getFstrZugArt();
                    }
                    ENUMFstrZugArt _wert = null;
                    if (_fstrZugArt != null) {
                        _wert = _fstrZugArt.getWert();
                    }
                    String _literal = null;
                    if (_wert != null) {
                        _literal = _wert.getLiteral();
                    }
                    String _substring = null;
                    if (_literal != null) {
                        _substring = _literal.substring(1);
                    }
                    _builder.append(_substring);
                    _builder.append("B");
                    return _builder.toString();
                }
            };
            Case _case = new Case((Functions.Function1)_function_9, (Functions.Function1)_function_10);
            Functions.Function1<Fstr_Zug_Rangier, Boolean> _function_11 = new Functions.Function1<Fstr_Zug_Rangier, Boolean>(){

                public Boolean apply(Fstr_Zug_Rangier it) {
                    Fstr_Zug_AttributeGroup _fstrZug = it.getFstrZug();
                    Signal _iDSignalGruppenausfahrt = null;
                    if (_fstrZug != null) {
                        _iDSignalGruppenausfahrt = _fstrZug.getIDSignalGruppenausfahrt();
                    }
                    return _iDSignalGruppenausfahrt != null;
                }
            };
            Functions.Function1<Fstr_Zug_Rangier, String> _function_12 = new Functions.Function1<Fstr_Zug_Rangier, String>(){

                public String apply(Fstr_Zug_Rangier it) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("G");
                    Fstr_Zug_AttributeGroup _fstrZug = it.getFstrZug();
                    Fstr_Zug_Art_TypeClass _fstrZugArt = null;
                    if (_fstrZug != null) {
                        _fstrZugArt = _fstrZug.getFstrZugArt();
                    }
                    ENUMFstrZugArt _wert = null;
                    if (_fstrZugArt != null) {
                        _wert = _fstrZugArt.getWert();
                    }
                    String _substring = _wert.getLiteral().substring(1);
                    _builder.append(_substring);
                    return _builder.toString();
                }
            };
            Case _case_1 = new Case((Functions.Function1)_function_11, (Functions.Function1)_function_12);
            Functions.Function1<Fstr_Zug_Rangier, Boolean> _function_13 = new Functions.Function1<Fstr_Zug_Rangier, Boolean>(){

                public Boolean apply(Fstr_Zug_Rangier it) {
                    return true;
                }
            };
            Functions.Function1<Fstr_Zug_Rangier, String> _function_14 = new Functions.Function1<Fstr_Zug_Rangier, String>(){

                public String apply(Fstr_Zug_Rangier it) {
                    Fstr_Zug_AttributeGroup _fstrZug = it.getFstrZug();
                    Fstr_Zug_Art_TypeClass _fstrZugArt = null;
                    if (_fstrZug != null) {
                        _fstrZugArt = _fstrZug.getFstrZugArt();
                    }
                    ENUMFstrZugArt _wert = null;
                    if (_fstrZugArt != null) {
                        _wert = _fstrZugArt.getWert();
                    }
                    return _wert.getLiteral().substring(1);
                }
            };
            Case _case_2 = new Case((Functions.Function1)_function_13, (Functions.Function1)_function_14);
            this.fillSwitch(instance, _column, fstrZugRangier, new Case[]{_case, _case_1, _case_2});
            Functions.Function1<Fstr_Zug_Rangier, String> _function_15 = new Functions.Function1<Fstr_Zug_Rangier, String>(){

                public String apply(Fstr_Zug_Rangier it) {
                    String _elvis = null;
                    Fstr_Zug_AttributeGroup _fstrZug = null;
                    if (fstrZugRangier != null) {
                        _fstrZug = fstrZugRangier.getFstrZug();
                    }
                    Automatische_Einstellung_TypeClass _automatischeEinstellung = null;
                    if (_fstrZug != null) {
                        _automatischeEinstellung = _fstrZug.getAutomatischeEinstellung();
                    }
                    ENUMAutomatischeEinstellung _wert = null;
                    if (_automatischeEinstellung != null) {
                        _wert = _automatischeEinstellung.getWert();
                    }
                    String _translate = null;
                    if (_wert != null) {
                        _translate = SslzTransformator.this.translate((Enumerator)_wert);
                    }
                    _elvis = _translate != null ? _translate : SslzTransformator.EMPTY_FILLING;
                    return _elvis;
                }
            };
            this.fill(instance, this.getColumn(this.cols, "H"), fstrZugRangier, (Functions.Function1)_function_15);
            Functions.Function1<Fstr_Zug_Rangier, String> _function_16 = new Functions.Function1<Fstr_Zug_Rangier, String>(){

                public String apply(Fstr_Zug_Rangier it) {
                    String _elvis = null;
                    Fstr_Zug_Rangier_Allg_AttributeGroup _fstrZugRangierAllg = null;
                    if (fstrZugRangier != null) {
                        _fstrZugRangierAllg = fstrZugRangier.getFstrZugRangierAllg();
                    }
                    F_Bedienung_TypeClass _fBedienung = null;
                    if (_fstrZugRangierAllg != null) {
                        _fBedienung = _fstrZugRangierAllg.getFBedienung();
                    }
                    Boolean _wert = null;
                    if (_fBedienung != null) {
                        _wert = _fBedienung.getWert();
                    }
                    String _translate = null;
                    if (_wert != null) {
                        _translate = SslzTransformator.this.translate(_wert);
                    }
                    _elvis = _translate != null ? _translate : SslzTransformator.EMPTY_FILLING;
                    return _elvis;
                }
            };
            this.fill(instance, this.getColumn(this.cols, "I"), fstrZugRangier, (Functions.Function1)_function_16);
            ColumnDescriptor _column_1 = this.getColumn(this.cols, "J");
            Set _elvis = null;
            Fstr_Fahrweg _fstrFahrweg = null;
            if (fstrZugRangier != null) {
                _fstrFahrweg = FstrZugRangierExtensions.getFstrFahrweg((Fstr_Zug_Rangier)fstrZugRangier);
            }
            Signal _zielSignal = null;
            if (_fstrFahrweg != null) {
                _zielSignal = FahrwegExtensions.getZielSignal((Fstr_Fahrweg)_fstrFahrweg);
            }
            Set _zgFahrtGleichzeitigVerbot = null;
            if (_zielSignal != null) {
                _zgFahrtGleichzeitigVerbot = SignalExtensions.getZgFahrtGleichzeitigVerbot((Signal)_zielSignal);
            }
            _elvis = _zgFahrtGleichzeitigVerbot != null ? _zgFahrtGleichzeitigVerbot : (_emptySet = Collections.emptySet());
            Functions.Function1<Set<Gleis_Bezeichnung>, Iterable<String>> _function_17 = new Functions.Function1<Set<Gleis_Bezeichnung>, Iterable<String>>(){

                public Iterable<String> apply(Set<Gleis_Bezeichnung> it) {
                    return SslzTransformator.this.fillInselgleis(it);
                }
            };
            this.fillIterable(instance, _column_1, _elvis, (Functions.Function1)_function_17, AbstractPlanPro2TableModelTransformator.MIXED_STRING_COMPARATOR);
            Functions.Function1<Fstr_Zug_Rangier, Iterable<String>> _function_18 = new Functions.Function1<Fstr_Zug_Rangier, Iterable<String>>(){

                public Iterable<String> apply(Fstr_Zug_Rangier it) {
                    Fstr_Fahrweg _fstrFahrweg = FstrZugRangierExtensions.getFstrFahrweg((Fstr_Zug_Rangier)it);
                    List _abhaengigkeiten = null;
                    if (_fstrFahrweg != null) {
                        _abhaengigkeiten = FahrwegExtensions.getAbhaengigkeiten((Fstr_Fahrweg)_fstrFahrweg);
                    }
                    List _map = null;
                    if (_abhaengigkeiten != null) {
                        Functions.Function1<Fstr_Abhaengigkeit, String> _function = new Functions.Function1<Fstr_Abhaengigkeit, String>(){

                            public String apply(Fstr_Abhaengigkeit it_1) {
                                Schluesselsperre _schluesselsperre = FstrAbhaengigkeitExtensions.schluesselsperre((Fstr_Abhaengigkeit)it_1);
                                Bezeichnung_Element_AttributeGroup _bezeichnung = null;
                                if (_schluesselsperre != null) {
                                    _bezeichnung = _schluesselsperre.getBezeichnung();
                                }
                                Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
                                if (_bezeichnung != null) {
                                    _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
                                }
                                String _wert = null;
                                if (_bezeichnungTabelle != null) {
                                    _wert = _bezeichnungTabelle.getWert();
                                }
                                return _wert;
                            }
                        };
                        _map = ListExtensions.map((List)_abhaengigkeiten, (Functions.Function1)_function);
                    }
                    return _map;
                }
            };
            this.fillIterable(instance, this.getColumn(this.cols, "K"), fstrZugRangier, (Functions.Function1)_function_18, AbstractPlanPro2TableModelTransformator.MIXED_STRING_COMPARATOR);
            boolean _isDebugEnabled = logger.isDebugEnabled();
            if (_isDebugEnabled) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("IDBUEEinschaltung=");
                Fstr_Zug_AttributeGroup _fstrZug_1 = fstrZugRangier.getFstrZug();
                EList _iDBUEEinschaltung = null;
                if (_fstrZug_1 != null) {
                    _iDBUEEinschaltung = _fstrZug_1.getIDBUEEinschaltung();
                }
                _builder.append((Object)_iDBUEEinschaltung);
                logger.debug(_builder.toString());
            }
            Functions.Function1<Fstr_Zug_Rangier, Iterable<String>> _function_19 = new Functions.Function1<Fstr_Zug_Rangier, Iterable<String>>(){

                public Iterable<String> apply(Fstr_Zug_Rangier it) {
                    Set _bUes = FahrwegExtensions.getBUes((Fstr_Fahrweg)FstrZugRangierExtensions.getFstrFahrweg((Fstr_Zug_Rangier)it));
                    Set _bUesImGefahrraum = FstrZugRangierExtensions.getBUesImGefahrraum((Fstr_Zug_Rangier)fstrZugRangier);
                    Functions.Function1<BUE_Anlage, Boolean> _function = new Functions.Function1<BUE_Anlage, Boolean>(){

                        public Boolean apply(BUE_Anlage it_1) {
                            boolean _contains;
                            BUE_Anlage_Allg_AttributeGroup _bUEAnlageAllg = it_1.getBUEAnlageAllg();
                            BUE_Sicherungsart_TypeClass _bUESicherungsart = null;
                            if (_bUEAnlageAllg != null) {
                                _bUESicherungsart = _bUEAnlageAllg.getBUESicherungsart();
                            }
                            ENUMBUESicherungsart _wert = null;
                            if (_bUESicherungsart != null) {
                                _wert = _bUESicherungsart.getWert();
                            }
                            return !(_contains = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new ENUMBUESicherungsart[]{ENUMBUESicherungsart.ENUMBUE_SICHERUNGSART_P, ENUMBUESicherungsart.ENUMBUE_SICHERUNGSART_PUND_LF, ENUMBUESicherungsart.ENUMBUE_SICHERUNGSART_UE, ENUMBUESicherungsart.ENUMBUE_SICHERUNGSART_UE_UND_P})).contains(_wert));
                        }
                    };
                    Functions.Function1<BUE_Anlage, String> _function_1 = new Functions.Function1<BUE_Anlage, String>(){

                        public String apply(BUE_Anlage it_1) {
                            Bezeichnung_Element_AttributeGroup _bezeichnung = it_1.getBezeichnung();
                            Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
                            if (_bezeichnung != null) {
                                _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
                            }
                            String _wert = null;
                            if (_bezeichnungTabelle != null) {
                                _wert = _bezeichnungTabelle.getWert();
                            }
                            return _wert;
                        }
                    };
                    return IterableExtensions.map((Iterable)IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)Iterables.concat((Iterable)_bUes, (Iterable)_bUesImGefahrraum), (Functions.Function1)_function)), (Functions.Function1)_function_1);
                }
            };
            this.fillIterable(instance, this.getColumn(this.cols, "L"), fstrZugRangier, (Functions.Function1)_function_19, AbstractPlanPro2TableModelTransformator.MIXED_STRING_COMPARATOR);
            Functions.Function1<Fstr_Zug_Rangier, Iterable<String>> _function_20 = new Functions.Function1<Fstr_Zug_Rangier, Iterable<String>>(){

                public Iterable<String> apply(Fstr_Zug_Rangier it) {
                    Functions.Function1<Fstr_Nichthaltfall, String> _function = new Functions.Function1<Fstr_Nichthaltfall, String>(){

                        public String apply(Fstr_Nichthaltfall it_1) {
                            FMA_Anlage _fmaAnlage = FstrNichthaltfallExtensions.getFmaAnlage((Fstr_Nichthaltfall)it_1);
                            Gleis_Abschnitt _iDGleisAbschnitt = null;
                            if (_fmaAnlage != null) {
                                _iDGleisAbschnitt = _fmaAnlage.getIDGleisAbschnitt();
                            }
                            Bezeichnung_Element_AttributeGroup _bezeichnung = null;
                            if (_iDGleisAbschnitt != null) {
                                _bezeichnung = _iDGleisAbschnitt.getBezeichnung();
                            }
                            Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
                            if (_bezeichnung != null) {
                                _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
                            }
                            String _wert = null;
                            if (_bezeichnungTabelle != null) {
                                _wert = _bezeichnungTabelle.getWert();
                            }
                            return _wert;
                        }
                    };
                    return ListExtensions.map((List)FstrZugRangierExtensions.getFstrNichthaltfall((Fstr_Zug_Rangier)it), (Functions.Function1)_function);
                }
            };
            this.fillIterable(instance, this.getColumn(this.cols, "M"), fstrZugRangier, (Functions.Function1)_function_20, AbstractPlanPro2TableModelTransformator.MIXED_STRING_COMPARATOR);
            Functions.Function1<Fstr_Zug_Rangier, String> _function_21 = new Functions.Function1<Fstr_Zug_Rangier, String>(){

                public String apply(Fstr_Zug_Rangier it) {
                    Fstr_Fahrweg _fstrFahrweg = FstrZugRangierExtensions.getFstrFahrweg((Fstr_Zug_Rangier)it);
                    Signal _start = null;
                    if (_fstrFahrweg != null) {
                        _start = FahrwegExtensions.getStart((Fstr_Fahrweg)_fstrFahrweg);
                    }
                    Schaltmittel_Zuordnung _zweitesHaltfallkriterium = null;
                    if (_start != null) {
                        _zweitesHaltfallkriterium = SignalExtensions.getZweitesHaltfallkriterium((Signal)_start);
                    }
                    Basis_Objekt _schalter = null;
                    if (_zweitesHaltfallkriterium != null) {
                        _schalter = SchaltmittelZuordnungExtensions.getSchalter((Schaltmittel_Zuordnung)_zweitesHaltfallkriterium);
                    }
                    Bezeichnung_Element_AttributeGroup _bezeichnung = null;
                    if ((Zugeinwirkung)_schalter != null) {
                        _bezeichnung = ((Zugeinwirkung)_schalter).getBezeichnung();
                    }
                    Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
                    if (_bezeichnung != null) {
                        _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
                    }
                    String _wert = null;
                    if (_bezeichnungTabelle != null) {
                        _wert = _bezeichnungTabelle.getWert();
                    }
                    return _wert;
                }
            };
            this.fill(instance, this.getColumn(this.cols, "N"), fstrZugRangier, (Functions.Function1)_function_21);
            final Wrapper schaltmittel = new Wrapper();
            final Wrapper gleisabschnitte = new Wrapper();
            final Wrapper zugeinwirkungen = new Wrapper();
            ColumnDescriptor _column_2 = this.getColumn(this.cols, "O");
            Functions.Function1<Fstr_Zug_Rangier, Boolean> _function_22 = new Functions.Function1<Fstr_Zug_Rangier, Boolean>(){

                public Boolean apply(Fstr_Zug_Rangier it) {
                    Set _emptySet;
                    boolean _xblockexpression = false;
                    Set _elvis = null;
                    Fstr_Fahrweg _fstrFahrweg = FstrZugRangierExtensions.getFstrFahrweg((Fstr_Zug_Rangier)it);
                    Signal _start = null;
                    if (_fstrFahrweg != null) {
                        _start = FahrwegExtensions.getStart((Fstr_Fahrweg)_fstrFahrweg);
                    }
                    List _anrueckverschluss = null;
                    if (_start != null) {
                        _anrueckverschluss = SignalExtensions.getAnrueckverschluss((Signal)_start);
                    }
                    List _map = null;
                    if (_anrueckverschluss != null) {
                        Functions.Function1<Schaltmittel_Zuordnung, Basis_Objekt> _function = new Functions.Function1<Schaltmittel_Zuordnung, Basis_Objekt>(){

                            public Basis_Objekt apply(Schaltmittel_Zuordnung it_1) {
                                return SchaltmittelZuordnungExtensions.getSchalter((Schaltmittel_Zuordnung)it_1);
                            }
                        };
                        _map = ListExtensions.map((List)_anrueckverschluss, (Functions.Function1)_function);
                    }
                    Set _set = null;
                    if (_map != null) {
                        _set = IterableExtensions.toSet(_map);
                    }
                    _elvis = _set != null ? _set : (_emptySet = Collections.emptySet());
                    schaltmittel.setValue(_elvis);
                    Functions.Function1<FMA_Anlage, Gleis_Abschnitt> _function_1 = new Functions.Function1<FMA_Anlage, Gleis_Abschnitt>(){

                        public Gleis_Abschnitt apply(FMA_Anlage it_1) {
                            return it_1.getIDGleisAbschnitt();
                        }
                    };
                    gleisabschnitte.setValue((Object)IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)((Iterable)schaltmittel.getValue()), FMA_Anlage.class), (Functions.Function1)_function_1)));
                    boolean _isEmpty = ((Set)gleisabschnitte.getValue()).isEmpty();
                    _xblockexpression = !_isEmpty;
                    return _xblockexpression;
                }
            };
            Functions.Function1<Fstr_Zug_Rangier, Iterable<String>> _function_23 = new Functions.Function1<Fstr_Zug_Rangier, Iterable<String>>(){

                public Iterable<String> apply(Fstr_Zug_Rangier it) {
                    Functions.Function1<Gleis_Abschnitt, String> _function = new Functions.Function1<Gleis_Abschnitt, String>(){

                        public String apply(Gleis_Abschnitt it_1) {
                            Bezeichnung_Element_AttributeGroup _bezeichnung = it_1.getBezeichnung();
                            Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
                            if (_bezeichnung != null) {
                                _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
                            }
                            String _wert = null;
                            if (_bezeichnungTabelle != null) {
                                _wert = _bezeichnungTabelle.getWert();
                            }
                            return _wert;
                        }
                    };
                    return IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)((Iterable)gleisabschnitte.getValue()), (Functions.Function1)_function));
                }
            };
            Case _case_3 = new Case((Functions.Function1)_function_22, (Functions.Function1)_function_23, AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR, AbstractPlanPro2TableModelTransformator.MIXED_STRING_COMPARATOR);
            Functions.Function1<Fstr_Zug_Rangier, Boolean> _function_24 = new Functions.Function1<Fstr_Zug_Rangier, Boolean>(){

                public Boolean apply(Fstr_Zug_Rangier it) {
                    boolean _xblockexpression = false;
                    Functions.Function1<Zugeinwirkung, String> _function = new Functions.Function1<Zugeinwirkung, String>(){

                        public String apply(Zugeinwirkung it_1) {
                            Bezeichnung_Element_AttributeGroup _bezeichnung = it_1.getBezeichnung();
                            Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
                            if (_bezeichnung != null) {
                                _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
                            }
                            String _wert = null;
                            if (_bezeichnungTabelle != null) {
                                _wert = _bezeichnungTabelle.getWert();
                            }
                            return _wert;
                        }
                    };
                    zugeinwirkungen.setValue((Object)IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)((Iterable)schaltmittel.getValue()), Zugeinwirkung.class), (Functions.Function1)_function)));
                    boolean _isEmpty = ((Set)zugeinwirkungen.getValue()).isEmpty();
                    _xblockexpression = !_isEmpty;
                    return _xblockexpression;
                }
            };
            Functions.Function1<Fstr_Zug_Rangier, Iterable<String>> _function_25 = new Functions.Function1<Fstr_Zug_Rangier, Iterable<String>>(){

                public Iterable<String> apply(Fstr_Zug_Rangier it) {
                    return (Iterable)zugeinwirkungen.getValue();
                }
            };
            Case _case_4 = new Case((Functions.Function1)_function_24, (Functions.Function1)_function_25, AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR, AbstractPlanPro2TableModelTransformator.MIXED_STRING_COMPARATOR);
            this.fillSwitch(instance, _column_2, fstrZugRangier, new Case[]{_case_3, _case_4});
            Functions.Function1<Fstr_Zug_Rangier, String> _function_26 = new Functions.Function1<Fstr_Zug_Rangier, String>(){

                public String apply(Fstr_Zug_Rangier it) {
                    Fstr_Fahrweg _fstrFahrweg = null;
                    if (fstrZugRangier != null) {
                        _fstrFahrweg = FstrZugRangierExtensions.getFstrFahrweg((Fstr_Zug_Rangier)fstrZugRangier);
                    }
                    Fstr_V_Hg_TypeClass _fstrVHg = null;
                    if (_fstrFahrweg != null) {
                        _fstrVHg = _fstrFahrweg.getFstrVHg();
                    }
                    BigInteger _wert = null;
                    if (_fstrVHg != null) {
                        _wert = _fstrVHg.getWert();
                    }
                    String _string = null;
                    if (_wert != null) {
                        _string = _wert.toString();
                    }
                    return _string;
                }
            };
            this.fill(instance, this.getColumn(this.cols, "P"), fstrZugRangier, (Functions.Function1)_function_26);
            Functions.Function1<Fstr_Zug_Rangier, Boolean> _function_27 = new Functions.Function1<Fstr_Zug_Rangier, Boolean>(){

                public Boolean apply(Fstr_Zug_Rangier it) {
                    int _geschwindigkeit = FstrZugRangierExtensions.geschwindigkeit((Fstr_Zug_Rangier)fstrZugRangier);
                    return _geschwindigkeit == Integer.MAX_VALUE;
                }
            };
            Functions.Function1<Fstr_Zug_Rangier, String> _function_28 = new Functions.Function1<Fstr_Zug_Rangier, String>(){

                public String apply(Fstr_Zug_Rangier it) {
                    return SslzTransformator.EMPTY_FILLING;
                }
            };
            Functions.Function1<Fstr_Zug_Rangier, String> _function_29 = new Functions.Function1<Fstr_Zug_Rangier, String>(){

                public String apply(Fstr_Zug_Rangier it) {
                    return Integer.toString(FstrZugRangierExtensions.geschwindigkeit((Fstr_Zug_Rangier)fstrZugRangier));
                }
            };
            this.fillConditional(instance, this.getColumn(this.cols, "Q"), fstrZugRangier, (Functions.Function1)_function_27, (Functions.Function1)_function_28, (Functions.Function1)_function_29);
            Functions.Function1<Fstr_Zug_Rangier, String> _function_30 = new Functions.Function1<Fstr_Zug_Rangier, String>(){

                public String apply(Fstr_Zug_Rangier it) {
                    Fstr_DWeg _fstrDWeg = null;
                    if (fstrZugRangier != null) {
                        _fstrDWeg = FstrZugRangierExtensions.getFstrDWeg((Fstr_Zug_Rangier)fstrZugRangier);
                    }
                    Fstr_DWeg_Spezifisch_AttributeGroup _fstrDWegSpezifisch = null;
                    if (_fstrDWeg != null) {
                        _fstrDWegSpezifisch = _fstrDWeg.getFstrDWegSpezifisch();
                    }
                    DWeg_V_TypeClass _dWegV = null;
                    if (_fstrDWegSpezifisch != null) {
                        _dWegV = _fstrDWegSpezifisch.getDWegV();
                    }
                    BigInteger _wert = null;
                    if (_dWegV != null) {
                        _wert = _dWegV.getWert();
                    }
                    String _string = null;
                    if (_wert != null) {
                        _string = _wert.toString();
                    }
                    return _string;
                }
            };
            this.fill(instance, this.getColumn(this.cols, "R"), fstrZugRangier, (Functions.Function1)_function_30);
            Functions.Function1<Fstr_Zug_Rangier, String> _function_31 = new Functions.Function1<Fstr_Zug_Rangier, String>(){

                public String apply(Fstr_Zug_Rangier it) {
                    Fstr_Zug_Rangier_Allg_AttributeGroup _fstrZugRangierAllg = null;
                    if (fstrZugRangier != null) {
                        _fstrZugRangierAllg = fstrZugRangier.getFstrZugRangierAllg();
                    }
                    Fstr_V_TypeClass _fstrV = null;
                    if (_fstrZugRangierAllg != null) {
                        _fstrV = _fstrZugRangierAllg.getFstrV();
                    }
                    BigInteger _wert = null;
                    if (_fstrV != null) {
                        _wert = _fstrV.getWert();
                    }
                    String _string = null;
                    if (_wert != null) {
                        _string = _wert.toString();
                    }
                    return _string;
                }
            };
            this.fill(instance, this.getColumn(this.cols, "S"), fstrZugRangier, (Functions.Function1)_function_31);
            ColumnDescriptor _column_3 = this.getColumn(this.cols, "T");
            Functions.Function1<Fstr_Zug_Rangier, Boolean> _function_32 = new Functions.Function1<Fstr_Zug_Rangier, Boolean>(){

                public Boolean apply(Fstr_Zug_Rangier it) {
                    boolean _equals;
                    boolean _and = false;
                    boolean _or = false;
                    Fstr_Zug_Art_TypeClass _fstrZugArt = it.getFstrZug().getFstrZugArt();
                    ENUMFstrZugArt _wert = null;
                    if (_fstrZugArt != null) {
                        _wert = _fstrZugArt.getWert();
                    }
                    String _literal = null;
                    if (_wert != null) {
                        _literal = _wert.getLiteral();
                    }
                    if (_equals = Objects.equal((Object)_literal, (Object)"ZM")) {
                        _or = true;
                    } else {
                        boolean _equals_1;
                        Fstr_Zug_Art_TypeClass _fstrZugArt_1 = it.getFstrZug().getFstrZugArt();
                        ENUMFstrZugArt _wert_1 = null;
                        if (_fstrZugArt_1 != null) {
                            _wert_1 = _fstrZugArt_1.getWert();
                        }
                        String _literal_1 = null;
                        if (_wert_1 != null) {
                            _literal_1 = _wert_1.getLiteral();
                        }
                        _or = _equals_1 = Objects.equal((Object)_literal_1, (Object)"ZUM");
                    }
                    if (!_or) {
                        _and = false;
                    } else {
                        boolean _not;
                        Functions.Function1<Fstr_Signalisierung, Boolean> _function = new Functions.Function1<Fstr_Signalisierung, Boolean>(){

                            public Boolean apply(Fstr_Signalisierung it_1) {
                                return SignalbegriffExtensions.hasSignalbegriffID((Signal_Signalbegriff)FstrSignalisierungExtensions.getSignalSignalbegriff((Fstr_Signalisierung)it_1), Zs3.class) && Objects.equal((Object)SignalRahmenExtensions.getSignal((Signal_Rahmen)SignalbegriffExtensions.signalRahmen((Signal_Signalbegriff)FstrSignalisierungExtensions.getSignalSignalbegriff((Fstr_Signalisierung)it_1))), (Object)FstrZugRangierExtensions.getFstrFahrweg((Fstr_Zug_Rangier)fstrZugRangier).getIDZiel());
                            }
                        };
                        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)FstrZugRangierExtensions.fstrSignalisierung((Fstr_Zug_Rangier)it), (Functions.Function1)_function));
                        _and = _not = !_isEmpty;
                    }
                    return _and;
                }
            };
            Functions.Function1<Fstr_Zug_Rangier, Iterable<String>> _function_33 = new Functions.Function1<Fstr_Zug_Rangier, Iterable<String>>(){

                public Iterable<String> apply(Fstr_Zug_Rangier it) {
                    Functions.Function1<Fstr_Signalisierung, Signal_Signalbegriff> _function = new Functions.Function1<Fstr_Signalisierung, Signal_Signalbegriff>(){

                        public Signal_Signalbegriff apply(Fstr_Signalisierung it_1) {
                            return FstrSignalisierungExtensions.getSignalSignalbegriff((Fstr_Signalisierung)it_1);
                        }
                    };
                    Functions.Function1<Signal_Signalbegriff, Boolean> _function_1 = new Functions.Function1<Signal_Signalbegriff, Boolean>(){

                        public Boolean apply(Signal_Signalbegriff it_1) {
                            return SignalbegriffExtensions.hasSignalbegriffID((Signal_Signalbegriff)it_1, Zs3.class) && Objects.equal((Object)SignalRahmenExtensions.getSignal((Signal_Rahmen)SignalbegriffExtensions.signalRahmen((Signal_Signalbegriff)it_1)), (Object)FstrZugRangierExtensions.getFstrFahrweg((Fstr_Zug_Rangier)fstrZugRangier).getIDZiel());
                        }
                    };
                    Functions.Function1<Signal_Signalbegriff, String> _function_2 = new Functions.Function1<Signal_Signalbegriff, String>(){

                        public String apply(Signal_Signalbegriff it_1) {
                            Signalbegriff_ID_TypeClass _signalbegriffID = it_1.getSignalbegriffID();
                            String _symbol = null;
                            if (_signalbegriffID != null) {
                                _symbol = _signalbegriffID.getSymbol();
                            }
                            return _symbol;
                        }
                    };
                    List signals = IterableExtensions.sortBy((Iterable)IterableExtensions.filter((Iterable)ListExtensions.map((List)FstrZugRangierExtensions.fstrSignalisierung((Fstr_Zug_Rangier)it), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
                    Functions.Function1<Signal_Signalbegriff, String> _function_3 = new Functions.Function1<Signal_Signalbegriff, String>(){

                        public String apply(Signal_Signalbegriff it_1) {
                            Signalbegriff_ID_TypeClass _signalbegriffID = it_1.getSignalbegriffID();
                            String _symbol = null;
                            if (_signalbegriffID != null) {
                                _symbol = _signalbegriffID.getSymbol();
                            }
                            return _symbol;
                        }
                    };
                    return IterableExtensions.filterNull((Iterable)ListExtensions.map((List)signals, (Functions.Function1)_function_3));
                }
            };
            Case _case_5 = new Case((Functions.Function1)_function_32, (Functions.Function1)_function_33, AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR, null);
            Functions.Function1<Fstr_Zug_Rangier, Boolean> _function_34 = new Functions.Function1<Fstr_Zug_Rangier, Boolean>(){

                public Boolean apply(Fstr_Zug_Rangier it) {
                    return true;
                }
            };
            Functions.Function1<Fstr_Zug_Rangier, Iterable<String>> _function_35 = new Functions.Function1<Fstr_Zug_Rangier, Iterable<String>>(){

                public Iterable<String> apply(Fstr_Zug_Rangier it) {
                    Functions.Function1<Fstr_Signalisierung, Boolean> _function = new Functions.Function1<Fstr_Signalisierung, Boolean>(){

                        public Boolean apply(Fstr_Signalisierung it_1) {
                            return FstrSignalisierungExtensions.getSignalSignalbegriff((Fstr_Signalisierung)it_1) != null && FstrSignalisierungExtensions.getSignalSignalbegriffZiel((Fstr_Signalisierung)it_1) == null && SignalbegriffExtensions.hasSignalbegriffID((Signal_Signalbegriff)FstrSignalisierungExtensions.getSignalSignalbegriff((Fstr_Signalisierung)it_1), Zs3.class) && Objects.equal((Object)SignalRahmenExtensions.getSignal((Signal_Rahmen)SignalbegriffExtensions.signalRahmen((Signal_Signalbegriff)FstrSignalisierungExtensions.getSignalSignalbegriff((Fstr_Signalisierung)it_1))).getIdentitaet().getWert(), (Object)FahrwegExtensions.getStart((Fstr_Fahrweg)FstrZugRangierExtensions.getFstrFahrweg((Fstr_Zug_Rangier)fstrZugRangier)).getIdentitaet().getWert());
                        }
                    };
                    Functions.Function1<Fstr_Signalisierung, String> _function_1 = new Functions.Function1<Fstr_Signalisierung, String>(){

                        public String apply(Fstr_Signalisierung it_1) {
                            Signal_Signalbegriff _signalSignalbegriff = FstrSignalisierungExtensions.getSignalSignalbegriff((Fstr_Signalisierung)it_1);
                            Signalbegriff_ID_TypeClass _signalbegriffID = null;
                            if (_signalSignalbegriff != null) {
                                _signalbegriffID = _signalSignalbegriff.getSignalbegriffID();
                            }
                            String _symbol = null;
                            if (_signalbegriffID != null) {
                                _symbol = _signalbegriffID.getSymbol();
                            }
                            return _symbol;
                        }
                    };
                    List zs3Start = IterableExtensions.sortBy((Iterable)IterableExtensions.filter((Iterable)FstrZugRangierExtensions.fstrSignalisierung((Fstr_Zug_Rangier)fstrZugRangier), (Functions.Function1)_function), (Functions.Function1)_function_1);
                    Functions.Function1<Fstr_Signalisierung, Boolean> _function_2 = new Functions.Function1<Fstr_Signalisierung, Boolean>(){

                        public Boolean apply(Fstr_Signalisierung it_1) {
                            return FstrSignalisierungExtensions.getSignalSignalbegriff((Fstr_Signalisierung)it_1) != null && FstrSignalisierungExtensions.getSignalSignalbegriffZiel((Fstr_Signalisierung)it_1) != null && SignalbegriffExtensions.hasSignalbegriffID((Signal_Signalbegriff)FstrSignalisierungExtensions.getSignalSignalbegriff((Fstr_Signalisierung)it_1), Zs3.class) && (SignalbegriffExtensions.hasSignalbegriffID((Signal_Signalbegriff)FstrSignalisierungExtensions.getSignalSignalbegriffZiel((Fstr_Signalisierung)it_1), Zs3.class) || SignalbegriffExtensions.hasSignalbegriffID((Signal_Signalbegriff)FstrSignalisierungExtensions.getSignalSignalbegriffZiel((Fstr_Signalisierung)it_1), Hp0.class)) && Objects.equal((Object)SignalRahmenExtensions.getSignal((Signal_Rahmen)SignalbegriffExtensions.signalRahmen((Signal_Signalbegriff)FstrSignalisierungExtensions.getSignalSignalbegriff((Fstr_Signalisierung)it_1))).getIdentitaet().getWert(), (Object)FahrwegExtensions.getStart((Fstr_Fahrweg)FstrZugRangierExtensions.getFstrFahrweg((Fstr_Zug_Rangier)fstrZugRangier)).getIdentitaet().getWert());
                        }
                    };
                    Functions.Function1<Fstr_Signalisierung, String> _function_3 = new Functions.Function1<Fstr_Signalisierung, String>(){

                        public String apply(Fstr_Signalisierung it_1) {
                            Signal_Signalbegriff _signalSignalbegriff = FstrSignalisierungExtensions.getSignalSignalbegriff((Fstr_Signalisierung)it_1);
                            Signalbegriff_ID_TypeClass _signalbegriffID = null;
                            if (_signalSignalbegriff != null) {
                                _signalbegriffID = _signalSignalbegriff.getSignalbegriffID();
                            }
                            String _symbol = null;
                            if (_signalbegriffID != null) {
                                _symbol = _signalbegriffID.getSymbol();
                            }
                            return _symbol;
                        }
                    };
                    List zs3StartZiel = IterableExtensions.sortBy((Iterable)IterableExtensions.filter((Iterable)FstrZugRangierExtensions.fstrSignalisierung((Fstr_Zug_Rangier)fstrZugRangier), (Functions.Function1)_function_2), (Functions.Function1)_function_3);
                    Functions.Function1<Fstr_Signalisierung, String> _function_4 = new Functions.Function1<Fstr_Signalisierung, String>(){

                        public String apply(Fstr_Signalisierung it_1) {
                            StringConcatenation _builder = new StringConcatenation();
                            Signal_Signalbegriff _signalSignalbegriff = FstrSignalisierungExtensions.getSignalSignalbegriff((Fstr_Signalisierung)it_1);
                            Signalbegriff_ID_TypeClass _signalbegriffID = null;
                            if (_signalSignalbegriff != null) {
                                _signalbegriffID = _signalSignalbegriff.getSignalbegriffID();
                            }
                            String _symbol = null;
                            if (_signalbegriffID != null) {
                                _symbol = _signalbegriffID.getSymbol();
                            }
                            _builder.append(_symbol);
                            return _builder.toString();
                        }
                    };
                    Set result = IterableExtensions.toSet((Iterable)ListExtensions.map((List)zs3Start, (Functions.Function1)_function_4));
                    if (!zs3Start.isEmpty() && !zs3StartZiel.isEmpty()) {
                        Functions.Function1<Fstr_Signalisierung, String> _function_5 = new Functions.Function1<Fstr_Signalisierung, String>(){

                            public String apply(Fstr_Signalisierung it_1) {
                                StringConcatenation _builder = new StringConcatenation();
                                Signal_Signalbegriff _signalSignalbegriff = FstrSignalisierungExtensions.getSignalSignalbegriff((Fstr_Signalisierung)it_1);
                                Signalbegriff_ID_TypeClass _signalbegriffID = null;
                                if (_signalSignalbegriff != null) {
                                    _signalbegriffID = _signalSignalbegriff.getSignalbegriffID();
                                }
                                String _symbol = null;
                                if (_signalbegriffID != null) {
                                    _symbol = _signalbegriffID.getSymbol();
                                }
                                _builder.append(_symbol);
                                _builder.append("(");
                                boolean _hasSignalbegriffID = SignalbegriffExtensions.hasSignalbegriffID((Signal_Signalbegriff)FstrSignalisierungExtensions.getSignalSignalbegriffZiel((Fstr_Signalisierung)it_1), Hp0.class);
                                if (_hasSignalbegriffID) {
                                    _builder.append("0");
                                } else {
                                    Signal_Signalbegriff _signalSignalbegriffZiel = FstrSignalisierungExtensions.getSignalSignalbegriffZiel((Fstr_Signalisierung)it_1);
                                    Signalbegriff_ID_TypeClass _signalbegriffID_1 = null;
                                    if (_signalSignalbegriffZiel != null) {
                                        _signalbegriffID_1 = _signalSignalbegriffZiel.getSignalbegriffID();
                                    }
                                    String _symbol_1 = null;
                                    if (_signalbegriffID_1 != null) {
                                        _symbol_1 = _signalbegriffID_1.getSymbol();
                                    }
                                    _builder.append(_symbol_1);
                                }
                                _builder.append(")");
                                return _builder.toString();
                            }
                        };
                        result.addAll(ListExtensions.map((List)zs3StartZiel, (Functions.Function1)_function_5));
                    }
                    return result;
                }
            };
            Case _case_6 = new Case((Functions.Function1)_function_34, (Functions.Function1)_function_35, AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR, null);
            this.fillSwitch(instance, _column_3, fstrZugRangier, new Case[]{_case_5, _case_6});
            Functions.Function1<Fstr_Zug_Rangier, String> _function_36 = new Functions.Function1<Fstr_Zug_Rangier, String>(){

                public String apply(Fstr_Zug_Rangier it) {
                    String _elvis = null;
                    Fstr_Mittel_AttributeGroup _fstrMittel = null;
                    if (fstrZugRangier != null) {
                        _fstrMittel = fstrZugRangier.getFstrMittel();
                    }
                    Fstr_Mittel_V_Aufwertung_TypeClass _fstrMittelVAufwertung = null;
                    if (_fstrMittel != null) {
                        _fstrMittelVAufwertung = _fstrMittel.getFstrMittelVAufwertung();
                    }
                    Boolean _wert = null;
                    if (_fstrMittelVAufwertung != null) {
                        _wert = _fstrMittelVAufwertung.getWert();
                    }
                    String _translate = null;
                    if (_wert != null) {
                        _translate = SslzTransformator.this.translate(_wert);
                    }
                    _elvis = _translate != null ? _translate : SslzTransformator.EMPTY_FILLING;
                    return _elvis;
                }
            };
            this.fill(instance, this.getColumn(this.cols, "U"), fstrZugRangier, (Functions.Function1)_function_36);
            Functions.Function1<Fstr_Zug_Rangier, Boolean> _function_37 = new Functions.Function1<Fstr_Zug_Rangier, Boolean>(){

                public Boolean apply(final Fstr_Zug_Rangier r) {
                    Functions.Function1<Signal_Signalbegriff, Boolean> _function = new Functions.Function1<Signal_Signalbegriff, Boolean>(){

                        public Boolean apply(Signal_Signalbegriff it) {
                            return SignalbegriffExtensions.hasSignalbegriffID((Signal_Signalbegriff)it, ZlO.class) && IterableExtensions.toList((Iterable)ListExtensions.map((List)FstrZugRangierExtensions.fstrSignalisierung((Fstr_Zug_Rangier)r), (Functions.Function1)new Functions.Function1<Fstr_Signalisierung, Signal_Signalbegriff>(){

                                public Signal_Signalbegriff apply(Fstr_Signalisierung it_1) {
                                    return FstrSignalisierungExtensions.getSignalSignalbegriff((Fstr_Signalisierung)it_1);
                                }
                            })).contains(it);
                        }
                    };
                    return IterableExtensions.exists((Iterable)SignalExtensions.getSignalbegriffe((Signal)FahrwegExtensions.getStart((Fstr_Fahrweg)FstrZugRangierExtensions.getFstrFahrweg((Fstr_Zug_Rangier)r))), (Functions.Function1)_function);
                }
            };
            Functions.Function1<Fstr_Zug_Rangier, String> _function_38 = new Functions.Function1<Fstr_Zug_Rangier, String>(){

                public String apply(Fstr_Zug_Rangier it) {
                    return "x";
                }
            };
            this.fillConditional(instance, this.getColumn(this.cols, "V"), fstrZugRangier, (Functions.Function1)_function_37, (Functions.Function1)_function_38);
            Functions.Function1<Fstr_Zug_Rangier, Iterable<String>> _function_39 = new Functions.Function1<Fstr_Zug_Rangier, Iterable<String>>(){

                public Iterable<String> apply(Fstr_Zug_Rangier it) {
                    Functions.Function1<Fstr_Signalisierung, Signal_Signalbegriff> _function = new Functions.Function1<Fstr_Signalisierung, Signal_Signalbegriff>(){

                        public Signal_Signalbegriff apply(Fstr_Signalisierung it_1) {
                            return FstrSignalisierungExtensions.getSignalSignalbegriff((Fstr_Signalisierung)it_1);
                        }
                    };
                    Functions.Function1<Signal_Signalbegriff, Boolean> _function_1 = new Functions.Function1<Signal_Signalbegriff, Boolean>(){

                        public Boolean apply(Signal_Signalbegriff it_1) {
                            return SignalbegriffExtensions.hasSignalbegriffID((Signal_Signalbegriff)it_1, Zs3v.class);
                        }
                    };
                    Functions.Function1<Signal_Signalbegriff, String> _function_2 = new Functions.Function1<Signal_Signalbegriff, String>(){

                        public String apply(Signal_Signalbegriff it_1) {
                            return it_1.getSignalbegriffID().getSymbol();
                        }
                    };
                    return IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)ListExtensions.map((List)FstrZugRangierExtensions.fstrSignalisierung((Fstr_Zug_Rangier)it), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
                }
            };
            this.fillIterable(instance, this.getColumn(this.cols, "W"), fstrZugRangier, (Functions.Function1)_function_39, (Comparator)SIGNALBEGRIFF_COMPARATOR);
            Functions.Function1<Fstr_Zug_Rangier, Iterable<String>> _function_40 = new Functions.Function1<Fstr_Zug_Rangier, Iterable<String>>(){

                public Iterable<String> apply(Fstr_Zug_Rangier it) {
                    Functions.Function1<Fstr_Signalisierung, Signal_Signalbegriff> _function = new Functions.Function1<Fstr_Signalisierung, Signal_Signalbegriff>(){

                        public Signal_Signalbegriff apply(Fstr_Signalisierung it_1) {
                            return FstrSignalisierungExtensions.getSignalSignalbegriff((Fstr_Signalisierung)it_1);
                        }
                    };
                    Functions.Function1<Signal_Signalbegriff, Boolean> _function_1 = new Functions.Function1<Signal_Signalbegriff, Boolean>(){

                        public Boolean apply(Signal_Signalbegriff it_1) {
                            return SignalbegriffExtensions.hasSignalbegriffID((Signal_Signalbegriff)it_1, Zs2.class);
                        }
                    };
                    Functions.Function1<Signal_Signalbegriff, String> _function_2 = new Functions.Function1<Signal_Signalbegriff, String>(){

                        public String apply(Signal_Signalbegriff it_1) {
                            return it_1.getSignalbegriffID().getSymbol();
                        }
                    };
                    return IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)ListExtensions.map((List)FstrZugRangierExtensions.fstrSignalisierung((Fstr_Zug_Rangier)it), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
                }
            };
            this.fillIterable(instance, this.getColumn(this.cols, "X"), fstrZugRangier, (Functions.Function1)_function_40, (Comparator)SIGNALBEGRIFF_COMPARATOR);
            Functions.Function1<Fstr_Zug_Rangier, Iterable<String>> _function_41 = new Functions.Function1<Fstr_Zug_Rangier, Iterable<String>>(){

                public Iterable<String> apply(Fstr_Zug_Rangier it) {
                    Functions.Function1<Fstr_Signalisierung, Signal_Signalbegriff> _function = new Functions.Function1<Fstr_Signalisierung, Signal_Signalbegriff>(){

                        public Signal_Signalbegriff apply(Fstr_Signalisierung it_1) {
                            return FstrSignalisierungExtensions.getSignalSignalbegriff((Fstr_Signalisierung)it_1);
                        }
                    };
                    Functions.Function1<Signal_Signalbegriff, Boolean> _function_1 = new Functions.Function1<Signal_Signalbegriff, Boolean>(){

                        public Boolean apply(Signal_Signalbegriff it_1) {
                            return SignalbegriffExtensions.hasSignalbegriffID((Signal_Signalbegriff)it_1, Zs2v.class);
                        }
                    };
                    Functions.Function1<Signal_Signalbegriff, String> _function_2 = new Functions.Function1<Signal_Signalbegriff, String>(){

                        public String apply(Signal_Signalbegriff it_1) {
                            return it_1.getSignalbegriffID().getSymbol();
                        }
                    };
                    return IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)ListExtensions.map((List)FstrZugRangierExtensions.fstrSignalisierung((Fstr_Zug_Rangier)it), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
                }
            };
            this.fillIterable(instance, this.getColumn(this.cols, "Y"), fstrZugRangier, (Functions.Function1)_function_41, (Comparator)SIGNALBEGRIFF_COMPARATOR);
            Functions.Function1<Fstr_Zug_Rangier, Boolean> _function_42 = new Functions.Function1<Fstr_Zug_Rangier, Boolean>(){

                public Boolean apply(final Fstr_Zug_Rangier r) {
                    Functions.Function1<Signal_Signalbegriff, Boolean> _function = new Functions.Function1<Signal_Signalbegriff, Boolean>(){

                        public Boolean apply(Signal_Signalbegriff b) {
                            return SignalbegriffExtensions.hasSignalbegriffID((Signal_Signalbegriff)b, Zs6.class) && ListExtensions.map((List)FstrZugRangierExtensions.fstrSignalisierung((Fstr_Zug_Rangier)r), (Functions.Function1)new Functions.Function1<Fstr_Signalisierung, Signal_Signalbegriff>(){

                                public Signal_Signalbegriff apply(Fstr_Signalisierung it) {
                                    return FstrSignalisierungExtensions.getSignalSignalbegriff((Fstr_Signalisierung)it);
                                }
                            }).contains(b);
                        }
                    };
                    return IterableExtensions.exists((Iterable)SignalExtensions.getSignalbegriffe((Signal)FahrwegExtensions.getStart((Fstr_Fahrweg)FstrZugRangierExtensions.getFstrFahrweg((Fstr_Zug_Rangier)r))), (Functions.Function1)_function);
                }
            };
            Functions.Function1<Fstr_Zug_Rangier, String> _function_43 = new Functions.Function1<Fstr_Zug_Rangier, String>(){

                public String apply(Fstr_Zug_Rangier it) {
                    return "x";
                }
            };
            this.fillConditional(instance, this.getColumn(this.cols, "Z"), fstrZugRangier, (Functions.Function1)_function_42, (Functions.Function1)_function_43);
            Functions.Function1<Fstr_Zug_Rangier, Boolean> _function_44 = new Functions.Function1<Fstr_Zug_Rangier, Boolean>(){

                public Boolean apply(Fstr_Zug_Rangier it) {
                    Functions.Function1<Fstr_Signalisierung, Signal_Signalbegriff> _function = new Functions.Function1<Fstr_Signalisierung, Signal_Signalbegriff>(){

                        public Signal_Signalbegriff apply(Fstr_Signalisierung it_1) {
                            return FstrSignalisierungExtensions.getSignalSignalbegriff((Fstr_Signalisierung)it_1);
                        }
                    };
                    Functions.Function1<Signal_Signalbegriff, Boolean> _function_1 = new Functions.Function1<Signal_Signalbegriff, Boolean>(){

                        public Boolean apply(Signal_Signalbegriff it_1) {
                            Signalbegriff_ID_TypeClass _signalbegriffID = it_1.getSignalbegriffID();
                            return _signalbegriffID instanceof Zs13;
                        }
                    };
                    return IterableExtensions.exists((Iterable)ListExtensions.map((List)FstrZugRangierExtensions.fstrSignalisierung((Fstr_Zug_Rangier)it), (Functions.Function1)_function), (Functions.Function1)_function_1);
                }
            };
            Functions.Function1<Fstr_Zug_Rangier, String> _function_45 = new Functions.Function1<Fstr_Zug_Rangier, String>(){

                public String apply(Fstr_Zug_Rangier it) {
                    return "x";
                }
            };
            this.fillConditional(instance, this.getColumn(this.cols, "AA"), fstrZugRangier, (Functions.Function1)_function_44, (Functions.Function1)_function_45);
            Functions.Function1<Fstr_Zug_Rangier, List<String>> _function_46 = new Functions.Function1<Fstr_Zug_Rangier, List<String>>(){

                public List<String> apply(Fstr_Zug_Rangier it) {
                    List _xblockexpression = null;
                    Functions.Function1<Fstr_Signalisierung, Boolean> _function = new Functions.Function1<Fstr_Signalisierung, Boolean>(){

                        public Boolean apply(Fstr_Signalisierung it_1) {
                            return FstrSignalisierungExtensions.getSignalSignalbegriff((Fstr_Signalisierung)it_1) != null && SignalbegriffExtensions.hasSignalbegriffID((Signal_Signalbegriff)FstrSignalisierungExtensions.getSignalSignalbegriff((Fstr_Signalisierung)it_1), Zs3.class) && !Objects.equal((Object)SignalRahmenExtensions.getSignal((Signal_Rahmen)SignalbegriffExtensions.signalRahmen((Signal_Signalbegriff)FstrSignalisierungExtensions.getSignalSignalbegriff((Fstr_Signalisierung)it_1))).getIdentitaet().getWert(), (Object)FahrwegExtensions.getStart((Fstr_Fahrweg)FstrZugRangierExtensions.getFstrFahrweg((Fstr_Zug_Rangier)fstrZugRangier)).getIdentitaet().getWert());
                        }
                    };
                    Functions.Function1<Fstr_Signalisierung, String> _function_1 = new Functions.Function1<Fstr_Signalisierung, String>(){

                        public String apply(Fstr_Signalisierung it_1) {
                            Signal_Signalbegriff _signalSignalbegriff = FstrSignalisierungExtensions.getSignalSignalbegriff((Fstr_Signalisierung)it_1);
                            Signalbegriff_ID_TypeClass _signalbegriffID = null;
                            if (_signalSignalbegriff != null) {
                                _signalbegriffID = _signalSignalbegriff.getSignalbegriffID();
                            }
                            String _symbol = null;
                            if (_signalbegriffID != null) {
                                _symbol = _signalbegriffID.getSymbol();
                            }
                            return _symbol;
                        }
                    };
                    List zs3NichtStart = IterableExtensions.sortBy((Iterable)IterableExtensions.filter((Iterable)FstrZugRangierExtensions.fstrSignalisierung((Fstr_Zug_Rangier)fstrZugRangier), (Functions.Function1)_function), (Functions.Function1)_function_1);
                    Functions.Function1<Fstr_Signalisierung, String> _function_2 = new Functions.Function1<Fstr_Signalisierung, String>(){

                        public String apply(Fstr_Signalisierung it_1) {
                            StringConcatenation _builder = new StringConcatenation();
                            Signal_Signalbegriff _signalSignalbegriff = FstrSignalisierungExtensions.getSignalSignalbegriff((Fstr_Signalisierung)it_1);
                            Signal_Rahmen _signalRahmen = null;
                            if (_signalSignalbegriff != null) {
                                _signalRahmen = SignalbegriffExtensions.signalRahmen((Signal_Signalbegriff)_signalSignalbegriff);
                            }
                            Signal _signal = null;
                            if (_signalRahmen != null) {
                                _signal = SignalRahmenExtensions.getSignal((Signal_Rahmen)_signalRahmen);
                            }
                            Bezeichnung_Element_AttributeGroup _bezeichnung = null;
                            if (_signal != null) {
                                _bezeichnung = _signal.getBezeichnung();
                            }
                            Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
                            if (_bezeichnung != null) {
                                _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
                            }
                            String _wert = null;
                            if (_bezeichnungTabelle != null) {
                                _wert = _bezeichnungTabelle.getWert();
                            }
                            _builder.append(_wert);
                            _builder.append("(");
                            Signal_Signalbegriff _signalSignalbegriff_1 = FstrSignalisierungExtensions.getSignalSignalbegriff((Fstr_Signalisierung)it_1);
                            Signalbegriff_ID_TypeClass _signalbegriffID = null;
                            if (_signalSignalbegriff_1 != null) {
                                _signalbegriffID = _signalSignalbegriff_1.getSignalbegriffID();
                            }
                            String _symbol = null;
                            if (_signalbegriffID != null) {
                                _symbol = _signalbegriffID.getSymbol();
                            }
                            _builder.append(_symbol);
                            return _builder.toString();
                        }
                    };
                    _xblockexpression = ListExtensions.map((List)zs3NichtStart, (Functions.Function1)_function_2);
                    return _xblockexpression;
                }
            };
            Functions.Function1<String, String> _function_47 = new Functions.Function1<String, String>(){

                public String apply(String it) {
                    return it;
                }
            };
            this.fillIterable(instance, this.getColumn(this.cols, "AB"), fstrZugRangier, (Functions.Function1)_function_46, null, (Functions.Function1)_function_47, AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR);
            boolean _isDebugEnabled_1 = logger.isDebugEnabled();
            if (_isDebugEnabled_1) {
                try {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("signalbegriffeImFahrweg=");
                    String _debugString = Debug.debugString((Object)FahrwegExtensions.getSignalbegriffeImFahrweg((Fstr_Fahrweg)FstrZugRangierExtensions.getFstrFahrweg((Fstr_Zug_Rangier)fstrZugRangier)));
                    _builder_1.append(_debugString);
                    logger.debug(_builder_1.toString());
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("fstrSignalisierung=");
                    String _debugString_1 = Debug.debugString((Object)FstrZugRangierExtensions.fstrSignalisierung((Fstr_Zug_Rangier)fstrZugRangier));
                    _builder_2.append(_debugString_1);
                    logger.debug(_builder_2.toString());
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        Exception e = (Exception)_t;
                        logger.error(e.getMessage());
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            Functions.Function1<Fstr_Zug_Rangier, String> _function_48 = new Functions.Function1<Fstr_Zug_Rangier, String>(){

                public String apply(Fstr_Zug_Rangier it) {
                    Functions.Function1<Signal_Signalbegriff, Boolean> _function = new Functions.Function1<Signal_Signalbegriff, Boolean>(){

                        public Boolean apply(final Signal_Signalbegriff b1) {
                            return SignalbegriffExtensions.hasSignalbegriffID((Signal_Signalbegriff)b1, Zs6.class) && IterableExtensions.exists((Iterable)FstrZugRangierExtensions.fstrSignalisierung((Fstr_Zug_Rangier)fstrZugRangier), (Functions.Function1)new Functions.Function1<Fstr_Signalisierung, Boolean>(){

                                public Boolean apply(Fstr_Signalisierung b2) {
                                    Signal_Signalbegriff _signalSignalbegriff = FstrSignalisierungExtensions.getSignalSignalbegriff((Fstr_Signalisierung)b2);
                                    return _signalSignalbegriff == b1;
                                }
                            });
                        }
                    };
                    Signal_Signalbegriff _findFirst = (Signal_Signalbegriff)IterableExtensions.findFirst((Iterable)FahrwegExtensions.getSignalbegriffeImFahrweg((Fstr_Fahrweg)FstrZugRangierExtensions.getFstrFahrweg((Fstr_Zug_Rangier)it)), (Functions.Function1)_function);
                    Signal_Rahmen _signalRahmen = null;
                    if (_findFirst != null) {
                        _signalRahmen = SignalbegriffExtensions.signalRahmen((Signal_Signalbegriff)_findFirst);
                    }
                    Signal _signal = null;
                    if (_signalRahmen != null) {
                        _signal = SignalRahmenExtensions.getSignal((Signal_Rahmen)_signalRahmen);
                    }
                    Bezeichnung_Element_AttributeGroup _bezeichnung = null;
                    if (_signal != null) {
                        _bezeichnung = _signal.getBezeichnung();
                    }
                    Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
                    if (_bezeichnung != null) {
                        _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
                    }
                    String _wert = null;
                    if (_bezeichnungTabelle != null) {
                        _wert = _bezeichnungTabelle.getWert();
                    }
                    return _wert;
                }
            };
            this.fill(instance, this.getColumn(this.cols, "AC"), fstrZugRangier, (Functions.Function1)_function_48);
            Functions.Function1<Fstr_Zug_Rangier, Iterable<String>> _function_49 = new Functions.Function1<Fstr_Zug_Rangier, Iterable<String>>(){

                public Iterable<String> apply(Fstr_Zug_Rangier it) {
                    Functions.Function1<Fstr_Signalisierung, Signal_Signalbegriff> _function = new Functions.Function1<Fstr_Signalisierung, Signal_Signalbegriff>(){

                        public Signal_Signalbegriff apply(Fstr_Signalisierung it_1) {
                            return FstrSignalisierungExtensions.getSignalSignalbegriff((Fstr_Signalisierung)it_1);
                        }
                    };
                    Functions.Function1<Signal_Signalbegriff, Boolean> _function_1 = new Functions.Function1<Signal_Signalbegriff, Boolean>(){

                        public Boolean apply(Signal_Signalbegriff it_1) {
                            return SignalbegriffExtensions.hasSignalbegriffID((Signal_Signalbegriff)it_1, Kl.class);
                        }
                    };
                    Functions.Function1<Signal_Signalbegriff, String> _function_2 = new Functions.Function1<Signal_Signalbegriff, String>(){

                        public String apply(Signal_Signalbegriff it_1) {
                            Signal _signal = SignalRahmenExtensions.getSignal((Signal_Rahmen)SignalbegriffExtensions.signalRahmen((Signal_Signalbegriff)it_1));
                            Bezeichnung_Element_AttributeGroup _bezeichnung = null;
                            if (_signal != null) {
                                _bezeichnung = _signal.getBezeichnung();
                            }
                            Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
                            if (_bezeichnung != null) {
                                _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
                            }
                            String _wert = null;
                            if (_bezeichnungTabelle != null) {
                                _wert = _bezeichnungTabelle.getWert();
                            }
                            return _wert;
                        }
                    };
                    return IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)ListExtensions.map((List)FstrZugRangierExtensions.fstrSignalisierung((Fstr_Zug_Rangier)it), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
                }
            };
            this.fillIterable(instance, this.getColumn(this.cols, "AD"), fstrZugRangier, (Functions.Function1)_function_49, AbstractPlanPro2TableModelTransformator.MIXED_STRING_COMPARATOR);
            Functions.Function1<Fstr_Zug_Rangier, Iterable<String>> _function_50 = new Functions.Function1<Fstr_Zug_Rangier, Iterable<String>>(){

                public Iterable<String> apply(Fstr_Zug_Rangier it) {
                    Functions.Function1<Signal, String> _function = new Functions.Function1<Signal, String>(){

                        public String apply(Signal it_1) {
                            Bezeichnung_Element_AttributeGroup _bezeichnung = it_1.getBezeichnung();
                            Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
                            if (_bezeichnung != null) {
                                _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
                            }
                            String _wert = null;
                            if (_bezeichnungTabelle != null) {
                                _wert = _bezeichnungTabelle.getWert();
                            }
                            return _wert;
                        }
                    };
                    return ListExtensions.map((List)FstrZugRangierExtensions.getVorsignalisierung((Fstr_Zug_Rangier)it), (Functions.Function1)_function);
                }
            };
            this.fillIterable(instance, this.getColumn(this.cols, "AE"), fstrZugRangier, (Functions.Function1)_function_50, AbstractPlanPro2TableModelTransformator.MIXED_STRING_COMPARATOR);
            ColumnDescriptor _column_4 = this.getColumn(this.cols, "AF");
            Functions.Function1<Fstr_Zug_Rangier, Boolean> _function_51 = new Functions.Function1<Fstr_Zug_Rangier, Boolean>(){

                public Boolean apply(Fstr_Zug_Rangier it) {
                    Functions.Function1<Fstr_Abhaengigkeit, Bedien_Anzeige_Element_Allg_AttributeGroup> _function = new Functions.Function1<Fstr_Abhaengigkeit, Bedien_Anzeige_Element_Allg_AttributeGroup>(){

                        public Bedien_Anzeige_Element_Allg_AttributeGroup apply(Fstr_Abhaengigkeit it_1) {
                            Bedien_Anzeige_Element _iDBedienAnzeigeElement = it_1.getIDBedienAnzeigeElement();
                            Bedien_Anzeige_Element_Allg_AttributeGroup _bedienAnzeigeElementAllg = null;
                            if (_iDBedienAnzeigeElement != null) {
                                _bedienAnzeigeElementAllg = _iDBedienAnzeigeElement.getBedienAnzeigeElementAllg();
                            }
                            return _bedienAnzeigeElementAllg;
                        }
                    };
                    Functions.Function1<Bedien_Anzeige_Element_Allg_AttributeGroup, Boolean> _function_1 = new Functions.Function1<Bedien_Anzeige_Element_Allg_AttributeGroup, Boolean>(){

                        public Boolean apply(Bedien_Anzeige_Element_Allg_AttributeGroup it_1) {
                            boolean _tripleNotEquals;
                            boolean _or = false;
                            Taste_TypeClass _taste = null;
                            if (it_1 != null) {
                                _taste = it_1.getTaste();
                            }
                            boolean bl = _tripleNotEquals = _taste != null;
                            if (_tripleNotEquals) {
                                _or = true;
                            } else {
                                boolean _tripleNotEquals_1;
                                Schalter_TypeClass _schalter = null;
                                if (it_1 != null) {
                                    _schalter = it_1.getSchalter();
                                }
                                _or = _tripleNotEquals_1 = _schalter != null;
                            }
                            return _or;
                        }
                    };
                    Bedien_Anzeige_Element_Allg_AttributeGroup _findFirst = (Bedien_Anzeige_Element_Allg_AttributeGroup)IterableExtensions.findFirst((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)BasisAttributExtensions.getContainer((EObject)fstrZugRangier).getContents(), Fstr_Abhaengigkeit.class), (Functions.Function1)_function), (Functions.Function1)_function_1);
                    return _findFirst != null;
                }
            };
            Functions.Function1<Fstr_Zug_Rangier, String> _function_52 = new Functions.Function1<Fstr_Zug_Rangier, String>(){

                public String apply(Fstr_Zug_Rangier it) {
                    List<Bedien_Anzeige_Element> _emptyList;
                    String _xblockexpression = null;
                    List<Bedien_Anzeige_Element> _elvis = null;
                    Fstr_Fahrweg _fstrFahrweg = FstrZugRangierExtensions.getFstrFahrweg((Fstr_Zug_Rangier)it);
                    List _abhaengigkeiten = null;
                    if (_fstrFahrweg != null) {
                        _abhaengigkeiten = FahrwegExtensions.getAbhaengigkeiten((Fstr_Fahrweg)_fstrFahrweg);
                    }
                    List _map = null;
                    if (_abhaengigkeiten != null) {
                        Functions.Function1<Fstr_Abhaengigkeit, Bedien_Anzeige_Element> _function = new Functions.Function1<Fstr_Abhaengigkeit, Bedien_Anzeige_Element>(){

                            public Bedien_Anzeige_Element apply(Fstr_Abhaengigkeit it_1) {
                                return FstrAbhaengigkeitExtensions.getBedienAnzeigeElement((Fstr_Abhaengigkeit)it_1);
                            }
                        };
                        _map = ListExtensions.map((List)_abhaengigkeiten, (Functions.Function1)_function);
                    }
                    List<Bedien_Anzeige_Element> _filterNull = null;
                    if (_map != null) {
                        _filterNull = IterableExtensions.filterNull(_map);
                    }
                    _elvis = _filterNull != null ? _filterNull : (_emptyList = Collections.emptyList());
                    List<Bedien_Anzeige_Element> bedAnzeigeElemente = _elvis;
                    String footnotes = SslzTransformator.this.footnoteTransformation.transform((Basis_Objekt)it, instance);
                    StringConcatenation _builder = new StringConcatenation();
                    for (Bedien_Anzeige_Element bae : bedAnzeigeElemente) {
                        Functions.Function1<Enumerator, String> _function_1 = new Functions.Function1<Enumerator, String>(){

                            public String apply(Enumerator it_1) {
                                return SslzTransformator.this.translate(it_1);
                            }
                        };
                        String _comment = BedienAnzeigeElementExtensions.comment((Bedien_Anzeige_Element)bae, (Functions.Function1)_function_1);
                        _builder.append(_comment);
                        _builder.append((Object)bae);
                        _builder.append(" ");
                    }
                    _builder.append(" ");
                    _builder.append(footnotes);
                    _xblockexpression = _builder.toString().trim();
                    return _xblockexpression;
                }
            };
            Case _case_7 = new Case((Functions.Function1)_function_51, (Functions.Function1)_function_52);
            Functions.Function1<Fstr_Zug_Rangier, Boolean> _function_53 = new Functions.Function1<Fstr_Zug_Rangier, Boolean>(){

                public Boolean apply(Fstr_Zug_Rangier it) {
                    boolean _isEmpty = it.getIDFstrAusschlussBesonders().isEmpty();
                    return !_isEmpty;
                }
            };
            Functions.Function1<Fstr_Zug_Rangier, String> _function_54 = new Functions.Function1<Fstr_Zug_Rangier, String>(){

                public String apply(Fstr_Zug_Rangier it) {
                    String _xblockexpression = null;
                    Functions.Function1<Fstr_Zug_Rangier, String> _function = new Functions.Function1<Fstr_Zug_Rangier, String>(){

                        public String apply(Fstr_Zug_Rangier it_1) {
                            Functions.Function1<Fstr_Zug_Art_TypeClass, Boolean> _function = new Functions.Function1<Fstr_Zug_Art_TypeClass, Boolean>(){

                                public Boolean apply(Fstr_Zug_Art_TypeClass art) {
                                    return FstrZugRangierExtensions.isZ((Fstr_Zug_Art_TypeClass)art);
                                }
                            };
                            return FstrZugRangierExtensions.getZugFstrBezeichnung((Fstr_Zug_Rangier)it_1, (Functions.Function1)_function);
                        }
                    };
                    List fstrAusschlussBesonders = ListExtensions.map((List)it.getIDFstrAusschlussBesonders(), (Functions.Function1)_function);
                    String footnotes = SslzTransformator.this.footnoteTransformation.transform((Basis_Objekt)it, instance);
                    StringConcatenation _builder = new StringConcatenation();
                    for (String fstr : fstrAusschlussBesonders) {
                        _builder.append(fstr);
                        _builder.append(" ");
                    }
                    _builder.append(" ");
                    _builder.append(footnotes);
                    _xblockexpression = _builder.toString().trim();
                    return _xblockexpression;
                }
            };
            Case _case_8 = new Case((Functions.Function1)_function_53, (Functions.Function1)_function_54);
            this.fillSwitch(instance, _column_4, fstrZugRangier, new Case[]{_case_7, _case_8});
            boolean _isDebugEnabled_2 = logger.isDebugEnabled();
            if (!_isDebugEnabled_2) continue;
            logger.debug(Utils.debugString((Object)instance));
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("rowGroups=");
            int _size = factory.getTable().getTablecontent().getRowgroups().size();
            _builder_1.append((Object)_size);
            logger.debug(_builder_1.toString());
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("rows=");
            Functions.Function2<Integer, RowGroup, Integer> _function_55 = new Functions.Function2<Integer, RowGroup, Integer>(){

                public Integer apply(Integer sum, RowGroup rg) {
                    int _size = rg.getRows().size();
                    return sum + _size;
                }
            };
            Integer _fold = (Integer)IterableExtensions.fold((Iterable)factory.getTable().getTablecontent().getRowgroups(), (Object)0, (Functions.Function2)_function_55);
            _builder_2.append((Object)_fold);
            logger.debug(_builder_2.toString());
        }
        return factory.getTable();
    }

    private static String totalTime(Duration duration, int current, int total) {
        long estimated = duration.dividedBy(current).multipliedBy(total).toSeconds();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)(estimated / 3600L));
        _builder.append("h ");
        _builder.append((Object)(estimated % 3600L / 60L));
        _builder.append("m ");
        _builder.append((Object)(estimated % 60L));
        _builder.append("s");
        return _builder.toString();
    }

    public List<String> fillInselgleis(Collection<Gleis_Bezeichnung> tracks) {
        Functions.Function1<Gleis_Bezeichnung, String> _function = new Functions.Function1<Gleis_Bezeichnung, String>(){

            public String apply(Gleis_Bezeichnung it) {
                return it.getBezeichnung().getBezGleisBezeichnung().getWert();
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.toSet((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map(tracks, (Functions.Function1)_function))));
    }

    private String fahrwegStart(Fstr_Zug_Rangier fstrZugRangier) {
        Fstr_Fahrweg _fstrFahrweg = null;
        if (fstrZugRangier != null) {
            _fstrFahrweg = FstrZugRangierExtensions.getFstrFahrweg((Fstr_Zug_Rangier)fstrZugRangier);
        }
        Signal _start = null;
        if (_fstrFahrweg != null) {
            _start = FahrwegExtensions.getStart((Fstr_Fahrweg)_fstrFahrweg);
        }
        Bezeichnung_Element_AttributeGroup _bezeichnung = null;
        if (_start != null) {
            _bezeichnung = _start.getBezeichnung();
        }
        Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
        if (_bezeichnung != null) {
            _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
        }
        String _wert = null;
        if (_bezeichnungTabelle != null) {
            _wert = _bezeichnungTabelle.getWert();
        }
        return _wert;
    }

    private String fahrwegZiel(Fstr_Zug_Rangier fstrZugRangier) {
        Fstr_Fahrweg _fstrFahrweg = null;
        if (fstrZugRangier != null) {
            _fstrFahrweg = FstrZugRangierExtensions.getFstrFahrweg((Fstr_Zug_Rangier)fstrZugRangier);
        }
        Signal _zielSignal = null;
        if (_fstrFahrweg != null) {
            _zielSignal = FahrwegExtensions.getZielSignal((Fstr_Fahrweg)_fstrFahrweg);
        }
        Bezeichnung_Element_AttributeGroup _bezeichnung = null;
        if (_zielSignal != null) {
            _bezeichnung = _zielSignal.getBezeichnung();
        }
        Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
        if (_bezeichnung != null) {
            _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
        }
        String _wert = null;
        if (_bezeichnungTabelle != null) {
            _wert = _bezeichnungTabelle.getWert();
        }
        return _wert;
    }

    private String fahrwegZielBlock(Fstr_Zug_Rangier fstrZugRangier) {
        Fstr_Fahrweg _iDFstrFahrweg = null;
        if (fstrZugRangier != null) {
            _iDFstrFahrweg = fstrZugRangier.getIDFstrFahrweg();
        }
        Basis_Objekt _iDZiel = null;
        if (_iDFstrFahrweg != null) {
            _iDZiel = _iDFstrFahrweg.getIDZiel();
        }
        final Signal ziel = (Signal)_iDZiel;
        Functions.Function1<Fstr_Fahrweg, Boolean> _function = new Functions.Function1<Fstr_Fahrweg, Boolean>(){

            public Boolean apply(Fstr_Fahrweg it) {
                Signal _iDStart = it.getIDStart();
                return Objects.equal((Object)ziel, (Object)_iDStart);
            }
        };
        final Iterable startFahrweg = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)BasisAttributExtensions.getContainer((EObject)ziel).getContents(), Fstr_Fahrweg.class), (Functions.Function1)_function);
        Functions.Function1<Fstr_Zug_Rangier, Boolean> _function_1 = new Functions.Function1<Fstr_Zug_Rangier, Boolean>(){

            public Boolean apply(Fstr_Zug_Rangier it) {
                boolean _contains;
                boolean _and = false;
                Fstr_Zug_AttributeGroup _fstrZug = it.getFstrZug();
                Fstr_Zug_Art_TypeClass _fstrZugArt = null;
                if (_fstrZug != null) {
                    _fstrZugArt = _fstrZug.getFstrZugArt();
                }
                ENUMFstrZugArt _wert = null;
                if (_fstrZugArt != null) {
                    _wert = _fstrZugArt.getWert();
                }
                boolean _tripleEquals = _wert == ENUMFstrZugArt.ENUM_FSTR_ZUG_ART_B;
                _and = !_tripleEquals ? false : (_contains = IterableExtensions.contains((Iterable)startFahrweg, (Object)it.getIDFstrFahrweg()));
                return _and;
            }
        };
        Functions.Function1<Fstr_Zug_Rangier, String> _function_2 = new Functions.Function1<Fstr_Zug_Rangier, String>(){

            public String apply(Fstr_Zug_Rangier it) {
                Fstr_Fahrweg _iDFstrFahrweg = it.getIDFstrFahrweg();
                Basis_Objekt _iDZiel = null;
                if (_iDFstrFahrweg != null) {
                    _iDZiel = _iDFstrFahrweg.getIDZiel();
                }
                Bezeichnung_Element_AttributeGroup _bezeichnung = null;
                if ((Signal)_iDZiel != null) {
                    _bezeichnung = ((Signal)_iDZiel).getBezeichnung();
                }
                Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
                if (_bezeichnung != null) {
                    _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
                }
                String _wert = null;
                if (_bezeichnungTabelle != null) {
                    _wert = _bezeichnungTabelle.getWert();
                }
                return _wert;
            }
        };
        String start = IterableExtensions.join((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)BasisAttributExtensions.getContainer((EObject)ziel).getContents(), Fstr_Zug_Rangier.class), (Functions.Function1)_function_1), (Functions.Function1)_function_2)), (CharSequence)" ");
        StringConcatenation _builder = new StringConcatenation();
        Bezeichnung_Element_AttributeGroup _bezeichnung = null;
        if (ziel != null) {
            _bezeichnung = ziel.getBezeichnung();
        }
        Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
        if (_bezeichnung != null) {
            _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
        }
        String _wert = null;
        if (_bezeichnungTabelle != null) {
            _wert = _bezeichnungTabelle.getWert();
        }
        _builder.append(_wert);
        _builder.append(" [");
        _builder.append(start);
        _builder.append("]");
        return _builder.toString();
    }

    private String fahrwegNummer(Fstr_Zug_Rangier fstrZugRangier) {
        int _intValue;
        boolean _greaterThan;
        Fstr_Zug_Rangier_Allg_AttributeGroup _fstrZugRangierAllg = null;
        if (fstrZugRangier != null) {
            _fstrZugRangierAllg = fstrZugRangier.getFstrZugRangierAllg();
        }
        Fstr_Reihenfolge_TypeClass _fstrReihenfolge = null;
        if (_fstrZugRangierAllg != null) {
            _fstrReihenfolge = _fstrZugRangierAllg.getFstrReihenfolge();
        }
        BigInteger _wert = null;
        if (_fstrReihenfolge != null) {
            _wert = _fstrReihenfolge.getWert();
        }
        boolean bl = _greaterThan = (_intValue = _wert.intValue()) > 1;
        if (_greaterThan) {
            Fstr_Zug_Rangier_Allg_AttributeGroup _fstrZugRangierAllg_1 = null;
            if (fstrZugRangier != null) {
                _fstrZugRangierAllg_1 = fstrZugRangier.getFstrZugRangierAllg();
            }
            Fstr_Reihenfolge_TypeClass _fstrReihenfolge_1 = null;
            if (_fstrZugRangierAllg_1 != null) {
                _fstrReihenfolge_1 = _fstrZugRangierAllg_1.getFstrReihenfolge();
            }
            BigInteger _wert_1 = null;
            if (_fstrReihenfolge_1 != null) {
                _wert_1 = _fstrReihenfolge_1.getWert();
            }
            return _wert_1.subtract(BigInteger.ONE).toString();
        }
        return EMPTY_FILLING;
    }

    private Fstr_Zug_Rangier getZielFstrZugRangier(Fstr_Zug_Rangier it) {
        final Basis_Objekt zielSignal = it.getIDFstrFahrweg().getIDZiel();
        Functions.Function1<Fstr_Zug_Rangier, Boolean> _function = new Functions.Function1<Fstr_Zug_Rangier, Boolean>(){

            public Boolean apply(Fstr_Zug_Rangier it_1) {
                boolean _equals;
                boolean _and = false;
                Fstr_Fahrweg _iDFstrFahrweg = it_1.getIDFstrFahrweg();
                Signal _iDStart = null;
                if (_iDFstrFahrweg != null) {
                    _iDStart = _iDFstrFahrweg.getIDStart();
                }
                if (!(_equals = Objects.equal((Object)_iDStart, (Object)zielSignal))) {
                    _and = false;
                } else {
                    boolean _tripleEquals;
                    Fstr_Zug_AttributeGroup _fstrZug = it_1.getFstrZug();
                    Fstr_Zug_Art_TypeClass _fstrZugArt = null;
                    if (_fstrZug != null) {
                        _fstrZugArt = _fstrZug.getFstrZugArt();
                    }
                    ENUMFstrZugArt _wert = null;
                    if (_fstrZugArt != null) {
                        _wert = _fstrZugArt.getWert();
                    }
                    _and = _tripleEquals = _wert == ENUMFstrZugArt.ENUM_FSTR_ZUG_ART_B;
                }
                return _and;
            }
        };
        return (Fstr_Zug_Rangier)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)BasisAttributExtensions.getContainer((EObject)zielSignal).getContents(), Fstr_Zug_Rangier.class), (Functions.Function1)_function);
    }
}

