/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.emfforms.text;

import javax.inject.Inject;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.renderer.TextControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.set.basis.emfforms.RendererContext;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.viewmodel.ToolboxViewModelService;
import org.eclipse.set.emfforms.utils.RendererContextImpl;
import org.eclipse.set.utils.ButtonAction;
import org.eclipse.set.utils.emfforms.Annotations;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TextWithButtonControlSWTRenderer
extends TextControlSWTRenderer {
    final ButtonAction buttonAction;

    @Inject
    public TextWithButtonControlSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, EMFFormsEditSupport emfFormsEditSupport) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, emfFormsEditSupport);
        ToolboxViewModelService toolboxViewModelService = Services.getToolboxViewModelService();
        String buttonActionKey = Annotations.getViewModelValue((VElement)vElement, (String)"buttonActionKey");
        if (buttonActionKey == null) {
            throw new IllegalArgumentException("No buttonActionKey for " + vElement.getName());
        }
        this.buttonAction = (ButtonAction)toolboxViewModelService.get(buttonActionKey);
        if (this.buttonAction == null) {
            throw new IllegalArgumentException("No button action for key \"" + buttonActionKey + "\" found.");
        }
    }

    protected Control createSWTControl(Composite parent) {
        Composite filenameControl = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(filenameControl);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)filenameControl);
        Control textBox = super.createSWTControl(filenameControl);
        String buttonText = this.buttonAction.getText();
        int buttonWidth = this.buttonAction.getWidth();
        Button button = new Button(filenameControl, 8);
        button.setText(buttonText);
        GridDataFactory.swtDefaults().minSize(buttonWidth, 0).hint(buttonWidth, -1).applyTo((Control)button);
        RendererContextImpl rendererContext = new RendererContextImpl();
        rendererContext.put(Button.class, button);
        rendererContext.put(VElement.class, this.getVElement());
        this.buttonAction.register((RendererContext)rendererContext);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TextWithButtonControlSWTRenderer.this.buttonAction.selected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TextWithButtonControlSWTRenderer.this.buttonAction.selected(e);
            }
        });
        return textBox;
    }

    protected void setControlEnabled(SWTGridCell gridCell, Control control, boolean enabled) {
        super.setControlEnabled(gridCell, control, enabled && !((VControl)this.getVElement()).isReadonly());
    }
}

