/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.handler;

import java.nio.file.Path;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.set.application.Messages;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.constants.ValidationResult;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.set.utils.handler.AbstractOpenHandler;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenPlanProHandler
extends AbstractOpenHandler {
    static final Logger logger = LoggerFactory.getLogger(OpenPlanProHandler.class);
    @Inject
    @Translation
    private org.eclipse.set.utils.Messages utilMessages;
    @Inject
    IEventBroker eventBroker;
    @Inject
    @Translation
    Messages messages;
    @Inject
    EPartService partService;

    protected Path chooseFile(Shell shell) {
        return this.getDialogService().openFileDialog(shell, this.getDialogService().getPlanProFileFilters()).orElse(null);
    }

    protected IModelSession createSession(Path path) {
        IModelSession session = this.sessionService.loadModelSession(path);
        session.init();
        return session;
    }

    protected String getErrorCauseMessage() {
        return this.messages.Common_InfoErrorCause;
    }

    protected String getErrorMessage() {
        return this.messages.OpenPlanProHandler_LoadingPlanProModelFileErrorMessage;
    }

    protected String getErrorTitleMessage() {
        return this.messages.OpenPlanProHandler_LoadingPlanProModelFileErrorTitle;
    }

    protected String getTaskMessage() {
        return this.messages.OpenPlanProHandler_LoadingPlanProModelFile;
    }

    protected IModelSession validation(IModelSession modelSession, Shell shell, Path path) {
        if (modelSession == null) {
            return null;
        }
        ValidationResult.Outcome validationOutcome = modelSession.getValidationsOutcome(ValidationResult::getOutcome);
        if (validationOutcome == ValidationResult.Outcome.VALID || validationOutcome == ValidationResult.Outcome.NOT_SUPPORTED) {
            return modelSession;
        }
        ValidationResult.Outcome xsdOutcome = modelSession.getValidationsOutcome(ValidationResult::getXsdOutcome);
        ValidationResult.Outcome emfOutcome = modelSession.getValidationsOutcome(ValidationResult::getEmfOutcome);
        if (!(xsdOutcome != ValidationResult.Outcome.VALID && xsdOutcome != ValidationResult.Outcome.NOT_SUPPORTED || emfOutcome != ValidationResult.Outcome.VALID && emfOutcome != ValidationResult.Outcome.NOT_SUPPORTED)) {
            if (ToolboxConfiguration.isDevelopmentMode()) {
                logger.info("user dialog for loading of invalid file skipped due to development mode being enabled");
                return modelSession;
            }
            if (!this.getDialogService().loadIncompleteModel(shell, path.toString())) {
                modelSession.close();
                return null;
            }
            return modelSession;
        }
        if (!this.getDialogService().loadInvalidModel(shell, path.toString())) {
            modelSession.close();
            return null;
        }
        return modelSession;
    }
}

