/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.parts;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.core.services.statusreporter.StatusReporter;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.set.application.Messages;
import org.eclipse.set.basis.ActionProvider;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.extensions.IModelSessionExtensions;
import org.eclipse.set.basis.extensions.PartDescriptionExtensions;
import org.eclipse.set.basis.part.PartDescription;
import org.eclipse.set.basis.viewgroups.ToolboxViewGroup;
import org.eclipse.set.core.services.action.ActionService;
import org.eclipse.set.core.services.branding.BrandingService;
import org.eclipse.set.core.services.part.ToolboxPartService;
import org.eclipse.set.core.services.session.SessionService;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.set.utils.events.DefaultToolboxEventHandler;
import org.eclipse.set.utils.events.EditingCompleted;
import org.eclipse.set.utils.events.NewActiveViewEvent;
import org.eclipse.set.utils.events.SessionDirtyChanged;
import org.eclipse.set.utils.events.ToolboxEventHandler;
import org.eclipse.set.utils.events.ToolboxEvents;
import org.eclipse.set.utils.widgets.HighlightButton;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentActionsPart
implements ActionProvider {
    private static final Logger logger = LoggerFactory.getLogger(DocumentActionsPart.class);
    private static final Comparator<? super PartDescription> PART_DESCRIPTION_COMPARATOR = Comparator.comparing(PartDescription::getOrderPriority).reversed().thenComparing(PartDescription::getToolboxViewName);
    @Inject
    private ActionService actionService;
    @Inject
    private BrandingService brandingService;
    @Inject
    private IEventBroker broker;
    private LocalResourceManager localResourceManager;
    @Inject
    @Translation
    private Messages messages;
    @Inject
    MApplication application;
    ExpandBar bar;
    @Inject
    EHandlerService handlerService;
    final Map<String, HighlightButton> idToButton = new HashMap<String, HighlightButton>();
    int index = 0;
    @Inject
    SessionService sessionService;
    @Inject
    StatusReporter statusReporter;
    @Inject
    ToolboxPartService toolboxPartService;
    final List<ViewButton> viewButtons = Lists.newLinkedList();

    private static void highlightButton(Map.Entry<String, HighlightButton> entry, Set<String> openIds) {
        String id = entry.getKey();
        HighlightButton button = entry.getValue();
        button.setHighlight(openIds.contains(id));
    }

    @PostConstruct
    public void postConstruct(Composite parent, Display display, Shell shell) {
        logger.debug(this.statusReporter.toString());
        this.localResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        GridLayout partLayout = new GridLayout();
        partLayout.marginWidth = 0;
        partLayout.marginHeight = 0;
        parent.setLayout((Layout)partLayout);
        logger.info(this.messages.DocumentActionsPart_StartupMessage);
        this.bar = new ExpandBar(parent, 512);
        this.bar.setLayoutData((Object)new GridData(4, 4, true, true));
        this.bar.setSpacing(8);
        ScrollBar vScrollBar = this.bar.getVerticalBar();
        if (vScrollBar != null) {
            vScrollBar.setIncrement(15);
            vScrollBar.setPageIncrement(15);
        } else {
            logger.warn("Could not set scrolling increment");
        }
        Composite logoZone = new Composite(parent, 0);
        logoZone.setLayoutData((Object)new GridData(0x1000000, 0x1000008, false, false));
        logoZone.setLayout((Layout)new GridLayout());
        Label logoLabel = new Label(logoZone, 0);
        logoLabel.setLayoutData((Object)new GridData(2, 2, true, false));
        this.brandingService.getActionLogo().ifPresent(descriptor -> {
            Image actionLogo = this.localResourceManager.createImage(descriptor);
            logoLabel.setText("LOGO");
            logoLabel.setImage(actionLogo);
        });
        this.application.getContext().runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                if (!DocumentActionsPart.this.toolboxPartService.isActionAreaVisible()) {
                    return true;
                }
                IModelSession modelSession = (IModelSession)context.get(IModelSession.class);
                if (modelSession != null) {
                    DocumentActionsPart.this.createExpandItems();
                    DocumentActionsPart.this.checkEnableViewButtons(modelSession);
                    DocumentActionsPart.this.bar.setEnabled(true);
                } else {
                    Control item;
                    Control[] controlArray = DocumentActionsPart.this.bar.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        item = controlArray[n2];
                        item.dispose();
                        ++n2;
                    }
                    controlArray = DocumentActionsPart.this.bar.getItems();
                    n = controlArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        item = controlArray[n2];
                        item.dispose();
                        ++n2;
                    }
                    DocumentActionsPart.this.index = 0;
                    DocumentActionsPart.this.viewButtons.clear();
                    DocumentActionsPart.this.idToButton.clear();
                    DocumentActionsPart.this.bar.setEnabled(false);
                }
                return true;
            }
        });
        ToolboxEvents.subscribe((IEventBroker)this.broker, NewActiveViewEvent.class, (ToolboxEventHandler)new DefaultToolboxEventHandler<NewActiveViewEvent>(){

            public void accept(NewActiveViewEvent e) {
                DocumentActionsPart.this.highlightButtons();
            }
        });
        ToolboxEvents.subscribe((IEventBroker)this.broker, EditingCompleted.class, (ToolboxEventHandler)new DefaultToolboxEventHandler<EditingCompleted>(){

            public void accept(EditingCompleted e) {
                DocumentActionsPart.this.createExpandItems();
                DocumentActionsPart.this.checkEnableViewButtons((IModelSession)DocumentActionsPart.this.application.getContext().get(IModelSession.class));
            }
        });
        ToolboxEvents.subscribe((IEventBroker)this.broker, SessionDirtyChanged.class, (ToolboxEventHandler)new DefaultToolboxEventHandler<SessionDirtyChanged>(){

            public void accept(SessionDirtyChanged e) {
                DocumentActionsPart.this.createExpandItems();
                DocumentActionsPart.this.checkEnableViewButtons((IModelSession)DocumentActionsPart.this.application.getContext().get(IModelSession.class));
            }
        });
        this.actionService.setActionProvider((ActionProvider)this);
    }

    public void update() {
        IModelSession session = (IModelSession)this.application.getContext().get(IModelSession.class);
        if (session != null) {
            this.highlightButtons();
        }
    }

    private void checkEnabled(ViewButton viewButton, IModelSession modelSession) {
        PartDescription view = viewButton.getView();
        viewButton.getButton().setEnabled(this.testEnable(view, modelSession));
    }

    private void createExpandItem(ToolboxViewGroup group) {
        if (Arrays.stream(this.bar.getItems()).anyMatch(item -> item.getText().equals(group.text()))) {
            return;
        }
        Composite composite = new Composite((Composite)this.bar, 0);
        GridLayout layout = new GridLayout();
        layout.marginBottom = 10;
        layout.marginRight = 10;
        layout.marginTop = 10;
        layout.marginLeft = 10;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.createRegisteredViewsForExpandItem(composite, group);
        if (composite.getChildren().length == 0) {
            composite.dispose();
            return;
        }
        ExpandItem expandItem = new ExpandItem(this.bar, 0, this.index);
        expandItem.setText(group.text());
        expandItem.setHeight(composite.computeSize((int)-1, (int)-1).y);
        expandItem.setControl((Control)composite);
        Image image = this.localResourceManager.createImage(group.imageDescriptor());
        expandItem.setImage(image);
        expandItem.setControl((Control)composite);
        expandItem.setExpanded(group.isInitiallyExpanded());
        ++this.index;
    }

    private void createRegisteredViewsForExpandItem(Composite parent, ToolboxViewGroup group) {
        List registeredDescriptions = this.toolboxPartService.getRegisteredDescriptions(group);
        registeredDescriptions.sort(PART_DESCRIPTION_COMPARATOR);
        Object[] listEnableView = registeredDescriptions.stream().filter(registered -> this.testEnable((PartDescription)registered, (IModelSession)this.application.getContext().get(IModelSession.class))).toArray();
        if (listEnableView.length == 0) {
            return;
        }
        for (PartDescription view : registeredDescriptions) {
            HighlightButton button = new HighlightButton(parent, 16392);
            this.idToButton.put(view.getId(), button);
            button.getButton().setText(view.getToolboxViewName());
            button.getButton().setToolTipText(view.getToolboxViewToolTip());
            GridData layoutData = new GridData(4, 4, true, true);
            button.getButton().setLayoutData((Object)layoutData);
            button.getButton().addListener(13, event -> {
                boolean bl = this.toolboxPartService.showPart(view.getId());
            });
            this.viewButtons.add(new ViewButton(button.getButton(), view));
            if (!logger.isDebugEnabled()) continue;
            logger.debug(PartDescriptionExtensions.debugHtml((PartDescription)view, (String)group.text()));
        }
    }

    private boolean isExclusiveEditorOpen() {
        return this.viewButtons.stream().map(ViewButton::getView).filter(PartDescription::isExclusiveEditor).filter(arg_0 -> ((ToolboxPartService)this.toolboxPartService).isOpen(arg_0)).findAny().isPresent();
    }

    private static boolean showDevelopmentItems() {
        return ToolboxConfiguration.isDevelopmentMode();
    }

    @Inject
    @Optional
    private void subscribeTopicSelectedElement(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*") Event event) {
        this.highlightButtons();
    }

    private boolean testEnable(PartDescription view, IModelSession modelSession) {
        if (modelSession == null) {
            return false;
        }
        boolean enable = true;
        enable = enable && (!view.needsLoadedModel() || IModelSessionExtensions.hasLoadedModel((IModelSession)modelSession));
        enable = enable && (!view.needsXsdValidation() || IModelSessionExtensions.isXsdValid((IModelSession)modelSession));
        enable = enable && (!view.needsEmfValidation() || IModelSessionExtensions.isEmfValid((IModelSession)modelSession));
        enable = enable && (!view.needsCleanSession() || !modelSession.isDirty());
        enable = enable && view.canProcess(modelSession.getNature());
        enable = enable && (!view.isExclusiveEditor() || this.toolboxPartService.isOpen(view) || !this.isExclusiveEditorOpen());
        return enable;
    }

    protected void checkEnableViewButtons(IModelSession modelSession) {
        this.viewButtons.forEach(vb -> this.checkEnabled((ViewButton)vb, modelSession));
    }

    protected void highlightButtons() {
        Set openParts = this.toolboxPartService.getOpenParts().stream().map(MApplicationElement::getElementId).collect(Collectors.toSet());
        this.idToButton.entrySet().stream().forEach(entry -> DocumentActionsPart.highlightButton(entry, openParts));
        this.checkEnableViewButtons((IModelSession)this.application.getContext().get(IModelSession.class));
    }

    void createExpandItems() {
        this.toolboxPartService.getViewGroups().stream().filter(g -> !g.isInvisible()).filter(g -> DocumentActionsPart.showDevelopmentItems() || !g.isDevelopment()).sorted(Comparator.comparingInt(ToolboxViewGroup::orderPriority).reversed()).forEach(this::createExpandItem);
    }

    private static class ViewButton {
        private final Button button;
        private final PartDescription view;

        public ViewButton(Button button, PartDescription view) {
            this.button = button;
            this.view = view;
        }

        public Button getButton() {
            return this.button;
        }

        public PartDescription getView() {
            return this.view;
        }
    }
}

