/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.internal.primitive;

import java.util.Collection;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.iterator.FloatIterator;

public final class FloatIteratorIterate {
    private FloatIteratorIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static void forEach(FloatIterator iterator, FloatProcedure procedure) {
        while (iterator.hasNext()) {
            procedure.value(iterator.next());
        }
    }

    public static <R extends MutableFloatCollection> R select(FloatIterator iterator, FloatPredicate predicate, R targetCollection) {
        while (iterator.hasNext()) {
            float item = iterator.next();
            if (!predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <R extends MutableFloatCollection> R reject(FloatIterator iterator, FloatPredicate predicate, R targetCollection) {
        while (iterator.hasNext()) {
            float item = iterator.next();
            if (predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <V, R extends Collection<V>> R collect(FloatIterator iterator, FloatToObjectFunction<? extends V> function, R targetCollection) {
        while (iterator.hasNext()) {
            float item = iterator.next();
            targetCollection.add(function.valueOf(item));
        }
        return targetCollection;
    }

    public static float detectIfNone(FloatIterator iterator, FloatPredicate predicate, float ifNone) {
        while (iterator.hasNext()) {
            float item = iterator.next();
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    public static int count(FloatIterator iterator, FloatPredicate predicate) {
        int count = 0;
        while (iterator.hasNext()) {
            if (!predicate.accept(iterator.next())) continue;
            ++count;
        }
        return count;
    }

    public static boolean anySatisfy(FloatIterator iterator, FloatPredicate predicate) {
        while (iterator.hasNext()) {
            if (!predicate.accept(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean allSatisfy(FloatIterator iterator, FloatPredicate predicate) {
        while (iterator.hasNext()) {
            if (predicate.accept(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean noneSatisfy(FloatIterator iterator, FloatPredicate predicate) {
        while (iterator.hasNext()) {
            if (!predicate.accept(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> T injectInto(FloatIterator iterator, T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        while (iterator.hasNext()) {
            result = function.valueOf(result, iterator.next());
        }
        return result;
    }

    public static double sum(FloatIterator iterator) {
        double sum = 0.0;
        while (iterator.hasNext()) {
            sum += (double)iterator.next();
        }
        return sum;
    }

    public static float max(FloatIterator iterator) {
        float max = iterator.next();
        while (iterator.hasNext()) {
            float next = iterator.next();
            if (Float.compare(max, next) >= 0) continue;
            max = next;
        }
        return max;
    }

    public static float min(FloatIterator iterator) {
        float min = iterator.next();
        while (iterator.hasNext()) {
            float next = iterator.next();
            if (Float.compare(next, min) >= 0) continue;
            min = next;
        }
        return min;
    }
}

