/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.datum;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.locationtech.proj4j.datum.Grid;
import org.locationtech.proj4j.util.FloatPolarCoordinate;
import org.locationtech.proj4j.util.IntPolarCoordinate;
import org.locationtech.proj4j.util.PolarCoordinate;

public final class CTABLEV2 {
    private static final byte[] magic = "CTABLE V2".getBytes(StandardCharsets.US_ASCII);

    public static boolean testHeader(byte[] header) {
        return CTABLEV2.containsAt(magic, header, 0);
    }

    public static Grid.ConversionTable init(DataInputStream definition) throws IOException {
        int nullPosition;
        byte[] header = new byte[160];
        definition.readFully(header);
        if (!CTABLEV2.containsAt(magic, header, 0)) {
            throw new Error("Not a CTABLE V2 file");
        }
        byte[] id_bytes = Arrays.copyOfRange(header, 16, 96);
        PolarCoordinate ll = new PolarCoordinate(CTABLEV2.doubleFromBytes(header, 96), CTABLEV2.doubleFromBytes(header, 104));
        PolarCoordinate del = new PolarCoordinate(CTABLEV2.doubleFromBytes(header, 112), CTABLEV2.doubleFromBytes(header, 120));
        IntPolarCoordinate lim = new IntPolarCoordinate(CTABLEV2.intFromBytes(header, 128), CTABLEV2.intFromBytes(header, 132));
        if (lim.lam < 1 || lim.lam > 100000 || lim.phi < 1 || lim.phi > 100000) {
            throw new Error("Grid position counts outside of acceptable parameters for CTABLE file " + lim);
        }
        for (nullPosition = 0; nullPosition < id_bytes.length && id_bytes[nullPosition] != 0; ++nullPosition) {
        }
        Grid.ConversionTable table = new Grid.ConversionTable();
        table.id = new String(id_bytes, 0, nullPosition, StandardCharsets.US_ASCII).trim();
        table.ll = ll;
        table.del = del;
        table.lim = lim;
        return table;
    }

    public static void load(DataInputStream definition, Grid grid) throws IOException {
        Grid.ConversionTable table = grid.table;
        int entryCount = table.lim.lam * table.lim.phi;
        FloatPolarCoordinate[] cvs = new FloatPolarCoordinate[entryCount];
        byte[] buff = new byte[8];
        definition.skipBytes(160);
        for (int i = 0; i < entryCount; ++i) {
            definition.readFully(buff);
            cvs[i] = new FloatPolarCoordinate(CTABLEV2.floatFromBytes(buff, 0), CTABLEV2.floatFromBytes(buff, 4));
        }
        table.cvs = cvs;
    }

    private static boolean containsAt(byte[] needle, byte[] haystack, int offset) {
        if (needle == null || haystack == null) {
            return false;
        }
        int maxoffset = Math.min(needle.length - 1, haystack.length - offset - 1);
        for (int i = 0; i < maxoffset; ++i) {
            if (needle[i] == haystack[offset + i]) continue;
            return false;
        }
        return true;
    }

    private static double doubleFromBytes(byte[] b, int offset) {
        return ByteBuffer.wrap(b, offset, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
    }

    private static int intFromBytes(byte[] b, int offset) {
        return ByteBuffer.wrap(b, offset, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    private static float floatFromBytes(byte[] b, int offset) {
        return ByteBuffer.wrap(b, offset, 4).order(ByteOrder.LITTLE_ENDIAN).getFloat();
    }
}

