/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.files;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class ToolboxFileFilter
implements FileFilter {
    private final String filterName;
    private List<String> extensions = Lists.newLinkedList();
    private boolean filterNameWithFilterList = false;

    public static void check(List<ToolboxFileFilter> extensions, final Path path) throws InvalidFilterFilename {
        Functions.Function2<Boolean, ToolboxFileFilter, Boolean> _function = new Functions.Function2<Boolean, ToolboxFileFilter, Boolean>(){

            public Boolean apply(Boolean r, ToolboxFileFilter e) {
                return r != false || e.accept(path);
            }
        };
        boolean valid = (Boolean)IterableExtensions.fold(extensions, (Object)false, (Functions.Function2)_function);
        if (!valid) {
            throw new InvalidFilterFilename(extensions, path);
        }
    }

    public static String getFilterExtensions(List<ToolboxFileFilter> extensions) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (ToolboxFileFilter e : extensions) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            _builder.append(e.filterName);
            _builder.append(": ");
            String _filterExtensions = e.getFilterExtensions();
            _builder.append(_filterExtensions);
        }
        return _builder.toString();
    }

    ToolboxFileFilter(String filterName) {
        this.filterName = filterName;
    }

    ToolboxFileFilter(String filterName, List<String> extensions) {
        this.filterName = filterName;
        this.add(extensions);
    }

    public String getFilterName() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(this.filterName);
        if (this.filterNameWithFilterList) {
            _builder.append(" (");
            String _filterExtensions = this.getFilterExtensions();
            _builder.append(_filterExtensions);
            _builder.append(")");
        }
        return _builder.toString();
    }

    public void add(Iterable<String> extensions) {
        Iterables.addAll(this.extensions, extensions);
    }

    public void add(String newExtension) {
        this.extensions.add(newExtension);
    }

    public void setFilterNameWithFilterList(boolean value) {
        this.filterNameWithFilterList = value;
    }

    public String getFilterExtensions() {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (String ext : this.extensions) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)";", "");
            }
            _builder.append("*.");
            _builder.append(ext);
        }
        return _builder.toString();
    }

    @Override
    public boolean accept(final File pathname) {
        Functions.Function2<Boolean, String, Boolean> _function = new Functions.Function2<Boolean, String, Boolean>(){

            public Boolean apply(Boolean r, String ext) {
                return r != false || ToolboxFileFilter.match(pathname.toString(), ext);
            }
        };
        return (Boolean)IterableExtensions.fold(this.extensions, (Object)false, (Functions.Function2)_function);
    }

    public boolean accept(final Path path) {
        Functions.Function2<Boolean, String, Boolean> _function = new Functions.Function2<Boolean, String, Boolean>(){

            public Boolean apply(Boolean r, String ext) {
                return r != false || ToolboxFileFilter.match(path.toString(), ext);
            }
        };
        return (Boolean)IterableExtensions.fold(this.extensions, (Object)false, (Functions.Function2)_function);
    }

    private static boolean match(String filename, String ext) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(?i).*\\.");
        _builder.append(ext);
        return Pattern.matches(_builder.toString(), filename);
    }

    public static class InvalidFilterFilename
    extends Exception {
        @Accessors
        private final List<ToolboxFileFilter> extensions;
        @Accessors
        private final Path path;

        public InvalidFilterFilename(final List<ToolboxFileFilter> extensions, final Path path) {
            super(new Functions.Function0<String>(){

                public String apply() {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)path);
                    _builder.append(" does not match any of the filters ");
                    boolean _hasElements = false;
                    for (ToolboxFileFilter e : extensions) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        _builder.append(e.filterName);
                    }
                    return _builder.toString();
                }
            }.apply());
            this.extensions = extensions;
            this.path = path;
        }

        @Pure
        public List<ToolboxFileFilter> getExtensions() {
            return this.extensions;
        }

        @Pure
        public Path getPath() {
            return this.path;
        }
    }
}

