/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.pt1;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.set.feature.table.PlanPro2TableTransformationService;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.extensions.ColumnDescriptorExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableExtensions;
import org.eclipse.set.model.tablemodel.format.TextAlignment;
import org.eclipse.set.utils.excel.ExcelWorkbookExtension;
import org.eclipse.set.utils.table.ColumnDescriptorModelBuilder;
import org.eclipse.set.utils.table.GroupBuilder;
import org.eclipse.set.utils.table.TableBuilderFromExcel;

public abstract class AbstractPlanPro2TableTransformationService
extends PlanPro2TableTransformationService {
    private static final String TEMPLATE_DIR = "data/export/excel/";
    protected Set<ColumnDescriptor> cols;
    protected XSSFSheet excelTemplate = null;

    public ColumnDescriptor buildHeading(Table table) {
        ColumnDescriptor root = super.buildHeading(table);
        ColumnDescriptorExtensions.addMissingHeadingUnits((ColumnDescriptor)root);
        return root;
    }

    protected Set<ColumnDescriptor> getColumnsListe(ColumnDescriptor root) {
        HashSet<ColumnDescriptor> colunnsListe = new HashSet<ColumnDescriptor>();
        root.getChildren().forEach(child -> {
            colunnsListe.add((ColumnDescriptor)child);
            Set<ColumnDescriptor> nestedColumn = this.getColumnsListe((ColumnDescriptor)child);
            if (!nestedColumn.isEmpty()) {
                colunnsListe.addAll(nestedColumn);
            }
        });
        return colunnsListe;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ColumnDescriptor fillHeaderDescriptions(ColumnDescriptorModelBuilder builder) {
        GroupBuilder root;
        block15: {
            root = builder.createRootColumn(this.getTableHeading());
            Path templatePath = Paths.get(TEMPLATE_DIR, this.getTableNameInfo().getShortName().toLowerCase() + "_vorlage.xlsx").toAbsolutePath();
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try {
                    FileInputStream inputStream = new FileInputStream(templatePath.toFile());
                    try {
                        try (XSSFWorkbook workbook = new XSSFWorkbook((InputStream)inputStream);){
                            this.excelTemplate = (XSSFSheet)workbook.getSheetAt(0);
                            TableBuilderFromExcel.headerBuilder((Sheet)this.excelTemplate, (GroupBuilder)root, (int)1);
                        }
                        if (inputStream == null) break block15;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.cols = this.getColumnsListe(root.getGroupRoot());
        return root.getGroupRoot();
    }

    public Set<Integer> getFixedColumnsPos() {
        Set repeatingColumns = ExcelWorkbookExtension.getRepeatingColumns((Sheet)this.excelTemplate);
        if (repeatingColumns.isEmpty()) {
            return Collections.singleton(0);
        }
        return repeatingColumns.stream().map(ele -> ele - 1).filter(ele -> ele >= 0).collect(Collectors.toCollection(HashSet::new));
    }

    protected abstract String getTableHeading();

    protected void setColumnTextAlignment(Table table) {
        if (this.excelTemplate == null) {
            return;
        }
        ExcelWorkbookExtension.getFirstDataRow((Sheet)this.excelTemplate).forEach(cell -> {
            if (cell != null) {
                HorizontalAlignment alignment = cell.getCellStyle().getAlignment();
                int columnIdx = cell.getColumnIndex() - 1;
                switch (alignment) {
                    case LEFT: {
                        TableExtensions.setTextAlignment((Table)table, (int)columnIdx, (TextAlignment)TextAlignment.LEFT);
                        break;
                    }
                    case RIGHT: {
                        TableExtensions.setTextAlignment((Table)table, (int)columnIdx, (TextAlignment)TextAlignment.RIGHT);
                        break;
                    }
                }
            }
        });
    }
}

