/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.export.parts;

import jakarta.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.OverwriteHandling;
import org.eclipse.set.basis.export.CheckBoxTreeElement;
import org.eclipse.set.basis.export.CheckboxModelElement;
import org.eclipse.set.basis.extensions.Exceptions;
import org.eclipse.set.basis.threads.Threads;
import org.eclipse.set.core.services.configurationservice.UserConfigurationService;
import org.eclipse.set.feature.export.Messages;
import org.eclipse.set.feature.export.checkboxmodel.CheckBoxTreeModelProvider;
import org.eclipse.set.feature.export.checkboxmodel.CheckboxTreeModel;
import org.eclipse.set.services.export.ExportService;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.SaveAndRefreshAction;
import org.eclipse.set.utils.SelectableAction;
import org.eclipse.set.utils.events.SessionDirtyChanged;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DocumentExportPart
extends BasePart {
    private static final int SECTION_FONT_HEIGHT = 16;
    static final Logger logger = LoggerFactory.getLogger(DocumentExportPart.class);
    private Text directoryPath;
    private Button exportButton;
    private boolean isSessionDirty;
    private Path selectedDir;
    @Inject
    UserConfigurationService userConfigService;
    Button checkOverrideButton;
    @Inject
    ExportService exportService;
    @Inject
    @Translation
    Messages messages;
    @Inject
    @Translation
    org.eclipse.set.utils.Messages utilMessages;
    CheckboxTreeViewer viewer;
    private CheckboxTreeModel treeDataModel;
    private Composite buttonBar;

    protected DocumentExportPart() {
    }

    public Button getExportButton() {
        return this.exportButton;
    }

    protected CheckboxTreeViewer getViewer() {
        return this.viewer;
    }

    protected Composite getButtonBar() {
        return this.buttonBar;
    }

    protected ExportService getExportService() {
        return this.exportService;
    }

    public CheckboxTreeModel getTreeDataModel() {
        return this.treeDataModel;
    }

    private void createExportListSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(this.getDescription());
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        label.setLayoutData((Object)layoutData);
        Composite section = this.createSection(parent, this.messages.chose_export, 2);
        Label sectionLabel = new Label(section, 0);
        sectionLabel.setText(this.messages.chose_export_detail);
        GridData layoutDataSectionLabel = new GridData();
        layoutDataSectionLabel.horizontalSpan = 2;
        sectionLabel.setLayoutData((Object)layoutDataSectionLabel);
        this.viewer = new CheckboxTreeViewer(section, 2816);
        this.viewer.setComparator(new ViewerComparator());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                CheckboxModelElement ele = (CheckboxModelElement)element;
                return ele.toString();
            }
        });
        this.viewer.setContentProvider((IContentProvider)new CheckBoxTreeModelProvider());
        this.treeDataModel = this.createTreeModelData();
        this.viewer.setInput((Object)this.treeDataModel);
        this.treeDataModel.selectAll();
        this.viewer.setCheckedElements((Object[])this.treeDataModel.getChecked());
        this.viewer.expandAll();
        this.createSelectButtonGroup(section);
        this.viewer.setCheckStateProvider(this.checkStateProvider());
        this.viewer.addCheckStateListener(this.checkStateListerner());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.viewer.getTree());
    }

    protected ICheckStateListener checkStateListerner() {
        return event -> {
            Object object = event.getElement();
            if (object instanceof CheckBoxTreeElement) {
                void treeElement;
                CheckBoxTreeElement checkBoxTreeElement = (CheckBoxTreeElement)object;
                CheckBoxTreeElement cfr_ignored_0 = (CheckBoxTreeElement)object;
                if (event.getChecked()) {
                    treeElement.select();
                } else {
                    treeElement.deselect();
                }
                this.viewer.update((Object)treeElement, null);
                this.validateExportButton();
            }
        };
    }

    protected ICheckStateProvider checkStateProvider() {
        return new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public boolean isChecked(Object element) {
                Object object = element;
                if (object instanceof CheckBoxTreeElement) {
                    void treeElement;
                    CheckBoxTreeElement checkBoxTreeElement = (CheckBoxTreeElement)object;
                    CheckBoxTreeElement cfr_ignored_0 = (CheckBoxTreeElement)object;
                    if (treeElement.isParent()) {
                        DocumentExportPart.this.viewer.setSubtreeChecked((Object)treeElement, treeElement.isChecked());
                    } else {
                        boolean isAllChildsSameStatus = treeElement.getParent().getChildElements().stream().allMatch(arg_0 -> 2.lambda$0((CheckBoxTreeElement)treeElement, arg_0));
                        boolean isParentChecked = DocumentExportPart.this.viewer.getChecked((Object)treeElement.getParent());
                        if (isAllChildsSameStatus && isParentChecked != treeElement.isChecked() || !isAllChildsSameStatus && isParentChecked) {
                            DocumentExportPart.this.viewer.setChecked((Object)treeElement.getParent(), treeElement.getParent().isChecked());
                        }
                    }
                    return treeElement.isChecked();
                }
                return false;
            }

            private static /* synthetic */ boolean lambda$0(CheckBoxTreeElement checkBoxTreeElement, CheckBoxTreeElement ele) {
                return ele.isChecked() == checkBoxTreeElement.isChecked();
            }
        };
    }

    protected void createSelectButtonGroup(Composite parent) {
        this.buttonBar = new Composite(parent, 1024);
        FillLayout fillLayout = new FillLayout(512);
        fillLayout.spacing = 2;
        this.buttonBar.setLayout((Layout)fillLayout);
        this.createSelectButton(this.buttonBar, this.messages.selectAll, this.treeDataModel, CheckboxTreeModel::selectAll);
        this.createSelectButton(this.buttonBar, this.messages.selectNone, this.treeDataModel, CheckboxTreeModel::deselectAll);
        GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)this.buttonBar);
    }

    protected Button createSelectButton(Composite parent, String buttonText, CheckboxTreeModel treeModel, Consumer<CheckboxTreeModel> modelAction) {
        Button button = new Button(parent, 8);
        button.setText(buttonText);
        button.addListener(13, event -> {
            modelAction.accept(treeModel);
            this.viewer.setCheckedElements((Object[])treeModel.getChecked());
            this.validateExportButton();
        });
        return button;
    }

    private void createExportSection(Composite parent) {
        Composite section = this.createSection(parent, this.messages.export_settings, 3);
        Label label = new Label(section, 0);
        label.setText(this.messages.output_directory);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        this.directoryPath = new Text(section, 0);
        GridData gridData2 = new GridData(4, 0x1000000, true, false);
        gridData2.horizontalSpan = 2;
        this.directoryPath.setLayoutData((Object)gridData2);
        this.directoryPath.setText(this.getSelectedDirectory().toString());
        this.directoryPath.setEditable(false);
        Button buttonSelectDir = new Button(section, 8);
        buttonSelectDir.setText(this.messages.chose_directory_button);
        buttonSelectDir.addListener(13, event -> this.getDialogService().selectDirectory(parent.getShell(), this.getSelectedDirectory().toString()).ifPresent(selectedName -> {
            Path selectedPath;
            Path dir;
            this.selectedDir = dir = (selectedPath = Paths.get(selectedName, new String[0]));
            this.directoryPath.setText(this.getSelectedDirectory().toString());
            this.userConfigService.setLastExportPath(this.selectedDir);
        }));
        this.checkOverrideButton = new Button(section, 32);
        this.checkOverrideButton.setSelection(true);
        Label checkOverrideLabel = new Label(section, 0);
        checkOverrideLabel.setText(this.messages.DocumentExportPart_checkOverrideLabel);
    }

    private Composite createSection(Composite parent, String headingText, int columns) {
        int step = Math.min(0, 4);
        Group section = new Group(parent, 0);
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        section.setLayout((Layout)new GridLayout(columns, false));
        FontDescriptor descriptor = FontDescriptor.createFrom((Font)section.getFont()).setHeight(16 - 2 * step);
        Font font = (Font)this.localResourceManager.create((DeviceResourceDescriptor)descriptor);
        section.setFont(font);
        section.setText(headingText);
        return section;
    }

    private void startExport(Shell shell, final IModelSession modelSession) {
        ProgressMonitorDialog progressMonitorDialog;
        block3: {
            final OverwriteHandling overwriteHandling = OverwriteHandling.forCheckbox((boolean)this.checkOverrideButton.getSelection());
            final Object[] checkedElements = this.viewer.getCheckedElements();
            IRunnableWithProgress exportThread = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(DocumentExportPart.this.getTaskMessage(), -1);
                    Threads.stopCurrentOnCancel((IProgressMonitor)monitor);
                    Object[] objectArray = checkedElements;
                    int n = checkedElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object entry = objectArray[n2];
                        CheckboxModelElement ele = (CheckboxModelElement)entry;
                        DocumentExportPart.this.export(ele, modelSession, overwriteHandling, monitor);
                        ++n2;
                    }
                    monitor.done();
                }
            };
            progressMonitorDialog = new ProgressMonitorDialog(shell);
            try {
                progressMonitorDialog.run(true, true, exportThread);
            }
            catch (Exception e) {
                if (Exceptions.isCausedByThreadDeath((Throwable)e)) break block3;
                this.getDialogService().error(shell, e);
            }
        }
        if (!progressMonitorDialog.getProgressMonitor().isCanceled()) {
            this.getDialogService().openDirectoryAfterExport(this.getToolboxShell(), this.getSelectedDirectory());
            this.userConfigService.setLastExportPath(this.getSelectedDirectory());
        }
    }

    protected abstract CheckboxTreeModel createTreeModelData();

    protected void createView(Composite parent) {
        this.selectedDir = this.userConfigService.getLastExportPath();
        parent.setLayout((Layout)new FillLayout());
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 512);
        scrolledComposite.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)scrolledComposite);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setAlwaysShowScrollBars(false);
        this.isSessionDirty = this.getModelSession().isDirty();
        Composite content = new Composite((Composite)scrolledComposite, 0);
        content.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)content);
        scrolledComposite.setContent((Control)content);
        this.createExportListSection(content);
        this.createExportSection(content);
        this.exportButton = new Button(content, 8);
        this.exportButton.setText(this.getExportButtonText());
        this.exportButton.addListener(13, event -> this.startExport(parent.getShell(), this.getModelSession()));
        scrolledComposite.setMinSize(content.computeSize(-1, -1));
        this.validateExportButton();
        this.setOutdated(this.getModelSession().isDirty());
    }

    protected abstract void export(CheckboxModelElement var1, IModelSession var2, OverwriteHandling var3, IProgressMonitor var4);

    protected abstract String getDescription();

    protected abstract String getExportButtonText();

    protected SelectableAction getOutdatedAction() {
        return new SaveAndRefreshAction((BasePart)this);
    }

    protected Path getSelectedDirectory() {
        return this.selectedDir;
    }

    protected abstract String getTaskMessage();

    protected void handleSessionDirtyEvent(SessionDirtyChanged e) {
        this.isSessionDirty = e.isDirty();
        this.validateExportButton();
        this.setOutdated(this.isSessionDirty);
    }

    protected void validateExportButton() {
        this.exportButton.setEnabled(this.viewer.getCheckedElements().length > 0 && !this.isSessionDirty);
    }
}

