/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.export.pdf;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.text.PDFTextStripper;
import org.eclipse.core.runtime.Assert;
import org.eclipse.set.basis.FreeFieldInfo;
import org.eclipse.set.basis.OverwriteHandling;
import org.eclipse.set.basis.ToolboxPaths;
import org.eclipse.set.basis.Translateable;
import org.eclipse.set.basis.constants.ExportType;
import org.eclipse.set.basis.constants.TableType;
import org.eclipse.set.basis.exceptions.FileExportException;
import org.eclipse.set.basis.exceptions.UserAbortion;
import org.eclipse.set.basis.extensions.PathExtensions;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.feature.export.pdf.TableToTableDocument;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.titlebox.Titlebox;
import org.eclipse.set.ppmodel.extensions.EObjectExtensions;
import org.eclipse.set.services.export.TableExport;
import org.eclipse.set.services.fop.FopService;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.set.utils.export.xsl.TransformTable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Component(immediate=true)
public class FopPdfExportBuilder
implements TableExport {
    @Reference
    EnumTranslationService enumTranslationService;
    protected static final String PAGE_NUMBER_PATTERN = "^PageNumber_\\d+[ab]*[\\+|-]$";
    private static final String FOOTNOTE_PAGE_NUMBER_PATTERN = "^PageNumber_\\d+[\\+|-]$";
    protected static final Logger logger = LoggerFactory.getLogger(FopPdfExportBuilder.class);
    private static final String TITLEBOX_SHORTCUT = "schriftfeld";
    protected FopService fopService;
    private String templateDir = "./data/export/pdf/";

    protected static TransformerFactory newTransformerFactory() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            // empty catch block
        }
        return transformerFactory;
    }

    protected static String createTableDocumentText(Table table, Titlebox titlebox, FreeFieldInfo freeFieldInfo) throws ParserConfigurationException, TransformerException {
        TableToTableDocument tableToXmlFo = TableToTableDocument.createTransformation();
        Document document = tableToXmlFo.transformToDocument(table, titlebox, freeFieldInfo);
        Transformer documentToString = FopPdfExportBuilder.newTransformerFactory().newTransformer();
        DOMSource source = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        documentToString.transform(source, result);
        return writer.toString();
    }

    private static String createTitleboxDocumentText(Titlebox titlebox) throws Exception {
        TableToTableDocument tableToXmlFo = TableToTableDocument.createTransformation();
        Document document = tableToXmlFo.transformToDocument(titlebox);
        Transformer documentToString = FopPdfExportBuilder.newTransformerFactory().newTransformer();
        DOMSource source = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        documentToString.transform(source, result);
        return writer.toString();
    }

    protected static void exportTableDocument(Path filename, String content) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (PrintWriter out = new PrintWriter(filename.toString());){
            out.println(content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected static String getFilename(String shortcut, String extension) {
        return shortcut + "-fop." + extension;
    }

    protected static Table getTableToBeExported(Map<TableType, Table> tables, ExportType exportType) {
        switch (exportType) {
            case INVENTORY_RECORDS: {
                Table invTable = tables.get(TableType.FINAL);
                if (invTable != null) {
                    return invTable;
                }
                return tables.get(TableType.SINGLE);
            }
            case PLANNING_RECORDS: {
                Table planTable = tables.get(TableType.DIFF);
                if (planTable != null) {
                    return planTable;
                }
                return tables.get(TableType.SINGLE);
            }
        }
        throw new IllegalArgumentException(exportType.toString());
    }

    public void export(Map<TableType, Table> tables, ExportType exportType, Titlebox titlebox, FreeFieldInfo freeFieldInfo, String shortcut, String outputDir, ToolboxPaths toolboxPaths, TableType tableType, OverwriteHandling overwriteHandling) throws FileExportException {
        logger.info("Exporting {}", (Object)shortcut);
        Table table = FopPdfExportBuilder.getTableToBeExported(tables, exportType);
        List<String> pageBreakRowsIndex = this.getPageBreakRowsIndex(table);
        Assert.isNotNull((Object)table);
        Path outputPath = toolboxPaths.getTableExportPath(shortcut, Paths.get(outputDir, new String[0]), exportType, ToolboxPaths.ExportPathExtension.TABLE_PDF_EXPORT_EXTENSION);
        try {
            String tableDocumentText = FopPdfExportBuilder.createTableDocumentText(table, titlebox, freeFieldInfo);
            if (ToolboxConfiguration.isDevelopmentMode()) {
                FopPdfExportBuilder.exportTableDocument(Paths.get(outputDir, FopPdfExportBuilder.getFilename(shortcut, "xml")), tableDocumentText);
            }
            this.createTablePdf(tableDocumentText, outputPath, shortcut, tableType, FopService.PdfAMode.PDF_A_3a, overwriteHandling, pageBreakRowsIndex);
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            throw new FileExportException(outputPath, (Throwable)e);
        }
        catch (UserAbortion userAbortion) {
            // empty catch block
        }
    }

    protected void createTablePdf(String tableDocumentText, Path outputPath, String shortcut, TableType tableType, FopService.PdfAMode pdfAMode, OverwriteHandling overwriteHandling, List<String> pageBreakRowsIndex) throws IOException, SAXException, TransformerException, ParserConfigurationException, UserAbortion {
        TransformTable transformTable = new TransformTable(shortcut, this.translationTableType(tableType));
        Document xslDoc = pageBreakRowsIndex.isEmpty() ? transformTable.transform() : transformTable.transform(pageBreakRowsIndex);
        this.createTablePdf(xslDoc, tableDocumentText, outputPath, shortcut, pdfAMode, overwriteHandling);
        if (transformTable.isMultiPageLayout()) {
            FopPdfExportBuilder.reSortPdfPage(outputPath);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void reSortPdfPage(Path outputPath) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            PDDocument pdf = PDDocument.load((File)outputPath.toFile());
            try {
                try (PDDocument newPdf = new PDDocument();){
                    List outputIntents;
                    int pageCount = pdf.getPages().getCount();
                    LinkedList<PDPage> tablePages = new LinkedList<PDPage>();
                    LinkedList<PDPage> footnotePages = new LinkedList<PDPage>();
                    int i = pageCount;
                    while (i >= 0) {
                        PDPage page = pdf.getPage(i - 1);
                        if (!FopPdfExportBuilder.isFootnotePage(pdf, i)) break;
                        footnotePages.addFirst(page);
                        --i;
                    }
                    int tablePageCount = (pageCount - footnotePages.size()) / 2;
                    int i2 = 0;
                    while (i2 < tablePageCount) {
                        tablePages.add(pdf.getPage(i2));
                        tablePages.add(pdf.getPage(i2 + tablePageCount));
                        ++i2;
                    }
                    footnotePages.forEach(arg_0 -> ((PDDocument)pdf).removePage(arg_0));
                    tablePages.forEach(arg_0 -> ((PDDocument)newPdf).addPage(arg_0));
                    footnotePages.forEach(arg_0 -> ((PDDocument)newPdf).addPage(arg_0));
                    PDMetadata metadata = pdf.getDocumentCatalog().getMetadata();
                    if (metadata != null) {
                        newPdf.getDocumentCatalog().setMetadata(metadata);
                    }
                    if ((outputIntents = pdf.getDocumentCatalog().getOutputIntents()) != null && !outputIntents.isEmpty()) {
                        newPdf.getDocumentCatalog().setOutputIntents(outputIntents);
                    }
                    newPdf.save(outputPath.toFile());
                }
                if (pdf == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (pdf == null) throw throwable;
                pdf.close();
                throw throwable;
            }
            pdf.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static boolean isFootnotePage(PDDocument pdf, int pageIndex) {
        try {
            PDFTextStripper pdfTextStripper = new PDFTextStripper();
            pdfTextStripper.setStartPage(pageIndex);
            pdfTextStripper.setEndPage(pageIndex);
            String pageText = pdfTextStripper.getText(pdf);
            Pattern pageNumberPattern = Pattern.compile(PAGE_NUMBER_PATTERN);
            Pattern footnodePageNumberPattern = Pattern.compile(FOOTNOTE_PAGE_NUMBER_PATTERN);
            String pageNumber = ((Stream)Arrays.stream(pageText.split(" |\\r?\\n")).parallel()).filter(text -> pageNumberPattern.matcher((CharSequence)text).find()).findFirst().orElse("");
            if (pageNumber.isBlank() || pageNumber.isEmpty()) {
                throw new IllegalArgumentException("Can't find page number in pdf page");
            }
            return footnodePageNumberPattern.matcher(pageNumber).find();
        }
        catch (IOException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    private void createTablePdf(Document xslDoc, String tableDocumentText, Path outputPath, String shortcut, FopService.PdfAMode pdfAMode, OverwriteHandling overwriteHandling) throws IOException, SAXException, TransformerException, UserAbortion {
        if (xslDoc != null) {
            if (ToolboxConfiguration.isDevelopmentMode()) {
                Transformer documentToString = FopPdfExportBuilder.newTransformerFactory().newTransformer();
                DOMSource source = new DOMSource(xslDoc);
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(writer);
                documentToString.transform(source, result);
                FopPdfExportBuilder.exportTableDocument(Paths.get(outputPath.getParent().toString(), FopPdfExportBuilder.getFilename(shortcut, "xsl")), writer.toString());
            }
            ByteArrayInputStream tableDocumentStream = new ByteArrayInputStream(tableDocumentText.getBytes(StandardCharsets.UTF_8));
            StreamSource tableDocumentSource = new StreamSource(tableDocumentStream);
            this.fopService.fop(FopService.OutputFormat.PDF, (Source)TransformTable.toStreamSource((Document)xslDoc), (Source)tableDocumentSource, outputPath, pdfAMode, overwriteHandling, null);
        } else {
            logger.error("Cant export table: " + shortcut);
        }
    }

    protected List<String> getPageBreakRowsIndex(Table table) {
        return Collections.emptyList();
    }

    public void exportTitleboxImage(Titlebox titlebox, Path imagePath, OverwriteHandling overwriteHandling) throws Exception {
        try {
            String tableDocumentText = FopPdfExportBuilder.createTitleboxDocumentText(titlebox);
            if (ToolboxConfiguration.isDevelopmentMode()) {
                FopPdfExportBuilder.exportTableDocument(Paths.get(imagePath.getParent().toString(), TITLEBOX_SHORTCUT, "xml"), tableDocumentText);
            }
            this.createImageFile(tableDocumentText, imagePath, overwriteHandling);
        }
        catch (UserAbortion userAbortion) {
            // empty catch block
        }
    }

    public void exportTitleboxPdf(Titlebox titlebox, Path pdfPath, OverwriteHandling overwriteHandling) throws Exception {
        try {
            String tableDocumentText = FopPdfExportBuilder.createTitleboxDocumentText(titlebox);
            if (ToolboxConfiguration.isDevelopmentMode()) {
                FopPdfExportBuilder.exportTableDocument(Paths.get(pdfPath.getParent().toString(), FopPdfExportBuilder.getFilename(TITLEBOX_SHORTCUT, "xml")), tableDocumentText);
            }
            this.createPdf(tableDocumentText, pdfPath, TITLEBOX_SHORTCUT, FopService.PdfAMode.NONE, overwriteHandling);
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new RuntimeException(e);
        }
        catch (UserAbortion userAbortion) {
            // empty catch block
        }
    }

    public void exportSiteplanPdf(List<BufferedImage> imagesData, Titlebox titleBox, FreeFieldInfo freeFieldInfo, double ppm, String outputDir, ToolboxPaths toolboxPaths, TableType tableType, OverwriteHandling overwriteHandling) {
    }

    public String getTemplateDir() {
        return this.templateDir;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC, unbind="-")
    public void setFopService(FopService fopService) {
        this.fopService = fopService;
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    private void createImageFile(String tableDocumentText, Path imagePath, OverwriteHandling overwriteHandling) throws SAXException, IOException, TransformerException, UserAbortion {
        File xsltFile = this.getTemplateFilename(TITLEBOX_SHORTCUT).toFile();
        if (xsltFile.canRead()) {
            StreamSource xslt = new StreamSource(xsltFile);
            ByteArrayInputStream tableDocumentStream = new ByteArrayInputStream(tableDocumentText.getBytes(StandardCharsets.UTF_8));
            StreamSource tableDocumentSource = new StreamSource(tableDocumentStream);
            this.fopService.fop(FopService.OutputFormat.IMAGE, (Source)xslt, (Source)tableDocumentSource, imagePath, FopService.PdfAMode.NONE, overwriteHandling, null);
        } else {
            logger.error("Missing pdf export template: " + xsltFile.toString());
        }
    }

    private void createPdf(String tableDocumentText, Path outputPath, String shortcut, FopService.PdfAMode pdfAMode, OverwriteHandling overwriteHandling) throws IOException, SAXException, TransformerException, UserAbortion {
        File xsltFile = this.getTemplateFilename(shortcut).toFile();
        PathExtensions.checkCanRead((Path)xsltFile.toPath());
        if (xsltFile.canRead()) {
            StreamSource xslt = new StreamSource(xsltFile);
            ByteArrayInputStream tableDocumentStream = new ByteArrayInputStream(tableDocumentText.getBytes(StandardCharsets.UTF_8));
            StreamSource tableDocumentSource = new StreamSource(tableDocumentStream);
            this.fopService.fop(FopService.OutputFormat.PDF, (Source)xslt, (Source)tableDocumentSource, outputPath, pdfAMode, overwriteHandling, null);
        } else {
            logger.error("Missing pdf export template: " + xsltFile.toString());
        }
    }

    private Path getTemplateFilename(String shortcut) {
        return Paths.get(this.getTemplateDir(), shortcut + "_vorlage.xsl");
    }

    protected String translationTableType(TableType tableType) {
        return EObjectExtensions.getNullableObject((Object)tableType, type -> this.enumTranslationService.translate((Translateable)type).getPresentation()).orElse(null);
    }

    public String getTableShortcut() {
        throw new UnsupportedOperationException();
    }

    public TableExport.ExportFormat getExportFormat() {
        return TableExport.ExportFormat.PDF;
    }
}

