/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.graph;

import com.google.common.collect.Iterators;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Assert;
import org.eclipse.set.basis.cache.Cache;
import org.eclipse.set.basis.cache.NoCache;
import org.eclipse.set.basis.graph.AbstractDigraph;
import org.eclipse.set.basis.graph.DirectedEdge;
import org.eclipse.set.basis.graph.DirectedEdgePath;
import org.eclipse.set.basis.graph.DirectedEdgePoint;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public abstract class AbstractDirectedEdgePath<E, N, P>
extends AbstractDigraph<E, N, P>
implements DirectedEdgePath<E, N, P> {
    private final LinkedList<DirectedEdge<E, N, P>> edges = new LinkedList();
    private P end;
    private P start;
    private static Cache edgeToPointsCache;
    private static Supplier<Cache> edgeToPointsCacheSupplier;

    private static boolean equals(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return o1 == null && o2 == null;
        }
        return o1.equals(o2);
    }

    public static void setEdgeToPointsCacheSupplier(Supplier<Cache> edgeToPointsCacheSupplier) {
        AbstractDirectedEdgePath.edgeToPointsCacheSupplier = edgeToPointsCacheSupplier;
    }

    protected AbstractDirectedEdgePath(List<DirectedEdge<E, N, P>> edges, P start, P end) {
        if (edges != null) {
            this.edges.addAll(edges);
        }
        this.start = start;
        this.end = end;
    }

    @Override
    public void append(DirectedEdge<E, N, P> e) {
        this.edges.add(e);
    }

    @Override
    public BigDecimal distance(P p1, P p2) {
        int idx2;
        if (p1 == null) {
            return this.distanceFromStart(p2);
        }
        if (p2 == null) {
            return this.distanceToEnd(p1);
        }
        int idx1 = this.getIndex(p1);
        if (idx1 < (idx2 = this.getIndex(p2))) {
            return this.distance(p1, idx1, p2, idx2);
        }
        if (idx2 < idx1) {
            return this.distance(p2, idx2, p1, idx1);
        }
        DirectedEdge<E, N, int> e = this.get((P)idx1);
        return e.distance((int)p1, (int)p2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof DirectedEdgePath) {
            void path;
            DirectedEdgePath directedEdgePath = (DirectedEdgePath)object;
            DirectedEdgePath cfr_ignored_0 = (DirectedEdgePath)object;
            return AbstractDirectedEdgePath.equals(path.getStart(), this.getStart()) && AbstractDirectedEdgePath.equals(path.getEnd(), this.getEnd()) && AbstractDirectedEdgePath.equals(path.getEdgeList(), this.getEdgeList());
        }
        return false;
    }

    @Override
    public DirectedEdge<E, N, P> get(int i) {
        return this.edges.get(i);
    }

    @Override
    public DirectedEdge<E, N, P> get(P p) {
        for (DirectedEdge directedEdge : this.edges) {
            if (!directedEdge.contains(p)) continue;
            return directedEdge;
        }
        return null;
    }

    @Override
    public DirectedEdge<E, N, P> getEdgeForHead(N head) {
        HashSet<DirectedEdge<E, N, P>> result = new HashSet<DirectedEdge<E, N, P>>();
        for (DirectedEdge<E, N, P> edge : this.getEdges()) {
            if (edge.getHead() != head) continue;
            result.add(edge);
        }
        Assert.isTrue((result.size() <= 1 ? 1 : 0) != 0);
        if (result.size() == 1) {
            return (DirectedEdge)result.iterator().next();
        }
        return null;
    }

    @Override
    public DirectedEdge<E, N, P> getEdgeForTail(N tail) {
        HashSet<DirectedEdge<E, N, P>> result = new HashSet<DirectedEdge<E, N, P>>();
        for (DirectedEdge<E, N, P> edge : this.getEdges()) {
            if (edge.getTail() != tail) continue;
            result.add(edge);
        }
        Assert.isTrue((result.size() <= 1 ? 1 : 0) != 0);
        if (result.size() == 1) {
            return (DirectedEdge)result.iterator().next();
        }
        return null;
    }

    @Override
    public Iterator<DirectedEdge<E, N, P>> getEdgeIterator() {
        return this.edges.iterator();
    }

    @Override
    public List<DirectedEdge<E, N, P>> getEdgeList() {
        return this.edges;
    }

    @Override
    public Iterator<DirectedEdgePoint<E, N, P>> getEdgePointIterator() {
        List<DirectedEdgePoint<E, N, P>> pathDirectedEdgePoints;
        LinkedList<DirectedEdgePoint<E, N, P>> directedEdgePoints = new LinkedList<DirectedEdgePoint<E, N, P>>();
        Iterator<DirectedEdge<E, N, P>> edgeIter = this.getEdgeIterator();
        AbstractDirectedEdgePath.createCache();
        while (edgeIter.hasNext()) {
            DirectedEdge<E, N, P> edge = edgeIter.next();
            List pointList = (List)edgeToPointsCache.get(edge.getCacheKey(), () -> this.getPointList(edge));
            for (Object point : pointList) {
                directedEdgePoints.add(new DirectedEdgePoint<E, N, P>(edge, point));
            }
        }
        List points = directedEdgePoints.stream().map(DirectedEdgePoint::getPoint).collect(Collectors.toList());
        if (this.start != null && this.end != null) {
            int fromIndex = points.indexOf(this.start);
            this.checkIndex(fromIndex, this.start);
            int toIndex = points.indexOf(this.end);
            this.checkIndex(toIndex, this.end);
            pathDirectedEdgePoints = directedEdgePoints.subList(fromIndex, toIndex + 1);
        } else if (this.start != null) {
            int fromIndex = points.indexOf(this.start);
            this.checkIndex(fromIndex, this.start);
            pathDirectedEdgePoints = directedEdgePoints.subList(fromIndex, directedEdgePoints.size());
        } else if (this.end != null) {
            int toIndex = points.indexOf(this.end);
            this.checkIndex(toIndex, this.end);
            pathDirectedEdgePoints = directedEdgePoints.subList(0, toIndex + 1);
        } else {
            pathDirectedEdgePoints = directedEdgePoints;
        }
        return pathDirectedEdgePoints.iterator();
    }

    private List<P> getPointList(DirectedEdge<E, N, P> edge) {
        return IteratorExtensions.toList(edge.getIterator());
    }

    private static void createCache() {
        if (edgeToPointsCache == null) {
            edgeToPointsCache = edgeToPointsCacheSupplier != null ? edgeToPointsCacheSupplier.get() : new NoCache();
        }
    }

    @Override
    public Set<DirectedEdge<E, N, P>> getEdges() {
        return new HashSet<DirectedEdge<E, N, P>>(this.edges);
    }

    @Override
    public P getEnd() {
        return this.end;
    }

    @Override
    public int getIndex(DirectedEdge<E, N, P> e) {
        return this.edges.indexOf(e);
    }

    @Override
    public BigDecimal getLength() {
        return this.distance(this.getStart(), this.getEnd());
    }

    @Override
    public Iterator<P> getPointIterator() {
        return Iterators.transform(this.getEdgePointIterator(), DirectedEdgePoint::getPoint);
    }

    @Override
    public P getStart() {
        return this.start;
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (this.start != null ? this.start.hashCode() : 0);
        hash = 17 * hash + (this.end != null ? this.end.hashCode() : 0);
        hash = 17 * hash + this.edges.hashCode();
        return hash;
    }

    @Override
    public void prepend(DirectedEdge<E, N, P> e) {
        this.edges.addFirst(e);
    }

    @Override
    public void setEnd(P end) {
        this.end = end;
    }

    @Override
    public void setStart(P start) {
        this.start = start;
    }

    @Override
    public DirectedEdgePath<E, N, P> subPath(P subStart, P subEnd) {
        DirectedEdge<E, N, P> startEdge = this.get(subStart);
        DirectedEdge<E, N, P> endEdge = this.get(subEnd);
        if (startEdge != null && endEdge != null) {
            int endIdx;
            int startIdx = this.getIndex((P)startEdge);
            if (startIdx < (endIdx = this.getIndex((P)endEdge))) {
                return this.createSubPath(startIdx, endIdx, subStart, subEnd);
            }
            if (startIdx == endIdx) {
                BigDecimal subStartDistance = startEdge.distanceFromTail(subStart);
                BigDecimal subEndDistance = endEdge.distanceFromTail(subEnd);
                Comparator<BigDecimal> distanceComparator = this.getDistanceComparator();
                if (distanceComparator.compare(subStartDistance, subEndDistance) <= 0) {
                    return this.createSubPath(startIdx, endIdx, subStart, subEnd);
                }
            }
        }
        return null;
    }

    public String toString() {
        return String.format("%s{start=%s end=%s edges=%s}", super.toString(), this.getStart(), this.getEnd(), this.getEdgesString());
    }

    private void checkIndex(int index, P point) {
        if (index < 0) {
            throw new IllegalArgumentException(String.format("Point %s not on this path.", point.toString()));
        }
    }

    private DirectedEdgePath<E, N, P> createSubPath(int startIdx, int endIdx, P subStart, P subEnd) {
        DirectedEdgePath<E, N, P> result = this.getEmptyPath();
        int i = startIdx;
        while (i <= endIdx) {
            result.append(this.edges.get(i));
            ++i;
        }
        result.setStart(subStart);
        result.setEnd(subEnd);
        return result;
    }

    private BigDecimal distance(P pStart, int idxStart, P pEnd, int idxEnd) {
        if (idxStart > idxEnd) {
            return BigDecimal.ZERO;
        }
        if (idxStart != idxEnd) {
            BigDecimal startDistance = pStart != null ? this.get((P)idxStart).distanceToHead((int)pStart) : this.get((P)idxStart).getLength();
            BigDecimal endDistance = pEnd != null ? this.get((P)idxEnd).distanceFromTail((int)pEnd) : this.get((P)idxEnd).getLength();
            BigDecimal inBetweenDistance = BigDecimal.ZERO;
            int i = idxStart + 1;
            while (i < idxEnd) {
                inBetweenDistance = inBetweenDistance.add(this.get((P)i).getLength());
                ++i;
            }
            return startDistance.add(inBetweenDistance).add(endDistance);
        }
        if (pStart == null && pEnd == null) {
            return this.get((P)idxStart).getLength();
        }
        if (pStart == null) {
            return this.get((P)idxStart).distanceFromTail((int)pEnd);
        }
        return this.get((P)idxStart).distanceToHead((int)pStart);
    }

    private BigDecimal distanceFromStart(P p) {
        if (this.getStart() != null) {
            return this.distance(this.getStart(), p);
        }
        if (p != null) {
            return this.distance(null, 0, p, this.getIndex(p));
        }
        return this.distance(null, 0, null, this.edges.size() - 1);
    }

    private BigDecimal distanceToEnd(P p) {
        if (this.getEnd() != null) {
            return this.distance(this.getEnd(), p);
        }
        return this.distance(p, this.getIndex(p), null, this.edges.size() - 1);
    }

    private String getEdgesString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        boolean isFirst = true;
        for (DirectedEdge directedEdge : this.edges) {
            if (!isFirst) {
                builder.append(", ");
            }
            builder.append(directedEdge.toString());
            isFirst = false;
        }
        builder.append("]");
        return builder.toString();
    }

    private int getIndex(P p) {
        DirectedEdge<E, N, P> e = this.get(p);
        if (e == null) {
            throw new IllegalArgumentException(p.toString());
        }
        return this.getIndex((P)e);
    }
}

