/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.abstracttableview;

import java.util.Set;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupHeaderLayer;
import org.eclipse.set.basis.tables.Tables;
import org.eclipse.set.feature.table.abstracttableview.ColumnGroup4HeaderLayer;
import org.eclipse.set.feature.table.abstracttableview.ColumnGroupGroupGroupHeaderLayer;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.extensions.ColumnDescriptorExtensions;

public final class NatTableColumnGroupHelper {
    private static final String ZERO_WIDTH_SPACE = "\u200b";

    private static void addGroupsToHeader(Set<ColumnDescriptor> groups, HeaderLayer columnHeaderLayer) {
        for (ColumnDescriptor group : groups) {
            int[] indices = ColumnDescriptorExtensions.getColumnIndices((ColumnDescriptor)group);
            int uniqueIndex = indices.length > 0 ? indices[0] : 0;
            String groupLabel = group.getLabel() + ZERO_WIDTH_SPACE.repeat(uniqueIndex);
            columnHeaderLayer.addColumnsIndexesToGroup(groupLabel, indices);
        }
    }

    public static void addColumnNumbers(ColumnDescriptor header, ColumnGroup4HeaderLayer columnGroup4HeaderLayer) {
        int noOfcolumns = ColumnDescriptorExtensions.getColumns((ColumnDescriptor)header).size();
        int i = 0;
        while (i < noOfcolumns) {
            String label = Tables.getColumnIdentifier((int)i);
            columnGroup4HeaderLayer.addColumnsIndexesToGroup(label, i++);
        }
    }

    public static void addGroup4(ColumnDescriptor header, ColumnGroup4HeaderLayer columnGroup4HeaderLayer) {
        NatTableColumnGroupHelper.addGroupsToHeader(ColumnDescriptorExtensions.getGroup4((ColumnDescriptor)header), (string, nArray) -> columnGroup4HeaderLayer.addColumnsIndexesToGroup(string, nArray));
    }

    public static void addGroupGroupGroups(ColumnDescriptor header, ColumnGroupGroupGroupHeaderLayer columnGroupGroupGroupHeaderLayer) {
        NatTableColumnGroupHelper.addGroupsToHeader(ColumnDescriptorExtensions.getGroupGroupGroups((ColumnDescriptor)header), (string, nArray) -> columnGroupGroupGroupHeaderLayer.addColumnsIndexesToGroup(string, nArray));
    }

    public static void addGroupGroups(ColumnDescriptor header, ColumnGroupGroupHeaderLayer columnGroupGroupHeaderLayer) {
        NatTableColumnGroupHelper.addGroupsToHeader(ColumnDescriptorExtensions.getGroupGroups((ColumnDescriptor)header), (string, nArray) -> columnGroupGroupHeaderLayer.addColumnsIndexesToGroup(string, nArray));
    }

    public static void addGroups(ColumnDescriptor header, ColumnGroupHeaderLayer columnGroupHeaderLayer) {
        NatTableColumnGroupHelper.addGroupsToHeader(ColumnDescriptorExtensions.getGroups((ColumnDescriptor)header), (string, nArray) -> columnGroupHeaderLayer.addColumnsIndexesToGroup(string, nArray));
    }

    private NatTableColumnGroupHelper() {
    }

    @FunctionalInterface
    private static interface HeaderLayer {
        public void addColumnsIndexesToGroup(String var1, int ... var2);
    }
}

