/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.export;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.set.basis.FreeFieldInfo;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.OverwriteHandling;
import org.eclipse.set.basis.Pair;
import org.eclipse.set.basis.constants.ExportType;
import org.eclipse.set.basis.constants.TableType;
import org.eclipse.set.basis.export.CheckBoxTreeElement;
import org.eclipse.set.basis.export.CheckboxModelElement;
import org.eclipse.set.basis.guid.Guid;
import org.eclipse.set.core.services.export.AdditionalExportService;
import org.eclipse.set.core.services.part.ToolboxPartService;
import org.eclipse.set.feature.export.checkboxmodel.CheckboxTreeModel;
import org.eclipse.set.feature.export.parts.DocumentExportPart;
import org.eclipse.set.feature.table.export.TableCheckboxTreeModel;
import org.eclipse.set.feature.table.messages.Messages;
import org.eclipse.set.model.planpro.PlanPro.Container_AttributeGroup;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.extensions.TableExtensions;
import org.eclipse.set.model.titlebox.Titlebox;
import org.eclipse.set.ppmodel.extensions.utils.PlanProToFreeFieldTransformation;
import org.eclipse.set.ppmodel.extensions.utils.PlanProToTitleboxTransformation;
import org.eclipse.set.ppmodel.extensions.utils.TableNameInfo;
import org.eclipse.set.services.export.TableCompileService;
import org.eclipse.set.services.table.TableService;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.SaveAndRefreshAction;
import org.eclipse.set.utils.SelectableAction;
import org.eclipse.set.utils.events.ContainerDataChanged;
import org.eclipse.set.utils.events.DefaultToolboxEventHandler;
import org.eclipse.set.utils.events.ProjectDataChanged;
import org.eclipse.set.utils.events.SelectedControlAreaChangedEvent;
import org.eclipse.set.utils.events.ToolboxEventHandler;
import org.eclipse.set.utils.events.ToolboxEvents;
import org.eclipse.set.utils.exception.ExceptionHandler;
import org.eclipse.set.utils.table.TableInfo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PlanProExportPart
extends DocumentExportPart {
    protected static final Logger logger = LoggerFactory.getLogger(PlanProExportPart.class);
    protected static final String EMPTY_TABLE = "leer";
    @Inject
    @Translation
    protected Messages messages;
    @Inject
    @Optional
    private AdditionalExportService<CheckBoxTreeElement> additionalExportService;
    @Inject
    ToolboxPartService toolboxPartService;
    @Inject
    TableService tableService;
    @Inject
    TableCompileService compileService;
    private ToolboxEventHandler<SelectedControlAreaChangedEvent> selectionControlAreaHandler;

    @Inject
    public PlanProExportPart() {
    }

    @PostConstruct
    private void postConstruct() {
        Set<String> currentAreaIds = this.getModelSession().getSelectedControlAreas().stream().map(Pair::getSecond).collect(Collectors.toSet());
        this.updateTreeElements(currentAreaIds);
        this.selectionControlAreaHandler = new DefaultToolboxEventHandler<SelectedControlAreaChangedEvent>(){

            public void accept(SelectedControlAreaChangedEvent t) {
                Set<String> areaIds = t.getControlAreas().stream().map(area -> area.areaId()).collect(Collectors.toSet());
                PlanProExportPart.this.updateTreeElements(areaIds);
            }
        };
        ToolboxEvents.subscribe((IEventBroker)this.getBroker(), SelectedControlAreaChangedEvent.class, this.selectionControlAreaHandler);
    }

    /*
     * WARNING - void declaration
     */
    public CheckboxTreeModel getTreeDataModel() {
        CheckboxTreeModel checkboxTreeModel = super.getTreeDataModel();
        if (checkboxTreeModel instanceof TableCheckboxTreeModel) {
            void tableTreeModel;
            TableCheckboxTreeModel tableCheckboxTreeModel = (TableCheckboxTreeModel)checkboxTreeModel;
            TableCheckboxTreeModel cfr_ignored_0 = (TableCheckboxTreeModel)checkboxTreeModel;
            return tableTreeModel;
        }
        throw new IllegalArgumentException();
    }

    protected void updateTreeElements(Set<String> areaIds) {
        HashSet avaibleTables = new HashSet(this.tableService.getAvailableTables());
        TableType tableType = this.getModelSession().getTableType();
        if (!(this.getTreeDataModel() instanceof TableCheckboxTreeModel)) {
            throw new IllegalArgumentException();
        }
        TableCheckboxTreeModel treeDataModel = (TableCheckboxTreeModel)this.getTreeDataModel();
        try {
            this.getDialogService().showProgress(this.getToolboxShell(), monitor -> {
                logger.debug("Start update tree elements");
                Map pt1Tables = this.tableService.transformTables(monitor, this.getModelSession(), avaibleTables, tableType, areaIds);
                Display.getDefault().asyncExec(() -> {
                    pt1Tables.forEach((tableInfo, table) -> {
                        CheckBoxTreeElement element = treeDataModel.getElement((TableInfo)tableInfo).orElse(null);
                        if (element == null) {
                            element = treeDataModel.addElement((TableInfo)tableInfo);
                        }
                        if (TableExtensions.isTableEmpty((Table)table)) {
                            element.setStatus(EMPTY_TABLE);
                            element.deselect();
                        } else {
                            element.setStatus(null);
                            element.select();
                        }
                        this.getViewer().update((Object)element, null);
                    });
                    this.validateExportButton();
                });
            });
        }
        catch (Exception e) {
            this.getDialogService().error(this.getToolboxShell(), e);
        }
    }

    @PreDestroy
    private void preDestroy() {
        logger.trace("preDestroy");
        ToolboxEvents.unsubscribe((IEventBroker)this.getBroker(), this.selectionControlAreaHandler);
    }

    protected CheckboxTreeModel createTreeModelData() {
        ArrayList<CheckBoxTreeElement> elements = new ArrayList<CheckBoxTreeElement>();
        Collection availableTables = this.tableService.getAvailableTables();
        availableTables.forEach(tableInfo -> {
            TableNameInfo nameInfo = this.tableService.getTableNameInfo(tableInfo.shortcut());
            CheckBoxTreeElement parentElement = elements.stream().filter(ele -> ele.getId().equals(tableInfo.category().getId())).findFirst().orElse(null);
            if (parentElement == null) {
                parentElement = new CheckBoxTreeElement(tableInfo.category().getId(), tableInfo.category().toString());
                elements.add(parentElement);
            }
            parentElement.addChild(new CheckBoxTreeElement(nameInfo.getShortName().toLowerCase(), nameInfo.getFullDisplayName()));
        });
        if (this.additionalExportService != null) {
            this.additionalExportService.createAdditionalCheckboxModelElements(elements);
        }
        return new TableCheckboxTreeModel(elements, this.tableService);
    }

    protected void createSelectButtonGroup(Composite parent) {
        super.createSelectButtonGroup(parent);
        this.createSelectButton(this.getButtonBar(), this.messages.TableExportPart_FilterEmptyButton, this.getTreeDataModel(), model -> Arrays.stream(model.getAllElements()).filter(ele -> ele.getStatus() != null && ele.getStatus().equals(EMPTY_TABLE)).forEach(ele -> ele.deselect()));
    }

    private Path getAttachmentPath(String guid) {
        try {
            return this.getModelSession().getToolboxFile().getMediaPath(Guid.create((String)guid));
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    protected void export(CheckboxModelElement element, IModelSession modelSession, OverwriteHandling overwriteHandling, IProgressMonitor monitor) {
        String id = element.getId();
        if (TableInfo.Pt1TableCategory.getCategoryEnum((String)id) != null) {
            return;
        }
        if (this.additionalExportService != null && this.additionalExportService.isAdditionalExportId(id)) {
            this.additionalExportService.createAdditionalExport(id, modelSession, monitor, this.getSelectedDirectory(), this.getExportType(), overwriteHandling);
        } else {
            Map tables = this.compileService.compile(id, modelSession, modelSession.getSelectedControlAreas().stream().map(Pair::getSecond).collect(Collectors.toSet()));
            PlanProToTitleboxTransformation planProToTitlebox = PlanProToTitleboxTransformation.create();
            Titlebox titlebox = planProToTitlebox.transform(modelSession.getPlanProSchnittstelle(), this.tableService.getTableNameInfo(id), this::getAttachmentPath);
            this.updateTitlebox(titlebox);
            PlanProToFreeFieldTransformation planProToFreeField = PlanProToFreeFieldTransformation.create();
            FreeFieldInfo freeFieldInfo = planProToFreeField.transform(modelSession);
            this.getExportService().exportPdf(tables, this.getExportType(), titlebox, freeFieldInfo, id, this.getSelectedDirectory().toString(), modelSession.getToolboxPaths(), modelSession.getTableType(), overwriteHandling, (Consumer)new ExceptionHandler(this.getToolboxShell(), this.getDialogService()));
        }
    }

    protected abstract ExportType getExportType();

    protected SelectableAction getOutdatedAction() {
        return new SaveAndRefreshAction((BasePart)this);
    }

    protected String getTaskMessage() {
        return this.messages.TableExportPart_TaskMsg;
    }

    protected void handleContainerDataChanged(ContainerDataChanged e) {
        this.setOutdated(true);
    }

    protected void handleProjectDataChanged(ProjectDataChanged e) {
        this.setOutdated(true);
    }

    protected abstract void updateTitlebox(Titlebox var1);

    protected void updateViewContainerDataChanged(List<Container_AttributeGroup> container) {
        this.setOutdated(false);
    }

    protected void updateViewProjectDataChanged(List<Notification> notifications) {
        this.setOutdated(false);
    }
}

