/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.model.tablemodel.extensions;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.html.HtmlEscapers;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.model.planpro.Basisobjekte.Bearbeitungsvermerk;
import org.eclipse.set.model.planpro.Basisobjekte.Bearbeitungsvermerk_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Kommentar_TypeClass;
import org.eclipse.set.model.tablemodel.CellContent;
import org.eclipse.set.model.tablemodel.CompareCellContent;
import org.eclipse.set.model.tablemodel.CompareFootnoteContainer;
import org.eclipse.set.model.tablemodel.FootnoteContainer;
import org.eclipse.set.model.tablemodel.MultiColorCellContent;
import org.eclipse.set.model.tablemodel.MultiColorContent;
import org.eclipse.set.model.tablemodel.SimpleFootnoteContainer;
import org.eclipse.set.model.tablemodel.StringCellContent;
import org.eclipse.set.model.tablemodel.TableCell;
import org.eclipse.set.model.tablemodel.extensions.TableCellExtensions;
import org.eclipse.set.model.tablemodel.extensions.Utils;
import org.eclipse.set.utils.StringExtensions;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class CellContentExtensions {
    public static final String WARNING_MARK_YELLOW = "<!-- warning-mark-yellow -->";
    public static final String WARNING_MARK_RED = "<!-- warning-mark-red -->";
    public static final String WARNING_MARK_BLACK = "<!-- warning-mark-black -->";
    public static final String HOURGLASS_ICON = "\u23f3";
    private static final String FOOTNOTE_SEPARATOR = ", ";
    private static final String ERROR_PREFIX = "Error:";

    protected static String _getRichTextValue(CellContent content) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Content ");
        String _simpleName = content.getClass().getSimpleName();
        _builder.append(_simpleName);
        _builder.append(" not supported.");
        return _builder.toString();
    }

    protected static String _getRichTextValue(Void content) {
        return "";
    }

    protected static String _getRichTextValue(StringCellContent content) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<p style=\"text-align:");
        String _textAlign = CellContentExtensions.getTextAlign((CellContent)content);
        _builder.append(_textAlign);
        _builder.append("\">");
        String _valueFormat = CellContentExtensions.getValueFormat((CellContent)content);
        _builder.append(_valueFormat);
        _builder.append("</p>");
        return _builder.toString();
    }

    protected static String _getRichTextValue(CompareCellContent content) {
        Function<String, String> _function = it -> WARNING_MARK_YELLOW;
        Function<String, String> _function_1 = it -> WARNING_MARK_BLACK;
        Function<String, String> _function_2 = it -> WARNING_MARK_RED;
        BiFunction<String, String, String> _function_3 = (text, mark) -> CellContentExtensions.getCompareValueFormat(mark, text);
        Iterable<String> result = CellContentExtensions.formatCompareContent(content.getOldValue(), content.getNewValue(), _function, _function_1, _function_2, _function_3);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<p style=\"text-align:");
        String _textAlign = CellContentExtensions.getTextAlign((CellContent)content);
        _builder.append(_textAlign);
        _builder.append("\">");
        String _xifexpression = null;
        _xifexpression = content.getSeparator() == null || content.getSeparator().equals("\r\n") ? "<br></br>" : content.getSeparator();
        String _iterableToString = CellContentExtensions.iterableToString(result, _xifexpression);
        _builder.append(_iterableToString);
        _builder.append("</p>");
        return _builder.toString();
    }

    protected static String _getRichTextValue(MultiColorCellContent content) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<p style=\"text-align:");
        String _textAlign = CellContentExtensions.getTextAlign((CellContent)content);
        _builder.append(_textAlign);
        _builder.append("\">");
        String _multiColorFormat = CellContentExtensions.getMultiColorFormat(content);
        _builder.append(_multiColorFormat);
        _builder.append("</p>");
        return _builder.toString();
    }

    protected static String _getRichTextValueWithFootnotes(CellContent content, FootnoteContainer fc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Content ");
        String _simpleName = content.getClass().getSimpleName();
        _builder.append(_simpleName);
        _builder.append(" not supported.");
        return _builder.toString();
    }

    protected static String _getRichTextValueWithFootnotes(Void content, Void fc) {
        return "";
    }

    protected static String _getRichTextValueWithFootnotes(StringCellContent content, Void fc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<p style=\"text-align:");
        String _textAlign = CellContentExtensions.getTextAlign((CellContent)content);
        _builder.append(_textAlign);
        _builder.append("\">");
        String _valueFormat = CellContentExtensions.getValueFormat((CellContent)content);
        _builder.append(_valueFormat);
        _builder.append("</p>");
        return _builder.toString();
    }

    protected static String _getRichTextValueWithFootnotes(StringCellContent content, SimpleFootnoteContainer fc) {
        boolean _notEquals;
        Functions.Function1 _function = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("*");
            int _footnoteNumber = Utils.getFootnoteNumber((EObject)content, it);
            _builder.append((Object)_footnoteNumber);
            return _builder.toString();
        };
        String footnoteText = CellContentExtensions.iterableToString(ListExtensions.map((List)fc.getFootnotes(), (Functions.Function1)_function), FOOTNOTE_SEPARATOR);
        boolean bl = _notEquals = !Objects.equals(footnoteText, "");
        if (_notEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("<p style=\"text-align:");
            String _textAlign = CellContentExtensions.getTextAlign((CellContent)content);
            _builder.append(_textAlign);
            _builder.append("\">");
            String _valueFormat = CellContentExtensions.getValueFormat((CellContent)content);
            _builder.append(_valueFormat);
            _builder.append(" ");
            _builder.append(footnoteText);
            _builder.append("</p>");
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("<p style=\"text-align:");
        String _textAlign_1 = CellContentExtensions.getTextAlign((CellContent)content);
        _builder_1.append(_textAlign_1);
        _builder_1.append("\">");
        String _valueFormat_1 = CellContentExtensions.getValueFormat((CellContent)content);
        _builder_1.append(_valueFormat_1);
        _builder_1.append("</p>");
        return _builder_1.toString();
    }

    protected static String _getRichTextValueWithFootnotes(CellContent content, CompareFootnoteContainer fc) {
        Iterable _plus;
        Function<String, String> _function = it -> WARNING_MARK_YELLOW;
        Function<String, String> _function_1 = it -> WARNING_MARK_BLACK;
        Function<String, String> _function_2 = it -> WARNING_MARK_RED;
        BiFunction<String, String, String> _function_3 = (text, mark) -> CellContentExtensions.getCompareValueFormat(mark, text);
        Iterable result = CellContentExtensions.formatCompareContent(content, _function, _function_1, _function_2, _function_3);
        Function<Bearbeitungsvermerk, String> _function_4 = it -> WARNING_MARK_YELLOW;
        Function<Bearbeitungsvermerk, String> _function_5 = it -> WARNING_MARK_BLACK;
        Function<Bearbeitungsvermerk, String> _function_6 = it -> WARNING_MARK_RED;
        BiFunction<Bearbeitungsvermerk, String, String> _function_7 = (text, mark) -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("*");
            int _footnoteNumber = Utils.getFootnoteNumber((EObject)content, text);
            _builder.append((Object)_footnoteNumber);
            return CellContentExtensions.getCompareValueFormat(mark, _builder.toString());
        };
        Iterable<String> footnotes = CellContentExtensions.formatCompareContent(fc, _function_4, _function_5, _function_6, _function_7);
        String _iterableToString = CellContentExtensions.iterableToString(footnotes, FOOTNOTE_SEPARATOR);
        result = _plus = Iterables.concat(result, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_iterableToString})));
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<p style=\"text-align:");
        String _textAlign = CellContentExtensions.getTextAlign(content);
        _builder.append(_textAlign);
        _builder.append("\">");
        Functions.Function1 _function_8 = it -> {
            int _length = it.length();
            return _length > 0;
        };
        String _xifexpression = null;
        _xifexpression = content.getSeparator() == null || content.getSeparator().equals("\r\n") ? "<br></br>" : content.getSeparator();
        String _iterableToString_1 = CellContentExtensions.iterableToString(IterableExtensions.filter((Iterable)result, (Functions.Function1)_function_8), _xifexpression);
        _builder.append(_iterableToString_1);
        _builder.append("</p>");
        return _builder.toString();
    }

    protected static String _getPlainStringValue(CellContent content) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Content ");
        String _simpleName = content.getClass().getSimpleName();
        _builder.append(_simpleName);
        _builder.append(" not supported.");
        return _builder.toString();
    }

    protected static String _getPlainStringValue(Void content) {
        return "";
    }

    protected static String _getPlainStringValue(StringCellContent content) {
        return CellContentExtensions.iterableToString((Iterable<String>)content.getValue(), content.getSeparator());
    }

    protected static String _getPlainStringValue(CompareCellContent content) {
        StringConcatenation _builder = new StringConcatenation();
        EList _oldValue = content.getOldValue();
        _builder.append((Object)_oldValue);
        _builder.append("/");
        EList _newValue = content.getNewValue();
        _builder.append((Object)_newValue);
        return _builder.toString();
    }

    protected static String _getPlainStringValue(MultiColorCellContent content) {
        StringConcatenation _builder = new StringConcatenation();
        EList _value = content.getValue();
        boolean _hasElements = false;
        for (MultiColorContent value : _value) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                String _separator = content.getSeparator();
                _builder.appendImmediate((Object)_separator, "");
            }
            String _format = String.format(value.getStringFormat(), value.getMultiColorValue());
            _builder.append(_format);
        }
        return _builder.toString();
    }

    protected static Iterable<String> _getStringValueIterable(Void content) {
        return Collections.unmodifiableList(CollectionLiterals.newArrayList());
    }

    protected static Iterable<String> _getStringValueIterable(CellContent content) {
        String _plainStringValue = CellContentExtensions.getPlainStringValue(content);
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_plainStringValue}));
    }

    protected static Iterable<String> _getStringValueIterable(StringCellContent content) {
        return content.getValue();
    }

    public static boolean isErrorText(String text) {
        return text != null && text.startsWith(ERROR_PREFIX);
    }

    protected static TableCell _getTableCell(CellContent content) {
        EObject _eContainer = content.eContainer();
        return (TableCell)_eContainer;
    }

    protected static TableCell _getTableCell(MultiColorContent content) {
        EObject _eContainer = content.eContainer().eContainer();
        return (TableCell)_eContainer;
    }

    private static String getTextAlign(CellContent content) {
        return TableCellExtensions.getFormat(CellContentExtensions.getTableCell((EObject)content)).getTextAlignment().getLiteral();
    }

    private static String _getValueFormat(StringCellContent content) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<span>");
        String _valueHtmlString = CellContentExtensions.getValueHtmlString(content);
        _builder.append(_valueHtmlString);
        _builder.append("</span>");
        return _builder.toString();
    }

    private static String _getValueFormat(MultiColorCellContent content) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<span>");
        String _htmlString = CellContentExtensions.getHtmlString(CellContentExtensions.getMultiColorFormat(content));
        _builder.append(_htmlString);
        _builder.append("</span>");
        return _builder.toString();
    }

    public static <S extends Comparable<? super S>, R, T, U> Iterable<U> formatCompareContent(Iterable<R> oldContent, Iterable<R> newContent, Function<R, T> oldFormatter, Function<R, T> commonFormatter, Function<R, T> newFormatter, BiFunction<R, T, U> postFormatter, final Function<R, S> sorter) {
        return CellContentExtensions.formatCompareContent(IterableExtensions.sortBy((Iterable)IterableExtensions.toList((Iterable)IterableExtensions.toSet((Iterable)IterableExtensions.filterNull(oldContent))), (Functions.Function1)new Functions.Function1<R, S>(){

            public S apply(R arg0) {
                return (Comparable)sorter.apply(arg0);
            }
        }), IterableExtensions.sortBy((Iterable)IterableExtensions.toList((Iterable)IterableExtensions.toSet((Iterable)IterableExtensions.filterNull(newContent))), (Functions.Function1)new Functions.Function1<R, S>(){

            public S apply(R arg0) {
                return (Comparable)sorter.apply(arg0);
            }
        }), oldFormatter, commonFormatter, newFormatter, postFormatter);
    }

    public static <R, T, U> Iterable<U> formatCompareContent(Iterable<R> oldContent, Iterable<R> newContent, Function<R, T> oldFormatter, Function<R, T> commonFormatter, Function<R, T> newFormatter, BiFunction<R, T, U> postFormatter) {
        Functions.Function1 _function = it -> {
            boolean _contains = IterableExtensions.contains((Iterable)oldContent, (Object)it);
            if (_contains) {
                return postFormatter.apply(it, commonFormatter.apply(it));
            }
            return postFormatter.apply(it, newFormatter.apply(it));
        };
        List result = ListExtensions.map((List)IterableExtensions.toList((Iterable)IterableExtensions.toSet((Iterable)IterableExtensions.filterNull(newContent))), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> {
            boolean _contains = IterableExtensions.contains((Iterable)newContent, (Object)it);
            return !_contains;
        };
        Functions.Function1 _function_2 = it -> postFormatter.apply(it, oldFormatter.apply(it));
        Iterable _map = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.toList((Iterable)IterableExtensions.toSet((Iterable)IterableExtensions.filterNull(oldContent))), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
        return Iterables.concat((Iterable)result, (Iterable)_map);
    }

    public static <T, U> Iterable<U> formatCompareContent(Object content, Function<String, T> oldFormatter, Function<String, T> commonFormatter, Function<String, T> newFormatter, BiFunction<String, T, U> postFormatter) {
        Iterable<Object> _switchResult = null;
        boolean _matched = false;
        if (content instanceof StringCellContent) {
            _matched = true;
            Functions.Function1 _function = it -> postFormatter.apply((String)it, (Object)commonFormatter.apply((String)it));
            _switchResult = ListExtensions.map((List)IterableExtensions.toList((Iterable)IterableExtensions.toSet((Iterable)IterableExtensions.filterNull((Iterable)((StringCellContent)content).getValue()))), (Functions.Function1)_function);
        }
        if (!_matched && content instanceof CompareCellContent) {
            _matched = true;
            _switchResult = CellContentExtensions.formatCompareContent(((CompareCellContent)content).getOldValue(), ((CompareCellContent)content).getNewValue(), oldFormatter, commonFormatter, newFormatter, postFormatter);
        }
        return _switchResult;
    }

    public static <T, U> Iterable<U> formatCompareContent(CompareFootnoteContainer content, Function<Bearbeitungsvermerk, T> oldFormatter, Function<Bearbeitungsvermerk, T> commonFormatter, Function<Bearbeitungsvermerk, T> newFormatter, BiFunction<Bearbeitungsvermerk, T, U> postFormatter) {
        EList _oldFootnotes = content.getOldFootnotes();
        EList _unchangedFootnotes = content.getUnchangedFootnotes();
        Iterable _plus = Iterables.concat((Iterable)_oldFootnotes, (Iterable)_unchangedFootnotes);
        EList _newFootnotes = content.getNewFootnotes();
        EList _unchangedFootnotes_1 = content.getUnchangedFootnotes();
        Iterable _plus_1 = Iterables.concat((Iterable)_newFootnotes, (Iterable)_unchangedFootnotes_1);
        Function<Bearbeitungsvermerk, String> _function = it -> {
            Bearbeitungsvermerk_Allg_AttributeGroup _bearbeitungsvermerkAllg = null;
            if (it != null) {
                _bearbeitungsvermerkAllg = it.getBearbeitungsvermerkAllg();
            }
            Kommentar_TypeClass _kommentar = null;
            if (_bearbeitungsvermerkAllg != null) {
                _kommentar = _bearbeitungsvermerkAllg.getKommentar();
            }
            String _wert = null;
            if (_kommentar != null) {
                _wert = _kommentar.getWert();
            }
            return _wert;
        };
        return CellContentExtensions.formatCompareContent(_plus, _plus_1, oldFormatter, commonFormatter, newFormatter, postFormatter, _function);
    }

    private static String getCompareValueFormat(String warning_mark, String value) {
        block16: {
            boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)value);
            if (_isNullOrEmpty) {
                return "";
            }
            boolean _isErrorText = CellContentExtensions.isErrorText(value);
            if (_isErrorText) {
                return warning_mark;
            }
            boolean _contains = value.contains(HOURGLASS_ICON);
            if (_contains) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("<span>");
                _builder.append(value);
                _builder.append("</span>");
                return _builder.toString();
            }
            if (warning_mark == null) break block16;
            switch (warning_mark) {
                case "<!-- warning-mark-black -->": {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("<span>");
                    String _htmlString = CellContentExtensions.getHtmlString(value);
                    _builder_1.append(_htmlString);
                    _builder_1.append("</span>");
                    return _builder_1.toString();
                }
                case "<!-- warning-mark-yellow -->": {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("<span style=\"background-color:rgb(255,255, 0)\"><s>");
                    String _htmlString_1 = CellContentExtensions.getHtmlString(value);
                    _builder_2.append(_htmlString_1);
                    _builder_2.append("</s></span>");
                    return _builder_2.toString();
                }
                case "<!-- warning-mark-red -->": {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("<span style=\"color:rgb(255, 0, 0)\">");
                    String _htmlString_2 = CellContentExtensions.getHtmlString(value);
                    _builder_3.append(_htmlString_2);
                    _builder_3.append("</span>");
                    return _builder_3.toString();
                }
            }
        }
        return null;
    }

    private static String getMultiColorFormat(MultiColorCellContent content) {
        boolean _isEmpty = content.getValue().isEmpty();
        if (_isEmpty) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        EList _value = content.getValue();
        boolean _hasElements = false;
        for (MultiColorContent element : _value) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                String _separator = content.getSeparator();
                _builder.appendImmediate((Object)_separator, "");
            }
            String _multiColorFormat = CellContentExtensions.getMultiColorFormat(element);
            _builder.append(_multiColorFormat);
        }
        return _builder.toString();
    }

    private static String getMultiColorFormat(MultiColorContent content) {
        boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)content.getMultiColorValue());
        if (_isNullOrEmpty) {
            String _xifexpression = null;
            boolean _isNullOrEmpty_1 = Strings.isNullOrEmpty((String)content.getStringFormat());
            _xifexpression = _isNullOrEmpty_1 ? "" : CellContentExtensions.getHtmlString(content.getStringFormat());
            return _xifexpression;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<span style=\"background-color:rgb(255,255, 0)\">");
        String _multiColorValueHtmlString = CellContentExtensions.getMultiColorValueHtmlString(content, WARNING_MARK_YELLOW);
        _builder.append(_multiColorValueHtmlString);
        _builder.append("</span><span style=\"color:rgb(255, 0, 0)\">");
        String _multiColorValueHtmlString_1 = CellContentExtensions.getMultiColorValueHtmlString(content, WARNING_MARK_RED);
        _builder.append(_multiColorValueHtmlString_1);
        _builder.append("</span>");
        String value = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("<span>");
        String _format = String.format(content.getStringFormat(), value);
        _builder_1.append(_format);
        _builder_1.append("</span>");
        return _builder_1.toString();
    }

    private static String getValueHtmlString(StringCellContent content) {
        String contentValue = CellContentExtensions.iterableToString((Iterable<String>)content.getValue(), content.getSeparator());
        if (CellContentExtensions.isErrorText(contentValue) && !ToolboxConfiguration.isDevelopmentMode()) {
            return WARNING_MARK_BLACK;
        }
        boolean _equals = contentValue.equals(HOURGLASS_ICON);
        if (_equals) {
            return contentValue;
        }
        return CellContentExtensions.getHtmlString(contentValue);
    }

    private static String getMultiColorValueHtmlString(MultiColorContent content, String warningColor) {
        if (CellContentExtensions.isErrorText(content.getMultiColorValue()) && !ToolboxConfiguration.isDevelopmentMode()) {
            return warningColor;
        }
        return CellContentExtensions.getHtmlString(content.getMultiColorValue());
    }

    private static String getHtmlString(String value) {
        return HtmlEscapers.htmlEscaper().escape(StringExtensions.intersperseWithZeroSpacesSC((String)value)).replaceAll("\n", "<br></br>");
    }

    public static String iterableToString(Iterable<String> sequence, String separator) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (String element : sequence) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                String _xifexpression = null;
                _xifexpression = separator == null ? "\n" : separator;
                _builder.appendImmediate((Object)_xifexpression, "");
            }
            _builder.append(element);
        }
        return _builder.toString();
    }

    public static boolean isEqual(CellContent content, CellContent other) {
        return CellContentExtensions.getPlainStringValue(content).equals(CellContentExtensions.getPlainStringValue(other));
    }

    public static String getRichTextValue(CellContent content) {
        if (content instanceof CompareCellContent) {
            return CellContentExtensions._getRichTextValue((CompareCellContent)content);
        }
        if (content instanceof MultiColorCellContent) {
            return CellContentExtensions._getRichTextValue((MultiColorCellContent)content);
        }
        if (content instanceof StringCellContent) {
            return CellContentExtensions._getRichTextValue((StringCellContent)content);
        }
        if (content != null) {
            return CellContentExtensions._getRichTextValue(content);
        }
        return CellContentExtensions._getRichTextValue(null);
    }

    public static String getRichTextValueWithFootnotes(CellContent content, FootnoteContainer fc) {
        if (content instanceof StringCellContent && fc instanceof SimpleFootnoteContainer) {
            return CellContentExtensions._getRichTextValueWithFootnotes((StringCellContent)content, (SimpleFootnoteContainer)fc);
        }
        if (content instanceof StringCellContent && fc == null) {
            return CellContentExtensions._getRichTextValueWithFootnotes((StringCellContent)content, null);
        }
        if (content != null && fc instanceof CompareFootnoteContainer) {
            return CellContentExtensions._getRichTextValueWithFootnotes(content, (CompareFootnoteContainer)fc);
        }
        if (content != null && fc != null) {
            return CellContentExtensions._getRichTextValueWithFootnotes(content, fc);
        }
        return CellContentExtensions._getRichTextValueWithFootnotes(null, null);
    }

    public static String getPlainStringValue(CellContent content) {
        if (content instanceof CompareCellContent) {
            return CellContentExtensions._getPlainStringValue((CompareCellContent)content);
        }
        if (content instanceof MultiColorCellContent) {
            return CellContentExtensions._getPlainStringValue((MultiColorCellContent)content);
        }
        if (content instanceof StringCellContent) {
            return CellContentExtensions._getPlainStringValue((StringCellContent)content);
        }
        if (content != null) {
            return CellContentExtensions._getPlainStringValue(content);
        }
        return CellContentExtensions._getPlainStringValue(null);
    }

    public static Iterable<String> getStringValueIterable(CellContent content) {
        if (content instanceof StringCellContent) {
            return CellContentExtensions._getStringValueIterable((StringCellContent)content);
        }
        if (content != null) {
            return CellContentExtensions._getStringValueIterable(content);
        }
        return CellContentExtensions._getStringValueIterable(null);
    }

    public static TableCell getTableCell(EObject content) {
        if (content instanceof CellContent) {
            return CellContentExtensions._getTableCell((CellContent)content);
        }
        if (content instanceof MultiColorContent) {
            return CellContentExtensions._getTableCell((MultiColorContent)content);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(content).toString());
    }

    private static String getValueFormat(CellContent content) {
        if (content instanceof MultiColorCellContent) {
            return CellContentExtensions._getValueFormat((MultiColorCellContent)content);
        }
        if (content instanceof StringCellContent) {
            return CellContentExtensions._getValueFormat((StringCellContent)content);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(content).toString());
    }
}

