/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.controlarea;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.set.application.Messages;
import org.eclipse.set.application.toolcontrol.ServiceProvider;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.constants.ContainerType;
import org.eclipse.set.basis.constants.TableType;
import org.eclipse.set.core.services.part.ToolboxPartService;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Stell_Bereich;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.set.ppmodel.extensions.StellBereichExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.utils.events.DefaultToolboxEventHandler;
import org.eclipse.set.utils.events.NewTableTypeEvent;
import org.eclipse.set.utils.events.SelectedControlAreaChangedEvent;
import org.eclipse.set.utils.events.ToolboxEvent;
import org.eclipse.set.utils.events.ToolboxEventHandler;
import org.eclipse.set.utils.events.ToolboxEvents;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlAreaSelectionControl {
    static final Logger LOGGER = LoggerFactory.getLogger(ControlAreaSelectionControl.class);
    private final MApplication application;
    private final IEventBroker broker;
    private ComboViewer comboViewer;
    @Translation
    private final Messages messages;
    ToolboxPartService partService;
    MultiContainer_AttributeGroup container;
    private ToolboxEventHandler<NewTableTypeEvent> newTableTypeHandler;
    private TableType tableType;
    private Object oldSelectionValue;

    public ControlAreaSelectionControl(Composite parent, ServiceProvider serviceProvider) {
        this.application = serviceProvider.application;
        this.broker = serviceProvider.broker;
        this.messages = serviceProvider.messages;
        this.partService = serviceProvider.partService;
        this.broker.subscribe("modelsession/close", event -> this.initCombo());
        this.createCombo(parent);
    }

    private void createCombo(Composite parent) {
        this.comboViewer = new ComboViewer(parent);
        this.comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new ControlAreaLabelProvider());
        this.initCombo();
        this.comboViewer.addSelectionChangedListener(this::selectionControlArea);
        this.newTableTypeHandler = new DefaultToolboxEventHandler<NewTableTypeEvent>(){

            public void accept(NewTableTypeEvent t) {
                ControlAreaSelectionControl.this.initCombo();
                ControlAreaSelectionControl.this.setCombo(t.getTableType());
                ControlAreaSelectionControl.this.seletcionControlArea(ControlAreaSelectionControl.this.comboViewer.getSelection(), t.getTableType());
            }
        };
        ToolboxEvents.subscribe((IEventBroker)this.broker, NewTableTypeEvent.class, this.newTableTypeHandler);
        this.application.getContext().runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                if (ControlAreaSelectionControl.this.getSession() != null) {
                    IModelSession session = (IModelSession)context.get(IModelSession.class);
                    if (session == null) {
                        ControlAreaSelectionControl.this.initCombo();
                    } else {
                        ControlAreaSelectionControl.this.tableType = PlanProSchnittstelleExtensions.isPlanning((PlanPro_Schnittstelle)session.getPlanProSchnittstelle()) ? TableType.DIFF : TableType.SINGLE;
                        ControlAreaSelectionControl.this.setCombo(ControlAreaSelectionControl.this.tableType);
                    }
                }
                return true;
            }
        });
    }

    private void setCombo(TableType type) {
        this.comboViewer.getCombo().removeAll();
        LinkedList<SelectedControlAreaChangedEvent.ControlAreaValue> values = new LinkedList<SelectedControlAreaChangedEvent.ControlAreaValue>();
        switch (type) {
            case FINAL: {
                values.addAll(this.getComboValues(this.getSession(), ContainerType.FINAL));
                break;
            }
            case INITIAL: {
                values.addAll(this.getComboValues(this.getSession(), ContainerType.INITIAL));
                break;
            }
            case SINGLE: {
                this.setSinglePlanControlAreaCombo();
                return;
            }
            case DIFF: {
                values.addAll(this.getDiffComboValues());
                break;
            }
        }
        if (values.isEmpty()) {
            this.setEmtpyControlAreaCombo();
            return;
        }
        this.comboViewer.setInput(values);
        if (values.size() > 1) {
            this.comboViewer.insert((Object)this.messages.ControlAreaCombo_All_ControlArea, values.size());
        }
        this.comboViewer.insert((Object)this.getDefaultValue(), 0);
        this.comboViewer.insert((Object)this.messages.ControlAreaCombo_All_Objects_Value, 1);
        Optional<SelectedControlAreaChangedEvent.ControlAreaValue> oldValue = values.stream().filter(areaValue -> {
            if (this.oldSelectionValue instanceof String) {
                return areaValue.equals(this.oldSelectionValue);
            }
            Object object = this.oldSelectionValue;
            if (object instanceof SelectedControlAreaChangedEvent.ControlAreaValue) {
                void oldAreaValue;
                SelectedControlAreaChangedEvent.ControlAreaValue controlAreaValue = (SelectedControlAreaChangedEvent.ControlAreaValue)object;
                SelectedControlAreaChangedEvent.ControlAreaValue cfr_ignored_0 = (SelectedControlAreaChangedEvent.ControlAreaValue)object;
                return areaValue.areaName().equals(oldAreaValue.areaName());
            }
            return false;
        }).findFirst();
        if (!this.oldSelectionValue.equals(this.messages.ControlAreaCombo_All_Objects_Value) && oldValue.isPresent()) {
            int index = this.comboViewer.getCombo().indexOf(oldValue.get().areaName());
            this.comboViewer.getCombo().select(index);
        } else {
            this.comboViewer.getCombo().select(0);
        }
        this.comboViewer.getCombo().setEnabled(true);
    }

    private List<SelectedControlAreaChangedEvent.ControlAreaValue> getDiffComboValues() {
        LinkedList<SelectedControlAreaChangedEvent.ControlAreaValue> values = new LinkedList<SelectedControlAreaChangedEvent.ControlAreaValue>();
        if (this.getSession() == null) {
            return values;
        }
        List<SelectedControlAreaChangedEvent.ControlAreaValue> initialValues = this.getComboValues(this.getSession(), ContainerType.INITIAL);
        values.addAll(initialValues);
        MultiContainer_AttributeGroup finalContainer = this.getSession().getContainer(ContainerType.FINAL);
        if (finalContainer == null) {
            return values;
        }
        if (initialValues.isEmpty()) {
            return this.getComboValues(this.getSession(), ContainerType.FINAL);
        }
        for (Stell_Bereich finalArea : finalContainer.getStellBereich()) {
            String finalAreaId = finalArea.getIdentitaet().getWert();
            Optional<SelectedControlAreaChangedEvent.ControlAreaValue> initialArea = values.stream().filter(area -> area.areaId().equals(finalAreaId)).findFirst();
            if (!initialArea.isEmpty()) continue;
            String areaName = StellBereichExtensions.getStellBeteichBezeichnung((Stell_Bereich)finalArea);
            if (areaName == null) {
                areaName = this.getDefaultAreaName(values.size());
            }
            values.add(new SelectedControlAreaChangedEvent.ControlAreaValue(areaName, finalAreaId));
        }
        return values;
    }

    private List<SelectedControlAreaChangedEvent.ControlAreaValue> getComboValues(IModelSession session, ContainerType containerType) {
        if (session == null) {
            return Collections.emptyList();
        }
        MultiContainer_AttributeGroup selectedContainer = session.getContainer(containerType);
        if (selectedContainer == null) {
            return Collections.emptyList();
        }
        this.container = selectedContainer;
        if (selectedContainer.getStellBereich() == null || !selectedContainer.getStellBereich().iterator().hasNext()) {
            this.comboViewer.getCombo().setEnabled(false);
            return Collections.emptyList();
        }
        LinkedList<SelectedControlAreaChangedEvent.ControlAreaValue> values = new LinkedList<SelectedControlAreaChangedEvent.ControlAreaValue>();
        int i = 1;
        for (Stell_Bereich area : selectedContainer.getStellBereich()) {
            String areaName = StellBereichExtensions.getStellBeteichBezeichnung((Stell_Bereich)area);
            if (areaName == null) {
                areaName = this.getDefaultAreaName(i);
            }
            values.add(new SelectedControlAreaChangedEvent.ControlAreaValue(areaName, area.getIdentitaet().getWert()));
            ++i;
        }
        return values;
    }

    private void setEmtpyControlAreaCombo() {
        this.comboViewer.add((Object)this.getDefaultValue());
        this.comboViewer.add((Object)this.messages.ControlAreaCombo_All_Objects_Value);
        this.comboViewer.getCombo().select(0);
        this.comboViewer.getCombo().setEnabled(true);
    }

    private void setSinglePlanControlAreaCombo() {
        this.comboViewer.add((Object)this.messages.ControlAreaCombo_All_Objects_Value);
        this.comboViewer.getCombo().select(0);
        this.comboViewer.getCombo().setEnabled(false);
    }

    private String getDefaultAreaName(int index) {
        return String.format(this.messages.ControlAreaCombo_Default_Area_Name, index);
    }

    private IModelSession getSession() {
        return (IModelSession)this.application.getContext().get(IModelSession.class);
    }

    private void initCombo() {
        this.comboViewer.getCombo().removeAll();
        this.comboViewer.setInput(List.of(this.messages.TableTypeSelectionControl_noSession, this.messages.ControlAreaCombo_All_Objects_Value));
        this.comboViewer.getCombo().select(0);
        this.comboViewer.getCombo().setEnabled(false);
        this.oldSelectionValue = this.getDefaultValue();
    }

    private void selectionControlArea(SelectionChangedEvent e) {
        this.seletcionControlArea(e.getSelection(), this.tableType);
    }

    public String getDefaultValue() {
        return this.messages.ControlAreaCombo_PlanningArea_Value;
    }

    /*
     * WARNING - void declaration
     */
    private void seletcionControlArea(ISelection s, TableType type) {
        ISelection iSelection = s;
        if (iSelection instanceof IStructuredSelection) {
            void selection;
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            IStructuredSelection cfr_ignored_0 = (IStructuredSelection)iSelection;
            Object selectedElement = selection.getFirstElement();
            if (this.oldSelectionValue.equals(selectedElement) && this.tableType != null && this.tableType.equals((Object)type)) {
                return;
            }
            this.tableType = type;
            this.oldSelectionValue = selectedElement;
            Object object = selectedElement;
            if (object instanceof SelectedControlAreaChangedEvent.ControlAreaValue) {
                void selected;
                SelectedControlAreaChangedEvent.ControlAreaValue controlAreaValue = (SelectedControlAreaChangedEvent.ControlAreaValue)object;
                SelectedControlAreaChangedEvent.ControlAreaValue cfr_ignored_1 = (SelectedControlAreaChangedEvent.ControlAreaValue)object;
                ToolboxEvents.send((IEventBroker)this.broker, (ToolboxEvent)new SelectedControlAreaChangedEvent((SelectedControlAreaChangedEvent.ControlAreaValue)selected, this.tableType, true));
                return;
            }
            Object object2 = selectedElement;
            if (object2 instanceof String) {
                void msg;
                String string = (String)object2;
                String cfr_ignored_2 = (String)object2;
                this.handleStringValue((String)msg);
            }
        }
    }

    private void handleStringValue(String msg) {
        if (msg.equals(this.messages.ControlAreaCombo_All_Objects_Value)) {
            ToolboxEvents.send((IEventBroker)this.broker, (ToolboxEvent)new SelectedControlAreaChangedEvent(this.tableType, true));
            return;
        }
        if (msg.equals(this.messages.ControlAreaCombo_PlanningArea_Value)) {
            ToolboxEvents.send((IEventBroker)this.broker, (ToolboxEvent)new SelectedControlAreaChangedEvent(this.tableType, false));
            return;
        }
        if (msg.equals(this.messages.ControlAreaCombo_All_ControlArea)) {
            try {
                List allValues = (List)List.class.cast(this.comboViewer.getInput());
                ToolboxEvents.send((IEventBroker)this.broker, (ToolboxEvent)new SelectedControlAreaChangedEvent(Set.copyOf(allValues), this.tableType, true));
            }
            catch (Exception exc) {
                throw new RuntimeException(exc);
            }
        }
    }

    private static class ControlAreaLabelProvider
    extends LabelProvider {
        /*
         * WARNING - void declaration
         */
        public String getText(Object element) {
            Object object = element;
            if (object instanceof SelectedControlAreaChangedEvent.ControlAreaValue) {
                void value;
                SelectedControlAreaChangedEvent.ControlAreaValue controlAreaValue = (SelectedControlAreaChangedEvent.ControlAreaValue)object;
                SelectedControlAreaChangedEvent.ControlAreaValue cfr_ignored_0 = (SelectedControlAreaChangedEvent.ControlAreaValue)object;
                return value.areaName();
            }
            return super.getText(element);
        }
    }
}

