/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.model.siteplan;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FMAComponentType implements Enumerator
{
    NONE(0, "None", "None"),
    AXLE(1, "Axle", "Axle"),
    NFDC_CIRCUIT(2, "NFDCCircuit", "NFDCCircuit"),
    TFDC_CIRCUIT(3, "TFDCCircuit", "TFDCCircuit");

    public static final int NONE_VALUE = 0;
    public static final int AXLE_VALUE = 1;
    public static final int NFDC_CIRCUIT_VALUE = 2;
    public static final int TFDC_CIRCUIT_VALUE = 3;
    private static final FMAComponentType[] VALUES_ARRAY;
    public static final List<FMAComponentType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FMAComponentType[]{NONE, AXLE, NFDC_CIRCUIT, TFDC_CIRCUIT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FMAComponentType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FMAComponentType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FMAComponentType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FMAComponentType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FMAComponentType get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return AXLE;
            }
            case 2: {
                return NFDC_CIRCUIT;
            }
            case 3: {
                return TFDC_CIRCUIT;
            }
        }
        return null;
    }

    private FMAComponentType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

