/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.export.xsl;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.eclipse.set.utils.excel.ExcelWorkbookExtension;
import org.eclipse.set.utils.export.xsl.AbstractTransformTableHeader;
import org.eclipse.set.utils.export.xsl.TransformStyle;
import org.eclipse.set.utils.export.xsl.TransformTableBody;
import org.eclipse.set.utils.export.xsl.XSLConstant;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class MultiPageTableHeader
extends AbstractTransformTableHeader {
    private static final String MULTIPAGE_LAYOUT_TEMPLATE_PATH = "data/export/pdf/multipage_layout.xsl";
    private static final String XSL_MAINPAGE_TEMPLATE_NAME = "MainPage";
    private final LinkedHashSet<Integer> pageBreakAts = CollectionLiterals.newLinkedHashSet();

    public MultiPageTableHeader(XSSFSheet sheet, float maxPaperWidth) {
        super(sheet, maxPaperWidth);
        this.pageBreakAts.addAll((Collection)Conversions.doWrapArray((Object)sheet.getColumnBreaks()));
    }

    @Override
    protected void addTableToTemplate(Element tableTemplate, Element table) {
        Element block = this.doc.createElement("fo:block");
        block.appendChild(table);
        tableTemplate.appendChild(block);
    }

    @Override
    protected Document getFopPageTemplate() throws ParserConfigurationException, SAXException, IOException {
        Document doc = AbstractTransformTableHeader.parseTemplate("data/export/pdf/table_template.xsl");
        Node rootNode = doc.getElementsByTagName("xsl:stylesheet").item(0);
        Document multipageTemplate = AbstractTransformTableHeader.parseTemplate(MULTIPAGE_LAYOUT_TEMPLATE_PATH);
        Optional<Element> newPageBlock = AbstractTransformTableHeader.findNodebyTagName(multipageTemplate, "fo:block", "id", XSLConstant.TableAttribute.START_INDENT);
        boolean _isPresent = newPageBlock.isPresent();
        if (_isPresent) {
            newPageBlock.get().setAttribute(XSLConstant.TableAttribute.START_INDENT, String.format("-%scm", Float.valueOf(this.maxPaperWidth).toString()));
        }
        Node clone = doc.importNode(multipageTemplate.getFirstChild(), true);
        Optional<Element> singlePageLayout = AbstractTransformTableHeader.findNodebyTagName(doc, "xsl:template", "name", XSL_MAINPAGE_TEMPLATE_NAME);
        boolean _isPresent_1 = singlePageLayout.isPresent();
        if (_isPresent_1) {
            rootNode.replaceChild(clone, singlePageLayout.get());
        } else {
            rootNode.appendChild(clone);
        }
        return doc;
    }

    @Override
    protected Set<Element> getTableStyle() {
        return new TransformTableBody(this.doc, (Sheet)this.sheet).pageBreakColumnCellStyle((int[])Conversions.unwrapArray(this.pageBreakAts, Integer.TYPE));
    }

    @Override
    protected Pair<Integer, Float> transformColumn(LinkedHashSet<Element> cols, float sumWidth, int colsIndex, int columNumber) {
        float columnWidth = Float.valueOf(ExcelWorkbookExtension.getColumnWidthInCm((Sheet)this.sheet, colsIndex)).floatValue();
        if (this.pageBreakAts.contains(colsIndex) || this.isBigerThanPaperWidth(sumWidth + columnWidth, colsIndex + 1)) {
            this.pageBreakAts.add(colsIndex);
            columnWidth = this.maxPaperWidth - sumWidth;
            cols.add(this.createTableColumn(columNumber, columnWidth));
            Pair<Integer, Float> repeatColumns = this.transformBreakColumns(cols, columNumber);
            return Pair.of((Object)((Integer)repeatColumns.getKey()), (Object)((Float)repeatColumns.getValue()));
        }
        cols.add(this.createTableColumn(columNumber, columnWidth));
        return Pair.of((Object)columNumber, (Object)Float.valueOf(sumWidth + columnWidth));
    }

    private Pair<Integer, Float> transformBreakColumns(LinkedHashSet<Element> columns, int columnNumber) {
        Set<Integer> repeatingColumns = ExcelWorkbookExtension.getRepeatingColumns((Sheet)this.sheet);
        boolean _isEmpty = repeatingColumns.isEmpty();
        if (_isEmpty) {
            float columnWidth = Float.valueOf(ExcelWorkbookExtension.getColumnWidthInCm((Sheet)this.sheet, 0)).floatValue();
            columns.add(this.createTableColumn(columnNumber, columnWidth));
            return Pair.of((Object)(columnNumber + 1), (Object)Float.valueOf(columnWidth));
        }
        float repeatColumnsWidth = 0.0f;
        int index = 0;
        while (index < repeatingColumns.size()) {
            int colIndex = columnNumber + index + 1;
            float columnWidth_1 = Float.valueOf(ExcelWorkbookExtension.getColumnWidthInCm((Sheet)this.sheet, (Integer)IterableExtensions.toList(repeatingColumns).get(index))).floatValue();
            float _repeatColumnsWidth = repeatColumnsWidth;
            repeatColumnsWidth = _repeatColumnsWidth + columnWidth_1;
            columns.add(this.createTableColumn(colIndex, columnWidth_1));
            ++index;
        }
        int _size = repeatingColumns.size();
        int _plus = columnNumber + _size;
        return Pair.of((Object)_plus, (Object)Float.valueOf(repeatColumnsWidth));
    }

    @Override
    protected int getCellSpanColumn(Optional<Cell> excelCell) {
        Optional<CellRangeAddress> cellSpanRange = ExcelWorkbookExtension.getColumnSpanRangeAt(excelCell.get());
        boolean _isPresent = cellSpanRange.isPresent();
        if (_isPresent) {
            int spanCount = cellSpanRange.get().getNumberOfCells();
            Functions.Function1 _function = it -> it < ((CellRangeAddress)cellSpanRange.get()).getLastColumn() && it > ((CellRangeAddress)cellSpanRange.get()).getFirstColumn();
            Integer breakInSpan = (Integer)IterableExtensions.findFirst(this.pageBreakAts, (Functions.Function1)_function);
            if (breakInSpan != null) {
                int colIndex = excelCell.get().getColumnIndex();
                boolean _isEmpty = ExcelWorkbookExtension.getCellStringValue(excelCell).isEmpty();
                if (_isEmpty) {
                    Cell _get = excelCell.get();
                    Optional<Cell> _cellAt = ExcelWorkbookExtension.getCellAt(excelCell.get().getSheet(), cellSpanRange.get().getFirstRow(), cellSpanRange.get().getFirstColumn());
                    Cell _get_1 = null;
                    if (_cellAt != null) {
                        _get_1 = _cellAt.get();
                    }
                    Optional<String> _cellStringValue = ExcelWorkbookExtension.getCellStringValue(_get_1);
                    String _get_2 = null;
                    if (_cellStringValue != null) {
                        _get_2 = _cellStringValue.get();
                    }
                    _get.setCellValue(_get_2);
                }
                int _xifexpression = 0;
                if (colIndex <= breakInSpan) {
                    int _firstColumn = cellSpanRange.get().getFirstColumn();
                    int _minus = breakInSpan - _firstColumn;
                    _xifexpression = _minus + 1;
                } else {
                    int _lastColumn = cellSpanRange.get().getLastColumn();
                    _xifexpression = _lastColumn - breakInSpan;
                }
                return _xifexpression;
            }
            return spanCount;
        }
        return 0;
    }

    @Override
    protected void addCell(Set<Element> cells, int rowIndex, Element cell, int cellStartCol) {
        Set<Integer> repeatingColumns;
        boolean _isEmpty;
        boolean _not;
        cells.add(cell);
        boolean _contains = this.pageBreakAts.contains(cellStartCol);
        boolean bl = _not = !_contains;
        if (_not) {
            return;
        }
        Element _lastOrNull = (Element)IterableExtensions.lastOrNull(cells);
        if (_lastOrNull != null) {
            TransformStyle.setBorderStyle(_lastOrNull, XSLConstant.TableAttribute.BorderDirection.RIGHT, "wide-border-style");
        }
        if (_isEmpty = (repeatingColumns = ExcelWorkbookExtension.getRepeatingColumns((Sheet)this.sheet)).isEmpty()) {
            cells.add(this.transformFirstColumnCell((Row)this.sheet.getRow(rowIndex)));
            return;
        }
        Consumer<Integer> _function = colIndex -> {
            if (colIndex == 0) {
                cells.add(this.transformFirstColumnCell((Row)this.sheet.getRow(rowIndex)));
            } else if (ExcelWorkbookExtension.getRowSpanRangeAt((Sheet)this.sheet, rowIndex, colIndex).isEmpty() && (ExcelWorkbookExtension.getCellAt((Sheet)this.sheet, rowIndex, colIndex).isPresent() || rowIndex == ExcelWorkbookExtension.getHeaderLastRowIndex((Sheet)this.sheet))) {
                boolean _tripleEquals;
                Node _cloneNode = ((Element[])Conversions.unwrapArray((Object)cells, Element.class))[colIndex].cloneNode(true);
                Element cloneNode = (Element)_cloneNode;
                String columnsSpanned = cloneNode.getAttribute(XSLConstant.TableAttribute.NUMBER_COLUMNS_SPANNED);
                int _size = repeatingColumns.size();
                int _minus = _size - 1;
                boolean bl = _tripleEquals = colIndex == _minus;
                if (_tripleEquals) {
                    TransformStyle.setBorderStyle(cloneNode, XSLConstant.TableAttribute.BorderDirection.RIGHT, "wide-border-style");
                }
                if (columnsSpanned.isEmpty() || columnsSpanned.equals("1")) {
                    cells.add(cloneNode);
                } else {
                    try {
                        int spanCount = Integer.parseInt(columnsSpanned);
                        Functions.Function1 _function_1 = it -> colIndex.compareTo((Integer)it) <= 0 && colIndex + spanCount >= it;
                        Iterable repeatingSpan = IterableExtensions.filter((Iterable)repeatingColumns, (Functions.Function1)_function_1);
                        cloneNode.setAttribute(XSLConstant.TableAttribute.NUMBER_COLUMNS_SPANNED, Integer.valueOf(IterableExtensions.size((Iterable)repeatingSpan)).toString());
                        cells.add(cloneNode);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof NumberFormatException) {
                            throw new NumberFormatException();
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
            }
        };
        repeatingColumns.forEach(_function);
    }

    private boolean isBigerThanPaperWidth(float currentSumWidth, int nextColumnIndex) {
        Functions.Function1 _function = it -> {
            int _firstColumn = it.getFirstColumn();
            return _firstColumn == nextColumnIndex;
        };
        CellRangeAddress nextColumnGroup = (CellRangeAddress)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)ExcelWorkbookExtension.getParentGroupSpan((Sheet)this.sheet))), (Functions.Function1)_function);
        if (nextColumnGroup != null) {
            float groupSumWidth = 0.0f;
            int i = nextColumnIndex;
            while (i <= nextColumnGroup.getLastColumn()) {
                float _groupSumWidth = groupSumWidth;
                float _floatValue = Float.valueOf(ExcelWorkbookExtension.getColumnWidthInCm((Sheet)this.sheet, i)).floatValue();
                groupSumWidth = _groupSumWidth + _floatValue;
                ++i;
            }
            return currentSumWidth + groupSumWidth > this.maxPaperWidth;
        }
        float _columnWidthInCm = ExcelWorkbookExtension.getColumnWidthInCm((Sheet)this.sheet, nextColumnIndex);
        float _plus = currentSumWidth + _columnWidthInCm;
        return _plus > this.maxPaperWidth;
    }
}

