/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.export.xsl;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.eclipse.set.utils.export.xsl.XSLConstant;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.w3c.dom.Element;

public class TransformStyle {
    public static void transformCellStyle(Element xslCell, Optional<Cell> excelCell) {
        boolean _isEmpty = excelCell.isEmpty();
        if (_isEmpty) {
            return;
        }
        CellStyle excelStyle = excelCell.get().getCellStyle();
        TransformStyle.setBorderStyle(xslCell, TransformStyle.transformBorderStyle(excelStyle));
        TransformStyle.transformTextAlign(xslCell, excelStyle.getAlignment(), excelStyle.getVerticalAlignment());
        TransformStyle.transformTextFont(xslCell, excelCell.get());
    }

    private static void setBorderStyle(Element cell, HashMap<XSLConstant.TableAttribute.BorderDirection, String> borderStyles) {
        Functions.Function2 _function = (directionm, style) -> {
            boolean _isEmpty = style.isEmpty();
            return !_isEmpty;
        };
        BiConsumer<XSLConstant.TableAttribute.BorderDirection, String> _function_1 = (direction, style) -> {
            String directionString = direction.getDirectionString();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("{$");
            _builder.append(style);
            _builder.append("}");
            cell.setAttribute(directionString, _builder.toString());
        };
        MapExtensions.filter(borderStyles, (Functions.Function2)_function).forEach(_function_1);
    }

    public static void setBorderStyle(Optional<Cell> cell, Element xslCell, XSLConstant.TableAttribute.BorderDirection direction) {
        boolean _isEmpty = cell.isEmpty();
        if (_isEmpty) {
            return;
        }
        String borderStyle = TransformStyle.transformBorderStyle(cell.get().getCellStyle()).get((Object)direction);
        TransformStyle.setBorderStyle(xslCell, direction, borderStyle);
    }

    public static void setBorderStyle(Element xslCell, XSLConstant.TableAttribute.BorderDirection direction, String borderStyle) {
        boolean _not;
        boolean _isEmpty = borderStyle.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            String _directionString = direction.getDirectionString();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("{$");
            _builder.append(borderStyle);
            _builder.append("}");
            xslCell.setAttribute(_directionString, _builder.toString());
        } else {
            boolean _tripleNotEquals;
            String _attribute = xslCell.getAttribute(direction.getDirectionString());
            boolean bl2 = _tripleNotEquals = _attribute != null;
            if (_tripleNotEquals) {
                xslCell.removeAttribute(direction.getDirectionString());
            }
        }
    }

    public static HashMap<XSLConstant.TableAttribute.BorderDirection, String> transformBorderStyle(CellStyle style) {
        return CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)((Object)XSLConstant.TableAttribute.BorderDirection.TOP), (Object)TransformStyle.transformBorderStyle(style.getBorderTop())), Pair.of((Object)((Object)XSLConstant.TableAttribute.BorderDirection.BOTTOM), (Object)TransformStyle.transformBorderStyle(style.getBorderBottom())), Pair.of((Object)((Object)XSLConstant.TableAttribute.BorderDirection.LEFT), (Object)TransformStyle.transformBorderStyle(style.getBorderLeft())), Pair.of((Object)((Object)XSLConstant.TableAttribute.BorderDirection.RIGHT), (Object)TransformStyle.transformBorderStyle(style.getBorderRight()))});
    }

    private static String transformBorderStyle(BorderStyle borderStyle) {
        if (borderStyle != null) {
            switch (borderStyle) {
                case THIN: {
                    return "small-border-style";
                }
                case MEDIUM: {
                    return "wide-border-style";
                }
            }
            return "";
        }
        return "";
    }

    public static void setExcelCellBorderStyle(Optional<Cell> cell, Map<XSLConstant.TableAttribute.BorderDirection, BorderStyle> borderStyles) {
        BiConsumer<XSLConstant.TableAttribute.BorderDirection, BorderStyle> _function = (direction, style) -> TransformStyle.setExcelCellBorderStyle(cell, direction, style);
        borderStyles.forEach(_function);
    }

    public static void setExcelCellBorderStyle(Optional<Cell> cell, XSLConstant.TableAttribute.BorderDirection direction, BorderStyle style) {
        boolean _isEmpty = cell.isEmpty();
        if (_isEmpty) {
            return;
        }
        Workbook wb = cell.get().getSheet().getWorkbook();
        CellStyle newStyle = wb.createCellStyle();
        newStyle.cloneStyleFrom(cell.get().getCellStyle());
        if (direction != null) {
            switch (direction) {
                case LEFT: {
                    newStyle.setBorderLeft(style);
                    break;
                }
                case RIGHT: {
                    newStyle.setBorderRight(style);
                    break;
                }
                case TOP: {
                    newStyle.setBorderTop(style);
                    break;
                }
                case BOTTOM: {
                    newStyle.setBorderBottom(style);
                    break;
                }
            }
        }
        Cell _get = cell.get();
        _get.setCellStyle(newStyle);
    }

    private static void transformTextAlign(Element xslCell, HorizontalAlignment horizonAlign, VerticalAlignment verticalAlign) {
        String horizon = "";
        if (horizonAlign != null) {
            switch (horizonAlign) {
                case LEFT: {
                    horizon = HorizontalAlignment.LEFT.name();
                    break;
                }
                case RIGHT: {
                    horizon = HorizontalAlignment.RIGHT.name();
                    break;
                }
                default: {
                    horizon = HorizontalAlignment.CENTER.name();
                    break;
                }
            }
        } else {
            horizon = HorizontalAlignment.CENTER.name();
        }
        xslCell.setAttribute(XSLConstant.TableAttribute.TEXT_ALIGN, horizon.toLowerCase());
    }

    private static void transformTextFont(Element xslCell, Cell excelCell) {
        boolean _italic;
        int cellFontIndex;
        Workbook workbook = excelCell.getRow().getSheet().getWorkbook();
        Font fontStyle = workbook.getFontAt(cellFontIndex = excelCell.getCellStyle().getFontIndex());
        boolean _bold = fontStyle.getBold();
        if (_bold) {
            xslCell.setAttribute(XSLConstant.TableAttribute.FONT_WEIGHT, "bold");
        }
        if (_italic = fontStyle.getItalic()) {
            xslCell.setAttribute(XSLConstant.TableAttribute.FONT_STYLE, "italic");
        }
    }
}

