/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.graph;

import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.set.basis.graph.TopPath;
import org.eclipse.set.basis.graph.TopPoint;
import org.eclipse.set.utils.graph.AsSplitTopGraph;
import org.eclipse.set.utils.graph.DirectedPathSearch;
import org.eclipse.set.utils.math.BigDecimalExtensions;
import org.jgrapht.Graph;
import org.jgrapht.graph.AsWeightedGraph;
import org.jgrapht.graph.DirectedPseudograph;

public class AsDirectedTopGraph {
    public static Graph<AsSplitTopGraph.Node, DirectedTOPEdge<AsSplitTopGraph.Edge>> asDirectedTopGraph(Graph<AsSplitTopGraph.Node, AsSplitTopGraph.Edge> base) {
        AsWeightedGraph graph = new AsWeightedGraph((Graph)new DirectedPseudograph(DirectedTOPEdge.class), new HashMap());
        base.vertexSet().forEach(arg_0 -> ((Graph)graph).addVertex(arg_0));
        base.edgeSet().forEach(arg_0 -> AsDirectedTopGraph.lambda$1((Graph)graph, base, arg_0));
        return graph;
    }

    public static TopPath getPath(AsSplitTopGraph graph, TopPoint from, TopPoint to, int maxPathWeight, Predicate<TopPath> relevantCondition) {
        AsSplitTopGraph.Node startNode = graph.splitGraphAt(from);
        AsSplitTopGraph.Node endNode = graph.splitGraphAt(to);
        Graph<AsSplitTopGraph.Node, DirectedTOPEdge<AsSplitTopGraph.Edge>> directedTopGraph = AsDirectedTopGraph.asDirectedTopGraph((Graph<AsSplitTopGraph.Node, AsSplitTopGraph.Edge>)graph);
        return AsDirectedTopGraph.getPath(directedTopGraph, startNode, endNode, maxPathWeight, relevantCondition);
    }

    public static TopPath getPath(Graph<AsSplitTopGraph.Node, DirectedTOPEdge<AsSplitTopGraph.Edge>> graph, AsSplitTopGraph.Node startNode, AsSplitTopGraph.Node endNode, int maxPathWeight, Predicate<TopPath> relevantCondition) {
        DirectedPathSearch directedPath;
        TopPath topPath;
        if (maxPathWeight <= 0) {
            throw new IllegalArgumentException("maxPathWeight must be greater als 0");
        }
        if (startNode == endNode && (topPath = (directedPath = new DirectedPathSearch(graph, startNode, endNode, maxPathWeight)).getTopPath(relevantCondition, false)) != null) {
            return topPath;
        }
        List<DirectedTOPEdge<AsSplitTopGraph.Edge>> relevantEdgesFromTarget = AsDirectedTopGraph.findRelevantEdgesFromTarget(graph, endNode, maxPathWeight);
        for (DirectedTOPEdge edge : graph.outgoingEdgesOf((Object)startNode)) {
            DirectedPathSearch path = new DirectedPathSearch(graph, startNode, endNode, maxPathWeight);
            path.addEdge(edge);
            List<TopPath> topPaths = AsDirectedTopGraph.getPath(path, relevantEdgesFromTarget, relevantCondition, false);
            if (topPaths.isEmpty()) continue;
            return topPaths.getFirst();
        }
        return null;
    }

    public static List<TopPath> getAllPaths(AsSplitTopGraph graph, TopPoint from, TopPoint to, int maxPathWeight) {
        DirectedPathSearch directedPath;
        TopPath topPath;
        AsSplitTopGraph.Node startNode = graph.splitGraphAt(from);
        AsSplitTopGraph.Node endNode = graph.splitGraphAt(to);
        Graph<AsSplitTopGraph.Node, DirectedTOPEdge<AsSplitTopGraph.Edge>> directedTopGraph = AsDirectedTopGraph.asDirectedTopGraph((Graph<AsSplitTopGraph.Node, AsSplitTopGraph.Edge>)graph);
        if (startNode == endNode && (topPath = (directedPath = new DirectedPathSearch(directedTopGraph, startNode, endNode, maxPathWeight)).getTopPath(null, true)) != null) {
            return List.of(topPath);
        }
        ArrayList<TopPath> result = new ArrayList<TopPath>();
        for (DirectedTOPEdge edge : directedTopGraph.outgoingEdgesOf((Object)startNode)) {
            DirectedPathSearch path = new DirectedPathSearch(directedTopGraph, startNode, endNode, maxPathWeight);
            path.addEdge(edge);
            List<TopPath> topPath2 = AsDirectedTopGraph.getPath(path, Collections.emptyList(), null, true);
            result.addAll(topPath2);
        }
        return result;
    }

    private static List<TopPath> getPath(DirectedPathSearch incompletePath, List<DirectedTOPEdge<AsSplitTopGraph.Edge>> relevantEdgesFromTarget, Predicate<TopPath> relevantCondition, boolean includeIncompletePath) {
        DirectedPathSearch path;
        ArrayList<TopPath> result = new ArrayList<TopPath>();
        LinkedList<DirectedPathSearch> incompletePaths = new LinkedList<DirectedPathSearch>();
        incompletePaths.add(incompletePath);
        Graph<AsSplitTopGraph.Node, DirectedTOPEdge<AsSplitTopGraph.Edge>> graph = incompletePath.graph();
        while ((path = (DirectedPathSearch)incompletePaths.poll()) != null) {
            DirectedTOPEdge<AsSplitTopGraph.Edge> lastEdge = path.path().getLast();
            AsSplitTopGraph.Node lastNode = (AsSplitTopGraph.Node)graph.getEdgeTarget(lastEdge);
            for (DirectedTOPEdge edge : graph.outgoingEdgesOf((Object)lastNode)) {
                if (!includeIncompletePath) {
                    TopPath shortesPath = AsDirectedTopGraph.getShortesPath(incompletePaths, path, edge, relevantEdgesFromTarget, relevantCondition);
                    if (shortesPath == null) continue;
                    return List.of(shortesPath);
                }
                AsDirectedTopGraph.getAllPaths(result, incompletePaths, path, edge);
            }
        }
        return result;
    }

    private static TopPath getShortesPath(Deque<DirectedPathSearch> incompletePaths, DirectedPathSearch path, DirectedTOPEdge<AsSplitTopGraph.Edge> edge, List<DirectedTOPEdge<AsSplitTopGraph.Edge>> relevantEdgesFromTarget, Predicate<TopPath> relevantCondition) {
        if (relevantEdgesFromTarget.contains(edge) && path.isRelevantPathWeight(edge.edge().getWeight())) {
            DirectedPathSearch newPath = path.clonePath();
            if (!newPath.addEdge(edge)) {
                return null;
            }
            TopPath topPath = newPath.getTopPath(relevantCondition, false);
            if (topPath != null) {
                return topPath;
            }
            if (newPath.isRelevantPathLength()) {
                incompletePaths.addFirst(newPath);
            }
        }
        return null;
    }

    private static void getAllPaths(List<TopPath> result, Deque<DirectedPathSearch> incompletePaths, DirectedPathSearch path, DirectedTOPEdge<AsSplitTopGraph.Edge> edge) {
        DirectedPathSearch newPath = path.clonePath();
        if (!newPath.addEdge(edge)) {
            return;
        }
        TopPath topPath = newPath.getTopPath(null, false);
        if (topPath != null) {
            result.add(topPath);
            return;
        }
        if (newPath.isRelevantPathLength()) {
            incompletePaths.addFirst(newPath);
        } else {
            result.add(newPath.getTopPath(null, true));
        }
    }

    private static List<DirectedTOPEdge<AsSplitTopGraph.Edge>> findRelevantEdgesFromTarget(Graph<AsSplitTopGraph.Node, DirectedTOPEdge<AsSplitTopGraph.Edge>> graph, AsSplitTopGraph.Node target, int maxPathWeight) {
        AsSplitTopGraph.Node vertex;
        ArrayList<DirectedTOPEdge<AsSplitTopGraph.Edge>> edgesDistance = new ArrayList<DirectedTOPEdge<AsSplitTopGraph.Edge>>();
        HashMap<AsSplitTopGraph.Node, BigDecimal> remainingWeigthFromEnd = new HashMap<AsSplitTopGraph.Node, BigDecimal>();
        ArrayDeque<AsSplitTopGraph.Node> nodesToProcess = new ArrayDeque<AsSplitTopGraph.Node>();
        nodesToProcess.add(target);
        BigDecimal tmpMaxWeight = BigDecimalExtensions.toBigDecimal(maxPathWeight);
        remainingWeigthFromEnd.put(target, tmpMaxWeight);
        while ((vertex = (AsSplitTopGraph.Node)nodesToProcess.poll()) != null) {
            assert (remainingWeigthFromEnd.containsKey(vertex));
            BigDecimal currentRemaining = (BigDecimal)remainingWeigthFromEnd.get(vertex);
            Set incomingEdgesOf = graph.incomingEdgesOf((Object)vertex);
            for (DirectedTOPEdge edge : incomingEdgesOf) {
                BigDecimal weight = ((AsSplitTopGraph.Edge)edge.edge()).getWeight();
                BigDecimal remainingWeight = currentRemaining.subtract(weight);
                if (remainingWeight.compareTo(BigDecimal.ZERO) < 1) continue;
                edgesDistance.add(edge);
                AsSplitTopGraph.Node edgeSource = (AsSplitTopGraph.Node)graph.getEdgeSource((Object)edge);
                remainingWeigthFromEnd.computeIfAbsent(edgeSource, v -> {
                    nodesToProcess.add(edgeSource);
                    return remainingWeight;
                });
                remainingWeigthFromEnd.computeIfPresent(edgeSource, (k, v) -> remainingWeight.compareTo((BigDecimal)v) > 0 ? remainingWeight : v);
            }
        }
        assert (nodesToProcess.isEmpty());
        return edgesDistance;
    }

    private static /* synthetic */ void lambda$1(Graph graph, Graph graph2, AsSplitTopGraph.Edge edge) {
        DirectedTOPEdge<AsSplitTopGraph.Edge> e1 = new DirectedTOPEdge<AsSplitTopGraph.Edge>(edge, true);
        graph.addEdge((Object)((AsSplitTopGraph.Node)graph2.getEdgeSource((Object)edge)), (Object)((AsSplitTopGraph.Node)graph2.getEdgeTarget((Object)edge)), e1);
        graph.setEdgeWeight(e1, graph2.getEdgeWeight((Object)edge));
        DirectedTOPEdge<AsSplitTopGraph.Edge> e2 = new DirectedTOPEdge<AsSplitTopGraph.Edge>(edge, false);
        graph.addEdge((Object)((AsSplitTopGraph.Node)graph2.getEdgeTarget((Object)edge)), (Object)((AsSplitTopGraph.Node)graph2.getEdgeSource((Object)edge)), e2);
        graph.setEdgeWeight(e2, graph2.getEdgeWeight((Object)edge));
    }

    public record DirectedTOPEdge<T>(T edge, boolean inTopDirection) {
    }
}

