/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.validation.report;

import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.constants.ValidationResult;
import org.eclipse.set.basis.exceptions.CustomValidationProblem;
import org.eclipse.set.basis.extensions.IModelSessionExtensions;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.core.services.version.PlanProVersionService;
import org.eclipse.set.feature.validation.Messages;
import org.eclipse.set.feature.validation.utils.FileInfoReader;
import org.eclipse.set.model.planpro.Layoutinformationen.PlanPro_Layoutinfo;
import org.eclipse.set.model.planpro.PlanPro.ENUMUntergewerkArt;
import org.eclipse.set.model.planpro.PlanPro.Fachdaten_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.LST_Planung_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.model.planpro.PlanPro.Untergewerk_Art_TypeClass;
import org.eclipse.set.model.validationreport.FileInfo;
import org.eclipse.set.model.validationreport.ObjectScope;
import org.eclipse.set.model.validationreport.ValidationProblem;
import org.eclipse.set.model.validationreport.ValidationReport;
import org.eclipse.set.model.validationreport.ValidationSeverity;
import org.eclipse.set.model.validationreport.ValidationreportFactory;
import org.eclipse.set.model.validationreport.VersionInfo;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.set.utils.xml.ObjectMetadataXMLReader;
import org.eclipse.set.utils.xml.XMLNodeFinder;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public class SessionToValidationReportTransformation {
    private final Messages messages;
    private final PlanProVersionService versionService;
    private ValidationReport report;
    private XMLNodeFinder xmlNodeFinder;
    private final EnumTranslationService enumService;
    private final LinkedList<ValidationSeverity> severityOrder = CollectionLiterals.newLinkedList((Object[])new ValidationSeverity[]{ValidationSeverity.ERROR, ValidationSeverity.WARNING, ValidationSeverity.SUCCESS});
    private final List<String> problemOrder;
    private Class<?> validationSourceClass;
    private final HashMap<ArrayList<?>, ValidationProblem> _createCache_transformException = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, ValidationProblem> _createCache_transformException_1 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, ValidationProblem> _createCache_transformException_2 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, ValidationProblem> _createCache_transform = CollectionLiterals.newHashMap();

    public SessionToValidationReportTransformation(Messages messages, PlanProVersionService versionService, EnumTranslationService enumService) {
        this.messages = messages;
        this.versionService = versionService;
        this.enumService = enumService;
        this.problemOrder = CollectionLiterals.newLinkedList((Object[])new String[]{messages.IoProblemMsg, messages.XsdProblemMsg, messages.XsdWarningMsg, messages.NilTestProblem_Type});
    }

    public ValidationReport transform(IModelSession session) {
        this.transformCreate(session);
        this.report.getProblems().clear();
        LinkedList problems = CollectionLiterals.newLinkedList();
        ValidationResult _validationResult = session.getValidationResult(PlanPro_Schnittstelle.class);
        ToolboxFile _toolboxFile = null;
        if (session != null) {
            _toolboxFile = session.getToolboxFile();
        }
        ToolboxFile _toolboxFile_1 = null;
        if (session != null) {
            _toolboxFile_1 = session.getToolboxFile();
        }
        Path _modelPath = null;
        if (_toolboxFile_1 != null) {
            _modelPath = _toolboxFile_1.getModelPath();
        }
        problems.addAll(this.transform(_validationResult, _toolboxFile, _modelPath));
        ValidationResult layoutValidation = session.getValidationResult(PlanPro_Layoutinfo.class);
        if (layoutValidation != null) {
            ToolboxFile _toolboxFile_2 = null;
            if (session != null) {
                _toolboxFile_2 = session.getToolboxFile();
            }
            ToolboxFile _toolboxFile_3 = null;
            if (session != null) {
                _toolboxFile_3 = session.getToolboxFile();
            }
            Path _layoutPath = null;
            if (_toolboxFile_3 != null) {
                _layoutPath = _toolboxFile_3.getLayoutPath();
            }
            Functions.Function1 _function = it -> {
                boolean _contains = problems.contains(it);
                return !_contains;
            };
            Iterables.addAll((Collection)problems, (Iterable)IterableExtensions.filter(this.transform(layoutValidation, _toolboxFile_2, _layoutPath), (Functions.Function1)_function));
        }
        this.sortProblem(problems);
        this.report.getProblems().addAll((Collection)problems);
        Iterable<String> subworkTypes = this.getSubworkTypes(session);
        int subworkCount = ((Object[])Conversions.unwrapArray(subworkTypes, Object.class)).length;
        this.report.setSubworkCount(Integer.valueOf(subworkCount).toString());
        if (subworkCount > 0) {
            this.report.setSubworkTypes(String.join((CharSequence)", ", subworkTypes));
        } else {
            this.report.setSubworkTypes(this.messages.NoSubworks);
        }
        return this.report;
    }

    public Set<ValidationProblem> transform(ValidationResult validationResult, ToolboxFile toolboxFile, Path sourcePath) {
        XMLNodeFinder _xMLNodeFinder;
        LinkedList problems = CollectionLiterals.newLinkedList();
        this.xmlNodeFinder = _xMLNodeFinder = new XMLNodeFinder();
        this.xmlNodeFinder.read(toolboxFile, sourcePath);
        this.validationSourceClass = validationResult.getValidatedSourceClass();
        problems.addAll(this.transform(validationResult.getXsdErrors(), this.messages.XsdProblemMsg, ValidationSeverity.ERROR, this.messages.XsdErrorSuccessMsg));
        problems.addAll(this.transform(validationResult.getXsdWarnings(), this.messages.XsdWarningMsg, ValidationSeverity.WARNING, this.messages.XsdSuccessMsg));
        problems.addAll(this.transform(validationResult.getIoErrors(), this.messages.IoProblemMsg, ValidationSeverity.ERROR, this.messages.IoSuccessMsg));
        Consumer<CustomValidationProblem> _function = it -> problems.add(this.transform((CustomValidationProblem)it));
        validationResult.getCustomProblems().forEach(_function);
        return IterableExtensions.toSet((Iterable)problems);
    }

    private <T extends Exception> List<ValidationProblem> transform(List<T> errors, String type, ValidationSeverity severity, String successMessage) {
        LinkedList result = CollectionLiterals.newLinkedList();
        boolean _isEmpty = errors.isEmpty();
        if (_isEmpty) {
            result.add(this.transform(type, successMessage));
        } else {
            Consumer<Exception> _function = it -> result.add(this.transform((Exception)it, type, severity));
            errors.forEach(_function);
        }
        return result;
    }

    private void transformCreate(IModelSession session) {
        VersionInfo _createSupportedVersion;
        FileInfo _fileInfo_1;
        ValidationReport _createValidationReport;
        ValidationReport _elvis = null;
        _elvis = this.report != null ? this.report : (_createValidationReport = ValidationreportFactory.eINSTANCE.createValidationReport());
        this.report = _elvis;
        ToolboxFile _toolboxFile = null;
        if (session != null) {
            _toolboxFile = session.getToolboxFile();
        }
        FileInfoReader fileInfoReader = new FileInfoReader(this.versionService, _toolboxFile);
        FileInfo _elvis_1 = null;
        FileInfo _fileInfo = this.report.getFileInfo();
        _elvis_1 = _fileInfo != null ? _fileInfo : (_fileInfo_1 = fileInfoReader.getFileInfo());
        this.report.setFileInfo(_elvis_1);
        String _xifexpression = null;
        boolean _hasLoadedModel = IModelSessionExtensions.hasLoadedModel((IModelSession)session);
        _xifexpression = _hasLoadedModel ? this.messages.YesMsg : this.messages.NoMsg;
        this.report.setModelLoaded(_xifexpression);
        ValidationResult.Outcome _validationsOutcome = null;
        if (session != null) {
            Function<ValidationResult, ValidationResult.Outcome> _function = it -> it.getOutcome();
            _validationsOutcome = session.getValidationsOutcome(_function);
        }
        String _transform = null;
        if (_validationsOutcome != null) {
            _transform = this.transform(_validationsOutcome);
        }
        this.report.setValid(_transform);
        ValidationResult.Outcome _validationsOutcome_1 = null;
        if (session != null) {
            Function<ValidationResult, ValidationResult.Outcome> _function_1 = it -> it.getXsdOutcome();
            _validationsOutcome_1 = session.getValidationsOutcome(_function_1);
        }
        String _transform_1 = null;
        if (_validationsOutcome_1 != null) {
            _transform_1 = this.transform(_validationsOutcome_1);
        }
        this.report.setXsdValid(_transform_1);
        ValidationResult.Outcome _validationsOutcome_2 = null;
        if (session != null) {
            Function<ValidationResult, ValidationResult.Outcome> _function_2 = it -> it.getEmfOutcome();
            _validationsOutcome_2 = session.getValidationsOutcome(_function_2);
        }
        String _transform_2 = null;
        if (_validationsOutcome_2 != null) {
            _transform_2 = this.transform(_validationsOutcome_2);
        }
        this.report.setEmfValid(_transform_2);
        VersionInfo _elvis_2 = null;
        VersionInfo _supportedVersion = this.report.getSupportedVersion();
        _elvis_2 = _supportedVersion != null ? _supportedVersion : (_createSupportedVersion = this.versionService.createSupportedVersion());
        this.report.setSupportedVersion(_elvis_2);
        this.report.setToolboxVersion(ToolboxConfiguration.getToolboxVersion().getLongVersion());
    }

    private String transform(ValidationResult.Outcome outcome) {
        if (outcome != null) {
            switch (outcome) {
                case VALID: {
                    return this.messages.ValidMsg;
                }
                case INVALID: {
                    return this.messages.InvalidMsg;
                }
            }
            return this.messages.ValidationNotSupportedMsg;
        }
        return this.messages.ValidationNotSupportedMsg;
    }

    private ValidationProblem transform(Exception exception, String type, ValidationSeverity severity) {
        Throwable cause = exception.getCause();
        if (cause instanceof XMIException) {
            return this.transformException((Exception)cause, type, severity);
        }
        if (cause instanceof SAXParseException) {
            return this.transformException((Exception)cause, type, severity);
        }
        return this.transformException(exception, type, severity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationProblem _transformException(XMIException exception, String type, ValidationSeverity severity) {
        ValidationProblem _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Serializable[]{exception, type, severity});
        HashMap<ArrayList<?>, ValidationProblem> hashMap = this._createCache_transformException;
        synchronized (hashMap) {
            ValidationProblem _createValidationProblem;
            if (this._createCache_transformException.containsKey(_cacheKey)) {
                return this._createCache_transformException.get(_cacheKey);
            }
            _result = _createValidationProblem = ValidationreportFactory.eINSTANCE.createValidationProblem();
            this._createCache_transformException.put(_cacheKey, _result);
        }
        this._init_transformException(_result, exception, type, severity);
        return _result;
    }

    private void _init_transformException(ValidationProblem it, XMIException exception, String type, ValidationSeverity severity) {
        it.setType(type);
        it.setSeverity(severity);
        it.setSeverityText(this.translate((Enumerator)severity));
        it.setLineNumber(exception.getLine());
        it.setMessage(this.transformToMessage((Exception)exception));
        Node xmlNode = this.xmlNodeFinder.findNodeByLineNumber(it.getLineNumber());
        if (xmlNode != null) {
            it.setObjectArt(ObjectMetadataXMLReader.getObjectType((Node)xmlNode));
            it.setObjectScope(ObjectMetadataXMLReader.getObjectScope((Node)xmlNode));
            it.setObjectState(ObjectMetadataXMLReader.getObjectState((Node)xmlNode));
            it.setAttributeName(ObjectMetadataXMLReader.getAttributeName((Node)xmlNode));
        }
        if (it.getObjectScope() == null || it.getObjectScope() == ObjectScope.UNKNOWN) {
            boolean _equals = Objects.equals(this.validationSourceClass, PlanPro_Layoutinfo.class);
            if (_equals) {
                it.setObjectScope(ObjectScope.LAYOUT);
            } else {
                it.setObjectScope(ObjectScope.CONTENT);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationProblem _transformException(SAXParseException exception, String type, ValidationSeverity severity) {
        ValidationProblem _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Serializable[]{exception, type, severity});
        HashMap<ArrayList<?>, ValidationProblem> hashMap = this._createCache_transformException_1;
        synchronized (hashMap) {
            ValidationProblem _createValidationProblem;
            if (this._createCache_transformException_1.containsKey(_cacheKey)) {
                return this._createCache_transformException_1.get(_cacheKey);
            }
            _result = _createValidationProblem = ValidationreportFactory.eINSTANCE.createValidationProblem();
            this._createCache_transformException_1.put(_cacheKey, _result);
        }
        this._init_transformException_1(_result, exception, type, severity);
        return _result;
    }

    private void _init_transformException_1(ValidationProblem it, SAXParseException exception, String type, ValidationSeverity severity) {
        it.setType(type);
        it.setSeverity(severity);
        it.setSeverityText(this.translate((Enumerator)severity));
        it.setLineNumber(exception.getLineNumber());
        it.setMessage(this.transformToMessage(exception));
        Node xmlNode = this.xmlNodeFinder.findNodeByLineNumber(it.getLineNumber());
        if (xmlNode != null) {
            it.setObjectArt(ObjectMetadataXMLReader.getObjectType((Node)xmlNode));
            it.setObjectScope(ObjectMetadataXMLReader.getObjectScope((Node)xmlNode));
            it.setObjectState(ObjectMetadataXMLReader.getObjectState((Node)xmlNode));
            it.setAttributeName(ObjectMetadataXMLReader.getAttributeName((Node)xmlNode));
        }
        if (it.getObjectScope() == null || it.getObjectScope() == ObjectScope.UNKNOWN) {
            boolean _equals = Objects.equals(this.validationSourceClass, PlanPro_Layoutinfo.class);
            if (_equals) {
                it.setObjectScope(ObjectScope.LAYOUT);
            } else {
                it.setObjectScope(ObjectScope.CONTENT);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationProblem _transformException(Exception exception, String type, ValidationSeverity severity) {
        ValidationProblem _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Serializable[]{exception, type, severity});
        HashMap<ArrayList<?>, ValidationProblem> hashMap = this._createCache_transformException_2;
        synchronized (hashMap) {
            ValidationProblem _createValidationProblem;
            if (this._createCache_transformException_2.containsKey(_cacheKey)) {
                return this._createCache_transformException_2.get(_cacheKey);
            }
            _result = _createValidationProblem = ValidationreportFactory.eINSTANCE.createValidationProblem();
            this._createCache_transformException_2.put(_cacheKey, _result);
        }
        this._init_transformException_2(_result, exception, type, severity);
        return _result;
    }

    private void _init_transformException_2(ValidationProblem it, Exception exception, String type, ValidationSeverity severity) {
        it.setType(type);
        it.setSeverity(severity);
        it.setSeverityText(this.translate((Enumerator)severity));
        it.setLineNumber(0);
        it.setMessage(this.transformToMessage(exception));
        it.setObjectArt("");
        it.setAttributeName("");
        boolean _equals = Objects.equals(this.validationSourceClass, PlanPro_Layoutinfo.class);
        if (_equals) {
            it.setObjectScope(ObjectScope.LAYOUT);
        } else {
            it.setObjectScope(ObjectScope.CONTENT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationProblem transform(CustomValidationProblem problem) {
        ValidationProblem _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new CustomValidationProblem[]{problem});
        HashMap<ArrayList<?>, ValidationProblem> hashMap = this._createCache_transform;
        synchronized (hashMap) {
            ValidationProblem _createValidationProblem;
            if (this._createCache_transform.containsKey(_cacheKey)) {
                return this._createCache_transform.get(_cacheKey);
            }
            _result = _createValidationProblem = ValidationreportFactory.eINSTANCE.createValidationProblem();
            this._createCache_transform.put(_cacheKey, _result);
        }
        this._init_transform(_result, problem);
        return _result;
    }

    private void _init_transform(ValidationProblem it, CustomValidationProblem problem) {
        it.setType(problem.getType());
        it.setSeverity(problem.getSeverity());
        it.setSeverityText(this.translate((Enumerator)problem.getSeverity()));
        it.setLineNumber(problem.getLineNumber());
        it.setMessage(problem.getMessage());
        it.setObjectArt(problem.getObjectArt());
        it.setObjectScope(problem.getObjectScope());
        it.setObjectState(problem.getObjectState());
        it.setAttributeName(problem.getAttributeName());
        if (it.getObjectScope() == null || it.getObjectScope() == ObjectScope.UNKNOWN) {
            if (Objects.equals(this.validationSourceClass, PlanPro_Layoutinfo.class) || it.getType() == "Metainformationen") {
                it.setObjectScope(ObjectScope.LAYOUT);
            } else {
                it.setObjectScope(ObjectScope.CONTENT);
            }
        }
    }

    private ValidationProblem transform(String errorType, String message) {
        ValidationProblem it = ValidationreportFactory.eINSTANCE.createValidationProblem();
        it.setType(errorType);
        it.setSeverity(ValidationSeverity.SUCCESS);
        it.setSeverityText(this.translate((Enumerator)it.getSeverity()));
        boolean _equals = Objects.equals(this.validationSourceClass, PlanPro_Layoutinfo.class);
        if (_equals) {
            it.setObjectScope(ObjectScope.LAYOUT);
        } else {
            it.setObjectScope(ObjectScope.CONTENT);
        }
        it.setMessage(message);
        return it;
    }

    private Iterable<String> getSubworkTypes(IModelSession session) {
        EList fachdaten;
        PlanPro_Schnittstelle _planProSchnittstelle = session.getPlanProSchnittstelle();
        LST_Planung_AttributeGroup _lSTPlanung = null;
        if (_planProSchnittstelle != null) {
            _lSTPlanung = _planProSchnittstelle.getLSTPlanung();
        }
        Fachdaten_AttributeGroup _fachdaten = null;
        if (_lSTPlanung != null) {
            _fachdaten = _lSTPlanung.getFachdaten();
        }
        EList _ausgabeFachdaten = null;
        if (_fachdaten != null) {
            _ausgabeFachdaten = _fachdaten.getAusgabeFachdaten();
        }
        if ((fachdaten = _ausgabeFachdaten) == null) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        HashMap subtypes = CollectionLiterals.newHashMap();
        Functions.Function1 _function = it -> {
            Untergewerk_Art_TypeClass _untergewerkArt = it.getUntergewerkArt();
            ENUMUntergewerkArt _wert = null;
            if (_untergewerkArt != null) {
                _wert = _untergewerkArt.getWert();
            }
            return _wert;
        };
        Consumer<ENUMUntergewerkArt> _function_1 = it -> {
            boolean _not;
            boolean _containsKey = subtypes.containsKey(it.toString());
            boolean bl = _not = !_containsKey;
            if (_not) {
                subtypes.put(it, 1);
            } else {
                Integer count = (Integer)subtypes.get(it.toString());
                subtypes.put(it, count + 1);
            }
        };
        IterableExtensions.filterNull((Iterable)ListExtensions.map((List)fachdaten, (Functions.Function1)_function)).forEach(_function_1);
        LinkedList result = CollectionLiterals.newLinkedList();
        BiConsumer<ENUMUntergewerkArt, Integer> _function_2 = (type, count) -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(type);
            _builder.append(" (");
            _builder.append(count);
            _builder.append(")");
            result.add(_builder.toString());
        };
        subtypes.forEach(_function_2);
        return result;
    }

    private void sortProblem(List<ValidationProblem> problems) {
        Function<ValidationProblem, Integer> _function = it -> this.severityOrder.indexOf(it.getSeverity());
        Function<ValidationProblem, Integer> _function_1 = it -> this.problemOrder.indexOf(it.getType());
        Function<ValidationProblem, String> _function_2 = it -> it.getObjectArt();
        Function<ValidationProblem, String> _function_3 = it -> it.getAttributeName();
        Function<ValidationProblem, ObjectScope> _function_4 = it -> it.getObjectScope();
        Function<ValidationProblem, Integer> _function_5 = it -> it.getLineNumber();
        Comparator<ValidationProblem> comparator = Comparator.comparing(_function).thenComparing(_function_1, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(_function_2, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(_function_3, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(Collections.reverseOrder(Comparator.comparing(_function_4, Comparator.nullsLast(Comparator.naturalOrder())))).thenComparing(_function_5, Comparator.nullsLast(Comparator.naturalOrder()));
        problems.sort(comparator);
        Procedures.Procedure2 _function_6 = (it, index) -> it.setId(index + 1);
        IterableExtensions.forEach(problems, (Procedures.Procedure2)_function_6);
    }

    private String _transformToMessage(Exception exception) {
        return exception.getMessage();
    }

    private String _transformToMessage(SAXParseException exception) {
        String original = exception.getMessage();
        return original.replaceFirst("cvc[^:]+: ", "");
    }

    private String translate(Enumerator enumerator) {
        if (enumerator == null) {
            return null;
        }
        return this.enumService.translate(enumerator).getAlternative();
    }

    private ValidationProblem transformException(Exception exception, String type, ValidationSeverity severity) {
        if (exception instanceof SAXParseException) {
            return this._transformException((SAXParseException)exception, type, severity);
        }
        if (exception instanceof XMIException) {
            return this._transformException((XMIException)exception, type, severity);
        }
        if (exception != null) {
            return this._transformException(exception, type, severity);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(exception, type, severity).toString());
    }

    private String transformToMessage(Exception exception) {
        if (exception instanceof SAXParseException) {
            return this._transformToMessage((SAXParseException)exception);
        }
        if (exception != null) {
            return this._transformToMessage(exception);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(exception).toString());
    }
}

