/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions.utils;

import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.set.basis.graph.AbstractDirectedEdgePath;
import org.eclipse.set.basis.graph.DirectedEdge;
import org.eclipse.set.basis.graph.DirectedEdgePath;
import org.eclipse.set.model.planpro.BasisTypen.ENUMLinksRechts;
import org.eclipse.set.model.planpro.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.model.planpro.Basisobjekte.Abstand_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Seitliche_Lage_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Seitlicher_Abstand_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Wirkrichtung_TypeClass;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Geodaten.TOP_Knoten;
import org.eclipse.set.model.planpro.Verweise.ID_TOP_Kante_TypeClass;
import org.eclipse.set.ppmodel.extensions.BereichObjektExtensions;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.exception.EndOfTopPathNotFound;
import org.eclipse.set.ppmodel.extensions.utils.Debug;
import org.eclipse.set.ppmodel.extensions.utils.DirectedTopKante;
import org.eclipse.set.ppmodel.extensions.utils.Distance;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class TopKantePath
extends AbstractDirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> {
    protected String cacheKey;

    public TopKantePath(Bereich_Objekt bereich, Punkt_Objekt_TOP_Kante_AttributeGroup start, Punkt_Objekt_TOP_Kante_AttributeGroup end) {
        this(TopKantePath.sortEdges(BereichObjektExtensions.getTopKanten(bereich), start, end), start, end);
        boolean _not;
        Functions.Function1 _function = it -> (TOP_Kante)it.getElement();
        Set mySet = IteratorExtensions.toSet((Iterator)IteratorExtensions.map((Iterator)this.getEdgeIterator(), (Functions.Function1)_function));
        boolean _equals = BereichObjektExtensions.getTopKanten(bereich).equals(mySet);
        boolean bl = _not = !_equals;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("sort top edges failed, bereich=");
            String _debugString = Debug.debugString(bereich);
            _builder.append(_debugString);
            throw new IllegalArgumentException(_builder.toString());
        }
        Functions.Function1 _function_1 = it -> {
            Abstand_TypeClass _abstand = it.getAbstand();
            BigDecimal _wert = null;
            if (_abstand != null) {
                _wert = _abstand.getWert();
            }
            ID_TOP_Kante_TypeClass _iDTOPKante = it.getIDTOPKante();
            TOP_Kante _value = null;
            if (_iDTOPKante != null) {
                _value = _iDTOPKante.getValue();
            }
            Identitaet_TypeClass _identitaet = null;
            if (_value != null) {
                _identitaet = _value.getIdentitaet();
            }
            String _wert_1 = null;
            if (_identitaet != null) {
                _wert_1 = _identitaet.getWert();
            }
            Wirkrichtung_TypeClass _wirkrichtung = it.getWirkrichtung();
            ENUMWirkrichtung _wert_2 = null;
            if (_wirkrichtung != null) {
                _wert_2 = _wirkrichtung.getWert();
            }
            Seitliche_Lage_TypeClass _seitlicheLage = it.getSeitlicheLage();
            ENUMLinksRechts _wert_3 = null;
            if (_seitlicheLage != null) {
                _wert_3 = _seitlicheLage.getWert();
            }
            Seitlicher_Abstand_TypeClass _seitlicherAbstand = it.getSeitlicherAbstand();
            BigDecimal _wert_4 = null;
            if (_seitlicherAbstand != null) {
                _wert_4 = _seitlicherAbstand.getWert();
            }
            return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[]{_wert, _wert_1, _wert_2, _wert_3, _wert_4}));
        };
        String cacheKeyPathEnds = IterableExtensions.join((Iterable)Iterables.concat((Iterable)ListExtensions.map(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Punkt_Objekt_TOP_Kante_AttributeGroup[]{start, end})), (Functions.Function1)_function_1)));
        Identitaet_TypeClass _identitaet = null;
        if (bereich != null) {
            _identitaet = bereich.getIdentitaet();
        }
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        String _plus = _wert + cacheKeyPathEnds;
        this.cacheKey = _plus;
    }

    public TopKantePath(List<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>> topKanten, Punkt_Objekt_TOP_Kante_AttributeGroup start, Punkt_Objekt_TOP_Kante_AttributeGroup end) {
        super(topKanten, (Object)start, (Object)end);
    }

    public TopKantePath() {
        super(null, null, null);
    }

    private static List<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>> sortEdges(Set<TOP_Kante> topKanten, Punkt_Objekt_TOP_Kante_AttributeGroup start, Punkt_Objekt_TOP_Kante_AttributeGroup end) {
        HashSet<TOP_Kante> topKantenCopy = new HashSet<TOP_Kante>();
        topKantenCopy.addAll(topKanten);
        LinkedList<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>> result = new LinkedList<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>>();
        TOP_Kante startKante = TopKantePath.find(start, topKantenCopy);
        boolean removed = topKantenCopy.remove(startKante);
        if (!removed) {
            throw new IllegalArgumentException("start object is not on top edge");
        }
        boolean _isConnectedTo = TopKanteExtensions.isConnectedTo(startKante, end);
        if (_isConnectedTo) {
            DirectedTopKante _directedTopKante = new DirectedTopKante(startKante, start, end);
            result.add(_directedTopKante);
            return result;
        }
        boolean _isEmpty = topKanten.isEmpty();
        if (_isEmpty) {
            throw new EndOfTopPathNotFound(start, end, result);
        }
        return TopKantePath.sortEdges(startKante, topKantenCopy, start, end, result);
    }

    private static List<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>> sortEdges(TOP_Kante current, Set<TOP_Kante> topKanten, Punkt_Objekt_TOP_Kante_AttributeGroup start, Punkt_Objekt_TOP_Kante_AttributeGroup end, List<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>> result) {
        DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> nextKante = TopKantePath.find(current, topKanten);
        Assert.isTrue((boolean)topKanten.remove(nextKante.getElement()));
        TOP_Knoten connector = TopKanteExtensions.connectionTo(current, (TOP_Kante)nextKante.getElement());
        TOP_Knoten currentStart = TopKanteExtensions.opposite(current, connector);
        DirectedTopKante _directedTopKante = new DirectedTopKante(current, currentStart);
        result.add(_directedTopKante);
        result.add(nextKante);
        boolean _isConnectedTo = TopKanteExtensions.isConnectedTo((TOP_Kante)nextKante.getElement(), end);
        if (_isConnectedTo) {
            return result;
        }
        boolean _isEmpty = topKanten.isEmpty();
        if (_isEmpty) {
            throw new EndOfTopPathNotFound(start, end, result);
        }
        return TopKantePath.sortEdges(nextKante, topKanten, start, end, result);
    }

    private static List<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>> sortEdges(DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> current, Set<TOP_Kante> topKanten, Punkt_Objekt_TOP_Kante_AttributeGroup start, Punkt_Objekt_TOP_Kante_AttributeGroup end, List<DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>> result) {
        DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> nextKante = TopKantePath.find((TOP_Kante)current.getElement(), topKanten);
        Assert.isTrue((boolean)topKanten.remove(nextKante.getElement()));
        result.add(nextKante);
        boolean _isConnectedTo = TopKanteExtensions.isConnectedTo((TOP_Kante)nextKante.getElement(), end);
        if (_isConnectedTo) {
            return result;
        }
        boolean _isEmpty = topKanten.isEmpty();
        if (_isEmpty) {
            throw new EndOfTopPathNotFound(start, end, result);
        }
        return TopKantePath.sortEdges(nextKante, topKanten, start, end, result);
    }

    private static TOP_Kante find(Punkt_Objekt_TOP_Kante_AttributeGroup connection, Set<TOP_Kante> topKanten) {
        for (TOP_Kante topKante : topKanten) {
            boolean _tripleEquals;
            ID_TOP_Kante_TypeClass _iDTOPKante = connection.getIDTOPKante();
            boolean bl = _tripleEquals = _iDTOPKante == topKante;
            if (!_tripleEquals) continue;
            return topKante;
        }
        for (TOP_Kante topKante_1 : topKanten) {
            boolean _isConnectedTo = TopKanteExtensions.isConnectedTo(topKante_1, connection);
            if (!_isConnectedTo) continue;
            return topKante_1;
        }
        return null;
    }

    private static DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> find(TOP_Kante connection, Set<TOP_Kante> topKanten) {
        for (TOP_Kante topKante : topKanten) {
            boolean _isConnectedTo = TopKanteExtensions.isConnectedTo(topKante, connection);
            if (!_isConnectedTo) continue;
            TOP_Knoten connector = TopKanteExtensions.connectionTo(topKante, connection);
            TOP_Knoten _tOPKnotenA = TopKanteExtensions.getTOPKnotenA(topKante);
            boolean _equals = Objects.equals(_tOPKnotenA, connector);
            return new DirectedTopKante(topKante, _equals);
        }
        return null;
    }

    public DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> copy() {
        List _edgeList = this.getEdgeList();
        Punkt_Objekt_TOP_Kante_AttributeGroup _start = (Punkt_Objekt_TOP_Kante_AttributeGroup)this.getStart();
        Punkt_Objekt_TOP_Kante_AttributeGroup _end = (Punkt_Objekt_TOP_Kante_AttributeGroup)this.getEnd();
        return new TopKantePath(_edgeList, _start, _end);
    }

    public Comparator<BigDecimal> getDistanceComparator() {
        return new Comparator<BigDecimal>(){

            @Override
            public int compare(BigDecimal d1, BigDecimal d2) {
                return new Distance().compare(d1, d2);
            }
        };
    }

    public DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> getEmptyPath() {
        return new TopKantePath();
    }

    public String getCacheKey() {
        return this.cacheKey;
    }
}

