/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.label.swt;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.label.model.VLabel;
import org.eclipse.emf.ecp.view.spi.label.model.VLabelStyle;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emf.ecp.view.template.model.VTStyleProperty;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.ecp.view.template.style.fontProperties.model.VTFontPropertiesFactory;
import org.eclipse.emf.ecp.view.template.style.fontProperties.model.VTFontPropertiesStyleProperty;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

public class LabelSWTRenderer
extends AbstractSWTRenderer<VLabel> {
    private final EMFDataBindingContext dbc;
    private final EMFFormsDatabinding emfFormsDatabinding;
    private final VTViewTemplateProvider vtViewTemplateProvider;
    private SWTGridDescription rendererGridDescription;
    private Font font;
    private Color labelColor;
    private Map<VLabelStyle, VTFontPropertiesStyleProperty> defaultStyles;
    private Composite parent;
    private EMFDataBindingContext dataBindingContext;

    @Inject
    public LabelSWTRenderer(VLabel vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, VTViewTemplateProvider vtViewTemplateProvider) {
        super((VElement)vElement, viewContext, reportService);
        this.emfFormsDatabinding = emfFormsDatabinding;
        this.vtViewTemplateProvider = vtViewTemplateProvider;
        this.dbc = new EMFDataBindingContext();
    }

    protected void dispose() {
        this.rendererGridDescription = null;
        if (this.font != null) {
            this.font.dispose();
        }
        if (this.labelColor != null) {
            this.labelColor.dispose();
        }
        if (this.dataBindingContext != null) {
            this.dataBindingContext.dispose();
            this.dataBindingContext = null;
        }
        this.dbc.dispose();
        super.dispose();
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            this.rendererGridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
            SWTGridCell gridCell = (SWTGridCell)this.rendererGridDescription.getGrid().get(0);
            gridCell.setVerticalGrab(false);
            gridCell.setVerticalFill(false);
            gridCell.setHorizontalFill(true);
            gridCell.setHorizontalGrab(true);
        }
        return this.rendererGridDescription;
    }

    protected Control renderControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        Label label;
        this.parent = parent;
        if (((VLabel)this.getVElement()).getStyle() == VLabelStyle.SEPARATOR) {
            label = new Label(parent, 258);
        } else {
            label = new Label(parent, 0);
            this.setText(label);
            this.applyStyle(label);
        }
        return label;
    }

    private void setText(Label label) {
        if (((VLabel)this.getVElement()).getDomainModelReference() != null) {
            try {
                IObservableValue observableValue = this.emfFormsDatabinding.getObservableValue(((VLabel)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
                ISWTObservableValue observeText = WidgetProperties.text().observe((Widget)label);
                final Binding binding = this.getDataBindingContext().bindValue((IObservableValue)observeText, observableValue);
                label.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        binding.dispose();
                    }
                });
            }
            catch (DatabindingFailedException ex) {
                this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
                label.setText(ex.getMessage());
            }
        } else {
            IObservableValue modelValue = EMFEditObservables.observeValue((EditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getVElement()), (EObject)this.getVElement(), (EStructuralFeature)VViewPackage.eINSTANCE.getElement_Label());
            ISWTObservableValue targetValue = WidgetProperties.text().observe((Widget)label);
            this.dbc.bindValue((IObservableValue)targetValue, modelValue);
        }
    }

    private DataBindingContext getDataBindingContext() {
        if (this.dataBindingContext == null) {
            this.dataBindingContext = new EMFDataBindingContext();
        }
        return this.dataBindingContext;
    }

    protected void applyStyle(Label label) {
        String fontName;
        VTFontPropertiesStyleProperty fontProperties = this.getFontProperty();
        if (fontProperties == null) {
            return;
        }
        FontData[] fD = label.getFont().getFontData();
        int style = 0;
        if (fontProperties.isBold()) {
            style |= 1;
        }
        if (fontProperties.isItalic()) {
            style |= 2;
        }
        fD[0].setStyle(style);
        fD[0].setHeight(fontProperties.getHeight());
        if (this.font != null) {
            this.font.dispose();
        }
        if (this.labelColor != null) {
            this.labelColor.dispose();
        }
        if ((fontName = fontProperties.getFontName()) == null) {
            fontName = this.getDefaultFontName((Control)label);
        }
        this.font = new Font((Device)label.getDisplay(), fontName, fontProperties.getHeight(), style);
        label.setFont(this.font);
        this.labelColor = this.getColor(fontProperties.getColorHEX());
        label.setForeground(this.labelColor);
    }

    private Color getColor(String colorHex) {
        String redString = colorHex.substring(0, 2);
        String greenString = colorHex.substring(2, 4);
        String blueString = colorHex.substring(4, 6);
        int red = Integer.parseInt(redString, 16);
        int green = Integer.parseInt(greenString, 16);
        int blue = Integer.parseInt(blueString, 16);
        return new Color((Device)Display.getDefault(), red, green, blue);
    }

    private VTFontPropertiesStyleProperty getFontProperty() {
        Set styleProperties = this.vtViewTemplateProvider.getStyleProperties(this.getVElement(), this.getViewModelContext());
        for (VTStyleProperty styleProperty : styleProperties) {
            if (!VTFontPropertiesStyleProperty.class.isInstance(styleProperty)) continue;
            VTFontPropertiesStyleProperty fontProperties = (VTFontPropertiesStyleProperty)VTFontPropertiesStyleProperty.class.cast(styleProperty);
            return fontProperties;
        }
        VTFontPropertiesStyleProperty fontProperties = this.getDefaultFontProperties().get(((VLabel)this.getVElement()).getStyle());
        return fontProperties;
    }

    private Map<VLabelStyle, VTFontPropertiesStyleProperty> getDefaultFontProperties() {
        if (this.defaultStyles == null) {
            this.defaultStyles = new HashMap<VLabelStyle, VTFontPropertiesStyleProperty>();
            String defaultFontName = this.parent.getDisplay().getSystemFont().getFontData()[0].getName();
            this.defaultStyles.put(VLabelStyle.H0, this.createStyle(false, false, "000000", defaultFontName, 10));
            this.defaultStyles.put(VLabelStyle.H1, this.createStyle(false, false, "000000", defaultFontName, 12));
            this.defaultStyles.put(VLabelStyle.H2, this.createStyle(false, false, "000000", defaultFontName, 14));
            this.defaultStyles.put(VLabelStyle.H3, this.createStyle(true, true, "000000", defaultFontName, 10));
            this.defaultStyles.put(VLabelStyle.H4, this.createStyle(true, false, "000000", defaultFontName, 10));
            this.defaultStyles.put(VLabelStyle.H5, this.createStyle(true, false, "000000", defaultFontName, 12));
            this.defaultStyles.put(VLabelStyle.H6, this.createStyle(true, false, "000000", defaultFontName, 14));
            this.defaultStyles.put(VLabelStyle.H7, this.createStyle(false, true, "000000", defaultFontName, 10));
            this.defaultStyles.put(VLabelStyle.H8, this.createStyle(false, true, "000000", defaultFontName, 12));
            this.defaultStyles.put(VLabelStyle.H9, this.createStyle(false, true, "000000", defaultFontName, 14));
        }
        return this.defaultStyles;
    }

    private VTFontPropertiesStyleProperty createStyle(boolean bold, boolean italic, String colorHex, String fontName, int fontHeight) {
        VTFontPropertiesStyleProperty fontProp = VTFontPropertiesFactory.eINSTANCE.createFontPropertiesStyleProperty();
        fontProp.setBold(bold);
        fontProp.setColorHEX(colorHex);
        fontProp.setFontName(fontName);
        fontProp.setHeight(fontHeight);
        fontProp.setItalic(italic);
        return fontProp;
    }
}

