/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.resource;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emfcloud.jackson.databind.EMFContext;

public class JsonResource
extends ResourceImpl {
    protected static final Map<EObject, String> DETACHED_EOBJECT_TO_ID_MAP = Collections.synchronizedMap(new WeakHashMap());
    private ObjectMapper mapper;
    private Map<String, EObject> idToEObjectMap;
    private Map<EObject, String> eObjectToIDMap;

    public JsonResource(URI uri, ObjectMapper mapper) {
        super(uri);
        this.mapper = mapper;
    }

    public JsonResource(URI uri) {
        super(uri);
    }

    public void setObjectMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    protected boolean isAttachedDetachedHelperRequired() {
        return this.useIDs() || super.isAttachedDetachedHelperRequired();
    }

    protected boolean useIDs() {
        return this.eObjectToIDMap != null || this.idToEObjectMap != null || this.useUUIDs();
    }

    protected boolean useIDAttributes() {
        return true;
    }

    protected boolean useUUIDs() {
        return false;
    }

    public String getID(EObject eObject) {
        if (this.eObjectToIDMap == null) {
            return null;
        }
        return this.eObjectToIDMap.get(eObject);
    }

    protected EObject getEObjectByID(String id) {
        EObject eObject;
        if (this.idToEObjectMap != null && (eObject = this.idToEObjectMap.get(id)) != null) {
            return eObject;
        }
        return super.getEObjectByID(id);
    }

    public String getURIFragment(EObject eObject) {
        String id = this.getID(eObject);
        if (id != null) {
            return id;
        }
        return super.getURIFragment(eObject);
    }

    public void setID(EObject eObject, String id) {
        String oldID;
        String string = oldID = id != null ? this.getEObjectToIDMap().put(eObject, id) : this.getEObjectToIDMap().remove(eObject);
        if (oldID != null) {
            this.getIDToEObjectMap().remove(oldID);
        }
        if (id != null) {
            this.getIDToEObjectMap().put(id, eObject);
        }
    }

    protected void attachedHelper(EObject eObject) {
        super.attachedHelper(eObject);
        String id = this.getID(eObject);
        if (id == null) {
            if (!this.isLoading()) {
                id = DETACHED_EOBJECT_TO_ID_MAP.remove(eObject);
                if (id == null) {
                    id = EcoreUtil.generateUUID();
                }
                this.setID(eObject, id);
            }
        } else {
            this.getIDToEObjectMap().put(id, eObject);
        }
    }

    protected void detachedHelper(EObject eObject) {
        if (this.useIDs() && this.unloadingContents == null) {
            if (this.useUUIDs()) {
                DETACHED_EOBJECT_TO_ID_MAP.put(eObject, this.getID(eObject));
            }
            if (this.idToEObjectMap != null && this.eObjectToIDMap != null) {
                this.setID(eObject, null);
            }
        }
        super.detachedHelper(eObject);
    }

    public Map<String, EObject> getIDToEObjectMap() {
        if (this.idToEObjectMap == null) {
            this.idToEObjectMap = new HashMap<String, EObject>();
        }
        return this.idToEObjectMap;
    }

    public Map<EObject, String> getEObjectToIDMap() {
        if (this.eObjectToIDMap == null) {
            this.eObjectToIDMap = new HashMap<EObject, String>();
        }
        return this.eObjectToIDMap;
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        if (options == null) {
            options = Collections.emptyMap();
        }
        if (inputStream instanceof URIConverter.Loadable) {
            ((URIConverter.Loadable)inputStream).loadResource((Resource)this);
        } else {
            ContextAttributes attributes = EMFContext.from(options).withPerCallAttribute((Object)EMFContext.Attributes.RESOURCE_SET, (Object)this.getResourceSet()).withPerCallAttribute((Object)EMFContext.Attributes.RESOURCE, (Object)this);
            this.mapper.reader().with(attributes).forType(Resource.class).withValueToUpdate((Object)this).readValue(inputStream);
        }
    }

    protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        if (options == null) {
            options = Collections.emptyMap();
        }
        if (outputStream instanceof URIConverter.Saveable) {
            ((URIConverter.Saveable)outputStream).saveResource((Resource)this);
        } else {
            this.mapper.writer().with(EMFContext.from(options)).writeValue(outputStream, (Object)this);
        }
    }
}

