/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table.tree;

import java.util.Map;
import java.util.function.UnaryOperator;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.command.StructuralRefreshCommand;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowHeaderComposite;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortHeaderLayer;
import org.eclipse.nebula.widgets.nattable.sort.command.SortColumnCommand;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.TreeLayer;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeCollapseAllCommand;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandAllCommand;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandCollapseCommand;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandCollapseCommandHandler;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.utils.table.BodyLayerStack;
import org.eclipse.set.utils.table.TableDataProvider;
import org.eclipse.set.utils.table.sorting.AbstractSortByColumnTables;
import org.eclipse.set.utils.table.sorting.TableSortModel;
import org.eclipse.set.utils.table.tree.TableTreeRowModel;
import org.eclipse.set.utils.table.tree.TreeDataProvider;
import org.eclipse.set.utils.table.tree.TreeSortCommandHandler;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractTreeLayerTable
extends AbstractSortByColumnTables {
    protected TreeLayer treeLayer;

    @Override
    protected void createTableBodyData(Table table, UnaryOperator<Integer> getSourceLine) {
        this.bodyDataProvider = new TreeDataProvider(table, getSourceLine);
        this.bodyDataLayer = new DataLayer((IDataProvider)this.bodyDataProvider);
        this.createTreeLayer();
        this.bodyLayerStack = new BodyLayerStack(this.bodyDataLayer, this.treeLayer);
    }

    private void createTreeLayer() {
        if (!(this.bodyDataProvider instanceof TreeDataProvider)) {
            return;
        }
        final TreeDataProvider treeData = (TreeDataProvider)this.bodyDataProvider;
        TableTreeRowModel treeRowModel = new TableTreeRowModel(treeData);
        this.treeLayer = new TreeLayer((IUniqueIndexLayer)this.bodyDataLayer, (ITreeRowModel)treeRowModel){

            public boolean doCommand(ILayerCommand command) {
                if (command instanceof StructuralRefreshCommand) {
                    AbstractTreeLayerTable.this.treeLayer.doCommand((ILayerCommand)new TreeExpandAllCommand());
                    AbstractTreeLayerTable.this.treeLayer.doCommand((ILayerCommand)new TreeCollapseAllCommand());
                    return true;
                }
                treeData.doExpandCollapseCommand(command);
                return super.doCommand(command);
            }
        };
        this.treeLayer.doCommand((ILayerCommand)new TreeCollapseAllCommand());
    }

    @Override
    protected SortHeaderLayer<BodyLayerStack> creatSortColumnHeaderLayer(ColumnHeaderLayer columnHeaderLayer) {
        TableSortModel tableSortModel = new TableSortModel(this.bodyDataProvider);
        SortHeaderLayer sortHeaderLayer = new SortHeaderLayer((ILayer)columnHeaderLayer, (ISortModel)tableSortModel, true);
        sortHeaderLayer.unregisterCommandHandler(SortColumnCommand.class);
        sortHeaderLayer.registerCommandHandler((ILayerCommandHandler)new TreeSortCommandHandler(tableSortModel, (SortHeaderLayer<BodyLayerStack>)sortHeaderLayer, this.treeLayer));
        return sortHeaderLayer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected FilterRowHeaderComposite<Object> createFilterRowHeader(SortHeaderLayer<BodyLayerStack> sortHeaderLayer, DataLayer columnHeaderDataLayer, ConfigRegistry configRegistry) {
        TableDataProvider tableDataProvider = this.bodyDataProvider;
        if (tableDataProvider instanceof TreeDataProvider) {
            void treeDataProvider;
            TreeDataProvider treeDataProvider2 = (TreeDataProvider)tableDataProvider;
            TreeDataProvider cfr_ignored_0 = (TreeDataProvider)tableDataProvider;
            return new FilterRowHeaderComposite(new TreeFilterStrategy(this.treeLayer, (TreeDataProvider)treeDataProvider), sortHeaderLayer, columnHeaderDataLayer.getDataProvider(), (IConfigRegistry)configRegistry);
        }
        return super.createFilterRowHeader(sortHeaderLayer, columnHeaderDataLayer, configRegistry);
    }

    public Button createExpandCollapseAllButton(Composite parent, final String expandAllLabel, final String collapseAllLabel) {
        final Button button = new Button(parent, 8);
        button.setText(this.treeLayer.hasHiddenRows() ? expandAllLabel : collapseAllLabel);
        this.treeLayer.registerCommandHandler((ILayerCommandHandler)new TreeExpandCollapseCommandHandler(this.treeLayer){

            protected boolean doCommand(TreeExpandCollapseCommand command) {
                String buttonText;
                boolean doCommand = super.doCommand(command);
                String string = buttonText = AbstractTreeLayerTable.this.treeLayer.hasHiddenRows() ? expandAllLabel : collapseAllLabel;
                if (!button.getText().equals(buttonText)) {
                    button.setText(buttonText);
                }
                return doCommand;
            }
        });
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractTreeLayerTable.this.toggleExpandCollapseAll(button, expandAllLabel, collapseAllLabel);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return button;
    }

    private void toggleExpandCollapseAll(Button button, String expandAllLabel, String collapseAllLabel) {
        if (button.getText().equals(expandAllLabel)) {
            this.treeLayer.doCommand((ILayerCommand)new TreeExpandAllCommand());
            button.setText(collapseAllLabel);
        } else {
            this.treeLayer.doCommand((ILayerCommand)new TreeCollapseAllCommand());
            button.setText(expandAllLabel);
        }
    }

    class TreeFilterStrategy<T>
    implements IFilterStrategy<T> {
        private final TreeDataProvider treeDataProvider;
        private final TreeLayer layer;

        public TreeFilterStrategy(TreeLayer treeLayer, TreeDataProvider treeDataProvider) {
            this.layer = treeLayer;
            this.treeDataProvider = treeDataProvider;
        }

        public void applyFilter(Map<Integer, Object> filterIndexToObjectMap) {
            this.layer.expandAll();
            this.treeDataProvider.applyFilter(filterIndexToObjectMap);
            AbstractTreeLayerTable.this.treeLayer.doCommand((ILayerCommand)new TreeCollapseAllCommand());
        }
    }
}

