/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.check;

import com.google.common.collect.Streams;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.feature.plazmodel.check.AbstractPlazContainerCheck;
import org.eclipse.set.feature.plazmodel.check.PlazCheck;
import org.eclipse.set.model.planpro.Geodaten.ENUMGEOForm;
import org.eclipse.set.model.planpro.Geodaten.ENUMGEOKoordinatensystem;
import org.eclipse.set.model.planpro.Geodaten.GEO_Kante;
import org.eclipse.set.model.planpro.Geodaten.GEO_Knoten;
import org.eclipse.set.model.planpro.Geodaten.GEO_Punkt;
import org.eclipse.set.model.plazmodel.PlazError;
import org.eclipse.set.model.plazmodel.PlazFactory;
import org.eclipse.set.model.validationreport.ValidationSeverity;
import org.eclipse.set.ppmodel.extensions.EObjectExtensions;
import org.eclipse.set.ppmodel.extensions.GeoKanteExtensions;
import org.eclipse.set.ppmodel.extensions.GeoKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.osgi.service.component.annotations.Component;

@Component
public class GeoKanteUniqueCoordinate
extends AbstractPlazContainerCheck
implements PlazCheck {
    @Override
    public String checkType() {
        return "Koordinaten";
    }

    @Override
    public String getDescription() {
        return "Alle Geo-Kanten haben unterschiedliche Anfangs- und End-Koordinaten.";
    }

    @Override
    public String getGeneralErrMsg() {
        return "Die Geo-Kante {GUID} hat gleiche Anfangs- und End-Koordinaten.";
    }

    private static String getGEOKanteGUID(GEO_Kante geoKante) {
        return EObjectExtensions.getNullableObject((Object)geoKante, kante -> kante.getIdentitaet().getWert()).orElse("(ohne Identit\u00e4t)");
    }

    @Override
    protected List<PlazError> run(MultiContainer_AttributeGroup container) {
        List geoKanten = Streams.stream((Iterable)container.getGEOKante()).toList();
        ArrayList<PlazError> errors = new ArrayList<PlazError>();
        geoKanten.stream().filter(geoKante -> {
            Optional kanteLength = EObjectExtensions.getNullableObject((Object)geoKante, kante -> kante.getGEOKanteAllg().getGEOLaenge().getWert());
            return !kanteLength.isEmpty() && ((BigDecimal)kanteLength.get()).compareTo(BigDecimal.ZERO) != 0 && geoKante.getGEOKanteAllg().getGEOForm().getWert() != ENUMGEOForm.ENUMGEO_FORM_KM_SPRUNG;
        }).forEach(geoKante -> {
            GEO_Knoten geoKnotenA = GeoKanteExtensions.getGeoKnotenA((GEO_Kante)geoKante);
            GEO_Knoten geoKnotenB = GeoKanteExtensions.getGeoKnotenB((GEO_Kante)geoKante);
            if (geoKnotenA == null || geoKnotenB == null) {
                PlazError error = this.createError((GEO_Kante)geoKante);
                error.setMessage(String.format("Die GEO_Kante %s fehlt GEO_Knoten", GeoKanteUniqueCoordinate.getGEOKanteGUID(geoKante)));
                errors.add(error);
                return;
            }
            try {
                List geoPunkteA = GeoKnotenExtensions.getGeoPunkte((GEO_Knoten)geoKnotenA);
                List geoPunkteB = GeoKnotenExtensions.getGeoPunkte((GEO_Knoten)geoKnotenB);
                geoPunkteA.addAll(geoPunkteB);
                Map<ENUMGEOKoordinatensystem, List<GEO_Punkt>> geoPunktGroupByCRS = geoPunkteA.stream().collect(Collectors.groupingBy(geoPunkt -> geoPunkt.getGEOPunktAllg().getGEOKoordinatensystem().getWert()));
                geoPunktGroupByCRS.forEach((crs, geoPunkte) -> {
                    if (!GeoKanteUniqueCoordinate.isUniqueCoordinatens(geoPunkte)) {
                        errors.add(this.createError((GEO_Kante)geoKante));
                    }
                });
            }
            catch (NullPointerException e) {
                PlazError error = this.createError((GEO_Kante)geoKante);
                error.setMessage(String.format("Die GEO_Punkte der GEO_Knoten von GEO_Kante %s haben ung\u00fcltige Koordinaten oder ein ung\u00fcltiges Koordinatensystem.", GeoKanteUniqueCoordinate.getGEOKanteGUID(geoKante)));
                errors.add(error);
            }
        });
        return errors;
    }

    private static boolean isUniqueCoordinatens(List<GEO_Punkt> geoPunkte) {
        if (geoPunkte.size() == 1) {
            return true;
        }
        Set xValues = geoPunkte.stream().map(geoPunkt -> geoPunkt.getGEOPunktAllg().getGKX().getWert()).collect(Collectors.toSet());
        Set yValues = geoPunkte.stream().map(geoPunkt -> geoPunkt.getGEOPunktAllg().getGKY().getWert()).collect(Collectors.toSet());
        return xValues.size() > 1 && yValues.size() > 1;
    }

    private PlazError createError(GEO_Kante geoKante) {
        PlazError plazError = PlazFactory.eINSTANCE.createPlazError();
        plazError.setSeverity(ValidationSeverity.ERROR);
        plazError.setObject((EObject)geoKante);
        plazError.setType(this.checkType());
        plazError.setMessage(this.transformErrorMsg(Map.of("GUID", GeoKanteUniqueCoordinate.getGEOKanteGUID(geoKante))));
        return plazError;
    }
}

