/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.check;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.feature.plazmodel.check.AbstractPlazContainerCheck;
import org.eclipse.set.feature.plazmodel.check.PlazCheck;
import org.eclipse.set.model.planpro.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.model.planpro.Geodaten.ENUMGEOKoordinatensystem;
import org.eclipse.set.model.planpro.Geodaten.GEO_Kante;
import org.eclipse.set.model.planpro.Geodaten.GEO_Kante_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.Geodaten.GEO_Knoten;
import org.eclipse.set.model.planpro.Geodaten.GEO_Koordinatensystem_TypeClass;
import org.eclipse.set.model.planpro.Geodaten.GEO_Laenge_TypeClass;
import org.eclipse.set.model.planpro.Geodaten.GEO_Punkt_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.Verweise.ID_GEO_Knoten_TypeClass;
import org.eclipse.set.model.plazmodel.PlazError;
import org.eclipse.set.model.plazmodel.PlazFactory;
import org.eclipse.set.ppmodel.extensions.GeoKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.osgi.service.component.annotations.Component;

@Component
public class MeridianBetweenGEOKante
extends AbstractPlazContainerCheck
implements PlazCheck {
    @Override
    public String checkType() {
        return "Mehrfache Koordinatensystem";
    }

    @Override
    public String getDescription() {
        return "Instanzen von GEO_Kante haben ein konsistentes Koordinatensystem.";
    }

    @Override
    protected List<PlazError> run(MultiContainer_AttributeGroup container) {
        boolean _tripleEquals;
        Functions.Function1 _function = it -> {
            ID_GEO_Knoten_TypeClass _iDGEOKnotenA = it.getIDGEOKnotenA();
            GEO_Knoten _value = null;
            if (_iDGEOKnotenA != null) {
                _value = _iDGEOKnotenA.getValue();
            }
            List _geoPunkte = null;
            if (_value != null) {
                _geoPunkte = GeoKnotenExtensions.getGeoPunkte((GEO_Knoten)_value);
            }
            List _map = null;
            if (_geoPunkte != null) {
                Functions.Function1 _function_1 = it_1 -> {
                    GEO_Punkt_Allg_AttributeGroup _gEOPunktAllg = it_1.getGEOPunktAllg();
                    GEO_Koordinatensystem_TypeClass _gEOKoordinatensystem = null;
                    if (_gEOPunktAllg != null) {
                        _gEOKoordinatensystem = _gEOPunktAllg.getGEOKoordinatensystem();
                    }
                    ENUMGEOKoordinatensystem _wert = null;
                    if (_gEOKoordinatensystem != null) {
                        _wert = _gEOKoordinatensystem.getWert();
                    }
                    return _wert;
                };
                _map = ListExtensions.map((List)_geoPunkte, (Functions.Function1)_function_1);
            }
            Set _set = null;
            if (_map != null) {
                _set = IterableExtensions.toSet((Iterable)_map);
            }
            Set crsA = _set;
            ID_GEO_Knoten_TypeClass _iDGEOKnotenB = it.getIDGEOKnotenB();
            GEO_Knoten _value_1 = null;
            if (_iDGEOKnotenB != null) {
                _value_1 = _iDGEOKnotenB.getValue();
            }
            List _geoPunkte_1 = null;
            if (_value_1 != null) {
                _geoPunkte_1 = GeoKnotenExtensions.getGeoPunkte((GEO_Knoten)_value_1);
            }
            List _map_1 = null;
            if (_geoPunkte_1 != null) {
                Functions.Function1 _function_2 = it_1 -> {
                    GEO_Punkt_Allg_AttributeGroup _gEOPunktAllg = it_1.getGEOPunktAllg();
                    GEO_Koordinatensystem_TypeClass _gEOKoordinatensystem = null;
                    if (_gEOPunktAllg != null) {
                        _gEOKoordinatensystem = _gEOPunktAllg.getGEOKoordinatensystem();
                    }
                    ENUMGEOKoordinatensystem _wert = null;
                    if (_gEOKoordinatensystem != null) {
                        _wert = _gEOKoordinatensystem.getWert();
                    }
                    return _wert;
                };
                _map_1 = ListExtensions.map((List)_geoPunkte_1, (Functions.Function1)_function_2);
            }
            Set _set_1 = null;
            if (_map_1 != null) {
                _set_1 = IterableExtensions.toSet((Iterable)_map_1);
            }
            Set crsB = _set_1;
            if (crsA == null || crsB == null) {
                return false;
            }
            Functions.Function1 _function_3 = a -> {
                Functions.Function1 _function_4 = b -> !Objects.equals(a, b);
                return IterableExtensions.exists((Iterable)crsB, (Functions.Function1)_function_4);
            };
            return IterableExtensions.exists((Iterable)crsA, (Functions.Function1)_function_3);
        };
        Iterable geoKantenWithMeridianSprung = IterableExtensions.filter((Iterable)container.getGEOKante(), (Functions.Function1)_function);
        int _size = IterableExtensions.size((Iterable)geoKantenWithMeridianSprung);
        boolean bl = _tripleEquals = _size == 0;
        if (_tripleEquals) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        ArrayList errList = CollectionLiterals.newArrayList();
        Consumer<GEO_Kante> _function_1 = it -> {
            double _doubleValue;
            boolean _tripleNotEquals;
            PlazError err = PlazFactory.eINSTANCE.createPlazError();
            GEO_Kante_Allg_AttributeGroup _gEOKanteAllg = it.getGEOKanteAllg();
            GEO_Laenge_TypeClass _gEOLaenge = null;
            if (_gEOKanteAllg != null) {
                _gEOLaenge = _gEOKanteAllg.getGEOLaenge();
            }
            BigDecimal _wert = null;
            if (_gEOLaenge != null) {
                _wert = _gEOLaenge.getWert();
            }
            boolean bl = _tripleNotEquals = (_doubleValue = _wert.doubleValue()) != 0.0;
            if (_tripleNotEquals) {
                String _elvis = null;
                Identitaet_TypeClass _identitaet = it.getIdentitaet();
                String _wert_1 = null;
                if (_identitaet != null) {
                    _wert_1 = _identitaet.getWert();
                }
                _elvis = _wert_1 != null ? _wert_1 : "[Keine GUID]";
                err.setMessage(this.transformErrorMsg(Map.of("GUID", _elvis)));
                err.setType(this.checkType());
                err.setObject((EObject)it);
                errList.add(err);
            }
        };
        geoKantenWithMeridianSprung.forEach(_function_1);
        return errList;
    }

    @Override
    public String getGeneralErrMsg() {
        return "Die GEO_Kante {GUID} mit der L\u00e4nge > 0 hat unterschiedliche Koordinatensysteme. Der sicherungstechnische Lageplan kann unvollst\u00e4ndig sein.";
    }
}

