/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.core.handler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.handler.BaseModuleHandler;
import org.eclipse.smarthome.automation.handler.ConditionHandler;
import org.eclipse.smarthome.automation.module.core.internal.exception.UncomparableException;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.TypeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareConditionHandler
extends BaseModuleHandler<Condition>
implements ConditionHandler {
    public final Logger logger = LoggerFactory.getLogger(CompareConditionHandler.class);
    public static final String MODULE_TYPE = "core.GenericCompareCondition";
    public static final String INPUT_LEFT_OBJECT = "input";
    public static final String INPUT_LEFT_FIELD = "inputproperty";
    public static final String RIGHT_OP = "right";
    public static final String OPERATOR = "operator";

    public CompareConditionHandler(Condition module) {
        super((Module)module);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSatisfied(Map<String, Object> context) {
        Object operatorObj = ((Condition)this.module).getConfiguration().get(OPERATOR);
        String operator = operatorObj != null && operatorObj instanceof String ? (String)operatorObj : null;
        Object rightObj = ((Condition)this.module).getConfiguration().get(RIGHT_OP);
        String rightOperandString = rightObj != null && rightObj instanceof String ? (String)rightObj : null;
        Object leftObjFieldNameObj = ((Condition)this.module).getConfiguration().get(INPUT_LEFT_FIELD);
        String leftObjectFieldName = leftObjFieldNameObj != null && leftObjFieldNameObj instanceof String ? (String)leftObjFieldNameObj : null;
        if (rightOperandString == null) return false;
        if (operator == null) {
            return false;
        }
        Object leftObj = context.get(INPUT_LEFT_OBJECT);
        Object toCompare = this.getCompareValue(leftObj, leftObjectFieldName);
        Object rightValue = this.getRightOperandValue(rightOperandString, toCompare);
        if (rightValue == null) {
            if (leftObj != null) {
                this.logger.info("unsupported type for compare condition: {}", leftObj.getClass());
                return false;
            }
            this.logger.info("unsupported type for compare condition: null ({})", ((Condition)this.module).getInputs().get(INPUT_LEFT_FIELD));
            return false;
        }
        try {
            switch (operator) {
                case "equals": 
                case "=": 
                case "==": 
                case "EQ": 
                case "eq": 
                case "EQUALS": {
                    if (toCompare != null) return toCompare.equals(rightValue);
                    if (rightOperandString.equals("null")) return true;
                    if (!rightOperandString.equals("")) return false;
                    return true;
                }
                case ">": 
                case "GT": 
                case "gt": {
                    if (toCompare == null) return false;
                    if (rightValue == null) {
                        return false;
                    }
                    if (this.compare(toCompare, rightValue) <= 0) return false;
                    return true;
                }
                case "=>": 
                case ">=": 
                case "GTE": 
                case "gte": {
                    if (toCompare == null) return false;
                    if (rightValue == null) {
                        return false;
                    }
                    if (this.compare(toCompare, rightValue) < 0) return false;
                    return true;
                }
                case "<": 
                case "LT": 
                case "lt": {
                    if (toCompare == null) return false;
                    if (rightValue == null) {
                        return false;
                    }
                    if (this.compare(toCompare, rightValue) >= 0) return false;
                    return true;
                }
                case "<=": 
                case "=<": 
                case "LTE": 
                case "lte": {
                    if (toCompare == null) return false;
                    if (rightValue == null) {
                        return false;
                    }
                    if (this.compare(toCompare, rightValue) > 0) return false;
                    return true;
                }
                case "matches": {
                    if (!(toCompare instanceof String)) return false;
                    if (rightValue == null) return false;
                    if (!(rightValue instanceof String)) return false;
                    return ((String)toCompare).matches((String)rightValue);
                }
            }
            return false;
        }
        catch (UncomparableException e) {
            return false;
        }
    }

    private int compare(Object a, Object b) throws UncomparableException {
        if (Comparable.class.isAssignableFrom(a.getClass()) && a.getClass().equals(b.getClass())) {
            try {
                return ((Comparable)a).compareTo(b);
            }
            catch (ClassCastException e) {
                throw new UncomparableException();
            }
        }
        throw new UncomparableException();
    }

    private Object getRightOperandValue(String rightOperandString2, Object toCompare) {
        if (rightOperandString2.equals("null")) {
            return rightOperandString2;
        }
        if (toCompare instanceof State) {
            ArrayList stateTypeList = new ArrayList();
            stateTypeList.add(((State)toCompare).getClass());
            return TypeParser.parseState(stateTypeList, (String)rightOperandString2);
        }
        if (toCompare instanceof Integer) {
            return Integer.parseInt(rightOperandString2);
        }
        if (toCompare instanceof String) {
            return rightOperandString2;
        }
        if (toCompare instanceof Long) {
            return Long.parseLong(rightOperandString2);
        }
        if (toCompare instanceof Double) {
            return Double.parseDouble(rightOperandString2);
        }
        return null;
    }

    private Object getCompareValue(Object leftObj, String leftObjFieldName) {
        if (leftObj == null || leftObjFieldName == null || leftObjFieldName.isEmpty() || leftObj instanceof String || leftObj instanceof Integer || leftObj instanceof Long || leftObj instanceof Double) {
            return leftObj;
        }
        try {
            Method m = leftObj.getClass().getMethod("get" + leftObjFieldName.substring(0, 1).toUpperCase() + leftObjFieldName.substring(1), new Class[0]);
            return m.invoke(leftObj, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | StringIndexOutOfBoundsException | InvocationTargetException e) {
            return null;
        }
    }
}

