/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.core.handler;

import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.handler.BaseTriggerModuleHandler;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventFilter;
import org.eclipse.smarthome.core.events.EventSubscriber;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericEventTriggerHandler
extends BaseTriggerModuleHandler
implements EventSubscriber,
EventFilter {
    private final Logger logger = LoggerFactory.getLogger(GenericEventTriggerHandler.class);
    private String source;
    private String topic;
    private Set<String> types;
    private BundleContext bundleContext;
    public static final String MODULE_TYPE_ID = "core.GenericEventTrigger";
    private static final String CFG_EVENT_TOPIC = "eventTopic";
    private static final String CFG_EVENT_SOURCE = "eventSource";
    private static final String CFG_EVENT_TYPES = "eventTypes";
    private ServiceRegistration eventSubscriberRegistration;

    public GenericEventTriggerHandler(Trigger module, BundleContext bundleContext) {
        super(module);
        this.source = (String)module.getConfiguration().get(CFG_EVENT_SOURCE);
        this.topic = (String)module.getConfiguration().get(CFG_EVENT_TOPIC);
        this.types = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(((String)module.getConfiguration().get(CFG_EVENT_TYPES)).split(","))));
        this.bundleContext = bundleContext;
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("event.topics", this.topic);
        this.eventSubscriberRegistration = this.bundleContext.registerService(EventSubscriber.class.getName(), (Object)this, properties);
        this.logger.trace("Registered EventSubscriber: Topic: {} Type: {} Source: {}", new Object[]{this.topic, this.types, this.source});
    }

    public Set<String> getSubscribedEventTypes() {
        return this.types;
    }

    public EventFilter getEventFilter() {
        return this;
    }

    public void receive(Event event) {
        if (this.ruleEngineCallback != null) {
            this.logger.trace("Received Event: Source: {} Topic: {} Type: {}  Payload: {}", new Object[]{event.getSource(), event.getTopic(), event.getType(), event.getPayload()});
            if (!event.getTopic().contains(this.source)) {
                return;
            }
            HashMap<String, Event> values = new HashMap<String, Event>();
            values.put("event", event);
            this.ruleEngineCallback.triggered((Trigger)this.module, values);
        }
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void dispose() {
        super.dispose();
        if (this.eventSubscriberRegistration != null) {
            this.eventSubscriberRegistration.unregister();
            this.eventSubscriberRegistration = null;
        }
    }

    public boolean apply(Event event) {
        this.logger.trace("->FILTER: {}:{}", (Object)event.getTopic(), (Object)this.source);
        return event.getTopic().contains(this.source);
    }
}

