/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.basic.internal.render;

import com.google.gson.JsonObject;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.model.sitemap.Mapping;
import org.eclipse.smarthome.model.sitemap.Selection;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.basic.internal.render.AbstractWidgetRenderer;
import org.eclipse.smarthome.ui.basic.render.RenderException;

public class SelectionRenderer
extends AbstractWidgetRenderer {
    @Override
    public boolean canRender(Widget w) {
        return w instanceof Selection;
    }

    private String getMappingsJSON(Selection w) {
        JsonObject resultObject = new JsonObject();
        for (Mapping mapping : w.getMappings()) {
            resultObject.addProperty(mapping.getCmd(), mapping.getLabel());
        }
        String result = resultObject.toString();
        result = StringEscapeUtils.escapeHtml((String)result);
        return result;
    }

    @Override
    public EList<Widget> renderWidget(Widget w, StringBuilder sb) throws RenderException {
        String snippet = this.getSnippet("selection");
        snippet = this.preprocessSnippet(snippet, w);
        snippet = StringUtils.replace((String)snippet, (String)"%value_map%", (String)this.getMappingsJSON((Selection)w));
        snippet = StringUtils.replace((String)snippet, (String)"%label_header%", (String)this.getLabel(w));
        String state = this.itemUIRegistry.getState(w).toString();
        Selection selection = (Selection)w;
        String mappingLabel = null;
        StringBuilder rowSB = new StringBuilder();
        for (Mapping mapping : selection.getMappings()) {
            String rowSnippet = this.getSnippet("selection_row");
            String command = mapping.getCmd() != null ? mapping.getCmd() : "";
            rowSnippet = StringUtils.replace((String)rowSnippet, (String)"%item%", (String)(w.getItem() != null ? w.getItem() : ""));
            rowSnippet = StringUtils.replace((String)rowSnippet, (String)"%cmd%", (String)this.escapeHtml(command));
            rowSnippet = StringUtils.replace((String)rowSnippet, (String)"%label%", (String)(mapping.getLabel() != null ? this.escapeHtml(mapping.getLabel()) : ""));
            if (state.equals(mapping.getCmd())) {
                mappingLabel = mapping.getLabel();
                rowSnippet = StringUtils.replace((String)rowSnippet, (String)"%checked%", (String)"checked=\"true\"");
            } else {
                rowSnippet = StringUtils.replace((String)rowSnippet, (String)"%checked%", (String)"");
            }
            rowSB.append(rowSnippet);
        }
        snippet = StringUtils.replace((String)snippet, (String)"%rows%", (String)rowSB.toString());
        snippet = StringUtils.replace((String)snippet, (String)"%value_header%", (String)(mappingLabel != null ? mappingLabel : ""));
        snippet = this.processColor(w, snippet);
        sb.append(snippet);
        return null;
    }
}

