/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.timer.factory;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.handler.BaseModuleHandlerFactory;
import org.eclipse.smarthome.automation.handler.ModuleHandler;
import org.eclipse.smarthome.automation.module.timer.handler.DayOfWeekConditionHandler;
import org.eclipse.smarthome.automation.module.timer.handler.GenericCronTriggerHandler;
import org.eclipse.smarthome.automation.module.timer.handler.TimeOfDayConditionHandler;
import org.eclipse.smarthome.automation.module.timer.handler.TimeOfDayTriggerHandler;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerModuleHandlerFactory
extends BaseModuleHandlerFactory {
    private final Logger logger = LoggerFactory.getLogger(TimerModuleHandlerFactory.class);
    public static final String THREADPOOLNAME = "ruletimer";
    private static final Collection<String> TYPES = Arrays.asList("timer.GenericCronTrigger", "timer.TimeOfDayTrigger", "core.TimeOfDayCondition", "timer.DayOfWeekCondition");

    @Deactivate
    public void deactivate() {
        super.deactivate();
    }

    public Collection<String> getTypes() {
        return TYPES;
    }

    protected ModuleHandler internalCreate(Module module, String ruleUID) {
        this.logger.trace("create {} -> {}", (Object)module.getId(), (Object)module.getTypeUID());
        String moduleTypeUID = module.getTypeUID();
        if ("timer.GenericCronTrigger".equals(moduleTypeUID) && module instanceof Trigger) {
            return new GenericCronTriggerHandler((Trigger)module);
        }
        if ("timer.TimeOfDayTrigger".equals(moduleTypeUID) && module instanceof Trigger) {
            return new TimeOfDayTriggerHandler((Trigger)module);
        }
        if ("core.TimeOfDayCondition".equals(moduleTypeUID) && module instanceof Condition) {
            return new TimeOfDayConditionHandler((Condition)module);
        }
        if ("timer.DayOfWeekCondition".equals(moduleTypeUID) && module instanceof Condition) {
            return new DayOfWeekConditionHandler((Condition)module);
        }
        this.logger.error("The module handler type '{}' is not supported.", (Object)moduleTypeUID);
        return null;
    }
}

